/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.analysis.de;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene1.analysis.Analyzer;
import org.apache.lucene1.analysis.LowerCaseFilter;
import org.apache.lucene1.analysis.StopFilter;
import org.apache.lucene1.analysis.TokenStream;
import org.apache.lucene1.analysis.de.GermanStemFilter;
import org.apache.lucene1.analysis.de.WordlistLoader;
import org.apache.lucene1.analysis.standard.StandardFilter;
import org.apache.lucene1.analysis.standard.StandardTokenizer;

public class GermanAnalyzer
extends Analyzer {
    private String[] GERMAN_STOP_WORDS = new String[]{"einer", "eine", "eines", "einem", "einen", "der", "die", "das", "dass", "da\u813d", "du", "er", "sie", "es", "was", "wer", "wie", "wir", "und", "oder", "ohne", "mit", "am", "im", "in", "aus", "auf", "ist", "sein", "war", "wird", "ihr", "ihre", "ihres", "als", "f\u7709r", "von", "mit", "dich", "dir", "mich", "mir", "mein", "sein", "kein", "durch", "wegen", "wird"};
    private Set stopSet = new HashSet();
    private Set exclusionSet = new HashSet();

    public GermanAnalyzer() {
        this.stopSet = StopFilter.makeStopSet(this.GERMAN_STOP_WORDS);
    }

    public GermanAnalyzer(String[] stopwords) {
        this.stopSet = StopFilter.makeStopSet(stopwords);
    }

    public GermanAnalyzer(Hashtable stopwords) {
        this.stopSet = new HashSet(stopwords.keySet());
    }

    public GermanAnalyzer(File stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet(stopwords);
    }

    public void setStemExclusionTable(String[] exclusionlist) {
        this.exclusionSet = StopFilter.makeStopSet(exclusionlist);
    }

    public void setStemExclusionTable(Hashtable exclusionlist) {
        this.exclusionSet = new HashSet(exclusionlist.keySet());
    }

    public void setStemExclusionTable(File exclusionlist) throws IOException {
        this.exclusionSet = WordlistLoader.getWordSet(exclusionlist);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(reader);
        result = new StandardFilter(result);
        result = new LowerCaseFilter(result);
        result = new StopFilter(result, this.stopSet);
        result = new GermanStemFilter(result, this.exclusionSet);
        return result;
    }
}

