/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.analysis.ru;

import java.io.Reader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene1.analysis.Analyzer;
import org.apache.lucene1.analysis.StopFilter;
import org.apache.lucene1.analysis.TokenStream;
import org.apache.lucene1.analysis.ru.RussianCharsets;
import org.apache.lucene1.analysis.ru.RussianLetterTokenizer;
import org.apache.lucene1.analysis.ru.RussianLowerCaseFilter;
import org.apache.lucene1.analysis.ru.RussianStemFilter;

public final class RussianAnalyzer
extends Analyzer {
    private static char A = '\u0000';
    private static char B = '\u0001';
    private static char V = (char)2;
    private static char G = (char)3;
    private static char D = (char)4;
    private static char E = (char)5;
    private static char ZH = (char)6;
    private static char Z = (char)7;
    private static char I = (char)8;
    private static char I_ = (char)9;
    private static char K = (char)10;
    private static char L = (char)11;
    private static char M = (char)12;
    private static char N = (char)13;
    private static char O = (char)14;
    private static char P = (char)15;
    private static char R = (char)16;
    private static char S = (char)17;
    private static char T = (char)18;
    private static char U = (char)19;
    private static char F = (char)20;
    private static char X = (char)21;
    private static char TS = (char)22;
    private static char CH = (char)23;
    private static char SH = (char)24;
    private static char SHCH = (char)25;
    private static char HARD = (char)26;
    private static char Y = (char)27;
    private static char SOFT = (char)28;
    private static char AE = (char)29;
    private static char IU = (char)30;
    private static char IA = (char)31;
    private static char[][] RUSSIAN_STOP_WORDS = new char[][]{{A}, {B, E, Z}, {B, O, L, E, E}, {B, Y}, {B, Y, L}, {B, Y, L, A}, {B, Y, L, I}, {B, Y, L, O}, {B, Y, T, SOFT}, {V}, {V, A, M}, {V, A, S}, {V, E, S, SOFT}, {V, O}, {V, O, T}, {V, S, E}, {V, S, E, G, O}, {V, S, E, X}, {V, Y}, {G, D, E}, {D, A}, {D, A, ZH, E}, {D, L, IA}, {D, O}, {E, G, O}, {E, E}, {E, I_}, {E, IU}, {E, S, L, I}, {E, S, T, SOFT}, {E, SHCH, E}, {ZH, E}, {Z, A}, {Z, D, E, S, SOFT}, {I}, {I, Z}, {I, L, I}, {I, M}, {I, X}, {K}, {K, A, K}, {K, O}, {K, O, G, D, A}, {K, T, O}, {L, I}, {L, I, B, O}, {M, N, E}, {M, O, ZH, E, T}, {M, Y}, {N, A}, {N, A, D, O}, {N, A, SH}, {N, E}, {N, E, G, O}, {N, E, E}, {N, E, T}, {N, I}, {N, I, X}, {N, O}, {N, U}, {O}, {O, B}, {O, D, N, A, K, O}, {O, N}, {O, N, A}, {O, N, I}, {O, N, O}, {O, T}, {O, CH, E, N, SOFT}, {P, O}, {P, O, D}, {P, R, I}, {S}, {S, O}, {T, A, K}, {T, A, K, ZH, E}, {T, A, K, O, I_}, {T, A, M}, {T, E}, {T, E, M}, {T, O}, {T, O, G, O}, {T, O, ZH, E}, {T, O, I_}, {T, O, L, SOFT, K, O}, {T, O, M}, {T, Y}, {U}, {U, ZH, E}, {X, O, T, IA}, {CH, E, G, O}, {CH, E, I_}, {CH, E, M}, {CH, T, O}, {CH, T, O, B, Y}, {CH, SOFT, E}, {CH, SOFT, IA}, {AE, T, A}, {AE, T, I}, {AE, T, O}, {IA}};
    private Set stopSet = new HashSet();
    private char[] charset;

    public RussianAnalyzer() {
        this.charset = RussianCharsets.UnicodeRussian;
        this.stopSet = StopFilter.makeStopSet(RussianAnalyzer.makeStopWords(RussianCharsets.UnicodeRussian));
    }

    public RussianAnalyzer(char[] charset) {
        this.charset = charset;
        this.stopSet = StopFilter.makeStopSet(RussianAnalyzer.makeStopWords(charset));
    }

    public RussianAnalyzer(char[] charset, String[] stopwords) {
        this.charset = charset;
        this.stopSet = StopFilter.makeStopSet(stopwords);
    }

    private static String[] makeStopWords(char[] charset) {
        String[] res = new String[RUSSIAN_STOP_WORDS.length];
        for (int i = 0; i < res.length; ++i) {
            char[] theStopWord = RUSSIAN_STOP_WORDS[i];
            StringBuffer theWord = new StringBuffer();
            for (int j = 0; j < theStopWord.length; ++j) {
                theWord.append(charset[theStopWord[j]]);
            }
            res[i] = theWord.toString();
        }
        return res;
    }

    public RussianAnalyzer(char[] charset, Hashtable stopwords) {
        this.charset = charset;
        this.stopSet = new HashSet(stopwords.keySet());
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new RussianLetterTokenizer(reader, this.charset);
        result = new RussianLowerCaseFilter(result, this.charset);
        result = new StopFilter(result, this.stopSet);
        result = new RussianStemFilter(result, this.charset);
        return result;
    }
}

