/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.analysis.ru;

import java.io.IOException;
import org.apache.lucene1.analysis.Token;
import org.apache.lucene1.analysis.TokenFilter;
import org.apache.lucene1.analysis.TokenStream;
import org.apache.lucene1.analysis.ru.RussianStemmer;

public final class RussianStemFilter
extends TokenFilter {
    private Token token = null;
    private RussianStemmer stemmer = null;

    public RussianStemFilter(TokenStream in, char[] charset) {
        super(in);
        this.stemmer = new RussianStemmer(charset);
    }

    public final Token next() throws IOException {
        this.token = this.input.next();
        if (this.token == null) {
            return null;
        }
        String s = this.stemmer.stem(this.token.termText());
        if (!s.equals(this.token.termText())) {
            return new Token(s, this.token.startOffset(), this.token.endOffset(), this.token.type());
        }
        return this.token;
    }

    public void setStemmer(RussianStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }
}

