/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.WeakHashMap;
import org.apache.lucene1.index.IndexReader;
import org.apache.lucene1.search.Filter;
import org.apache.lucene1.search.HitCollector;
import org.apache.lucene1.search.IndexSearcher;
import org.apache.lucene1.search.Query;

public class QueryFilter
extends Filter {
    private Query query;
    private transient WeakHashMap cache = null;

    public QueryFilter(Query query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        if (this.cache == null) {
            this.cache = new WeakHashMap();
        }
        WeakHashMap weakHashMap = this.cache;
        synchronized (weakHashMap) {
            BitSet cached = (BitSet)this.cache.get(reader);
            if (cached != null) {
                return cached;
            }
        }
        final BitSet bits = new BitSet(reader.maxDoc());
        new IndexSearcher(reader).search(this.query, new HitCollector(){

            public final void collect(int doc, float score) {
                bits.set(doc);
            }
        });
        WeakHashMap weakHashMap2 = this.cache;
        synchronized (weakHashMap2) {
            this.cache.put(reader, bits);
        }
        return bits;
    }

    public String toString() {
        return "QueryFilter(" + this.query + ")";
    }
}

