/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.search.spans;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene1.index.IndexReader;
import org.apache.lucene1.search.spans.SpanQuery;
import org.apache.lucene1.search.spans.Spans;

public class SpanFirstQuery
extends SpanQuery {
    private SpanQuery match;
    private int end;

    public SpanFirstQuery(SpanQuery match, int end) {
        this.match = match;
        this.end = end;
    }

    public SpanQuery getMatch() {
        return this.match;
    }

    public int getEnd() {
        return this.end;
    }

    public String getField() {
        return this.match.getField();
    }

    public Collection getTerms() {
        return this.match.getTerms();
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanFirst(");
        buffer.append(this.match.toString(field));
        buffer.append(", ");
        buffer.append(this.end);
        buffer.append(")");
        return buffer.toString();
    }

    public Spans getSpans(final IndexReader reader) throws IOException {
        return new Spans(){
            private Spans spans;
            {
                this.spans = SpanFirstQuery.this.match.getSpans(reader);
            }

            public boolean next() throws IOException {
                while (this.spans.next()) {
                    if (this.end() > SpanFirstQuery.this.end) continue;
                    return true;
                }
                return false;
            }

            public boolean skipTo(int target) throws IOException {
                if (!this.spans.skipTo(target)) {
                    return false;
                }
                if (this.spans.end() <= SpanFirstQuery.this.end) {
                    return true;
                }
                return this.next();
            }

            public int doc() {
                return this.spans.doc();
            }

            public int start() {
                return this.spans.start();
            }

            public int end() {
                return this.spans.end();
            }

            public String toString() {
                return "spans(" + SpanFirstQuery.this.toString() + ")";
            }
        };
    }
}

