/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene1.store.OutputStream;

final class FSOutputStream
extends OutputStream {
    RandomAccessFile file = null;

    public FSOutputStream(File path) throws IOException {
        this.file = new RandomAccessFile(path, "rw");
    }

    public final void flushBuffer(byte[] b, int size) throws IOException {
        this.file.write(b, 0, size);
    }

    public final void close() throws IOException {
        super.close();
        this.file.close();
    }

    public final void seek(long pos) throws IOException {
        super.seek(pos);
        this.file.seek(pos);
    }

    public final long length() throws IOException {
        return this.file.length();
    }

    protected final void finalize() throws IOException {
        this.file.close();
    }
}

