/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.store;

import java.io.IOException;

public abstract class InputStream
implements Cloneable {
    static final int BUFFER_SIZE = 1024;
    private byte[] buffer;
    private char[] chars;
    private long bufferStart = 0L;
    private int bufferLength = 0;
    private int bufferPosition = 0;
    protected long length;

    public final byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        if (len < 1024) {
            for (int i = 0; i < len; ++i) {
                b[i + offset] = this.readByte();
            }
        } else {
            long start = this.getFilePointer();
            this.seekInternal(start);
            this.readInternal(b, offset, len);
            this.bufferStart = start + (long)len;
            this.bufferPosition = 0;
            this.bufferLength = 0;
        }
    }

    public final int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public final int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public final long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public final long readVLong() throws IOException {
        byte b = this.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public final String readString() throws IOException {
        int length = this.readVInt();
        if (this.chars == null || length > this.chars.length) {
            this.chars = new char[length];
        }
        this.readChars(this.chars, 0, length);
        return new String(this.chars, 0, length);
    }

    public final void readChars(char[] buffer, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            byte b = this.readByte();
            buffer[i] = (b & 0x80) == 0 ? (char)(b & 0x7F) : ((b & 0xE0) != 224 ? (char)((b & 0x1F) << 6 | this.readByte() & 0x3F) : (char)((b & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | this.readByte() & 0x3F));
        }
    }

    private void refill() throws IOException {
        long start = this.bufferStart + (long)this.bufferPosition;
        long end = start + 1024L;
        if (end > this.length) {
            end = this.length;
        }
        this.bufferLength = (int)(end - start);
        if (this.bufferLength == 0) {
            throw new IOException("read past EOF");
        }
        if (this.buffer == null) {
            this.buffer = new byte[1024];
        }
        this.readInternal(this.buffer, 0, this.bufferLength);
        this.bufferStart = start;
        this.bufferPosition = 0;
    }

    protected abstract void readInternal(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close() throws IOException;

    public final long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public final void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(pos - this.bufferStart);
        } else {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    public final long length() {
        return this.length;
    }

    public Object clone() {
        InputStream clone = null;
        try {
            clone = (InputStream)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.buffer != null) {
            clone.buffer = new byte[1024];
            System.arraycopy(this.buffer, 0, clone.buffer, 0, this.bufferLength);
        }
        clone.chars = null;
        return clone;
    }
}

