/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.generator;

import java.util.StringTokenizer;

public class RecordUtil {
    private static final String CR = "\n";

    public static String getFieldName(int position, String name, int padTo) {
        StringBuffer fieldName = new StringBuffer("field_" + position + "_");
        RecordUtil.toIdentifier(name, fieldName);
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    protected static StringBuffer pad(StringBuffer fieldName, int padTo) {
        for (int i = fieldName.length(); i < padTo; ++i) {
            fieldName.append(' ');
        }
        return fieldName;
    }

    public static String getFieldName(String name, int padTo) {
        StringBuffer fieldName = new StringBuffer();
        RecordUtil.toIdentifier(name, fieldName);
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    public static String getFieldName1stCap(String name, int padTo) {
        StringBuffer fieldName = new StringBuffer();
        RecordUtil.toIdentifier(name, fieldName);
        fieldName.setCharAt(0, Character.toUpperCase(fieldName.charAt(0)));
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    public static String clone(String name, String type, int pos) {
        StringBuffer fieldName = new StringBuffer();
        RecordUtil.toIdentifier(name, fieldName);
        String javaFieldName = RecordUtil.getFieldName(pos, name, 0);
        if (type.startsWith("custom:")) {
            String javaType = type.substring(7);
            return "rec." + javaFieldName + " = ((" + javaType + ")" + javaFieldName + ".clone());";
        }
        return "rec." + javaFieldName + " = " + javaFieldName;
    }

    public static String initializeText(String size, String type) {
        return "";
    }

    private static void toIdentifier(String name, StringBuffer fieldName) {
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ' ') {
                fieldName.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            fieldName.append(name.charAt(i));
        }
    }

    private static void toConstIdentifier(String name, StringBuffer fieldName) {
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ' ') {
                fieldName.append('_');
                continue;
            }
            fieldName.append(Character.toUpperCase(name.charAt(i)));
        }
    }

    public static String getType(String size, String type, int padTo) {
        boolean wholeNumber;
        boolean bl = wholeNumber = type.equals("bits") || type.equals("int");
        if (wholeNumber && "1".equals(size)) {
            return RecordUtil.pad(new StringBuffer("byte"), padTo).toString();
        }
        if (wholeNumber && "2".equals(size)) {
            return RecordUtil.pad(new StringBuffer("short"), padTo).toString();
        }
        if (type.equals("int") && "varword".equals(size)) {
            return RecordUtil.pad(new StringBuffer("short[]"), padTo).toString();
        }
        if (wholeNumber && "4".equals(size)) {
            return RecordUtil.pad(new StringBuffer("int"), padTo).toString();
        }
        if (type.equals("float") && "8".equals(size)) {
            return RecordUtil.pad(new StringBuffer("double"), padTo).toString();
        }
        if (type.equals("string")) {
            return RecordUtil.pad(new StringBuffer("String"), padTo).toString();
        }
        if (type.equals("hbstring")) {
            return RecordUtil.pad(new StringBuffer("String"), padTo).toString();
        }
        if (type.startsWith("custom:")) {
            int pos = type.lastIndexOf(46);
            return RecordUtil.pad(new StringBuffer(type.substring(pos + 1)), padTo).toString();
        }
        return "short";
    }

    /*
     * WARNING - void declaration
     */
    public static String getType1stCap(String size, String type, int padTo) {
        void var3_4;
        StringBuffer result;
        boolean numeric;
        boolean bl = numeric = type.equals("bits") || type.equals("int");
        if (numeric && "1".equals(size)) {
            result = RecordUtil.pad(new StringBuffer("byte"), padTo);
        } else if (type.equals("int") && "varword".equals(size)) {
            result = RecordUtil.pad(new StringBuffer("short[]"), padTo);
        } else if (numeric && "2".equals(size)) {
            result = RecordUtil.pad(new StringBuffer("short"), padTo);
        } else if (type.equals("string")) {
            result = RecordUtil.pad(new StringBuffer("String"), padTo);
        } else if (type.equals("hbstring")) {
            result = RecordUtil.pad(new StringBuffer("HighByteString"), padTo);
        } else {
            return "";
        }
        var3_4.setCharAt(0, Character.toUpperCase(var3_4.charAt(0)));
        return var3_4.toString();
    }

    public static String getMask(int bit) {
        int mask = (int)Math.pow(2.0, bit);
        return "0x" + Integer.toHexString(mask);
    }

    public static String getConstName(String parentName, String constName, int padTo) {
        StringBuffer fieldName = new StringBuffer();
        RecordUtil.toConstIdentifier(parentName, fieldName);
        fieldName.append('_');
        RecordUtil.toConstIdentifier(constName, fieldName);
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    public static String getByteArrayString(String data) {
        StringTokenizer tokenizer = new StringTokenizer(data);
        StringBuffer retval = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            retval.append("(byte)0x").append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            retval.append(",");
        }
        return retval.toString();
    }

    public static String getToString(String fieldName, String type, String size) {
        StringBuffer result = new StringBuffer();
        result.append("        buffer.append(\"    .");
        result.append(RecordUtil.getFieldName(fieldName, 20));
        result.append(" = \")\n");
        if (!(type.equals("string") || type.equals("hbstring") || type.equals("float") || size.equals("varword") || type.startsWith("custom:"))) {
            result.append("            .append(\"0x\")");
            result.append(".append(HexDump.toHex( ");
            result.append(" get");
            result.append(RecordUtil.getFieldName1stCap(fieldName, 0));
            result.append(" ()))\n");
        }
        result.append("            .append(\" (\").append( get");
        result.append(RecordUtil.getFieldName1stCap(fieldName, 0));
        result.append("() ).append(\" )\");");
        return result.toString();
    }

    public static String getRecordId(String recordName, String excelName) {
        if (excelName == null || excelName.equals("")) {
            return recordName;
        }
        return excelName;
    }
}

