/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hpsf;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.UnexpectedException;
import org.apache.poi1.hpsf.DocumentSummaryInformation;
import org.apache.poi1.hpsf.HPSFRuntimeException;
import org.apache.poi1.hpsf.MarkUnsupportedException;
import org.apache.poi1.hpsf.MutablePropertySet;
import org.apache.poi1.hpsf.MutableSection;
import org.apache.poi1.hpsf.NoPropertySetStreamException;
import org.apache.poi1.hpsf.PropertySet;
import org.apache.poi1.hpsf.SummaryInformation;
import org.apache.poi1.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi1.hpsf.wellknown.SectionIDMap;

public class PropertySetFactory {
    public static PropertySet create(InputStream stream) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        PropertySet ps = new PropertySet(stream);
        try {
            if (ps.isSummaryInformation()) {
                return new SummaryInformation(ps);
            }
            if (ps.isDocumentSummaryInformation()) {
                return new DocumentSummaryInformation(ps);
            }
            return ps;
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new UnexpectedException(ex.toString());
        }
    }

    public static SummaryInformation newSummaryInformation() {
        MutablePropertySet ps = new MutablePropertySet();
        MutableSection s = (MutableSection)ps.getFirstSection();
        s.setFormatID(SectionIDMap.SUMMARY_INFORMATION_ID);
        try {
            return new SummaryInformation((PropertySet)ps);
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new HPSFRuntimeException(ex);
        }
    }

    public static DocumentSummaryInformation newDocumentSummaryInformation() {
        MutablePropertySet ps = new MutablePropertySet();
        MutableSection s = (MutableSection)ps.getFirstSection();
        s.setFormatID(SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID[0]);
        try {
            return new DocumentSummaryInformation((PropertySet)ps);
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new HPSFRuntimeException(ex);
        }
    }
}

