/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record;

import org.apache.poi1.hssf.record.Record;
import org.apache.poi1.hssf.record.RecordFormatException;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.util.LittleEndian;

public class InterfaceHdrRecord
extends Record {
    public static final short sid = 225;
    private short field_1_codepage;
    public static final short CODEPAGE = 1200;

    public InterfaceHdrRecord() {
    }

    public InterfaceHdrRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 225) {
            throw new RecordFormatException("NOT A INTERFACEHDR RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_codepage = in.readShort();
    }

    public void setCodepage(short cp) {
        this.field_1_codepage = cp;
    }

    public short getCodepage() {
        return this.field_1_codepage;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[INTERFACEHDR]\n");
        buffer.append("    .codepage        = ").append(Integer.toHexString(this.getCodepage())).append("\n");
        buffer.append("[/INTERFACEHDR]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)225);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getCodepage());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 225;
    }
}

