/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record.formula;

import org.apache.poi1.hssf.model.Workbook;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.hssf.record.formula.Ptg;
import org.apache.poi1.hssf.util.AreaReference;
import org.apache.poi1.hssf.util.CellReference;
import org.apache.poi1.hssf.util.SheetReferences;
import org.apache.poi1.util.BitField;
import org.apache.poi1.util.BitFieldFactory;
import org.apache.poi1.util.LittleEndian;

public class Area3DPtg
extends Ptg {
    public static final byte sid = 59;
    private static final int SIZE = 11;
    private short field_1_index_extern_sheet;
    private short field_2_first_row;
    private short field_3_last_row;
    private short field_4_first_column;
    private short field_5_last_column;
    private BitField rowRelative = BitFieldFactory.getInstance(32768);
    private BitField colRelative = BitFieldFactory.getInstance(16384);

    public Area3DPtg() {
    }

    public Area3DPtg(String arearef, short externIdx) {
        this.setArea(arearef);
        this.setExternSheetIndex(externIdx);
    }

    public Area3DPtg(RecordInputStream in) {
        this.field_1_index_extern_sheet = in.readShort();
        this.field_2_first_row = in.readShort();
        this.field_3_last_row = in.readShort();
        this.field_4_first_column = in.readShort();
        this.field_5_last_column = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AreaPtg\n");
        buffer.append("Index to Extern Sheet = " + this.getExternSheetIndex()).append("\n");
        buffer.append("firstRow = " + this.getFirstRow()).append("\n");
        buffer.append("lastRow  = " + this.getLastRow()).append("\n");
        buffer.append("firstCol = " + this.getFirstColumn()).append("\n");
        buffer.append("lastCol  = " + this.getLastColumn()).append("\n");
        buffer.append("firstColRel= " + this.isFirstRowRelative()).append("\n");
        buffer.append("lastColRowRel = " + this.isLastRowRelative()).append("\n");
        buffer.append("firstColRel   = " + this.isFirstColRelative()).append("\n");
        buffer.append("lastColRel    = " + this.isLastColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[0 + offset] = (byte)(59 + this.ptgClass);
        LittleEndian.putShort(array, 1 + offset, this.getExternSheetIndex());
        LittleEndian.putShort(array, 3 + offset, this.getFirstRow());
        LittleEndian.putShort(array, 5 + offset, this.getLastRow());
        LittleEndian.putShort(array, 7 + offset, this.getFirstColumnRaw());
        LittleEndian.putShort(array, 9 + offset, this.getLastColumnRaw());
    }

    public int getSize() {
        return 11;
    }

    public short getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    public void setExternSheetIndex(short index) {
        this.field_1_index_extern_sheet = index;
    }

    public short getFirstRow() {
        return this.field_2_first_row;
    }

    public void setFirstRow(short row) {
        this.field_2_first_row = row;
    }

    public short getLastRow() {
        return this.field_3_last_row;
    }

    public void setLastRow(short row) {
        this.field_3_last_row = row;
    }

    public short getFirstColumn() {
        return (short)(this.field_4_first_column & 0xFF);
    }

    public short getFirstColumnRaw() {
        return this.field_4_first_column;
    }

    public boolean isFirstRowRelative() {
        return this.rowRelative.isSet(this.field_4_first_column);
    }

    public boolean isFirstColRelative() {
        return this.colRelative.isSet(this.field_4_first_column);
    }

    public void setFirstColumn(short column) {
        this.field_4_first_column = (short)(this.field_4_first_column & 0xFF00);
        this.field_4_first_column = (short)(this.field_4_first_column | column & 0xFF);
    }

    public void setFirstColumnRaw(short column) {
        this.field_4_first_column = column;
    }

    public short getLastColumn() {
        return (short)(this.field_5_last_column & 0xFF);
    }

    public short getLastColumnRaw() {
        return this.field_5_last_column;
    }

    public boolean isLastRowRelative() {
        return this.rowRelative.isSet(this.field_5_last_column);
    }

    public boolean isLastColRelative() {
        return this.colRelative.isSet(this.field_5_last_column);
    }

    public void setLastColumn(short column) {
        this.field_5_last_column = (short)(this.field_5_last_column & 0xFF00);
        this.field_5_last_column = (short)(this.field_5_last_column | column & 0xFF);
    }

    public void setLastColumnRaw(short column) {
        this.field_5_last_column = column;
    }

    public void setFirstRowRelative(boolean rel) {
        this.field_4_first_column = this.rowRelative.setShortBoolean(this.field_4_first_column, rel);
    }

    public void setFirstColRelative(boolean rel) {
        this.field_4_first_column = this.colRelative.setShortBoolean(this.field_4_first_column, rel);
    }

    public void setLastRowRelative(boolean rel) {
        this.field_5_last_column = this.rowRelative.setShortBoolean(this.field_5_last_column, rel);
    }

    public void setLastColRelative(boolean rel) {
        this.field_5_last_column = this.colRelative.setShortBoolean(this.field_5_last_column, rel);
    }

    public void setArea(String ref) {
        AreaReference ar = new AreaReference(ref);
        this.setFirstRow((short)ar.getCells()[0].getRow());
        this.setFirstColumn(ar.getCells()[0].getCol());
        this.setLastRow((short)ar.getCells()[1].getRow());
        this.setLastColumn(ar.getCells()[1].getCol());
        this.setFirstColRelative(!ar.getCells()[0].isColAbsolute());
        this.setLastColRelative(!ar.getCells()[1].isColAbsolute());
        this.setFirstRowRelative(!ar.getCells()[0].isRowAbsolute());
        this.setLastRowRelative(!ar.getCells()[1].isRowAbsolute());
    }

    public String toFormulaString(Workbook book) {
        SheetReferences refs = book == null ? null : book.getSheetReferences();
        StringBuffer retval = new StringBuffer();
        if (refs != null) {
            retval.append(refs.getSheetName(this.field_1_index_extern_sheet));
            retval.append('!');
        }
        retval.append(new CellReference(this.getFirstRow(), this.getFirstColumn(), !this.isFirstRowRelative(), !this.isFirstColRelative()).toString());
        retval.append(':');
        retval.append(new CellReference(this.getLastRow(), this.getLastColumn(), !this.isLastRowRelative(), !this.isLastColRelative()).toString());
        return retval.toString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public Object clone() {
        Area3DPtg ptg = new Area3DPtg();
        ptg.field_1_index_extern_sheet = this.field_1_index_extern_sheet;
        ptg.field_2_first_row = this.field_2_first_row;
        ptg.field_3_last_row = this.field_3_last_row;
        ptg.field_4_first_column = this.field_4_first_column;
        ptg.field_5_last_column = this.field_5_last_column;
        ptg.setClass(this.ptgClass);
        return ptg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Area3DPtg)) {
            return false;
        }
        Area3DPtg area3DPtg = (Area3DPtg)o;
        if (this.field_1_index_extern_sheet != area3DPtg.field_1_index_extern_sheet) {
            return false;
        }
        if (this.field_2_first_row != area3DPtg.field_2_first_row) {
            return false;
        }
        if (this.field_3_last_row != area3DPtg.field_3_last_row) {
            return false;
        }
        if (this.field_4_first_column != area3DPtg.field_4_first_column) {
            return false;
        }
        return this.field_5_last_column == area3DPtg.field_5_last_column;
    }

    public int hashCode() {
        int result = this.field_1_index_extern_sheet;
        result = 29 * result + this.field_2_first_row;
        result = 29 * result + this.field_3_last_row;
        result = 29 * result + this.field_4_first_column;
        result = 29 * result + this.field_5_last_column;
        return result;
    }
}

