/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.record.formula;

import org.apache.poi1.hssf.model.Workbook;
import org.apache.poi1.hssf.record.RecordInputStream;
import org.apache.poi1.hssf.record.formula.Ptg;
import org.apache.poi1.util.BitField;
import org.apache.poi1.util.BitFieldFactory;
import org.apache.poi1.util.StringUtil;

public class StringPtg
extends Ptg {
    public static final int SIZE = 9;
    public static final byte sid = 23;
    int field_1_length;
    byte field_2_options;
    BitField fHighByte = BitFieldFactory.getInstance(1);
    private String field_3_string;

    private StringPtg() {
    }

    public StringPtg(RecordInputStream in) {
        this.field_1_length = in.readByte() & 0xFF;
        this.field_2_options = in.readByte();
        this.field_3_string = this.fHighByte.isSet(this.field_2_options) ? in.readUnicodeLEString(this.field_1_length) : in.readCompressedUnicode(this.field_1_length);
    }

    public StringPtg(String value) {
        if (value.length() > 255) {
            throw new IllegalArgumentException("String literals in formulas cant be bigger than 255 characters ASCII");
        }
        this.field_2_options = 0;
        this.field_2_options = (byte)this.fHighByte.setBoolean(this.field_2_options, StringUtil.hasMultibyte(value));
        this.field_3_string = value;
        this.field_1_length = value.length();
    }

    public String getValue() {
        return this.field_3_string;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 23;
        array[offset + 1] = (byte)this.field_1_length;
        array[offset + 2] = this.field_2_options;
        if (this.fHighByte.isSet(this.field_2_options)) {
            StringUtil.putUnicodeLE(this.getValue(), array, offset + 3);
        } else {
            StringUtil.putCompressedUnicode(this.getValue(), array, offset + 3);
        }
    }

    public int getSize() {
        if (this.fHighByte.isSet(this.field_2_options)) {
            return 2 * this.field_1_length + 3;
        }
        return this.field_1_length + 3;
    }

    public String toFormulaString(Workbook book) {
        return "\"" + this.getValue() + "\"";
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        StringPtg ptg = new StringPtg();
        ptg.field_1_length = this.field_1_length;
        ptg.field_2_options = this.field_2_options;
        ptg.field_3_string = this.field_3_string;
        return ptg;
    }
}

