/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.hssf.usermodel;

import org.apache.poi1.hssf.usermodel.HSSFAnchor;
import org.apache.poi1.hssf.usermodel.HSSFChildAnchor;
import org.apache.poi1.hssf.usermodel.HSSFClientAnchor;

public abstract class HSSFShape {
    public static final int LINEWIDTH_ONE_PT = 12700;
    public static final int LINEWIDTH_DEFAULT = 9525;
    public static final int LINESTYLE_SOLID = 0;
    public static final int LINESTYLE_DASHSYS = 1;
    public static final int LINESTYLE_DOTSYS = 2;
    public static final int LINESTYLE_DASHDOTSYS = 3;
    public static final int LINESTYLE_DASHDOTDOTSYS = 4;
    public static final int LINESTYLE_DOTGEL = 5;
    public static final int LINESTYLE_DASHGEL = 6;
    public static final int LINESTYLE_LONGDASHGEL = 7;
    public static final int LINESTYLE_DASHDOTGEL = 8;
    public static final int LINESTYLE_LONGDASHDOTGEL = 9;
    public static final int LINESTYLE_LONGDASHDOTDOTGEL = 10;
    public static final int LINESTYLE_NONE = -1;
    HSSFShape parent;
    HSSFAnchor anchor;
    int lineStyleColor = 0x8000040;
    int fillColor = 0x8000009;
    int lineWidth = 9525;
    int lineStyle = 0;
    boolean noFill = false;

    HSSFShape(HSSFShape parent, HSSFAnchor anchor) {
        this.parent = parent;
        this.anchor = anchor;
    }

    public HSSFShape getParent() {
        return this.parent;
    }

    public HSSFAnchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(HSSFAnchor anchor) {
        if (this.parent == null) {
            if (anchor instanceof HSSFChildAnchor) {
                throw new IllegalArgumentException("Must use client anchors for shapes directly attached to sheet.");
            }
        } else if (anchor instanceof HSSFClientAnchor) {
            throw new IllegalArgumentException("Must use child anchors for shapes attached to groups.");
        }
        this.anchor = anchor;
    }

    public int getLineStyleColor() {
        return this.lineStyleColor;
    }

    public void setLineStyleColor(int lineStyleColor) {
        this.lineStyleColor = lineStyleColor;
    }

    public void setLineStyleColor(int red, int green, int blue) {
        this.lineStyleColor = blue << 16 | green << 8 | red;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
    }

    public void setFillColor(int red, int green, int blue) {
        this.fillColor = blue << 16 | green << 8 | red;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    public boolean isNoFill() {
        return this.noFill;
    }

    public void setNoFill(boolean noFill) {
        this.noFill = noFill;
    }

    public int countOfAllChildren() {
        return 1;
    }
}

