/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi1.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi1.poifs.property.Property;
import org.apache.poi1.poifs.storage.BigBlock;
import org.apache.poi1.poifs.storage.BlockWritable;

public class PropertyBlock
extends BigBlock {
    private static final int _properties_per_block = 4;
    private Property[] _properties = new Property[4];

    private PropertyBlock(Property[] properties, int offset) {
        for (int j = 0; j < 4; ++j) {
            this._properties[j] = properties[j + offset];
        }
    }

    public static BlockWritable[] createPropertyBlockArray(List properties) {
        int block_count = (properties.size() + 4 - 1) / 4;
        Property[] to_be_written = new Property[block_count * 4];
        System.arraycopy(properties.toArray(new Property[0]), 0, to_be_written, 0, properties.size());
        for (int j = properties.size(); j < to_be_written.length; ++j) {
            to_be_written[j] = new Property(){

                protected void preWrite() {
                }

                public boolean isDirectory() {
                    return false;
                }
            };
        }
        BlockWritable[] rvalue = new BlockWritable[block_count];
        for (int j = 0; j < block_count; ++j) {
            rvalue[j] = new PropertyBlock(to_be_written, j * 4);
        }
        return rvalue;
    }

    void writeData(OutputStream stream) throws IOException {
        for (int j = 0; j < 4; ++j) {
            this._properties[j].writeData(stream);
        }
    }
}

