/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.report.client.util.ReportResourceUtil;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.cp.eip.mc.IJobDelegate;
import com.kingdee.eas.cp.eip.mc.JobDelegateFactory;
import com.kingdee.eas.cp.eip.mc.ProcSelectedInfo;
import com.kingdee.eas.cp.eip.mc.client.AbstractNewProcF7DialogUI;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class NewProcF7DialogUI
extends AbstractNewProcF7DialogUI {
    private static final Logger logger = CoreUIObject.getLogger(NewProcF7DialogUI.class);
    private DefaultKingdeeTreeNode nodeRoot = null;
    private HashSet set = new HashSet();
    private String[] orgFliter = null;
    private HashMap selectedProcMap = null;
    HashMap allProcMap = new HashMap();
    private boolean cancle = true;

    public Object getData() {
        return this.selectedProcMap;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.orgFliter == null) {
            this.orgFliter = (String[])this.getUIContext().get("orgFilter");
        }
        if (this.selectedProcMap == null) {
            this.selectedProcMap = (HashMap)this.getUIContext().get("selectedProcMap");
        }
        this.tblProc.checkParsed();
        this.tblProc.getSelectManager().setSelectMode(10);
        this.tblProc.setEditable(false);
        this.tblSelectedProc.checkParsed();
        this.tblSelectedProc.getSelectManager().setSelectMode(10);
        this.tblSelectedProc.setEditable(false);
        this.initTree();
        this.getProcessDataAndFill(null);
        this.fillSelectedProcData();
    }

    private void fillSelectedProcData() {
        if (this.selectedProcMap != null && this.selectedProcMap.size() > 0) {
            for (String procId : this.selectedProcMap.keySet()) {
                ProcSelectedInfo procInfo = (ProcSelectedInfo)this.selectedProcMap.get(procId);
                IRow row = this.tblSelectedProc.addRow();
                ICell cell = row.getCell("procId");
                cell.setValue((Object)procInfo.getProcDefId());
                cell = row.getCell("procName");
                cell.setValue((Object)procInfo.getName());
                if (procInfo.getProcCode() == null && procInfo.getDescription() == null && this.allProcMap != null && this.allProcMap.containsKey(procId)) {
                    procInfo = (ProcSelectedInfo)this.allProcMap.get(procId);
                    cell = row.getCell("procCode");
                    cell.setValue((Object)procInfo.getProcCode());
                    cell = row.getCell("description");
                    cell.setValue((Object)procInfo.getDescription());
                    this.selectedProcMap.put(procId, procInfo);
                    continue;
                }
                cell = row.getCell("procCode");
                cell.setValue((Object)procInfo.getProcCode());
                cell = row.getCell("description");
                cell.setValue((Object)procInfo.getDescription());
            }
        }
    }

    private boolean isSelected(String procId) {
        if (this.selectedProcMap != null) {
            return this.selectedProcMap.containsKey(procId);
        }
        this.selectedProcMap = new HashMap();
        return false;
    }

    private void searchProcessDataAndFill(String[] searchParam) {
        IJobDelegate delegate = null;
        HashMap map = new HashMap();
        try {
            delegate = JobDelegateFactory.getRemoteInstance();
            map = delegate.getProcessNew(this.orgFliter, null, searchParam);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        this.fillProcData(map);
    }

    private void getProcessDataAndFill(String packageName) {
        IJobDelegate delegate = null;
        try {
            delegate = JobDelegateFactory.getRemoteInstance();
            this.allProcMap = delegate.getProcessNew(this.orgFliter, packageName, null);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        this.fillProcData(this.allProcMap);
    }

    private void fillProcData(HashMap map) {
        String procId2 = null;
        ProcSelectedInfo info = null;
        this.tblProc.removeRows();
        for (String procId2 : map.keySet()) {
            info = (ProcSelectedInfo)map.get(procId2);
            IRow row = this.tblProc.addRow();
            ICell cell = row.getCell("procId");
            cell.setValue((Object)procId2);
            cell = row.getCell("procCode");
            cell.setValue((Object)info.getProcCode());
            cell = row.getCell("procName");
            cell.setValue((Object)info.getName());
            cell = row.getCell("description");
            cell.setValue((Object)info.getDescription());
        }
    }

    private void getPackageName(IBriefViewTreeNode root, HashSet set) {
        String packageName = root.getPackageName();
        set.add(packageName);
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode node = (IBriefViewTreeNode)enu.nextElement();
            this.getPackageName(node, set);
        }
    }

    private boolean isShowNode(String packageName) {
        for (String str : this.set) {
            if (!packageName.equalsIgnoreCase(str) && !str.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    private DefaultKingdeeTreeNode convertToKingdeeTreeNode(IBriefViewTreeNode root, DefaultKingdeeTreeNode nodeRoot) {
        nodeRoot.setText(root.getAlias());
        nodeRoot.setUserObject((Object)root);
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)enu.nextElement();
            if (!this.isShowNode(bvNode.getPackageName())) continue;
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setText(bvNode.getAlias());
            node.setUserObject((Object)bvNode);
            nodeRoot.add((MutableTreeNode)node);
            this.convertToKingdeeTreeNode(bvNode, node);
        }
        return nodeRoot;
    }

    public void initTree() {
        BOSObjectType[] types = new BOSObjectType[]{MetaDataTypeList.PACKAGE};
        IBriefViewTreeNode root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_packages", (BOSObjectType[])types);
        this.set.clear();
        this.getPackageName(root, this.set);
        this.nodeRoot = new DefaultKingdeeTreeNode((Object)"EAS");
        this.nodeRoot = this.convertToKingdeeTreeNode(root, this.nodeRoot);
        this.nodeRoot.setText(ReportResourceUtil.getReportMultiLanguageResource((String)"ALL_PROCESS_TREE"));
        this.flowPackTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.nodeRoot));
        this.flowPackTree.getSelectionModel().setSelectionMode(1);
        this.flowPackTree.setAutoscrolls(true);
        this.flowPackTree.setSelectionNode(this.nodeRoot);
        this.flowPackTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object object = NewProcF7DialogUI.this.flowPackTree.getLastSelectedPathComponent();
                if (object != null && object instanceof DefaultKingdeeTreeNode) {
                    IBriefViewTreeNode currentNodeObject = (IBriefViewTreeNode)((DefaultKingdeeTreeNode)object).getUserObject();
                    NewProcF7DialogUI.this.getProcessDataAndFill(currentNodeObject.getPackageName());
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isCancle() {
        return this.cancle;
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        String searchText = this.txtSearchProc.getText();
        String[] searchParam = new String[]{searchText, new Integer(this.cbSearchType.getSelectedIndex()).toString(), Boolean.toString(this.cbMoHu.isSelected())};
        this.searchProcessDataAndFill(searchParam);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.cancle = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.cancle = true;
        this.getUIWindow().close();
    }

    @Override
    protected void tblProc_tableClicked(KDTMouseEvent e) throws Exception {
        if (e != null && e.getType() != 0 && e.getClickCount() == 2) {
            this.btnAddProc_actionPerformed(null);
        }
    }

    @Override
    protected void btnAddProc_actionPerformed(ActionEvent e) throws Exception {
        List rowIndex = this.getTableSelectRow(this.tblProc);
        if (rowIndex.size() > 0) {
            for (Integer rowNum : rowIndex) {
                IRow row = this.tblProc.getRow(rowNum.intValue());
                String procDefId = (String)row.getCell("procId").getValue();
                String procCode = (String)row.getCell("procCode").getValue();
                String procName = (String)row.getCell("procName").getValue();
                String description = (String)row.getCell("description").getValue();
                if (this.isSelected(procDefId)) continue;
                ProcSelectedInfo procInfo = new ProcSelectedInfo();
                row = this.tblSelectedProc.addRow();
                ICell cell = row.getCell("procId");
                cell.setValue((Object)procDefId);
                cell = row.getCell("procCode");
                cell.setValue((Object)procCode);
                cell = row.getCell("procName");
                cell.setValue((Object)procName);
                cell = row.getCell("description");
                cell.setValue((Object)description);
                procInfo.setName(procName);
                procInfo.setProcDefId(procDefId);
                procInfo.setProcCode(procCode);
                procInfo.setDescription(description);
                this.selectedProcMap.put(procDefId, procInfo);
            }
        }
    }

    @Override
    protected void btnDeleteProc_actionPerformed(ActionEvent e) throws Exception {
        List rowIndex = this.getTableSelectRow(this.tblSelectedProc);
        Collections.sort(rowIndex);
        if (rowIndex.size() > 0) {
            for (int i = rowIndex.size() - 1; i >= 0; --i) {
                Integer rowNum = (Integer)rowIndex.get(i);
                IRow row = this.tblSelectedProc.getRow(rowNum.intValue());
                String procDefId = (String)row.getCell("procId").getValue();
                this.tblSelectedProc.removeRow(rowNum.intValue());
                this.selectedProcMap.remove(procDefId);
            }
        }
    }

    private List getTableSelectRow(KDTable table) {
        LinkedList<Integer> indexList;
        block7: {
            int size;
            block6: {
                indexList = new LinkedList<Integer>();
                size = table.getSelectManager().size();
                if (size != 1) break block6;
                KDTSelectBlock sb = table.getSelectManager().get();
                if (sb.getMode() == 8) {
                    for (int i = 0; i < table.getRowCount(); ++i) {
                        indexList.add(new Integer(i));
                    }
                } else {
                    for (int i = sb.getTop(); i <= sb.getBottom(); ++i) {
                        indexList.add(new Integer(i));
                    }
                }
                break block7;
            }
            if (size <= 1) break block7;
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = table.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    indexList.add(new Integer(j));
                }
            }
        }
        return indexList;
    }
}

