/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.eas.cp.common.web.util.WebContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class PortalContextUtil {
    private static Logger logger = Logger.getLogger(PortalContextUtil.class);

    public static Context getEasContext(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Context ctx = (Context)session.getAttribute("pureWebContext");
        if (ctx != null) {
            return ctx;
        }
        return PortalContextUtil.getRealEasContext(request);
    }

    public static Context getRealEasContext(HttpServletRequest request) {
        WebContext webContext = PortalContextUtil.getWebContext(request);
        Context ctx = null;
        if (webContext != null) {
            String sessionID = webContext.getSessionId();
            try {
                ctx = SessionManager.getInstance().getSession(sessionID).getContext();
            }
            catch (Exception e) {
                logger.error((Object)("[Eas portal]get eas user server context fails. context is null." + e.getMessage()));
            }
        } else {
            logger.error((Object)"[Eas portal]webContext is null.");
        }
        return ctx;
    }

    public static WebContext getWebContext(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebContext webContext = (WebContext)session.getAttribute("easWebContextSessionId");
        return webContext;
    }

    public static String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.equals("/")) {
            contextPath = "";
        }
        return contextPath;
    }

    public static String getEasWebApplicationPath() {
        return "/easweb";
    }

    public static String getOldPortalApplicationPath() {
        return "/easportal";
    }
}

