/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class WebAdminF7 {
    private static String strResource = "com.kingdee.eas.hr.base.HRBasedataResource";
    private static Logger logger = Logger.getLogger((String)WebAdminF7.class.getName());

    public String getTreeScript(String treeName, Context ctx) {
        return this.getTreeScript(treeName, ctx, false, true);
    }

    public String getTreeScript(String treeName, Context ctx, boolean includeChildCU, boolean isFilterOrg) {
        try {
            IRowSet rows = WebAdminF7.getAdminRowSet(ctx, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null, includeChildCU, isFilterOrg);
            String treeJs = WebAdminF7.buildTreeJsByRowSet(rows, includeChildCU, treeName);
            return treeJs;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getAdminFelterTreeScript(String treeName, Context ctx, boolean includeChildCU, boolean isFilterOrg) {
        if (this.isFilterByUserAdminOrgRange(ctx)) {
            Set adminCurrentUserRange = null;
            try {
                adminCurrentUserRange = WebAdminF7.getCurrentUserAdminOrgRange(ctx);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return this.getTreeScriptFilterByAdminRange(treeName, ctx, includeChildCU, isFilterOrg, adminCurrentUserRange);
        }
        return this.getTreeScript(treeName, ctx, includeChildCU, isFilterOrg);
    }

    public String getTreeScriptFilterByAdminRange(String treeName, Context ctx, boolean includeChildCU, boolean isFilterOrg, Set currentUserAdminOrgRange) {
        try {
            IRowSet rows = WebAdminF7.getAdminRowSet(ctx, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null, includeChildCU, isFilterOrg);
            String treeJs = WebAdminF7.buildFilterTreeJsByRowSet(rows, includeChildCU, treeName, currentUserAdminOrgRange);
            return treeJs;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getLowerAdminOrgTreeScript(String treeName, Context ctx) {
        try {
            IRowSet rows = WebAdminF7.getAdminRowSet(ctx, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ContextUtil.getCurrentAdminUnit((Context)ctx), false, true);
            String treeJs = WebAdminF7.buildTreeJsByRowSet(rows, false, treeName);
            return treeJs;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static IRowSet getAdminRowSet(Context ctx, String cuID, AdminOrgUnitInfo rootInfo, boolean includeChildCU, boolean isFilterOrg) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (rootInfo != null) {
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootInfo.getLongNumber()));
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootInfo.getLongNumber() + "!%"), CompareType.LIKE));
            if (includeChildCU) {
                fi.setMaskString("#0 or #1");
            } else {
                fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cuID));
                fi.setMaskString("(#0 or #1) and #2");
            }
        } else if (includeChildCU) {
            CtrlUnitInfo cuInfo = null;
            cuInfo = cuID == null ? ContextUtil.getCurrentCtrlUnit((Context)ctx) : CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuID)));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cuID));
        }
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private static String buildTreeJsByRowSet(IRowSet rows, boolean includeChildCU, String treeName) throws Exception {
        String firstLongNumber;
        if (rows == null) {
            return null;
        }
        AdminOrgUnitInfo adminInfo = null;
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        String rootLongNumber = firstLongNumber = null;
        String currentVar = "admin_0";
        String parentVar = "";
        StringBuffer sbf = new StringBuffer();
        String longNumber = "";
        String parLongNumber = "";
        int pid = 0;
        int i = 0;
        rows.beforeFirst();
        while (rows.next()) {
            adminInfo = WebAdminF7.createAdminUnitInfo(rows);
            if (i == 0) {
                sbf.append("var " + currentVar + "=" + treeName + ".AddNode(null,null,0,'" + adminInfo.getName() + "','tree_folder_close.gif','" + adminInfo.getId().toString() + "','tree_folder_open.gif','true','true',false);");
                sbf.append("\n");
                rootLongNumber = firstLongNumber = adminInfo.getLongNumber();
                hm.put(rootLongNumber, new Integer(0));
            } else {
                parLongNumber = longNumber = adminInfo.getLongNumber();
                while (!hm.containsKey(parLongNumber) && parLongNumber.lastIndexOf("!") != -1) {
                    parLongNumber = parLongNumber.substring(0, parLongNumber.lastIndexOf("!"));
                }
                if (hm.get(parLongNumber) != null) {
                    pid = (Integer)hm.get(parLongNumber);
                }
                currentVar = "admin_" + i;
                parentVar = "admin_" + pid;
                sbf.append("var " + currentVar + "=" + treeName + ".AddNode(" + parentVar + ",null," + i + ",'" + adminInfo.getName() + "','tree_folder_close.gif','" + adminInfo.getId().toString() + "','tree_folder_open.gif','true','true',false);");
                sbf.append("\n");
                hm.put(longNumber, new Integer(i));
            }
            ++i;
        }
        rows.beforeFirst();
        return sbf.toString();
    }

    private static String buildFilterTreeJsByRowSet(IRowSet rows, boolean includeChildCU, String treeName, Set adminCurrentUserRange) throws Exception {
        String firstLongNumber;
        if (rows == null) {
            return null;
        }
        AdminOrgUnitInfo adminInfo = null;
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        String rootLongNumber = firstLongNumber = null;
        String currentVar = "admin_0";
        String parentVar = "";
        StringBuffer sbf = new StringBuffer();
        String longNumber = "";
        String parLongNumber = "";
        int pid = 0;
        int i = 0;
        HashMap sonOrgMap = new HashMap();
        ArrayList<AdminOrgUnitInfo> adminlist = new ArrayList<AdminOrgUnitInfo>();
        while (rows.next()) {
            AdminOrgUnitInfo adminUnit = WebAdminF7.createAdminUnitInfo(rows);
            adminlist.add(adminUnit);
            if (adminUnit.getParent() == null) continue;
            String parentId = adminUnit.getParent().getId().toString();
            Set oldSonSet = null;
            oldSonSet = sonOrgMap.get(parentId) != null ? (Set)sonOrgMap.get(parentId) : new HashSet();
            oldSonSet.add(adminUnit);
            sonOrgMap.put(parentId, oldSonSet);
        }
        rows.beforeFirst();
        for (int n = 0; n < adminlist.size(); ++n) {
            adminInfo = (AdminOrgUnitInfo)adminlist.get(n);
            if (!WebAdminF7.hasdisplayNode(adminInfo, adminCurrentUserRange, sonOrgMap)) continue;
            String tree_folder_close = "tree_folder_close.gif";
            String tree_folder_open = "tree_folder_open.gif";
            String adminId = adminInfo.getId().toString();
            if (!adminCurrentUserRange.contains(adminInfo.getId().toString())) {
                tree_folder_close = "tree_cancel.gif";
                tree_folder_open = "tree_cancel.gif";
                adminId = "";
            }
            if (i == 0) {
                sbf.append("var " + currentVar + "=" + treeName + ".AddNode(null,null,0,'" + adminInfo.getName() + "','" + tree_folder_close + "','" + adminId + "','" + tree_folder_open + "','true','true',false);");
                sbf.append("\n");
                rootLongNumber = firstLongNumber = adminInfo.getLongNumber();
                hm.put(rootLongNumber, new Integer(0));
            } else {
                parLongNumber = longNumber = adminInfo.getLongNumber();
                while (!hm.containsKey(parLongNumber) && parLongNumber.lastIndexOf("!") != -1) {
                    parLongNumber = parLongNumber.substring(0, parLongNumber.lastIndexOf("!"));
                }
                if (hm.get(parLongNumber) != null) {
                    pid = (Integer)hm.get(parLongNumber);
                }
                currentVar = "admin_" + i;
                parentVar = "admin_" + pid;
                sbf.append("var " + currentVar + "=" + treeName + ".AddNode(" + parentVar + ",null," + i + ",'" + adminInfo.getName() + "','" + tree_folder_close + "','" + adminId + "','" + tree_folder_open + "','true','true',false);");
                sbf.append("\n");
                hm.put(longNumber, new Integer(i));
            }
            ++i;
        }
        return sbf.toString();
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("id")));
        adminInfo.setName(row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIndex(row.getInt("index"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    public static Set getCurrentUserAdminOrgRange(Context ctx) throws Exception {
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        HashSet<String> result = new HashSet<String>();
        IOrgRange orgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
        OrgRangeCollection coll = orgRange.findFullOrgCol((IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            result.add(coll.get(i).getOrg().getId().toString());
        }
        return result;
    }

    public boolean isFilterByUserAdminOrgRange(Context ctx) {
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            if (Administrator.isCUAdmin((Context)ctx, (IObjectPK)userPK)) {
                return false;
            }
            String paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"isReceiverFilterByAdminRange");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static boolean hasdisplayNode(AdminOrgUnitInfo adminInfo, Set orgRange, HashMap sonOrgMap) {
        String id = adminInfo.getId().toString();
        boolean hasPesession = false;
        if (orgRange.contains(id)) {
            return true;
        }
        Set sons = (Set)sonOrgMap.get(id);
        if (sons != null && sons.size() != 0) {
            for (AdminOrgUnitInfo entry : sons) {
                boolean b = WebAdminF7.hasdisplayNode(entry, orgRange, sonOrgMap);
                if (!b) continue;
                hasPesession = true;
                break;
            }
        }
        return hasPesession;
    }
}

