/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.web.dao;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.cp.common.web.util.DAOException;
import com.kingdee.eas.cp.common.web.util.ValueListDAO;
import com.kingdee.eas.cp.eip.mc.IMessageDaoFacade;
import com.kingdee.eas.cp.eip.mc.MessageDaoFacadeFactory;
import com.kingdee.eas.cp.eip.mc.SpecialMsgInfo;
import com.kingdee.eas.cp.eip.mc.web.Message;
import com.kingdee.eas.cp.eip.mc.web.MessageExtraFilter;
import com.kingdee.eas.cp.eip.mc.web.MsgType;
import com.kingdee.eas.cp.eip.mc.web.dao.MessageDAO;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CombineAssignMessageDAOImpl
implements MessageDAO,
ValueListDAO {
    Logger logger = Logger.getLogger((String)CombineAssignMessageDAOImpl.class.getName());
    private static final String specialLeft = "{{";
    private static final String specialRight = "}}";
    private static final int combineCountLimit = 25;
    Map msgInfoMap = new LinkedHashMap();
    private Context context;
    private Connection conn;
    private ResultSet rs;
    private String local = "L2";
    private String ctCountSql = "select count(*) from T_WFR_Assign a,T_BAS_AssignRead b where a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2) and a.FIsSendMsg=1 and ";
    private String countSql = "";
    private String recsCtSql = "";
    private String recsSql = "";
    private MessageExtraFilter extraFilter;
    private IMessageDaoFacade msgDao;

    public CombineAssignMessageDAOImpl(Context context) throws DAOException {
        this.setContext(context);
    }

    public CombineAssignMessageDAOImpl(Context context, MsgType type) throws DAOException {
        this.setContext(context);
        this.extraFilter = new MessageExtraFilter(CombineAssignMessageDAOImpl.class.getName(), this.local, type);
        this.setMessageSql(context.getCaller().toString(), type);
    }

    private void setMessageSql(String userId, MsgType type) throws DAOException {
        StringBuffer tempBuf = new StringBuffer();
        tempBuf.append(" a.FPERSONUSERID = '");
        tempBuf.append(userId);
        tempBuf.append("'");
        if (!StringUtils.isEmpty((String)type.getMsgDate())) {
            String beginStr = type.getMsgDate() + " 00:00:00";
            String endStr = type.getMsgDate() + " 23:59:59";
            Timestamp begin = Timestamp.valueOf(beginStr);
            Timestamp end = Timestamp.valueOf(endStr);
            tempBuf.append(" and a.FCREATEDTIME >={");
            tempBuf.append(begin);
            tempBuf.append("} and a.FCREATEDTIME <={");
            tempBuf.append(end);
            tempBuf.append("}");
        }
        if ("true".equals(type.getIfCurrentOrg())) {
            String filterSql = this.getOrgFilter(this.context);
            this.logger.debug((Object)("message filter sql is " + filterSql));
            tempBuf.append(filterSql);
        }
        this.extraFilter.setFilterSql(tempBuf);
        this.countSql = this.ctCountSql + tempBuf.toString();
        this.recsSql = this.recsCtSql + tempBuf.toString();
    }

    public int getRecordsCount() throws DAOException {
        try {
            int count = 0;
            this.logger.debug((Object)("\u6267\u884c\u6d88\u606f\u67e5\u8be2\u8bed\u53e5\uff1a" + this.countSql));
            if (this.msgDao == null) {
                this.msgDao = MessageDaoFacadeFactory.getRemoteInstance();
            }
            try {
                this.rs = this.msgDao.getRowSet(this.countSql);
            }
            catch (RuntimeException ee) {
                this.msgDao = MessageDaoFacadeFactory.getLocalInstance(this.context);
                this.rs = this.msgDao.getRowSet(this.countSql);
            }
            while (this.rs.next()) {
                count += this.rs.getInt(1);
            }
            this.logger.info((Object)("\u672c\u6b21\u67e5\u8be2\u6761\u4ef6\u53d6\u5f97\u7684\u8bb0\u5f55\u6570\u4e3a:" + count));
            return count;
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5f97\u5230\u6d88\u606f\u6570\u91cf\u65f6\u53d1\u751f\u9519\u8bef" + e.getMessage()), (Throwable)e);
            throw new DAOException((Throwable)e);
        }
    }

    public List getRecords(int pageSize, int pageNo, String orderByField, String orderType) throws DAOException {
        this.msgInfoMap.clear();
        ArrayList<Message> list = new ArrayList<Message>();
        Map combineMsgMap = new LinkedHashMap();
        Map messageInfoMap = new LinkedHashMap();
        if (pageNo <= 0) {
            return list;
        }
        messageInfoMap = this.getMessageInfoMap(pageSize, pageNo, orderByField, orderType);
        combineMsgMap = this.getCombineMsgMap();
        for (Object idObj : messageInfoMap.keySet()) {
            if (combineMsgMap.containsKey(idObj)) {
                list.add((Message)combineMsgMap.get(idObj));
                continue;
            }
            Message message = (Message)messageInfoMap.get(idObj);
            String title = message.getTitle();
            if (!StringUtils.isEmpty((String)title)) {
                int rIndex = title.indexOf(specialRight);
                if (title.startsWith(specialLeft) && rIndex > 2) continue;
            }
            list.add(message);
        }
        return list;
    }

    public void setContext(Context context) {
        this.local = context.getLocale().toString();
        this.recsCtSql = " b.FID, 10 as FType, 0 as FBizType, b.FSender_" + this.local + ",a.FPriority,b.FStatus, a.FSTATE, a.FSUBJECT_" + this.local + ",a.FCREATEDTIME as createdTime,a.FCREATEDTIME, a.FASSIGNID, a.FPERSONUSERID, b.FIsWebSupport from T_WFR_Assign a ,T_BAS_AssignRead b where a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2) and a.FIsSendMsg=1 and ";
        this.context = context;
    }

    public String getRecsCountSql() {
        return this.countSql;
    }

    public String getRecsSql() {
        return this.recsSql;
    }

    private String getOrgFilter(Context ctx) {
        StringBuffer buffer = new StringBuffer();
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        AdminOrgUnitInfo adminOrgUnitInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        SaleOrgUnitInfo saleOrgUnitInfo = ContextUtil.getCurrentSaleUnit((Context)ctx);
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = ContextUtil.getCurrentPurchaseUnit((Context)ctx);
        StorageOrgUnitInfo storageOrgUnitInfo = ContextUtil.getCurrentStorageUnit((Context)ctx);
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = ContextUtil.getCurrentCostUnit((Context)ctx);
        ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = ContextUtil.getCurrentProfitUnit((Context)ctx);
        buffer.append(" AND ( ( FOrgType = ").append(-1).append(" AND FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
        if (ctrlUnitInfo != null && ctrlUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(10).append(" AND FOrgID = '").append(ctrlUnitInfo.getId().toString()).append("' ) ");
        }
        if (adminOrgUnitInfo != null && adminOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(0).append(" AND FOrgID = '").append(adminOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(1).append(" AND FOrgID = '").append(companyOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (saleOrgUnitInfo != null && saleOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(2).append(" AND FOrgID = '").append(saleOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (purchaseOrgUnitInfo != null && purchaseOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(3).append(" AND FOrgID = '").append(purchaseOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (storageOrgUnitInfo != null && storageOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(4).append(" AND FOrgID = '").append(storageOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (costCenterOrgUnitInfo != null && costCenterOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(5).append(" AND FOrgID = '").append(costCenterOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (profitCenterOrgUnitInfo != null && profitCenterOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(6).append(" AND FOrgID = '").append(profitCenterOrgUnitInfo.getId().toString()).append("' ) ");
        }
        buffer.append(" ) ");
        return buffer.toString();
    }

    private String getRealOrderByfield(String orderField) {
        String realOrderField = "a.FCREATEDTIME";
        if ("FPriority".equals(orderField)) {
            return "a.FPriority";
        }
        if (orderField.startsWith("FTitle_")) {
            return "a.FSUBJECT_" + this.local;
        }
        if ("FReceiveTime".equals(orderField)) {
            return "a.FCREATEDTIME";
        }
        if (orderField.startsWith("FSender_")) {
            return "b.FSender_" + this.local;
        }
        if ("FSourceStatus".equals(orderField)) {
            return "a.FSTATE";
        }
        return realOrderField;
    }

    private Map getCombineMsgMap() {
        LinkedHashMap<String, Message> msgMap = new LinkedHashMap<String, Message>();
        Set keySet = this.msgInfoMap.keySet();
        String[] keys = keySet.toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            ArrayList combineMsgList = this.getSpecialMsgList(key);
            for (int j = 0; j < combineMsgList.size(); ++j) {
                Map map = (Map)combineMsgList.get(j);
                ArrayList infoList = (ArrayList)map.get(key);
                SpecialMsgInfo spInfo = (SpecialMsgInfo)infoList.get(0);
                Message message = spInfo.getMessage();
                if (infoList.size() > 1) {
                    String combineIds = "";
                    StringBuffer sbf = new StringBuffer();
                    for (int k = 0; k < infoList.size(); ++k) {
                        SpecialMsgInfo info = (SpecialMsgInfo)infoList.get(k);
                        String sourceID = info.getSourceID();
                        if (StringUtils.isEmpty((String)sbf.toString())) {
                            sbf.append(sourceID);
                            continue;
                        }
                        sbf.append(";");
                        sbf.append(sourceID);
                    }
                    combineIds = sbf.toString();
                    message.setCombineIDs(combineIds);
                    message.setTitle(spInfo.getSpecialStr());
                    msgMap.put(spInfo.getId(), message);
                    continue;
                }
                if (infoList.size() != 1) continue;
                String title = spInfo.getTitle();
                int rIndex = title.indexOf(specialRight);
                String temp = title.substring(2, rIndex) + title.substring(rIndex + 2, title.length());
                message.setTitle(temp);
                msgMap.put(spInfo.getId(), message);
            }
        }
        return msgMap;
    }

    private ArrayList getSpecialMsgList(String key) {
        ArrayList result = new ArrayList();
        ArrayList arrayList = (ArrayList)this.msgInfoMap.get(key);
        if (arrayList == null || arrayList.size() == 0) {
            return result;
        }
        if (arrayList.size() <= 25) {
            LinkedHashMap<String, ArrayList> map = new LinkedHashMap<String, ArrayList>();
            map.put(key, arrayList);
            result.add(map);
        } else {
            int size = arrayList.size();
            int count = 0;
            count = size % 25 == 0 ? size / 25 : size / 25 + 1;
            for (int i = 1; i <= count; ++i) {
                int start = (i - 1) * 25;
                int end = i * 25;
                ArrayList array = null;
                LinkedHashMap map = new LinkedHashMap();
                array = i == count ? new ArrayList(arrayList.subList(start, size)) : new ArrayList(arrayList.subList(start, end));
                map.put(key, array);
                result.add(map);
            }
        }
        return result;
    }

    private Map getMessageInfoMap(int pageSize, int pageNo, String orderByField, String orderType) throws DAOException {
        LinkedHashMap<String, Message> map = new LinkedHashMap<String, Message>();
        try {
            this.recsSql = "select top " + pageSize * pageNo + this.recsSql;
            this.recsSql = orderByField != null && orderByField.trim().length() > 0 ? this.recsSql + " order by " + this.getRealOrderByfield(orderByField) + " " + orderType : this.recsSql + " order by a.FCREATEDTIME DESC";
            this.logger.debug((Object)("\u6267\u884c\u67e5\u8be2\u6d88\u606f\u8bb0\u5f55\u7684\u8bed\u53e5\uff1a" + this.recsSql));
            if (this.msgDao == null) {
                this.msgDao = MessageDaoFacadeFactory.getRemoteInstance();
            }
            try {
                this.rs = this.msgDao.getRowSet(this.recsSql);
            }
            catch (RuntimeException ee) {
                this.logger.error((Object)"getRecords failed", (Throwable)ee);
                this.msgDao = MessageDaoFacadeFactory.getLocalInstance(this.context);
                this.rs = this.msgDao.getRowSet(this.recsSql);
            }
            int rIndex = 0;
            String title = "";
            String specialStr = "";
            String msgId = "";
            String sourceID = "";
            while (this.rs.next()) {
                SpecialMsgInfo info = new SpecialMsgInfo();
                msgId = this.rs.getString(1);
                info.setId(msgId);
                title = this.rs.getString(8);
                info.setTitle(title);
                sourceID = this.rs.getString(11);
                info.setSourceID(sourceID);
                Message message = new Message();
                message.setLocale(new Locale(this.local));
                message.setID(msgId);
                message.setType(this.rs.getInt(2));
                message.setBizType(this.rs.getInt(3));
                message.setSender(this.rs.getString(4));
                message.setPriority(this.rs.getInt(5));
                message.setStatus(this.rs.getInt(6));
                message.setSourceStatus(this.rs.getInt(7));
                message.setTitle(title);
                message.setSendTime(this.rs.getTimestamp(9));
                message.setReceiveTime(this.rs.getTimestamp(10));
                message.setSourceID(sourceID);
                message.setReceiver(this.rs.getString(12));
                String webSupport = this.rs.getString(13);
                if (StringUtils.isEmpty((String)webSupport)) {
                    message.setWebSupport(false);
                } else {
                    try {
                        if (1 == Integer.parseInt(webSupport)) {
                            message.setWebSupport(true);
                        } else {
                            message.setWebSupport(false);
                        }
                    }
                    catch (Exception e) {
                        message.setWebSupport(false);
                    }
                }
                info.setMessage(message);
                map.put(msgId, message);
                if (StringUtils.isEmpty((String)title)) continue;
                rIndex = title.indexOf(specialRight);
                if (!title.startsWith(specialLeft) || rIndex <= 2) continue;
                specialStr = title.substring(2, rIndex);
                info.setSpecialStr(specialStr);
                if (!this.msgInfoMap.containsKey(specialStr)) {
                    ArrayList<SpecialMsgInfo> ar = new ArrayList<SpecialMsgInfo>();
                    ar.add(info);
                    this.msgInfoMap.put(specialStr, ar);
                    continue;
                }
                ((ArrayList)this.msgInfoMap.get(specialStr)).add(info);
            }
        }
        catch (SQLException sqle) {
            this.logger.error((Object)("\u53d6\u6d88\u606f\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + sqle.getMessage()), (Throwable)sqle);
            throw new DAOException((Throwable)sqle);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u53d6\u6d88\u606f\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()), (Throwable)e);
            throw new DAOException((Throwable)e);
        }
        return map;
    }
}

