/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.IAssign;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.IMessageClassTree;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.MessageClassTreeFactory;
import com.kingdee.eas.base.message.MessageClassTreeInfo;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.myeas.IMessageOption;
import com.kingdee.eas.base.myeas.IUserDefineMsgType;
import com.kingdee.eas.base.myeas.MessageOptionFactory;
import com.kingdee.eas.base.myeas.MessageOptionInfo;
import com.kingdee.eas.base.myeas.UserDefineMsgTypeCollection;
import com.kingdee.eas.base.myeas.UserDefineMsgTypeFactory;
import com.kingdee.eas.base.myeas.UserDefineMsgTypeInfo;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.mc.web.Message;
import com.kingdee.eas.cp.eip.mc.web.MessageHander;
import com.kingdee.eas.cp.eip.mc.web.MsgType;
import com.kingdee.eas.cp.eip.mc.web.dao.CustomNodeMessageDaoImpl;
import com.kingdee.eas.cp.eip.mc.web.service.MessageCenterService;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class MessageWebService
extends BuffaloService {
    Logger logger = Logger.getLogger((String)MessageWebService.class.getName());

    public int[] getMsgCount(boolean isPureWeb) {
        int[] counts = new int[]{0, 0, 0, 0, 0, 0, 1};
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            if (ctx == null) {
                counts[6] = 0;
                return counts;
            }
            IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
            if (isPureWeb) {
                counts = messageCenter.getNewMessageCenterCounts(messageCenter.isOrg(), isPureWeb);
            }
            this.logger.debug((Object)("unDisposeTaskCount=" + counts[0] + ",unreadMessageCount=" + counts[1] + ",unreadNoticeCount=" + counts[2] + ",unreadTaskCount=" + counts[3] + ",unreadOnlineNoticeCount=" + counts[4] + ",unreadOnlineNoticeCount=" + counts[6]));
        }
        catch (Exception e) {
            counts[6] = 0;
            this.logger.error((Object)"\u53d6\u5f97\u6d88\u606f\u6570\u91cf\u62a5\u9519\uff1a", (Throwable)e);
        }
        return counts;
    }

    public List getTreeNodeMsgCount(boolean isPureWeb) {
        List list = new ArrayList();
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            IMessageCenter messageCenter = MessageCenterFactory.getLocalInstance((Context)ctx);
            list = messageCenter.getTreeNodeUnreadCount(messageCenter.isOrg(), isPureWeb);
            StringBuffer debugStr = new StringBuffer();
            debugStr.append("\u6d41\u7a0b\u4e2d\u5fc3\u6811\u8282\u70b9\u672a\u8bfb\u6761\u6570=" + list.get(0).toString());
            this.logger.debug((Object)debugStr);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u83b7\u53d6\u6d41\u7a0b\u4e2d\u5fc3\u6811\u8282\u70b9\u672a\u8bfb\u6761\u6570\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("error", "\u83b7\u53d6\u6d41\u7a0b\u4e2d\u5fc3\u6811\u8282\u70b9\u672a\u8bfb\u6761\u6570\u51fa\u9519");
            list.add(map);
            return list;
        }
        return list;
    }

    public int[] getTreeNodeMsgCount2(boolean isPureWeb) {
        int[] msgCount = new int[]{0, 0, 0, 0, 1};
        List list = new ArrayList();
        Map map = new HashMap();
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
            list = messageCenter.getTreeNodeUnreadCount(messageCenter.isOrg(), isPureWeb);
            StringBuffer debugStr = new StringBuffer();
            debugStr.append("\u6d41\u7a0b\u4e2d\u5fc3\u6811\u8282\u70b9\u672a\u8bfb\u6761\u6570=" + list.get(0).toString());
            this.logger.debug((Object)debugStr);
        }
        catch (Exception e) {
            msgCount[4] = 0;
            this.logger.error((Object)("\u83b7\u53d6\u6d41\u7a0b\u4e2d\u5fc3\u6811\u8282\u70b9\u672a\u8bfb\u6761\u6570\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
        if (list != null && list.size() > 0) {
            map = (Map)list.get(0);
            msgCount[0] = Integer.valueOf(map.get("undisposeAssignCount").toString());
            msgCount[1] = Integer.valueOf(map.get("noticeCount").toString());
            msgCount[2] = Integer.valueOf(map.get("intantMsgCount").toString());
            msgCount[3] = Integer.valueOf(map.get("oaMsgCount").toString());
        }
        return msgCount;
    }

    public int[] getCustomNodeMsgCount(String[] nodeId, String nodeType, boolean enableOrgQuery) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        MsgType msgType = new MsgType();
        int[] count = new int[nodeId.length];
        for (int i = 0; i < nodeId.length; ++i) {
            msgType.setCustomNodeID(nodeId[i]);
            msgType.setNodeType(Integer.parseInt(nodeType));
            msgType.setIfHistory("false");
            msgType.setIfCurrentOrg(Boolean.toString(enableOrgQuery));
            CustomNodeMessageDaoImpl impl = new CustomNodeMessageDaoImpl(ctx, msgType);
            count[i] = impl.getNodeMsgCount();
        }
        return count;
    }

    public void delMessage(String idStr, int msgType) {
        try {
            this.logger.debug((Object)("idStr=" + idStr + ",msgType=" + msgType));
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
            messageCenter.delMessage(idStr, com.kingdee.eas.base.message.MsgType.getEnum((int)msgType));
        }
        catch (Exception e) {
            this.logger.error((Object)"\u6279\u91cf\u5220\u9664\u6d88\u606f\u62a5\u9519", (Throwable)e);
        }
    }

    public void delHstMessage(String idStr, int type) {
        if (!StringUtils.isEmpty((String)idStr)) {
            try {
                HttpServletRequest request = (HttpServletRequest)this.getRequest();
                IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
                String[] idArray = idStr.split(",");
                for (int i = 0; i < idArray.length; ++i) {
                    messageCenter.delHstMsg(idArray[i], type);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"\u6279\u91cf\u5220\u9664\u5386\u53f2\u6d88\u606f\u62a5\u9519", (Throwable)e);
            }
        }
    }

    public void setReadStatus(String idStr, int status, int msgType) {
        try {
            this.logger.debug((Object)("idStr=" + idStr + ",status=" + status + ",msgType=" + msgType));
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
            messageCenter.setReadStatus(idStr, MsgStatus.getEnum((int)status), com.kingdee.eas.base.message.MsgType.getEnum((int)msgType));
        }
        catch (Exception e) {
            this.logger.error((Object)"\u8bbe\u7f6e\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u62a5\u9519", (Throwable)e);
        }
    }

    public String getcalendarXml(String yMonth, boolean isPureWeb) {
        String temp = "";
        if (yMonth != null && yMonth.trim().length() > 0) {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String beginStr = yMonth + "-01 00:00:00";
            String endStr = yMonth + "-31 23:59:59";
            Timestamp begin = Timestamp.valueOf(beginStr);
            Timestamp end = Timestamp.valueOf(endStr);
            Object[] params = new Object[]{begin, end, ctx.getCaller().toString()};
            HashMap dateMap = new HashMap();
            StringBuffer taskBf = new StringBuffer();
            taskBf.append(" select b.FID");
            taskBf.append(" ,a.FSUBJECT_");
            taskBf.append(ctx.getLocale().toString());
            taskBf.append(" ,a.FCREATEDTIME");
            taskBf.append(" ,a.FBody_");
            taskBf.append(ctx.getLocale().toString());
            taskBf.append(" ,a.FASSIGNID");
            taskBf.append(" ,'10' as FType");
            taskBf.append(" ,b.FIsWebSupport");
            taskBf.append(" from  T_WFR_Assign  a with(ReadPast),  T_BAS_AssignRead b");
            taskBf.append(" where a.FCREATEDTIME >= ? ");
            taskBf.append(" and a.FCREATEDTIME <= ? ");
            taskBf.append(" and a.FPERSONUSERID=?");
            if (!isPureWeb) {
                taskBf.append(" and a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2) and a.FIsSendMsg=1 order by a.FCREATEDTIME desc");
            } else {
                taskBf.append(" and a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2) and b.FIsWebSupport = 1 and a.FIsSendMsg=1 order by a.FCREATEDTIME desc");
            }
            StringBuffer sqlBf = new StringBuffer();
            sqlBf.append(" select FID");
            sqlBf.append(" ,FTitle_");
            sqlBf.append(ctx.getLocale().toString());
            sqlBf.append(" ,FReceiveTime");
            sqlBf.append(" ,FBody_");
            sqlBf.append(ctx.getLocale().toString());
            sqlBf.append(" ,FSourceID");
            sqlBf.append(" ,FType");
            sqlBf.append(" ,FBizType");
            sqlBf.append(" from T_BAS_Message");
            sqlBf.append(" where FReceiveTime >= ? ");
            sqlBf.append(" and FReceiveTime <= ? ");
            sqlBf.append(" and FReceiver=?");
            sqlBf.append(" and ((FType = 10 and FSourceStatus in(1,2)) or (FType=0 and FStatus=0)) order by FType desc,FReceiveTime desc");
            String haseOA = "false";
            try {
                IParamControl iParam = ParamControlFactory.getRemoteInstance();
                haseOA = iParam.getParamValue(null, "OFFICE001");
            }
            catch (Exception e) {
                this.logger.error((Object)"\u83b7\u5f97\u662f\u5426\u96c6\u6210\u529e\u516c\u7cfb\u7edf\u7684\u53c2\u6570\u62a5\u9519", (Throwable)e);
            }
            StringBuffer sqlOABf = new StringBuffer();
            if ("true".equals(haseOA)) {
                sqlOABf.append(" select FID");
                sqlOABf.append(" ,FTitle");
                sqlOABf.append(" ,FReceiveTime");
                sqlOABf.append(" ,FBody");
                sqlOABf.append(" ,FSourceID");
                sqlOABf.append(" ,FType");
                sqlOABf.append(" from T_BAS_Messageyr");
                sqlOABf.append(" where FReceiveTime >= ? ");
                sqlOABf.append(" and FReceiveTime <= ? ");
                sqlOABf.append(" and FReceiver=?");
                sqlOABf.append(" and FType=50 and FStatus=0 order by FReceiveTime desc");
            }
            try {
                Msg msg;
                String dateStr = null;
                ArrayList list = null;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)taskBf.toString(), (Object[])params);
                while (rs.next()) {
                    dateStr = rs.getString("FCREATEDTIME");
                    if (dateStr == null) continue;
                    list = (ArrayList)dateMap.get(dateStr = dateStr.substring(0, 10).replaceAll("-", ""));
                    if (list == null) {
                        list = new ArrayList();
                        dateMap.put(dateStr, list);
                    }
                    if (list.size() >= 3) continue;
                    msg = new Msg();
                    msg.id = rs.getString(1);
                    msg.title = rs.getString(2);
                    msg.time = rs.getString(3).substring(0, 16);
                    msg.body = rs.getString(4);
                    msg.resourceId = rs.getString(5);
                    msg.type = rs.getInt(6);
                    String webSupport = rs.getString(7);
                    if (StringUtils.isEmpty((String)webSupport)) {
                        msg.webSupport = false;
                    } else {
                        try {
                            msg.webSupport = 1 == Integer.parseInt(webSupport);
                        }
                        catch (Exception e) {
                            msg.webSupport = false;
                        }
                    }
                    list.add(msg);
                }
                if (!isPureWeb) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sqlBf.toString(), (Object[])params);
                    while (rs.next()) {
                        IAssign assign;
                        dateStr = rs.getString("FReceiveTime");
                        if (dateStr == null) continue;
                        list = (ArrayList)dateMap.get(dateStr = dateStr.substring(0, 10).replaceAll("-", ""));
                        if (list == null) {
                            list = new ArrayList();
                            dateMap.put(dateStr, list);
                        }
                        if (list.size() >= 3) continue;
                        msg = new Msg();
                        msg.id = rs.getString(1);
                        msg.title = rs.getString(2);
                        msg.time = rs.getString(3).substring(0, 16);
                        msg.body = rs.getString(4);
                        msg.resourceId = rs.getString(5);
                        msg.type = rs.getInt(6);
                        if (msg.resourceId != null && rs.getInt(7) == 40 && (assign = AssignFactory.getLocalInstance((Context)ctx)).exists((IObjectPK)new ObjectUuidPK(msg.resourceId))) {
                            AssignReadInfo assignReadInfo = AssignReadFactory.getLocalInstance((Context)ctx).getAssignReadInfo("where assignID ='" + msg.resourceId + "'");
                            msg.webSupport = assignReadInfo.isIsWebSupport();
                        }
                        list.add(msg);
                    }
                }
                if ("true".equals(haseOA)) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sqlOABf.toString(), (Object[])params);
                    while (rs.next()) {
                        dateStr = rs.getString("FReceiveTime");
                        if (dateStr == null) continue;
                        list = (ArrayList)dateMap.get(dateStr = dateStr.substring(0, 10).replaceAll("-", ""));
                        if (list == null) {
                            list = new ArrayList();
                            dateMap.put(dateStr, list);
                        }
                        if (list.size() >= 3) continue;
                        msg = new Msg();
                        msg.id = rs.getString(1);
                        msg.title = rs.getString(2);
                        msg.time = rs.getString(3).substring(0, 16);
                        msg.body = rs.getString(4);
                        msg.resourceId = rs.getString(5);
                        msg.type = rs.getInt(6);
                        list.add(msg);
                    }
                }
                temp = this.makeXml(yMonth, dateMap);
            }
            catch (Exception e) {
                this.logger.error((Object)("\u83b7\u5f97\u65e5\u5386\u6570\u636e\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()), (Throwable)e);
            }
        }
        return temp;
    }

    private String makeXml(String yMonth, HashMap map) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        String imagePath = WebContextUtil.getUserSkinPath((HttpServletRequest)request) + "/image/htc/";
        StringBuffer xmlBf = new StringBuffer();
        String date = yMonth.replaceAll("-", "");
        String tDate = "";
        ArrayList list = null;
        Msg msg = null;
        xmlBf.append("<month>");
        for (int i = 0; i < 31; ++i) {
            tDate = date + this.convertInt(i + 1);
            list = (ArrayList)map.get(tDate);
            if (list == null || list.size() <= 0) continue;
            xmlBf.append("<date dateValue=\"");
            xmlBf.append(tDate);
            xmlBf.append("\">");
            for (int j = 0; j < list.size(); ++j) {
                msg = (Msg)list.get(j);
                xmlBf.append("<event subject=\"");
                xmlBf.append("\u4e3b\u9898:");
                xmlBf.append(this.convertLenth(msg.title, 40));
                xmlBf.append("\"");
                xmlBf.append(" time=\"");
                xmlBf.append(msg.time);
                xmlBf.append("\"");
                xmlBf.append(" address=\"");
                xmlBf.append("\u4e8b\u4ef6:");
                xmlBf.append(this.convertLenth(msg.body, 40));
                xmlBf.append("\"");
                xmlBf.append(" iconurl=\"");
                xmlBf.append(imagePath);
                xmlBf.append(this.getImage(msg.type));
                xmlBf.append("\"");
                xmlBf.append(" url=\"");
                xmlBf.append("1,");
                xmlBf.append(msg.id);
                xmlBf.append(",");
                xmlBf.append(msg.resourceId);
                xmlBf.append(",");
                xmlBf.append(msg.type);
                xmlBf.append(",");
                xmlBf.append(msg.webSupport);
                xmlBf.append("\">");
                xmlBf.append("</event>");
            }
            xmlBf.append("</date>");
        }
        xmlBf.append("</month>");
        return xmlBf.toString();
    }

    private String convertInt(int i) {
        String temp = String.valueOf(i);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        return temp;
    }

    private String convertLenth(String str, int length) {
        if (str == null) {
            return "";
        }
        if (str.length() < length) {
            return str;
        }
        return str.substring(0, length);
    }

    private String getImage(int type) {
        String image = "normal.png";
        switch (type) {
            case 0: {
                image = "inform.png";
                break;
            }
            case 10: {
                image = "task.png";
                break;
            }
            default: {
                image = "normal.png";
            }
        }
        return image;
    }

    public String getUnDisposedTaskMsg() {
        StringBuffer sbf = new StringBuffer();
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        StringBuffer taskBf = new StringBuffer();
        taskBf.append(" select top 10 b.FID");
        taskBf.append(" ,a.FSUBJECT_");
        taskBf.append(ctx.getLocale().toString());
        taskBf.append(" ,a.FASSIGNID");
        taskBf.append(" from  T_WFR_Assign  a with(ReadPast),  T_BAS_AssignRead b");
        taskBf.append(" where a.FPERSONUSERID=?");
        taskBf.append(" and a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2)  and FIsWebSupport=1 and a.FIsSendMsg=1 order by a.FCREATEDTIME desc");
        Object[] params = new Object[]{ctx.getCaller().toString()};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)taskBf.toString(), (Object[])params);
            while (rs.next()) {
                sbf.append("<tr height=\"18\">");
                sbf.append("<td width=16 valign=\"top\" align=\"left\">");
                sbf.append("<IMG height=16 width=16 src=\"" + WebContextUtil.getUserSkinPath((HttpServletRequest)request) + "/image/common/reddot.gif\" width=9 border=0>");
                sbf.append("</td><td>");
                sbf.append("<a class=\"CMA\" href=\"javascript:openUrl('" + rs.getString(3) + "')\">" + rs.getString(2) + "</a>");
                sbf.append("<br></td></tr>");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"\u8bfb\u53d6\u4e3a\u5904\u7406\u4efb\u52a1\u51fa\u9519", (Throwable)e);
        }
        return sbf.toString();
    }

    public void setMessageCombin(boolean isCombin) {
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            IMessageCenter iMessage = MessageCenterFactory.getRemoteInstance();
            iMessage.setCombine(isCombin);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u8bbe\u7f6e\u6d88\u606f\u5408\u5e76\u53c2\u6570\u51fa\u9519", (Throwable)e);
        }
    }

    public int getAvokeMsgCount(boolean enableOrgQuery, boolean isPureWeb) {
        int avokeCount = 0;
        int[] counts = new int[7];
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            if (ctx == null) {
                counts[5] = 0;
                return 0;
            }
            IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
            counts = messageCenter.getNewMessageCenterCounts(enableOrgQuery, isPureWeb);
            avokeCount = counts[2] + counts[3] + counts[4] + counts[5];
        }
        catch (Exception e) {
            counts[5] = 0;
            this.logger.error((Object)"\u53d6\u5f97\u6d88\u606f\u6570\u91cf\u62a5\u9519\uff1a", (Throwable)e);
        }
        return avokeCount;
    }

    public HashMap CreateBubbleContent() {
        HashMap<String, String> contentMap = new HashMap<String, String>();
        int totalcount = 0;
        int instancemsgcount = 0;
        int wfwantdomsgcount = 0;
        String userTypesCountsStr = null;
        int[] noticecounts = new int[4];
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int[] counts = new int[7];
        try {
            if (ctx == null) {
                counts[5] = 0;
                totalcount = 0;
            }
            IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
            counts = messageCenter.getNewMessageCenterCounts(false, false);
            totalcount = counts[2] + counts[3] + counts[4] + counts[5];
            wfwantdomsgcount = counts[2];
            instancemsgcount = counts[3];
            noticecounts = this.getNoticeCount();
            userTypesCountsStr = this.getUserDefineMsgTypeCount(ctx);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u53d6\u5f97\u6d88\u606f\u6570\u91cf\u62a5\u9519\uff1a", (Throwable)e);
        }
        int wfnoticecount = noticecounts[0];
        int fwarnnoticecount = noticecounts[1];
        int asknoticecount = noticecounts[2];
        int backnoticecount = noticecounts[3];
        contentMap.put("totalCount", totalcount + "");
        contentMap.put("instancemsgcount", instancemsgcount + "");
        contentMap.put("wfnoticecount", wfnoticecount + "");
        contentMap.put("fwarnnoticecount", fwarnnoticecount + "");
        contentMap.put("asknoticecount", asknoticecount + "");
        contentMap.put("backnoticecount", backnoticecount + "");
        contentMap.put("userTypesCountsStr", userTypesCountsStr);
        return contentMap;
    }

    public String[] getBubbleContentArray(boolean istotal, boolean isnews, boolean isclass) {
        this.logger.info((Object)("getBubbleContentArray() start: istotal=" + istotal + "isnews=" + isnews + "isclass" + isclass));
        String[] contents = new String[9];
        int totalcount = 0;
        int instancemsgcount = 0;
        int wfwantdomsgcount = 0;
        String userTypesCountsStr = null;
        int wfnoticecount = 0;
        int fwarnnoticecount = 0;
        int asknoticecount = 0;
        int backnoticecount = 0;
        int[] noticecounts = new int[4];
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int[] counts = new int[7];
        try {
            counts[5] = 0;
            if (istotal) {
                IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
                counts = messageCenter.getNewMessageCenterCounts(false, true);
                totalcount = counts[0] + counts[1] + counts[3];
            }
            if (isclass) {
                wfwantdomsgcount = counts[2];
                instancemsgcount = counts[3];
                noticecounts = this.getNoticeCount();
                userTypesCountsStr = this.getUserDefineMsgTypeCount(ctx);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"\u53d6\u5f97\u5206\u7c7b\u6d88\u606f\u6570\u91cf\u62a5\u9519\uff1a", (Throwable)e);
        }
        if (isclass) {
            wfnoticecount = noticecounts[0];
            fwarnnoticecount = noticecounts[1];
            asknoticecount = noticecounts[2];
            backnoticecount = noticecounts[3];
        }
        contents[0] = totalcount + "";
        contents[1] = instancemsgcount + "";
        contents[2] = wfnoticecount + "";
        contents[3] = fwarnnoticecount + "";
        contents[4] = asknoticecount + "";
        contents[5] = backnoticecount + "";
        contents[6] = userTypesCountsStr;
        contents[8] = wfwantdomsgcount + "";
        contents[7] = "";
        if (isnews) {
            String userId = ctx.getCaller().toString();
            ArrayList assignlist = new ArrayList();
            ArrayList msglist = new ArrayList();
            try {
                IMessageCenter iMsg = MessageCenterFactory.getRemoteInstance();
                boolean ifOrg = iMsg.isOrg();
                this.getAssignMessageSql(userId, ctx, assignlist, ifOrg);
                this.getMessageSql(userId, ctx, msglist, ifOrg);
                msglist.addAll(assignlist);
                if (msglist.size() > 5) {
                    Collections.sort(msglist, (Comparator)new MessageCorparator());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"\u83b7\u53d6\u6700\u65b0\u7684\u4e94\u6761\u6d88\u606f\u51fa\u9519", (Throwable)e);
            }
            int tempsize = 0;
            tempsize = msglist.size() > 5 ? 5 : msglist.size();
            for (int k = 0; k < tempsize; ++k) {
                Message message = (Message)msglist.get(k);
                contents[7] = contents[7].length() > 0 ? contents[7] + "^|^" + message.getID() + "~|~" + message.getTitle() + "~|~" + message.getSourceID() + "~|~" + message.getBizType() + "~|~" + message.getSender() + "~|~" + message.isWebSupport() + "~|~" + message.getType() : message.getID() + "~|~" + message.getTitle() + "~|~" + message.getSourceID() + "~|~" + message.getBizType() + "~|~" + message.getSender() + "~|~" + message.isWebSupport() + "~|~" + message.getType();
            }
        }
        this.logger.info((Object)("contents[0]===totalcount====" + contents[0]));
        this.logger.info((Object)("contents[1]===instancemsgcount====" + contents[1]));
        this.logger.info((Object)("contents[2]===wfnoticecount====" + contents[2]));
        this.logger.info((Object)("contents[3]===fwarnnoticecount====" + contents[3]));
        this.logger.info((Object)("contents[4]===asknoticecount====" + contents[4]));
        this.logger.info((Object)("contents[5]===backnoticecount====" + contents[5]));
        this.logger.info((Object)("userTypesCountsStr str contents[6] =======" + contents[6]));
        this.logger.info((Object)("news info str contents[7]=======" + contents[7]));
        this.logger.info((Object)"getBubbleContentArray() end ");
        return contents;
    }

    private int[] getNoticeCount() throws Exception {
        this.logger.info((Object)"getNoticeCount() start.... ");
        int[] count = new int[]{0, 0, 0, 0};
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        StringBuffer unreadNoticeSql = new StringBuffer();
        unreadNoticeSql.append("SELECT COUNT(FID) AS COUNT FROM T_BAS_Message WITH(READPAST)   WHERE FReceiver = ? AND FType = ? AND FBizType = ? AND FStatus = ? ");
        Object[] unreadWorkFlowParams = new Object[]{ctx.getCaller().toString(), new Integer(0), new Integer(0), new Integer(0)};
        Object[] unreadFornWarnParams = new Object[]{ctx.getCaller().toString(), new Integer(0), new Integer(10), new Integer(0)};
        Object[] unreadAskMsgParams = new Object[]{ctx.getCaller().toString(), new Integer(0), new Integer(40), new Integer(0)};
        Object[] unreadBackMsgParams = new Object[]{ctx.getCaller().toString(), new Integer(0), new Integer(50), new Integer(0)};
        IMessageOption imo = MessageOptionFactory.getRemoteInstance();
        String userID = ctx.getCaller().toString();
        MessageOptionInfo info = null;
        boolean hasOption = imo.checkOptionInfo(userID);
        info = hasOption ? (MessageOptionInfo)imo.getUserOptionInfo(userID) : (MessageOptionInfo)imo.getUserOptionInfo("00000000-0000-0000-0000-00000000000013B7DE7F");
        String awakeMsgtype = info.getAwakeMsgType();
        if (awakeMsgtype != null) {
            IRowSet unreadBackMsgSet;
            IRowSet unreadAskMsgSet;
            IRowSet unreadFornWarnSet;
            IRowSet unreadworkflowSet;
            if (awakeMsgtype.indexOf("2") > 0 && (unreadworkflowSet = DbUtil.executeQuery((Context)ctx, (String)unreadNoticeSql.toString(), (Object[])unreadWorkFlowParams)).next()) {
                count[0] = unreadworkflowSet.getInt("COUNT");
            }
            if (awakeMsgtype.indexOf("3") > 0 && (unreadFornWarnSet = DbUtil.executeQuery((Context)ctx, (String)unreadNoticeSql.toString(), (Object[])unreadFornWarnParams)).next()) {
                count[1] = unreadFornWarnSet.getInt("COUNT");
            }
            if (awakeMsgtype.indexOf("4") > 0 && (unreadAskMsgSet = DbUtil.executeQuery((Context)ctx, (String)unreadNoticeSql.toString(), (Object[])unreadAskMsgParams)).next()) {
                count[2] = unreadAskMsgSet.getInt("COUNT");
            }
            if (awakeMsgtype.indexOf("5") > 0 && (unreadBackMsgSet = DbUtil.executeQuery((Context)ctx, (String)unreadNoticeSql.toString(), (Object[])unreadBackMsgParams)).next()) {
                count[3] = unreadBackMsgSet.getInt("COUNT");
            }
        }
        this.logger.info((Object)"getNoticeCount() end....");
        return count;
    }

    private String getUserDefineMsgTypeCount(Context ctx) throws Exception {
        this.logger.info((Object)"getUserDefineMsgTypeCount() end.... ");
        String usertypescounts = null;
        List usertypeinfolist = this.getUserCheckedDefineMsgTypeIdList(ctx);
        UserDefineMsgTypeInfo info = null;
        MessageClassTreeInfo msginfo = null;
        CustomNodeMessageDaoImpl impl = null;
        ObjectUuidPK pk = null;
        int count = 0;
        IMessageClassTree iMsgClassTree = MessageClassTreeFactory.getRemoteInstance();
        MsgType msgType = new MsgType();
        for (int i = 0; i < usertypeinfolist.size(); ++i) {
            info = (UserDefineMsgTypeInfo)usertypeinfolist.get(i);
            msgType.setCustomNodeID(info.getMsgtypeid());
            msgType.setNodeType(info.getMsgType());
            msgType.setIfHistory("false");
            msgType.setIfCurrentOrg(Boolean.toString(true));
            impl = new CustomNodeMessageDaoImpl(ctx, msgType);
            pk = new ObjectUuidPK(info.getMsgtypeid());
            msginfo = iMsgClassTree.getMessageClassTreeInfo((IObjectPK)pk);
            count = impl.getNodeMsgCount();
            if (count <= 0) continue;
            usertypescounts = usertypescounts != null && usertypescounts.length() > 0 ? usertypescounts + "^|^" + msginfo.getName() + "~|~" + count : msginfo.getName() + "~|~" + count;
        }
        this.logger.info((Object)"getUserDefineMsgTypeCount() end.... ");
        return usertypescounts;
    }

    private List getUserCheckedDefineMsgTypeIdList(Context ctx) {
        this.logger.info((Object)"getUserCheckedDefineMsgTypeIdList() start.... ");
        ArrayList<UserDefineMsgTypeInfo> list = new ArrayList<UserDefineMsgTypeInfo>();
        String userID = ctx.getCaller().toString();
        try {
            IUserDefineMsgType idmt = UserDefineMsgTypeFactory.getRemoteInstance();
            UserDefineMsgTypeCollection col = (UserDefineMsgTypeCollection)idmt.getUserMsgTypesByuserid(userID);
            if (col.size() == 0) {
                col = (UserDefineMsgTypeCollection)idmt.getUserMsgTypesByuserid("00000000-0000-0000-0000-00000000000013B7DE7F");
            }
            UserDefineMsgTypeInfo info = null;
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                list.add(info);
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)"getUserCheckedDefineMsgTypeIdList failed", (Throwable)e);
        }
        this.logger.info((Object)"getUserCheckedDefineMsgTypeIdList() end.... ");
        return list;
    }

    private void getMessageSql(String userId, Context ctx, List msglist, boolean iforg) throws Exception {
        String msgtypestr;
        String biztypestr;
        IMessageOption imo;
        MessageOptionInfo msgOptionInfo;
        this.logger.info((Object)("getMessageSql() start.... iforg" + iforg));
        String local = ctx.getLocale().toString();
        String recsCtSql = " FID, FType, FBizType, FSender_" + local + ",FPriority,FStatus, FSourceStatus, FTitle_" + local + ",FSendTime ,FReceiveTime, FSourceID, FSourceIDs, FReceiver from T_BAS_Message";
        StringBuffer tempBuf = new StringBuffer();
        tempBuf.append(" where FReceiver = '");
        tempBuf.append(userId);
        tempBuf.append("'");
        tempBuf.append(" and FStatus = 0 ");
        if (iforg) {
            String filterSql = this.getOrgFilter(ctx);
            tempBuf.append(filterSql);
        }
        if ((msgOptionInfo = (MessageOptionInfo)(imo = MessageOptionFactory.getRemoteInstance()).getUserOptionInfo(userId)) == null) {
            msgOptionInfo = (MessageOptionInfo)imo.getUserOptionInfo("00000000-0000-0000-0000-00000000000013B7DE7F");
        }
        if ((biztypestr = this.getMsgBizTypesFromMsgOption(msgtypestr = msgOptionInfo.getAwakeMsgType())).length() > 0) {
            tempBuf.append(" and FBizType in(");
            tempBuf.append(biztypestr);
            tempBuf.append(")");
        }
        tempBuf.append("order by FReceiveTime desc");
        String recsSql = "select top 5 " + recsCtSql + tempBuf.toString();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)recsSql.toString());
        String sourceids = null;
        while (rs.next()) {
            Message message = new Message();
            message.setLocale(new Locale(local));
            message.setID(rs.getString(1));
            message.setType(rs.getInt(2));
            message.setBizType(rs.getInt(3));
            message.setSender(rs.getString(4));
            message.setPriority(rs.getInt(5));
            message.setStatus(rs.getInt(6));
            message.setSourceStatus(rs.getInt(7));
            message.setTitle(rs.getString(8));
            message.setSendTime(rs.getTimestamp(10));
            message.setReceiveTime(rs.getTimestamp(10));
            message.setSourceID(rs.getString(11));
            sourceids = rs.getString(12);
            if (!StringUtils.isEmpty((String)sourceids)) {
                sourceids = sourceids.replaceAll("[|]", "^!^");
            }
            message.setSourceIDs(sourceids);
            message.setReceiver(rs.getString(13));
            String urgent = message.getBizType() + "";
            if (urgent.equals("40")) {
                if (message.getSourceID() == null || message.getSourceID().length() <= 0) {
                    message.setWebSupport(false);
                } else {
                    IAssign assign = AssignFactory.getRemoteInstance();
                    if (assign.exists((IObjectPK)new ObjectUuidPK(message.getSourceID()))) {
                        AssignReadInfo assignReadInfo = AssignReadFactory.getRemoteInstance().getAssignReadInfo("where assignID ='" + message.getSourceID() + "'");
                        if (assignReadInfo.isIsWebSupport()) {
                            message.setWebSupport(true);
                        } else {
                            message.setWebSupport(false);
                        }
                    }
                }
            }
            msglist.add(message);
        }
        this.logger.info((Object)"getMessageSql() end.... ");
    }

    private String getMsgBizTypesFromMsgOption(String types) {
        StringBuffer str = new StringBuffer();
        str.append("20");
        if (types.indexOf("2") != -1) {
            str.append(",0");
        }
        if (types.indexOf("3") != -1) {
            str.append(",10");
        }
        if (types.indexOf("4") != -1) {
            str.append(",40");
        }
        if (types.indexOf("5") != -1) {
            str.append(",50");
        }
        return str.toString();
    }

    private void getAssignMessageSql(String userId, Context ctx, List assignlist, boolean iforg) throws Exception {
        this.logger.info((Object)("getAssignMessageSql() start.... iforg" + iforg));
        String local = ctx.getLocale().toString();
        String recsCtSql = " b.FID, 10 as FType, 0 as FBizType, b.FSender_" + local + ",a.FPriority,b.FStatus, a.FSTATE, a.FSUBJECT_" + local + ",a.FCREATEDTIME as createdTime,a.FCREATEDTIME, a.FASSIGNID, a.FPERSONUSERID,b.FIsWebSupport from T_WFR_Assign a with(ReadPast),T_BAS_AssignRead b where a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2) and a.FIsSendMsg=1 and ";
        StringBuffer tempBuf = new StringBuffer();
        tempBuf.append(" a.FPERSONUSERID = '");
        tempBuf.append(userId);
        tempBuf.append("'");
        tempBuf.append(" and b.FStatus = 0");
        if (iforg) {
            String orgfilterSql = this.getOrgFilter(ctx);
            tempBuf.append(orgfilterSql);
        }
        String recsSql = "select top 5 " + recsCtSql + tempBuf.toString() + "order by a.FCREATEDTIME desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)recsSql.toString());
        while (rs.next()) {
            Message message = new Message();
            message.setLocale(new Locale(local));
            message.setID(rs.getString(1));
            message.setType(rs.getInt(2));
            message.setBizType(rs.getInt(3));
            message.setSender(rs.getString(4));
            message.setPriority(rs.getInt(5));
            message.setStatus(rs.getInt(6));
            message.setSourceStatus(rs.getInt(7));
            message.setTitle(rs.getString(8));
            message.setSendTime(rs.getTimestamp(10));
            message.setReceiveTime(rs.getTimestamp(10));
            message.setSourceID(rs.getString(11));
            message.setReceiver(rs.getString(12));
            String webSupport = rs.getString(13);
            if (StringUtils.isEmpty((String)webSupport)) {
                message.setWebSupport(false);
            } else {
                try {
                    if (1 == Integer.parseInt(webSupport)) {
                        message.setWebSupport(true);
                    } else {
                        message.setWebSupport(false);
                    }
                }
                catch (Exception e) {
                    message.setWebSupport(false);
                }
            }
            assignlist.add(message);
        }
        this.logger.info((Object)"getAssignMessageSql() end.... ");
    }

    private String getOrgFilter(Context ctx) {
        StringBuffer buffer = new StringBuffer();
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        AdminOrgUnitInfo adminOrgUnitInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        SaleOrgUnitInfo saleOrgUnitInfo = ContextUtil.getCurrentSaleUnit((Context)ctx);
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = ContextUtil.getCurrentPurchaseUnit((Context)ctx);
        StorageOrgUnitInfo storageOrgUnitInfo = ContextUtil.getCurrentStorageUnit((Context)ctx);
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = ContextUtil.getCurrentCostUnit((Context)ctx);
        ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = ContextUtil.getCurrentProfitUnit((Context)ctx);
        buffer.append(" AND ( ( FOrgType = ").append(-1).append(" AND FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
        if (ctrlUnitInfo != null && ctrlUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(10).append(" AND FOrgID = '").append(ctrlUnitInfo.getId().toString()).append("' ) ");
        }
        if (adminOrgUnitInfo != null && adminOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(0).append(" AND FOrgID = '").append(adminOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(1).append(" AND FOrgID = '").append(companyOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (saleOrgUnitInfo != null && saleOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(2).append(" AND FOrgID = '").append(saleOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (purchaseOrgUnitInfo != null && purchaseOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(3).append(" AND FOrgID = '").append(purchaseOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (storageOrgUnitInfo != null && storageOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(4).append(" AND FOrgID = '").append(storageOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (costCenterOrgUnitInfo != null && costCenterOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(5).append(" AND FOrgID = '").append(costCenterOrgUnitInfo.getId().toString()).append("' ) ");
        }
        if (profitCenterOrgUnitInfo != null && profitCenterOrgUnitInfo.getId() != null) {
            buffer.append(" OR ( FOrgType = ").append(6).append(" AND FOrgID = '").append(profitCenterOrgUnitInfo.getId().toString()).append("' ) ");
        }
        buffer.append(" ) ");
        return buffer.toString();
    }

    public void setMessageOrg(boolean isOrg) {
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            IMessageCenter iMessage = MessageCenterFactory.getRemoteInstance();
            iMessage.setOrg(isOrg);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u8bbe\u7f6e\u6d88\u606f\u5408\u5e76\u53c2\u6570\u51fa\u9519", (Throwable)e);
        }
    }

    public String filterSingleQuote(String str) {
        return str == null ? null : str.replaceAll("'", "\\\\'");
    }

    public StringBuffer getOpenMsgDetailParams(Message msg) {
        StringBuffer params = new StringBuffer("'");
        params.append(msg.getID()).append("',").append("'").append(msg.getSourceID()).append("',").append("'").append(this.filterSingleQuote(msg.getSourceIDs())).append("',").append("'").append(this.filterSingleQuote(msg.getTypeName())).append("',").append(new Integer(msg.getBizType()).toString()).append(",").append("'").append(this.filterSingleQuote(msg.getSender())).append("',").append("'").append(new Boolean(msg.isWebSupport()).toString()).append("'");
        return params;
    }

    public void setUrgenceMsgWebSupport(Context context, Message msg) throws BOSException, EASBizException {
        if (msg.getSourceID() == null || msg.getSourceID().length() <= 0) {
            msg.setWebSupport(false);
        } else {
            IAssign assign = AssignFactory.getRemoteInstance();
            if (assign.exists((IObjectPK)new ObjectUuidPK(msg.getSourceID()))) {
                AssignReadInfo assignReadInfo = AssignReadFactory.getRemoteInstance().getAssignReadInfo("where assignID ='" + msg.getSourceID() + "'");
                if (assignReadInfo.isIsWebSupport()) {
                    msg.setWebSupport(true);
                } else {
                    msg.setWebSupport(false);
                }
            }
        }
    }

    public String printItemTags(Context context, List msgList, int numLoop, String mainJsObjName) throws IOException, BOSException, EASBizException {
        StringBuffer itemTag = new StringBuffer("");
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String procResource = "com.kingdee.eas.cp.eip.pc.processresource";
        String senderRes = ResourceBase.getString((String)procResource, (String)"messageSender", (Locale)ctx.getLocale());
        for (int i = 0; i < numLoop; ++i) {
            Message msg = (Message)msgList.get(i);
            if (msg.getBizType() == 40) {
                this.setUrgenceMsgWebSupport(context, msg);
            }
            itemTag.append("<tr height=\"18\">");
            itemTag.append("<td style='padding-left:5px' width=16 valign=\"center\" align=\"left\">");
            itemTag.append("<IMG height=16 width=16 src=\"" + WebContextUtil.getUserSkinPath((HttpServletRequest)request) + "/image/common/reddot.gif\" width=9 border=0>");
            itemTag.append("</td><td>");
            itemTag.append("<a class=\"CMA\" href=\"#\" onclick=\"").append(mainJsObjName).append(".openInstantMsgDetail(").append(this.getOpenMsgDetailParams(msg)).append(");return false;\">" + msg.getTitle());
            itemTag.append(" (");
            itemTag.append(senderRes);
            itemTag.append(":");
            itemTag.append(msg.getSender());
            itemTag.append(" ");
            itemTag.append(msg.getReceiveTime());
            itemTag.append(")");
            itemTag.append("</a>");
            itemTag.append("<br></td></tr>");
        }
        return itemTag.toString();
    }

    public String getInstantMessage(String actualItemCount, String actualOrderType, String fp) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context context = WebContextUtil.getEasContext((HttpServletRequest)request);
        MessageCenterService mcService = new MessageCenterService();
        MsgType msgType = new MsgType();
        msgType.setType(40);
        msgType.setNodeType(3);
        msgType.setStatus(0);
        msgType.setSourceStatus(-3);
        msgType.setIfCurrentOrg("false");
        msgType.setIfCombine("false");
        msgType.setIfHistory("false");
        String orderField = "FReceiveTime";
        String mainJsObjName = "instantMsgPortlet" + fp;
        String bizType = "-1";
        msgType.setBizType(-1);
        int listSize = Integer.parseInt(actualItemCount);
        String str = "";
        String orderType = actualOrderType;
        MessageHander msgHandler = null;
        try {
            msgHandler = mcService.queryMessage(context, msgType, 1, listSize, orderField, orderType);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        int numTotal = msgHandler.getMsgCount();
        List msgList = msgHandler.getMsgList();
        if (numTotal <= 0) {
            str = "<tr><td style=\"border:0px;\"></td><td style=\"border:0px;\"><font color=Gray>\u8be5\u680f\u76ee\u4e2d\u6ca1\u6709\u5185\u5bb9\u53ef\u663e\u793a</font></td><td style=\"border:0px;\"></td></tr>";
        } else if (numTotal < listSize) {
            try {
                str = this.printItemTags(context, msgList, numTotal, mainJsObjName);
            }
            catch (EASBizException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                str = this.printItemTags(context, msgList, listSize, mainJsObjName);
            }
            catch (EASBizException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return str;
    }

    class MessageCorparator
    implements Comparator {
        MessageCorparator() {
        }

        public int compare(Object ob1, Object ob2) {
            Message msg1 = (Message)ob1;
            Message msg2 = (Message)ob2;
            int result = 0;
            MessageWebService.this.logger.debug((Object)("msg1.getSendTime()==" + msg1.getSendTime() + "  msg1.getSendTime()==" + msg1.getSendTime()));
            result = msg1.getSendTime().before(msg2.getSendTime()) ? 1 : (msg1.getSendTime().equals(msg2.getSendTime()) ? 0 : -1);
            return result;
        }
    }

    public class Msg {
        public int type;
        public String id;
        public String resourceId;
        public String title;
        public String body;
        public String time;
        public boolean webSupport = false;
    }
}

