/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.cp.mc.GraphicsFactory;
import com.kingdee.eas.cp.mc.GraphicsInfo;
import com.kingdee.eas.cp.mc.client.AbstractGraphicsPortletEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.portal.FlagEnum;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletStateEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class GraphicsPortletEditUI
extends AbstractGraphicsPortletEditUI {
    private String resource = "com.kingdee.eas.cp.mc.GraphicsPortletResource";
    private static final long serialVersionUID = 7168522362628668458L;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.comboEnable.removeAllItems();
        List list = EnumUtils.getEnumList((String)"com.kingdee.eas.portal.PortletStateEnum");
        Object[] obj = new Object[]{list.get(0), list.get(1)};
        this.comboEnable.addItems(obj);
        if (this.editData != null) {
            PortletInfo info = this.editData.getPortlet();
            if (info == null) {
                return;
            }
            this.comboEnable.setSelectedItem((Object)info.getEnable());
            this.txtPortletNumber.setText(info.getPortletNumber());
            List langList = KDBizMultiLangBox.getLanguageList();
            Iterator iter = langList.iterator();
            LanguageInfo languageInfo = null;
            while (iter.hasNext()) {
                languageInfo = (LanguageInfo)iter.next();
                this.txtPortletName.setItemData(languageInfo, (Object)info.getPortletName(languageInfo.getLocale()));
                this.txtDescription.setItemData(languageInfo, (Object)info.getDescription(languageInfo.getLocale()));
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtPortletNumber.setEditable(false);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        PortletInfo info = this.createNewPortletData();
        if (info == null) {
            return;
        }
        this.editData.setPortlet(info);
        this.doAfterUpdate(info);
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        SecureRandom r = new SecureRandom();
        GraphicsInfo info = new GraphicsInfo();
        PortletInfo pInfo = new PortletInfo();
        pInfo.setPortletNumber("GP_" + System.currentTimeMillis() + r.nextInt(100));
        pInfo.setEnable(PortletStateEnum.PORTLET_RUN);
        info.setPortlet(pInfo);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return GraphicsFactory.getRemoteInstance();
    }

    private boolean validateInput() {
        String number = this.txtPortletNumber.getText();
        if (number == null || number.equals("")) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"numbernotnull"));
            this.txtPortletNumber.requestFocus();
            return false;
        }
        String name = this.txtPortletName.getSelectedItem().toString();
        if (name == null || name.equals("")) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"namenotnull"));
            this.txtPortletName.requestFocus();
            return false;
        }
        Object state = this.comboEnable.getSelectedItem();
        if (state == null || state.equals("")) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"statenotnull"));
            this.comboEnable.requestFocus();
            return false;
        }
        return true;
    }

    private PortletInfo createNewPortletData() throws EASBizException, BOSException {
        if (!this.validateInput()) {
            return null;
        }
        PortletInfo portletInfo = new PortletInfo();
        portletInfo.setEnable((PortletStateEnum)this.comboEnable.getSelectedItem());
        portletInfo.setPortletNumber(this.txtPortletNumber.getText());
        portletInfo.setPortletDefineId("24");
        portletInfo.setFlag(FlagEnum.GRAPHICS_FLAG);
        this.setMutiLanguageProp(portletInfo);
        PortletInfo tempPortletInfo = this.editData.getPortlet();
        if (tempPortletInfo == null || tempPortletInfo.getId() == null) {
            portletInfo.setId(BOSUuid.create((BOSObjectType)portletInfo.getBOSType()));
            GraphicsFactory.getRemoteInstance().savePortlet((IObjectValue)portletInfo, 1);
        } else {
            portletInfo.setId(tempPortletInfo.getId());
            GraphicsFactory.getRemoteInstance().savePortlet((IObjectValue)portletInfo, 0);
        }
        return portletInfo;
    }

    private void addNewPortlet(PortletInfo info) {
        try {
            GraphicsFactory.getRemoteInstance().addNewRelatedPortlet(info);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private void setMutiLanguageProp(PortletInfo portletInfo) {
        List langList = KDBizMultiLangBox.getLanguageList();
        for (LanguageInfo languageInfo : langList) {
            Locale locale = languageInfo.getLocale();
            MultiLangItem name = this.txtPortletName.getItemBy(languageInfo);
            portletInfo.setPortletName((String)name.getData(), locale);
            MultiLangItem description = this.txtDescription.getItemBy(languageInfo);
            portletInfo.setDescription((String)description.getData(), locale);
        }
    }

    private void doAfterUpdate(PortletInfo info) throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState())) {
            IPortalServiceFacade service = PortalServiceFacadeFactory.getRemoteInstance();
            service.update(info.getId(), info);
            service.refreshPortletCache();
        }
    }
}

