/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.myeas.ToolBarStyleEnum;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.IMainFrameServiceFacade;
import com.kingdee.eas.base.uiframe.MainFrameServiceFacadeFactory;
import com.kingdee.eas.base.uiframe.client.F7MenuSelector;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.mc.AttributeBean;
import com.kingdee.eas.cp.mc.GraphicsCollection;
import com.kingdee.eas.cp.mc.GraphicsFactory;
import com.kingdee.eas.cp.mc.GraphicsInfo;
import com.kingdee.eas.cp.mc.IGraphics;
import com.kingdee.eas.cp.mc.MapGenerator;
import com.kingdee.eas.cp.mc.MapTypeEnum;
import com.kingdee.eas.cp.mc.PortletImportExportException;
import com.kingdee.eas.cp.mc.StateEnum;
import com.kingdee.eas.cp.mc.client.AbstractHtmlMapDesignUI;
import com.kingdee.eas.cp.mc.client.BeanUtil;
import com.kingdee.eas.cp.mc.client.DrawContainer;
import com.kingdee.eas.cp.mc.client.IShapeChange;
import com.kingdee.eas.cp.mc.client.ImportExportOprt;
import com.kingdee.eas.cp.mc.client.PortletFileFilter;
import com.kingdee.eas.cp.mc.shape.IShape;
import com.kingdee.eas.cp.mc.web.MutiGraphicsInstanceUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.apache.log4j.Logger;
import org.jdom2.Document;

public class HtmlMapDesignUI
extends AbstractHtmlMapDesignUI
implements IShapeChange {
    private static final Logger logger = Logger.getLogger((String)" com.kingdee.eas.cp.mc.client.HtmlMapDesignUI");
    private static final long serialVersionUID = 610911138652546579L;
    private String resource = "com.kingdee.eas.base.uiframe.UIFrameResource";
    private String imageName;
    JLayeredPane layerPane;
    JScrollPane scrollPane;
    JLabel imageContainer;
    DrawContainer drawContainer;
    HashMap hashMap = new HashMap();
    AttributeBean currentBean = null;
    Field[] fields = null;
    Map rowMap = null;
    File file = null;
    KDTDefaultCellEditor menuEditor;
    KDTDefaultCellEditor linkEditor;
    KDBizPromptBox titlePromptBox;
    KDTextField textArea;
    String localDir;
    File localFile;
    private String SERVER_RESOURCE = "";
    private String serverPath = null;
    JFileChooser fileChooser = null;
    JFileChooser chooser = null;
    PortletFileFilter jarFilter;
    PortletFileFilter zipFilter;
    private File imageSpots;
    private Object currentHref = null;
    private MutiGraphicsInstanceUtil instance = null;
    private String[] ids;

    public HtmlMapDesignUI() throws Exception {
        this.init();
        this.initWorkButton();
    }

    private void supportMutipleInstanceInit() {
        this.ids = (String[])this.getUIContext().get("ids");
    }

    private AttachmentInfo getImageByID(String id) {
        AttachmentInfo info = null;
        try {
            info = AttachmentFactory.getRemoteInstance().getAttachmentInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return info;
    }

    private AttachmentInfo addNewImage(File image) throws Exception {
        String fullname = image.getName();
        String mainname = StringUtil4File.getMainFileName((String)fullname);
        String extname = StringUtil4File.getExtendedFileName((String)fullname);
        byte[] content = FileGetter.getBytesFromFile((File)image);
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        sai.setMainName(mainname);
        sai.setExtName(extname);
        sai.setContent(content);
        AttachmentInfo attachmentInfo = this.constructAttachmentInfo(sai);
        AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
        String attachPK = attachmentClientManager.addNewAttachment(this.ids[1], image);
        if (this.ids[2] == null) {
            this.ids[2] = attachPK.toString();
        }
        attachmentInfo.setId(BOSUuid.read((String)attachPK));
        return attachmentInfo;
    }

    private AttachmentInfo constructAttachmentInfo(SimpleAttachmentInfo sai) {
        AttachmentInfo tempAI = new AttachmentInfo();
        byte[] content = sai.getContent();
        tempAI.setFile(content);
        tempAI.setSize(StringUtil4File.getFileSizeRepresentation((long)content.length));
        tempAI.setSizeInByte(content.length);
        tempAI.setName(sai.getMainName());
        String extname = sai.getExtName();
        tempAI.setSimpleName(extname);
        tempAI.setType(StringUtil4File.getFileTypeDescription((String)extname));
        tempAI.setId(BOSUuid.create((BOSObjectType)tempAI.getBOSType()));
        return tempAI;
    }

    private AttachmentInfo updateImage(File image) throws Exception {
        IAttachment _attachment = AttachmentFactory.getRemoteInstance();
        AttachmentInfo info = this.getImageByID(this.ids[2]);
        byte[] content = FileGetter.getBytesFromFile((File)image);
        info.setFile(content);
        AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
        attachmentClientManager.updateAttachmentContent(this.ids[2], content);
        return info;
    }

    protected void initWorkButton() {
        this.btnOpen.setIcon(EASResource.getIcon((String)"imgTbtn_showpicture"));
        this.btnSelected.setIcon(EASResource.getIcon((String)"imgTbtn_choose"));
        this.btnRect.setIcon(EASResource.getIcon((String)"imgTbtn_rectangle"));
        this.btnCircle.setIcon(EASResource.getIcon((String)"imgTbtn_rotundity"));
        this.btnPolygon.setIcon(EASResource.getIcon((String)"imgTbtn_polygon"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnRelease.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.menuItemRelease.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
    }

    public final void setButtonDefaultStyl(KDWorkButton button) {
        ToolBarStyleEnum toolBarStyleEnum = (ToolBarStyleEnum)UIFrameContext.getInstance().getProperty((Object)"ToolbarStyle");
        if (toolBarStyleEnum != null) {
            if (toolBarStyleEnum.equals((Object)ToolBarStyleEnum.IconText)) {
                this.toolBar.setTextIconDisStyle((short)3);
            } else if (toolBarStyleEnum.equals((Object)ToolBarStyleEnum.OnlyIcon)) {
                this.toolBar.setTextIconDisStyle((short)2);
            } else if (toolBarStyleEnum.equals((Object)ToolBarStyleEnum.OnlyText)) {
                this.toolBar.setTextIconDisStyle((short)1);
            } else if (toolBarStyleEnum.equals((Object)ToolBarStyleEnum.IconAllText)) {
                this.toolBar.setTextIconDisStyle((short)3);
            }
        }
        if (toolBarStyleEnum == null || toolBarStyleEnum.equals((Object)ToolBarStyleEnum.IconText)) {
            button.setIsControlByParent(false);
            button.setTextIconDisStyle((short)2);
        } else {
            button.setIsControlByParent(true);
        }
    }

    public void init() {
        this.rowMap = new HashMap();
        this.layerPane = new JLayeredPane();
        this.imageContainer = new JLabel("<html>Color and font test:<ul><li><font color=red>red</font><li><font color=blue>blue</font><li><font color=green>green</font><li><font size=-2>small</font><li><font size=+2>large</font><li><i>italic</i><li><b>bold</b></ul>");
        this.drawContainer = new DrawContainer((Component)((Object)this), this);
        this.scrollPane = new JScrollPane(this.layerPane);
        this.titlePromptBox = new KDBizPromptBox();
        this.titlePromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (!(HtmlMapDesignUI.this.titlePromptBox.getSelector() instanceof F7MenuSelector)) {
                    F7MenuSelector selector = new F7MenuSelector((Component)((Object)HtmlMapDesignUI.this), HtmlMapDesignUI.this.getString("menuTitle"));
                    HtmlMapDesignUI.this.titlePromptBox.setSelector((KDPromptSelector)selector);
                }
                e.setCanceled(HtmlMapDesignUI.this.drawContainer.getActiveShape() == null);
            }
        });
        this.titlePromptBox.setEditable(false);
        this.textArea = new KDTextField();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setFileFilter(ImageFilter.getInstance());
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.chooser = new JFileChooser();
        this.zipFilter = new PortletFileFilter("zip", "zip");
        this.chooser.addChoosableFileFilter(this.zipFilter);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setMultiSelectionEnabled(false);
        this.btnExport.setVisible(false);
        this.initProps();
        try {
            IMainFrameServiceFacade iFacade = MainFrameServiceFacadeFactory.getRemoteInstance();
            this.serverPath = iFacade.getPortalServerUrl();
        }
        catch (Exception e) {
            this.serverPath = "localhost:6888/easportal";
            e.printStackTrace();
        }
    }

    private File getLocalFile() {
        File file = null;
        SecureRandom rand = new SecureRandom();
        String localDir = System.getProperty("EAS_HOME");
        file = new File(localDir + "/client/temp/resource/" + this.getCodeRuleNumber(rand.nextInt()) + "/");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private void deleteFolder(File dir) {
        File[] filelist = dir.listFiles();
        int listlen = filelist.length;
        for (int i = 0; i < listlen; ++i) {
            if (filelist[i].isDirectory()) {
                this.deleteFolder(filelist[i]);
                continue;
            }
            filelist[i].delete();
        }
        dir.delete();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.supportMutipleInstanceInit();
        if (this.ids[2] != null) {
            this.instance = MutiGraphicsInstanceUtil.getInstance();
            this.instance.initIDs(this.ids);
            this.loadSolutionFromDB(null);
        }
    }

    public URL findSrcOnServer() throws MalformedURLException {
        String srvUrlPath = System.getProperty("UPDATE_SERVER");
        if (srvUrlPath == null || srvUrlPath.equals("")) {
            throw new NullPointerException("System Property UPDATE_SERVER is not available");
        }
        return new URL(srvUrlPath + File.separator + this.SERVER_RESOURCE);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initLayout() {
        super.initLayout();
        this.imageContainer.setHorizontalTextPosition(0);
        this.imageContainer.setHorizontalAlignment(0);
        this.layerPane.add((Component)this.imageContainer, new Integer(1));
        this.shapeList.setModel((ListModel)this.lists);
        this.shapeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                HtmlMapDesignUI.this.propList.getEditManager().stopEditing();
                HtmlMapDesignUI.this.listSelectChange(e);
            }
        });
        this.layerPane.add((Component)((Object)this.drawContainer), new Integer(2));
        this.layerPane.moveToFront((Component)((Object)this.drawContainer));
        this.kdPane.add((Component)this.scrollPane, 0);
        this.kdPane.setTitleAt(0, this.getString("design"));
    }

    private void gotoSite(String url) {
        if (url == null) {
            return;
        }
        boolean isUrl = true;
        try {
            if (url.indexOf("invokeFunctionUI") > 0) {
                isUrl = false;
                url = url.substring(url.indexOf("invokeFunctionUI"));
                url = url.substring(17, url.indexOf(")"));
                String[] paths = url.split(",");
                try {
                    UIContext uiContext = new UIContext((Object)this);
                    if (!StringUtils.isEmpty((String)paths[1])) {
                        uiContext.put("UIClassParam", this.trim(paths[1], '\''));
                    }
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.trim(paths[0], '\''), (Map)uiContext, null, this.trim(paths[2], '\''));
                    uiWindow.show();
                }
                catch (UIException e) {
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            } else {
                Runtime.getRuntime().exec("start " + url);
            }
        }
        catch (Exception er) {
            if (!isUrl) {
                er.printStackTrace();
                return;
            }
            try {
                Runtime.getRuntime().exec("cmd /c start " + url);
            }
            catch (Exception err) {
                try {
                    Runtime.getRuntime().exec("command.com /c start " + url);
                }
                catch (Exception errr) {
                    errr.printStackTrace();
                }
            }
        }
    }

    private String getCodeRuleNumber(int nCodeNumber) {
        StringBuffer sysNumber = new StringBuffer();
        String strCodeNumber = "";
        Calendar c = Calendar.getInstance();
        if (++nCodeNumber > 1000) {
            nCodeNumber = 0;
        }
        strCodeNumber = "" + nCodeNumber;
        int n = strCodeNumber.length();
        strCodeNumber = "";
        for (int i = 1; i < 4 - n; ++i) {
            strCodeNumber = strCodeNumber + 0;
        }
        strCodeNumber = strCodeNumber + nCodeNumber;
        sysNumber.append(c.get(1));
        if (c.get(2) + 1 < 10) {
            sysNumber.append(0).append(c.get(2) + 1);
        } else {
            sysNumber.append(c.get(2) + 1);
        }
        if (c.get(5) < 10) {
            sysNumber.append(0).append(c.get(5));
        } else {
            sysNumber.append(c.get(5));
        }
        if (c.get(11) < 10) {
            sysNumber.append(0).append(c.get(11));
        } else {
            sysNumber.append(c.get(11));
        }
        if (c.get(12) < 10) {
            sysNumber.append(0).append(c.get(12));
        } else {
            sysNumber.append(c.get(12));
        }
        if (c.get(13) < 10) {
            sysNumber.append(0).append(c.get(13));
        } else {
            sysNumber.append(c.get(13));
        }
        sysNumber.append(strCodeNumber);
        return sysNumber.toString();
    }

    public String trim(String str, char trim) {
        int st;
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] val = str.toCharArray();
        for (st = 0; st < len && val[st] == trim; ++st) {
        }
        while (st < len && val[len - 1] == trim) {
            --len;
        }
        return st > 0 || len < str.length() ? str.substring(st, len) : str;
    }

    private void initProps() {
        this.editor.setEditable(false);
        this.editor.setEditorKit(this.text.getEditorKitForContentType("text/html"));
        this.editor.addHyperlinkListener(new HyperlinkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                        HTMLDocument doc = (HTMLDocument)pane.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(evt);
                    } else {
                        HtmlMapDesignUI.this.setWairCusor();
                        try {
                            if (e.getURL() != null) {
                                HtmlMapDesignUI.this.gotoSite(e.getURL().toString());
                            } else if (e.getDescription() != null) {
                                HtmlMapDesignUI.this.gotoSite(e.getDescription());
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        finally {
                            HtmlMapDesignUI.this.setDefaultCusor();
                        }
                    }
                }
            }
        });
        this.kdPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HtmlMapDesignUI.this.kdPane.getSelectedIndex() == 1) {
                    String pathImage = HtmlMapDesignUI.this.imageName;
                    if (HtmlMapDesignUI.this.file != null) {
                        pathImage = HtmlMapDesignUI.this.file.getParent() + "/" + pathImage;
                    }
                    String html = MapGenerator.generaterHtml("file:///" + pathImage, HtmlMapDesignUI.this.drawContainer.getShapes());
                    HtmlMapDesignUI.this.text.setText(html);
                    HtmlMapDesignUI.this.editor.setText(html);
                }
            }
        });
        this.propList.getColumn("name").getStyleAttributes().setLocked(true);
        this.propList.getColumn("name").setWidth(78);
        this.propList.getColumn("name").getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        this.propList.getColumn("value").getStyleAttributes().setLocked(false);
        this.propList.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == 1 && HtmlMapDesignUI.this.currentBean != null) {
                    try {
                        MapTypeEnum old = HtmlMapDesignUI.this.currentBean.getType();
                        BeanUtil.setProperty(HtmlMapDesignUI.this.currentBean, HtmlMapDesignUI.this.fields[e.getRowIndex()].getName(), e.getValue());
                        if (e.getValue() instanceof MapTypeEnum) {
                            HtmlMapDesignUI.this.changeType(((KDTable)e.getSource()).getCell(e.getRowIndex() + 1, e.getColIndex()), (Object)old);
                            if (MapTypeEnum.LINK.equals(e.getValue())) {
                                HtmlMapDesignUI.this.propList.getRow(e.getRowIndex() + 1).getCell(1).setValue(HtmlMapDesignUI.this.currentBean.getHref());
                                BeanUtil.setProperty(HtmlMapDesignUI.this.currentBean, HtmlMapDesignUI.this.fields[e.getRowIndex() + 1].getName(), HtmlMapDesignUI.this.currentBean.getHref());
                            } else if (HtmlMapDesignUI.this.currentBean.getHref() instanceof MainMenuItemInfo) {
                                HtmlMapDesignUI.this.propList.getRow(e.getRowIndex() + 1).getCell(1).setValue(HtmlMapDesignUI.this.currentBean.getHref());
                                BeanUtil.setProperty(HtmlMapDesignUI.this.currentBean, HtmlMapDesignUI.this.fields[e.getRowIndex() + 1].getName(), HtmlMapDesignUI.this.currentBean.getHref());
                            }
                        }
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.fields = AttributeBean.class.getFields();
        Field field = null;
        IRow row = null;
        for (int i = 0; i < this.fields.length; ++i) {
            KDComboBox comBox;
            field = this.fields[i];
            row = this.propList.addRow();
            row.getCell("name").setValue((Object)this.getPropName(field.getName()));
            if (field.getType() == MapTypeEnum.class) {
                comBox = new KDComboBox();
                comBox.setEditable(false);
                comBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.cp.mc.MapTypeEnum").toArray());
                comBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (HtmlMapDesignUI.this.drawContainer.getActiveShape() == null) {
                            MsgBox.showWarning((String)HtmlMapDesignUI.this.getString("selectHotArea"));
                            HtmlMapDesignUI.this.drawContainer.requestFocus();
                        }
                    }
                });
                row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comBox));
            } else if (field.getType() == StateEnum.class) {
                comBox = new KDComboBox();
                comBox.setEditable(false);
                comBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.cp.mc.StateEnum").toArray());
                row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comBox));
            } else if ("href".equals(field.getName())) {
                row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.titlePromptBox));
            }
            this.rowMap.put(field.getName(), row);
        }
    }

    protected void changeType(ICell cell, Object obj) {
        if (this.currentBean == null || cell == null || this.currentBean.getType() == null || this.currentBean.getType().equals(obj)) {
            return;
        }
        cell.setValue(null);
        if (MapTypeEnum.MENU.equals((Object)this.currentBean.getType())) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.titlePromptBox));
        } else {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)this.textArea));
        }
    }

    private String getPropName(String name) {
        return EASResource.getString((String)"com.kingdee.eas.cp.mc.MapDesignResource", (String)name);
    }

    private void changeProps(AttributeBean bean) {
    }

    private void setProps(AttributeBean bean) {
        assert (this.fields != null);
        Field field = null;
        IRow row = null;
        this.changeType(this.propList.getCell(1, 1), null);
        for (int i = 0; i < this.fields.length; ++i) {
            field = this.fields[i];
            row = (IRow)this.rowMap.get(field.getName());
            try {
                Object values = BeanUtil.getProperty(bean, field.getName());
                row.getCell(1).setValue(values);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
    }

    public void listSelectChange(ListSelectionEvent e) {
        Object obj = ((KDList)e.getSource()).getSelectedValue();
        if (obj instanceof IShape) {
            this.drawContainer.setActiveShape((IShape)obj);
            this.changeProps(((IShape)obj).getAttribute());
        }
    }

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpen_actionPerformed(e);
        int option = this.fileChooser.showOpenDialog((Component)((Object)this));
        if (option == 1) {
            this.fileChooser.cancelSelection();
        } else {
            this.file = this.fileChooser.getSelectedFile();
            this.loadImage(this.file);
        }
    }

    private void loadImage(File imagefile) throws Exception {
        if (imagefile == null) {
            return;
        }
        ImageIcon icon = null;
        this.imageName = imagefile.getName();
        if (imagefile.exists() && imagefile.isFile()) {
            Toolkit.getDefaultToolkit().getImage(imagefile.getAbsolutePath()).flush();
            icon = new ImageIcon(imagefile.getAbsolutePath());
        }
        if (icon != null) {
            this.updateImage(icon);
        }
    }

    private void updateImage(ImageIcon image) {
        Dimension dim = new Dimension(image.getIconWidth(), image.getIconHeight());
        this.imageContainer.setIcon(null);
        this.imageContainer.setText(null);
        this.imageContainer.setBounds(0, 0, image.getIconWidth(), image.getIconHeight());
        this.drawContainer.setSize(dim);
        this.drawContainer.removeShapes();
        this.imageContainer.setIcon(image);
        this.layerPane.setPreferredSize(dim);
        this.repaint();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        MapGenerator.generateImageMap(this.imageName, this.drawContainer.getShapes());
    }

    @Override
    public void actionSelected_actionPerformed(ActionEvent e) throws Exception {
        this.setStoped();
        super.actionSelected_actionPerformed(e);
        this.editor.setText(this.text.getText());
        this.drawContainer.setCurrentShape(4);
    }

    @Override
    public void actionRect_actionPerformed(ActionEvent e) throws Exception {
        this.setStoped();
        super.actionRect_actionPerformed(e);
        this.drawContainer.setCurrentShape(1);
    }

    @Override
    public void actionCircle_actionPerformed(ActionEvent e) throws Exception {
        this.setStoped();
        super.actionCircle_actionPerformed(e);
        this.drawContainer.setCurrentShape(2);
    }

    @Override
    public void actionPolygon_actionPerformed(ActionEvent e) throws Exception {
        this.setStoped();
        super.actionPolygon_actionPerformed(e);
        this.drawContainer.setCurrentShape(3);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        this.drawContainer.removeShape(this.drawContainer.getActiveShape());
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        int returnVal = this.chooser.showOpenDialog((Component)((Object)this));
        if (returnVal == 1) {
            this.chooser.cancelSelection();
        } else if (returnVal == 0) {
            File jarfile = this.chooser.getSelectedFile();
            Document document = null;
            if (!jarfile.isFile()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.mc.MapDesignResource", (String)"invalidXml"));
                return;
            }
            this.localFile = this.getLocalFile();
            String path = ImportExportOprt.importZipFile(jarfile, this.localFile.toString());
            this.file = new File(path + File.separator + "hotImage.jpg");
            if (this.file.exists()) {
                this.loadImage(this.file);
            }
            String jarname = this.chooser.getSelectedFile().getName().split(".zip")[0];
            try {
                document = ImportExportOprt.xmIncoder(new File(path + File.separator + jarname + ".xml"));
                if (ImportExportOprt.loadFromXML(document, this.drawContainer)) {
                    super.onLoad();
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.mc.MapDesignResource", (String)"importSuccess"));
                }
            }
            catch (PortletImportExportException e1) {
                ExceptionHandler.handle((Throwable)((Object)e1));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionOutport_actionPerformed(ActionEvent e) throws Exception {
        if (this.file == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"please_load_image"));
            return;
        }
        int returnVal = this.chooser.showSaveDialog((Component)((Object)this));
        if (returnVal == 1) {
            this.chooser.cancelSelection();
        } else if (returnVal == 0) {
            String saveName = this.chooser.getSelectedFile().getName();
            if (saveName.endsWith(".zip")) {
                saveName = saveName.substring(0, saveName.length() - 4);
            }
            File savePath = this.chooser.getCurrentDirectory();
            String path = savePath.getPath() + File.separator + saveName;
            this.localFile = this.getLocalFile();
            File[] jarfiles = ImportExportOprt.exportFile(this.localFile, saveName, this.file, this.drawContainer);
            ImportExportOprt.exportZipFile(jarfiles, path);
            if (this.localFile.exists()) {
                this.deleteFolder(this.localFile);
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.mc.MapDesignResource", (String)"exportSuccess"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyFile(File from, File to) {
        if (from.equals(to)) {
            return true;
        }
        FileInputStream fileIn = null;
        BufferedInputStream buffIn = null;
        FileOutputStream fileOut = null;
        FilterOutputStream buffOut = null;
        try {
            fileIn = new FileInputStream(from);
            buffIn = new BufferedInputStream(fileIn);
            fileOut = new FileOutputStream(to);
            buffOut = new BufferedOutputStream(fileOut);
            int len = 0;
            byte[] rd = new byte[4096];
            while ((len = fileIn.read(rd)) >= 0) {
                ((BufferedOutputStream)buffOut).write(rd, 0, len);
            }
            ((BufferedOutputStream)buffOut).flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (buffOut != null) {
                try {
                    buffOut.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (buffIn != null) {
                try {
                    buffIn.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return true;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public String getServerUrl() {
        return "http://" + this.serverPath + "/";
    }

    private void loadSolutionFromDB(Context ctx) throws Exception {
        GraphicsInfo info = this.instance.getGraphicsInfoByPK(null);
        byte[] imageSpotsContent = info.getFile();
        this.file = this.instance.getImageFromDB(this.ids[2], ctx, null);
        this.imageSpots = this.instance.getImageSpotsFromDB(imageSpotsContent, null);
        this.loadImage(this.file);
        this.loadUI(this.imageSpots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUI(File file) {
        ObjectInputStream in = null;
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(file);
            in = new ObjectInputStream(fileIn);
            Object obj = in.readObject();
            if (obj != null && obj instanceof List) {
                List list = (List)obj;
                for (IShape shape : list) {
                    this.drawContainer.addShape(shape);
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void doBeforeReleaseAction() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRelease_actionPerformed(ActionEvent e) throws Exception {
        AttachmentInfo imageInfo;
        this.setStoped();
        this.doBeforeReleaseAction();
        this.localFile = this.getLocalFile();
        File newFile = new File(this.localFile, "hotImage.jpg");
        if (this.file == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"please_load_image"));
            return;
        }
        this.copyFile(this.file, newFile);
        File secFile = File.createTempFile("map", ".data");
        ObjectOutputStream objOut = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(secFile);
            objOut = new ObjectOutputStream(out);
            objOut.writeObject(this.drawContainer.getShapes());
        }
        finally {
            if (objOut != null) {
                try {
                    objOut.close();
                }
                catch (IOException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
        }
        if (this.ids[2] != null) {
            imageInfo = this.updateImage(this.file);
            byte[] secFileContent = FileGetter.getBytesFromFile((File)secFile);
            this.updateGraphicsInfo(imageInfo, secFileContent);
        } else {
            imageInfo = this.addNewImage(this.file);
            byte[] secFileContent = FileGetter.getBytesFromFile((File)secFile);
            this.updateGraphicsInfo(imageInfo, secFileContent);
        }
        if (this.localFile.exists()) {
            this.deleteFolder(this.localFile);
        }
        MsgBox.showInfo((Component)((Object)this), (String)this.getString("release_success"));
    }

    private void updateGraphicsInfo(AttachmentInfo attachmentInfo, byte[] secFileContent) {
        IGraphics graphics = null;
        try {
            graphics = GraphicsFactory.getRemoteInstance();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        GraphicsInfo info = this.getGraphicsInfoByPK(graphics);
        info.setAttachment(attachmentInfo);
        info.setFile(secFileContent);
        this.updateGraphicsInfo(graphics, info);
    }

    private GraphicsInfo getGraphicsInfoByPK(IGraphics graphics) {
        GraphicsInfo info = null;
        try {
            info = graphics.getGraphicsInfo((IObjectPK)new ObjectUuidPK(this.ids[1]));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return info;
    }

    private void updateGraphicsInfo(IGraphics graphics, GraphicsInfo info) {
        try {
            graphics.update((IObjectPK)new ObjectUuidPK(this.ids[1]), info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void initIDs(String portletID) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("attachment"));
        selector.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Portlet", (Object)portletID, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(filter);
        GraphicsCollection col = null;
        try {
            col = GraphicsFactory.getRemoteInstance().getGraphicsCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        GraphicsInfo info = col.get(0);
        String graphicsID = info.getId().toString();
        String attachID = info.getAttachment().getId().toString();
        this.ids = new String[]{portletID, graphicsID, attachID};
    }

    public void main(String[] args) {
    }

    @Override
    public void change(IShape shape, int status) {
        if (status == 1) {
            if (this.lists != null) {
                this.lists.removeElement(shape);
            }
            this.currentBean = null;
        } else if (status == 0) {
            if (this.lists != null) {
                this.lists.addElement(shape);
                this.shapeList.setSelectedValue((Object)shape, true);
                this.currentBean = shape.getAttribute();
            }
        } else if (status == 2) {
            if (this.lists != null) {
                this.shapeList.setSelectedValue((Object)shape, true);
                this.currentBean = shape.getAttribute();
            }
        } else if (status == 3 && this.lists != null) {
            this.lists.clear();
            this.currentBean = null;
        }
        if (this.currentBean != null) {
            this.setProps(this.currentBean);
        }
    }

    public void setStoped() {
        this.propList.getEditManager().stopEditing();
    }

    private static class ImageFilter
    extends FileFilter {
        private static ImageFilter instance;

        private ImageFilter() {
        }

        public static ImageFilter getInstance() {
            if (instance == null) {
                instance = new ImageFilter();
            }
            return instance;
        }

        @Override
        public boolean accept(File f) {
            String extension = this.getExtension(f);
            if (f.isDirectory()) {
                return true;
            }
            return extension.endsWith("jpg") || extension.endsWith("png") || extension.endsWith("gif");
        }

        @Override
        public String getDescription() {
            return "*.jpg  *.png  *.gif ";
        }

        private String getExtension(File f) {
            if (f == null) {
                return "";
            }
            String name = f.getName();
            int index = name.lastIndexOf(".");
            String extension = name.substring(index + 1).toLowerCase(Locale.ENGLISH);
            return extension;
        }
    }

    class MyFilter
    extends FileFilter {
        MyFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName();
            return filename.endsWith(".jpg");
        }

        @Override
        public String getDescription() {
            return "Graphics files";
        }
    }
}

