/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.plaf.PaintUtil;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFrame;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.cp.mc.client.HtmlMapDesignUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class KDMapDesigned
extends UIFrame
implements IUIWindow {
    private static final int CriticalWidth = 800;
    private static final long serialVersionUID = -7858811990653816160L;
    private KDPanel pnlTitle;
    private KDLabel lblTitle;
    private static Color backBeginColor = new Color(95, 145, 197);
    private static Color backEndColor = new Color(95, 145, 197);
    private static Color bottomColor1 = new Color(217, 217, 208);
    private static Color bottomColor2 = new Color(214, 214, 204);
    private static Color bottomColor3 = new Color(209, 209, 197);
    private static Color bottomColor4 = new Color(192, 192, 176);
    private static Icon arrowIcon = EASResource.getIcon((String)"imgTitle_arrowhead");
    private static Font titleFont = new Font(null, 1, 18);

    public KDMapDesigned(IUIObject uiObject) {
        super(uiObject);
    }

    public boolean close() {
        return this.getUIObject().destroyWindow();
    }

    private void initCloseButton() {
        KDToolBar toolBar = this.getUIObject().getUIToolBar();
        if (toolBar != null && toolBar.getComponentCount() > 0) {
            KDWorkButton btnClose = new KDWorkButton();
            btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
            btnClose.setText(UIFrameResource.getString((String)"close"));
            btnClose.setToolTipText(UIFrameResource.getString((String)"close"));
            btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDMapDesigned.this.close();
                }
            });
            toolBar.addSeparator();
            toolBar.add((Component)btnClose);
        }
    }

    public void setUIObject(IUIObject uiObject) {
        super.setUIObject(uiObject);
        this.addToolBar((JToolBar)uiObject.getUIToolBar());
        this.getUIMenuBar().hideLogo();
    }

    public KDPanel getTitlePanel(String title) {
        if (this.pnlTitle == null) {
            this.pnlTitle = new KDPanel(){

                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Color oldCol = g.getColor();
                    Dimension tempDim = this.getSize();
                    int y = 27;
                    g.setColor(bottomColor1);
                    g.drawLine(0, y, tempDim.width - 2, y);
                    g.setColor(bottomColor2);
                    g.drawLine(0, ++y, tempDim.width - 2, y);
                    g.setColor(bottomColor3);
                    g.drawLine(0, ++y, tempDim.width - 2, y);
                    g.setColor(bottomColor4);
                    g.drawLine(0, ++y, tempDim.width - 2, y);
                    g.setColor(oldCol);
                }
            };
            this.pnlTitle.setName("TitlePanel");
            this.pnlTitle.setLayout((LayoutManager)new BorderLayout());
            this.pnlTitle.setPreferredSize(new Dimension(200, 32));
            this.lblTitle = new KDLabel(){

                public void paintComponent(Graphics g) {
                    PaintUtil.drawVertShadow((Graphics)g, (JComponent)((Object)this), (float)0.0f, (float)0.0f, (Color)backBeginColor, (float)0.0f, (float)29.0f, (Color)backEndColor);
                    super.paintComponent(g);
                }

                public Insets getInsets() {
                    return new Insets(0, 0, 0, 0);
                }
            };
            this.lblTitle.setAlignmentX(0.0f);
            this.lblTitle.setPreferredSize(new Dimension(600, 28));
            this.lblTitle.setForeground(Color.WHITE);
            this.lblTitle.setFont(KDMapDesigned.getTitleFont());
            this.lblTitle.setText(title);
            this.lblTitle.setIcon(KDMapDesigned.getTitleIcon());
            this.pnlTitle.add((Component)this.lblTitle, (Object)"North");
        }
        return this.pnlTitle;
    }

    private static Icon getTitleIcon() {
        return arrowIcon;
    }

    private static Font getTitleFont() {
        return titleFont;
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (this.lblTitle != null) {
            this.lblTitle.setText(title);
            this.lblTitle.revalidate();
        }
    }

    private void setTitlePanel(IUIObject uiObject) {
        KDPanel pnlTitle = this.getTitlePanel(uiObject.getUITitle());
        this.getContentPane().add((Component)pnlTitle, "North");
    }

    private void resizeUIWindow(IUIObject uiObject, int winStyle) {
        int height = 0;
        int width = 0;
        Dimension preferredSize = null;
        if ((double)height == 0.0 || (double)width == 0.0) {
            height = 600;
            width = 800;
        }
        preferredSize = new Dimension(width, height);
        ((JPanel)this.getContentPane()).setPreferredSize(preferredSize);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
            KDMapDesigned design = new KDMapDesigned((IUIObject)new HtmlMapDesignUI());
            design.setBounds(0, 0, 800, 600);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = design.getSize();
            design.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
            design.setDefaultCloseOperation(3);
            design.show();
            design.setTitle("html map \u8bbe\u8ba1");
            design.getRootPane().getActionMap().remove("diaEscCloswWindow");
            System.out.println("run ok!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

