/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mrm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.mrm.MRApplyInfo;
import com.kingdee.eas.cp.mrm.MRMRegularInteval;
import com.kingdee.eas.cp.mrm.MRRegularInfo;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MRMRRegular
extends MRMRegularInteval {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.mrm.MRMRRegular");

    public MRMRRegular(MRRegularInfo regular, Date curDate) {
        super(regular, curDate);
    }

    public static void sendInform(Context ctx, MRApplyInfo apply) throws Exception {
        local = ctx.getLocale();
        HashMap map = MRMRRegular.getInformType(ctx, apply.getCU().getId().toString());
        boolean isSMS = false;
        boolean isMessage = false;
        boolean isEmail = false;
        if (map.get("isSMS") != null) {
            isSMS = (Boolean)map.get("isSMS");
            logger.error((Object)("isSMS:" + isSMS));
        }
        if (map.get("isMessage") != null) {
            isMessage = (Boolean)map.get("isMessage");
        }
        if (map.get("isEmail") != null) {
            isEmail = (Boolean)map.get("isEmail");
        }
        if (isMessage) {
            try {
                MRMRRegular.sendMessage(ctx, apply);
            }
            catch (Exception e) {
                logger.error((Object)("send message error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
        if (isEmail) {
            try {
                MRMRRegular.sendMail(ctx, apply);
            }
            catch (Exception e) {
                logger.error((Object)("send mail error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
        if (isSMS) {
            try {
                MRMRRegular.sendSMS(ctx, apply);
            }
            catch (Exception e) {
                logger.error((Object)("send sms error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
    }

    public static void sendMessage(Context ctx, MRApplyInfo apply) throws EASBizException, BOSException {
        String[] ids = MRMRRegular.getUserIdByApply(ctx, apply);
        String messageStr = MRMRRegular.getMsgTitleByMRApplyInfo(apply);
        String senderStr = apply.getApplier().getName();
        String bodyStr = MRMRRegular.getMsgBodyByMRApplyInfo(apply);
        MRMRRegular.sendMessage(ctx, ids, messageStr, senderStr, bodyStr, apply.getId().toString(), 0);
    }

    public static String[] getUserIdByApply(Context ctx, MRApplyInfo apply) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (apply.getApplier() != null) {
            set.add(apply.getApplier().getId().toString());
        }
        if (set.size() == 0) {
            return new String[0];
        }
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() == 0) {
            return new String[0];
        }
        String[] userIds = new String[uc.size()];
        int size = userIds.length;
        for (int i = 0; i < size; ++i) {
            userIds[i] = uc.get(i).getId().toString();
        }
        return userIds;
    }

    public static String getMsgTitleByMRApplyInfo(MRApplyInfo apply) {
        String lihuitheme = ResourceBase.getString((String)EAS, (String)"lihuitheme", (Locale)local);
        String lihuichongtu = ResourceBase.getString((String)EAS, (String)"lihuichongtu", (Locale)local);
        StringBuffer sb = new StringBuffer();
        sb.append(lihuitheme);
        sb.append(apply.getName());
        sb.append(lihuichongtu);
        return sb.toString();
    }

    public static void sendMail(Context ctx, MRApplyInfo apply) throws Exception {
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        if (apply.getApplier() != null) {
            list.add(apply.getApplier());
        }
        String to = MRMRRegular.getMailPersonStr(ctx, list);
        String subject = MRMRRegular.getMsgTitleByMRApplyInfo(apply);
        String body = MRMRRegular.getMsgBodyByMRApplyInfo(apply, true);
        if (to == null || to.length() == 0) {
            return;
        }
        MsgUtil.msgMailDerect((Context)ctx, (String)subject, (String)body, (String)to, null, null, null);
    }

    public static void sendSMS(Context ctx, MRApplyInfo apply) throws EASBizException, BOSException {
        String receiver;
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        if (apply.getApplier() != null) {
            list.add(apply.getApplier());
        }
        if ((receiver = MRMRRegular.getCellNumberStr(ctx, list)) == null || "".equals(receiver)) {
            return;
        }
        String content = MRMRRegular.getMsgTitleByMRApplyInfo(apply);
        SendMessageParamInfo paramInfo = new SendMessageParamInfo();
        paramInfo.setAppendCompanyName(false);
        paramInfo.setAppendNumber(false);
        paramInfo.setAppendPersonName(false);
        paramInfo.setAppendRevert(false);
        paramInfo.setAppendUserName(false);
        paramInfo.setContent(content);
        paramInfo.setReceiver(receiver);
        paramInfo.setCanback(false);
        logger.error((Object)"MsgFacadeFactory.getLocalInstance(ctx)>>iMsgFacade.sendMsg(paramInfo)");
        IMsgFacade iMsgFacade = MsgFacadeFactory.getLocalInstance((Context)ctx);
        iMsgFacade.sendMsg(paramInfo);
    }
}

