/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.pc.ProcCatalogException;
import com.kingdee.eas.cp.eip.pc.ProcCatalogNode;
import com.kingdee.eas.cp.eip.pc.client.AbstractOrgEfficencyStatConditionUI;
import com.kingdee.eas.cp.eip.pc.client.ProcessChooseTreeF7;
import com.kingdee.eas.cp.eip.pc.client.ProcessChooseTreeList;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgEfficencyStatConditionUI
extends AbstractOrgEfficencyStatConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgEfficencyStatConditionUI.class);
    private static Map cacheMap;

    public void setCacheMap() {
        cacheMap = new HashMap();
        if (this.kdbpbAdmin.getValue() != null) {
            cacheMap.put(ProEfficencyStatConditionParam.admin, this.kdbpbAdmin.getValue());
        }
        if (this.kddpStartDate.getValue() != null) {
            cacheMap.put(ProEfficencyStatConditionParam.startDate, this.kddpStartDate.getValue());
        }
        if (this.kddpEndDate.getValue() != null) {
            cacheMap.put(ProEfficencyStatConditionParam.endDate, this.kddpEndDate.getValue());
        }
        if (this.kdbpbProcess.getValue() != null) {
            cacheMap.put(ProEfficencyStatConditionParam.process, this.kdbpbProcess.getValue());
        }
    }

    public void initData() throws Exception {
        if (cacheMap != null && cacheMap.size() > 0) {
            if (cacheMap.get(ProEfficencyStatConditionParam.admin) != null) {
                this.kdbpbAdmin.setValue(cacheMap.get(ProEfficencyStatConditionParam.admin));
            }
            if (cacheMap.get(ProEfficencyStatConditionParam.startDate) != null) {
                this.kddpStartDate.setValue(cacheMap.get(ProEfficencyStatConditionParam.startDate));
            }
            if (cacheMap.get(ProEfficencyStatConditionParam.endDate) != null) {
                this.kddpEndDate.setValue(cacheMap.get(ProEfficencyStatConditionParam.endDate));
            }
            if (cacheMap.get(ProEfficencyStatConditionParam.process) != null) {
                this.kdbpbProcess.setValue(cacheMap.get(ProEfficencyStatConditionParam.process));
            }
            return;
        }
        this.kdbpbAdmin.setValue(null);
        String endTime = DateTimeUtils.defaultDateString((java.util.Date)new Timestamp(System.currentTimeMillis())).substring(0, 10);
        this.kddpEndDate.setValue((Object)Date.valueOf(endTime));
        this.kddpStartDate.setValue((Object)DateTimeUtils.addMonth((java.util.Date)Date.valueOf(endTime), (int)-1));
    }

    public OrgEfficencyStatConditionUI() throws Exception {
        this.kdbpbProcess.setRequired(true);
        AdminF7 adminBox = new AdminF7();
        adminBox.setMultiSelect(true);
        adminBox.setIsCUFilter(true);
        adminBox.disablePerm();
        adminBox.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.kdbpbAdmin.setDisplayFormat("$name$");
        this.kdbpbAdmin.setEditFormat("$number$");
        this.kdbpbAdmin.setCommitFormat("$number$");
        this.kdbpbAdmin.setSelector((KDPromptSelector)adminBox);
        ProcessChooseTreeF7 processChooseF7 = new ProcessChooseTreeF7((IUIObject)this, false, true);
        this.kdbpbProcess.setSelector((KDPromptSelector)processChooseF7);
        this.initData();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        this.kdbpbAdmin.setValue(null);
        this.kdbpbProcess.setValue(null);
        String endTime = DateTimeUtils.defaultDateString((java.util.Date)new Timestamp(System.currentTimeMillis())).substring(0, 10);
        this.kddpEndDate.setValue((Object)Date.valueOf(endTime));
        this.kddpStartDate.setValue((Object)DateTimeUtils.addMonth((java.util.Date)Date.valueOf(endTime), (int)-1));
    }

    public Object getParam() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object object = null;
        object = this.kdbpbAdmin.getValue();
        result.put(ProEfficencyStatConditionParam.admin, object);
        object = this.kdbpbProcess.getValue();
        result.put(ProEfficencyStatConditionParam.process, object);
        object = this.kddpEndDate.getValue();
        result.put(ProEfficencyStatConditionParam.endDate, object);
        object = this.kddpStartDate.getValue();
        result.put(ProEfficencyStatConditionParam.startDate, object);
        return result;
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public boolean verify() {
        try {
            this.checkError();
            return true;
        }
        catch (ProcCatalogException ite) {
            MsgBox.showInfo((String)ite.getMessage());
            return false;
        }
    }

    private void checkError() throws ProcCatalogException {
        if (this.kdbpbAdmin.getValue() == null && (this.kdbpbAdmin.getText() == null || this.kdbpbAdmin.getText().length() < 1)) {
            this.kdbpbAdmin.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.ADMIN_NOT_NULL);
        }
        if (this.kdbpbProcess.getValue() == null && (this.kdbpbProcess.getText() == null || this.kdbpbProcess.getText().length() < 1)) {
            this.kdbpbProcess.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.PROCESSNAME_NOT_NULL);
        }
        if (this.kddpStartDate.getValue() == null) {
            this.kddpStartDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.BEGINTIME_NOTNULL);
        }
        if (this.kddpEndDate.getValue() == null) {
            this.kddpEndDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.END_TIME_NOTNULL);
        }
        Date dtFrom = this.kddpStartDate.getSqlDate();
        Date dtTo = this.kddpEndDate.getSqlDate();
        if (dtFrom.toString().compareTo(dtTo.toString()) > 0) {
            this.kddpEndDate.setValue(null);
            this.kddpEndDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.STARTTIME_MUST_BIGGER_THAN_ENDTIME);
        }
    }

    public String getQuerySql() {
        StringBuffer strSql = new StringBuffer();
        Object objectTemp = null;
        objectTemp = this.kdbpbAdmin.getValue();
        Object[] objArray = null;
        if (objectTemp != null) {
            objArray = (Object[])objectTemp;
            String adminLongnumber = null;
            String adminName = null;
            OrgUnitInfo orgInfo = null;
            int size = objArray.length;
            for (int i = 0; i < size; ++i) {
                orgInfo = (OrgUnitInfo)objArray[i];
                if (adminLongnumber == null) {
                    adminLongnumber = orgInfo.getLongNumber();
                    adminName = orgInfo.getName();
                    continue;
                }
                adminLongnumber = adminLongnumber + "," + orgInfo.getLongNumber();
                adminName = adminName + "," + orgInfo.getName();
            }
            strSql.append(adminLongnumber);
            strSql.append("~!~").append(adminName).append("~!~");
        }
        if ((objectTemp = this.kdbpbProcess.getValue()) != null && objectTemp instanceof ProcessChooseTreeList) {
            ProcessChooseTreeList list = (ProcessChooseTreeList)objectTemp;
            String procID = null;
            if (list != null && list.size() > 0) {
                ProcCatalogNode node = (ProcCatalogNode)list.get(0);
                procID = node.getId();
            }
            strSql.append(procID);
        }
        strSql.append("~!~").append(this.kdbpbProcess.getText()).append("~!~");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        objectTemp = this.kddpStartDate.getValue();
        if (objectTemp != null) {
            strSql.append(format.format(objectTemp));
        }
        strSql.append("~!~");
        objectTemp = this.kddpEndDate.getValue();
        if (objectTemp != null) {
            strSql.append(format.format(objectTemp));
        }
        return strSql.toString();
    }

    public void setParam(Object param) {
        Map result = (Map)param;
        boolean nSize = false;
        this.kdbpbAdmin.setValue(result.get(ProEfficencyStatConditionParam.admin));
        this.kdbpbProcess.setValue(result.get(ProEfficencyStatConditionParam.process));
        this.kddpEndDate.setValue(result.get(ProEfficencyStatConditionParam.endDate));
        this.kddpStartDate.setValue(result.get(ProEfficencyStatConditionParam.startDate));
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer("");
        FilterItemCollection fic = this.filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)this.getQuerySql()));
        return this.filterInfo;
    }

    private Object getProcessList(CustomerParams cp) {
        ProcessChooseTreeList treeList = new ProcessChooseTreeList();
        ProcCatalogNode node = null;
        String str = cp.getCustomerParam("idList");
        if (str == null || "".equals(str)) {
            return null;
        }
        String[] idLists = str.split(",");
        String str1 = cp.getCustomerParam("stringList");
        if (str1 == null || "".equals(str1)) {
            return null;
        }
        String[] nameLists = str1.split(",");
        for (int i = 0; i < idLists.length; ++i) {
            node = new ProcCatalogNode();
            node.setId(idLists[i]);
            if (i < nameLists.length) {
                node.setName(nameLists[i]);
            }
            treeList.add(node);
        }
        return treeList;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        HashMap result = new HashMap();
        Object object = null;
        object = this.kdbpbAdmin.getValue();
        if (object != null && object.getClass().isArray()) {
            Object[] objs = (Object[])object;
            StringBuffer strBuf = new StringBuffer();
            CoreBaseInfo info = null;
            for (int i = 0; i < objs.length; ++i) {
                info = (CoreBaseInfo)objs[i];
                strBuf.append(info.getId().toString());
                strBuf.append(";");
            }
            cp.addCustomerParam(ProEfficencyStatConditionParam.admin, strBuf.toString());
        }
        object = this.kdbpbProcess.getValue();
        ProcessChooseTreeList treeList = (ProcessChooseTreeList)object;
        cp.addCustomerParam("idList", treeList.getIdList());
        cp.addCustomerParam("stringList", treeList.toString());
        object = this.kddpEndDate.getValue();
        cp.putDate(ProEfficencyStatConditionParam.endDate, (java.util.Date)object);
        object = this.kddpStartDate.getValue();
        cp.putDate(ProEfficencyStatConditionParam.startDate, (java.util.Date)object);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        String id = cp.getCustomerParam(ProEfficencyStatConditionParam.admin);
        try {
            if (id != null) {
                String[] idLists = id.split(";");
                IObjectValue value = null;
                ArrayList<IObjectValue> values = new ArrayList<IObjectValue>();
                for (int i = 0; i < idLists.length; ++i) {
                    String id1 = idLists[i];
                    if (id1 == null || "".equals(id1)) continue;
                    value = DynamicObjectFactory.getRemoteInstance().getValue(BOSUuid.read((String)id1).getType(), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id1)));
                    values.add(value);
                }
                this.kdbpbAdmin.setValue((Object)values.toArray());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.kdbpbProcess.setValue(this.getProcessList(cp));
        this.kddpEndDate.setValue((Object)cp.getDate(ProEfficencyStatConditionParam.endDate));
        this.kddpStartDate.setValue((Object)cp.getDate(ProEfficencyStatConditionParam.startDate));
    }

    public static class ProEfficencyStatConditionParam
    implements Serializable {
        public static String admin = "admin";
        public static String process = "process";
        public static String startDate = "startDate";
        public static String endDate = "endDate";
    }
}

