/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.eip.pc.ConfigurationItemFactory;
import com.kingdee.eas.cp.eip.pc.IConfigurationItem;
import com.kingdee.eas.cp.eip.pc.IProcCatalog;
import com.kingdee.eas.cp.eip.pc.IProcCatalogFacade;
import com.kingdee.eas.cp.eip.pc.IProcCatalogSolution;
import com.kingdee.eas.cp.eip.pc.ProcCatalogFacadeFactory;
import com.kingdee.eas.cp.eip.pc.ProcCatalogFactory;
import com.kingdee.eas.cp.eip.pc.ProcCatalogInfo;
import com.kingdee.eas.cp.eip.pc.ProcCatalogSolutionFactory;
import com.kingdee.eas.cp.eip.pc.ProcCatalogSolutionInfo;
import com.kingdee.eas.cp.eip.pc.ProcessCenterUtil;
import com.kingdee.eas.cp.eip.pc.client.AbstractProcCatalogUI;
import com.kingdee.eas.cp.eip.pc.client.ConfigurationItemUI;
import com.kingdee.eas.cp.eip.pc.client.util.BuildTreeNode;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ProcCatalogUI
extends AbstractProcCatalogUI {
    private String[] strOldName = null;
    private ConfigurationItemUI configurationItemUI = null;
    private boolean bChangeProcCatalog = false;
    private final String procCatalogResource = "com.kingdee.eas.cp.eip.pc.ProcCatalogResource";

    public ProcCatalogUI() throws Exception {
        this.kdtNodeName.getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    ProcCatalogUI.this.kdtNodeName_focusLost(e);
                }
                catch (Exception exc) {
                    ProcCatalogUI.this.handUIException(exc);
                }
            }
        });
        this.kdtNodeName.getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    ProcCatalogUI.this.kdtNodeName_keyPressed(e);
                }
                catch (Exception exc) {
                    ProcCatalogUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        List langList = KDBizMultiLangBox.getLanguageList();
        int langSize = langList.size();
        if (langSize > 0) {
            this.strOldName = new String[langSize];
            for (int i = 0; i < langSize; ++i) {
                this.strOldName[i] = "";
            }
        } else {
            this.strOldName = new String[]{""};
        }
        IProcCatalogSolution solution = ProcCatalogSolutionFactory.getRemoteInstance();
        FilterItemInfo filterItem = new FilterItemInfo("CU", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        FilterItemInfo filterItem2 = new FilterItemInfo("isDefault", (Object)"0");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(filterItem);
        filterInfo.getFilterItems().add(filterItem2);
        filterInfo.setMaskString(" #0 AND #1 ");
        if (solution.exists(filterInfo)) {
            this.initTreeData();
        } else {
            int nResponse = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"ifSetSolution"));
            if (nResponse == 0) {
                this.importSetting();
            } else {
                this.initTreeData();
            }
        }
        this.kdtNodeName.setSelectedIndex(this.setSelectLanguage());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddChildNode.setEnabled(true);
        this.actionAddRoot.setEnabled(true);
        this.actionClose.setEnabled(true);
        this.actionDeleteNode.setEnabled(true);
        this.actionImportSetting.setEnabled(true);
        this.actionInsertNode.setEnabled(true);
        this.actionMoveUpNode.setEnabled(true);
        this.actionMoveDownNode.setEnabled(true);
        this.kdtNodeName.setEditable(false);
    }

    private void initTreeData() throws Exception {
        IProcCatalog procCatalog = ProcCatalogFactory.getRemoteInstance();
        KDTreeNode rootNode = new BuildTreeNode().buildProcCatalogTree();
        if (rootNode != null && rootNode.getChildCount() > 0) {
            this.actionAddProcess.setEnabled(true);
        } else {
            this.actionAddProcess.setEnabled(false);
        }
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)rootNode);
        this.kdtProcCatalogTree.setModel((TreeModel)model);
        this.kdtProcCatalogTree.setRootVisible(false);
        this.kdtProcCatalogTree.expandAllNodes(true, (TreeNode)rootNode);
        this.kdtProcCatalogTree.setRowHeight(20);
        this.kdtProcCatalogTree.getSelectionModel().setSelectionMode(1);
    }

    @Override
    protected void kdtProcCatalogTree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.kdtProcCatalogTree_valueChanged(e);
        KDTreeNode treeNode = (KDTreeNode)this.kdtProcCatalogTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            ProcCatalogInfo parentTreeInfo = (ProcCatalogInfo)treeNode.getUserObject();
            List langList = KDBizMultiLangBox.getLanguageList();
            Iterator iter = langList.iterator();
            LanguageInfo languageInfo = null;
            int i = 0;
            while (iter.hasNext()) {
                languageInfo = (LanguageInfo)iter.next();
                this.kdtNodeName.setItemData(languageInfo, (Object)parentTreeInfo.getName(languageInfo.getLocale()));
                this.strOldName[i++] = parentTreeInfo.getName(languageInfo.getLocale());
            }
            this.kdtNodeName.setEditable(true);
        }
    }

    private int setSelectLanguage() {
        int nTemp = 0;
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        LanguageInfo currentLang = new LanguageInfo(SysContext.getSysContext().getLocale());
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            if (currentLang.getLocale().toString().equals(languageInfo.getLocale().toString())) break;
            ++nTemp;
        }
        return nTemp;
    }

    protected void kdtNodeName_focusLost(FocusEvent e) throws Exception {
        this.changeNodeName();
    }

    private void changeNodeName() throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.kdtProcCatalogTree.getLastSelectedPathComponent();
        if (treeNode == null) {
            return;
        }
        ProcCatalogInfo parentTreeInfo = (ProcCatalogInfo)treeNode.getUserObject();
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        int i = 0;
        int errorType = 0;
        int errorLangNo = 0;
        Locale errorLanguage = null;
        String[] processCatalogName = new String[langList.size()];
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            MultiLangItem name = this.kdtNodeName.getItemBy(languageInfo);
            String nameData = (String)name.getData();
            if (this.isLegal(nameData)) {
                errorType = 1;
                errorLanguage = languageInfo.getLocale();
                errorLangNo = i;
                break;
            }
            if (StringUtils.isEmpty((String)nameData)) {
                errorType = 2;
                errorLanguage = languageInfo.getLocale();
                errorLangNo = i;
                break;
            }
            processCatalogName[i] = nameData;
            if (!nameData.equals(this.strOldName[i])) {
                errorType = 3;
                errorLanguage = languageInfo.getLocale();
            }
            ++i;
        }
        if (errorType == 1) {
            this.kdtNodeName.setItemData(languageInfo, (Object)"");
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"noLegalChar"));
        } else if (errorType == 2) {
            this.kdtProcCatalogTree.setSelectionNode((DefaultKingdeeTreeNode)treeNode);
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"notNullNodeName"));
        } else if (errorType == 3) {
            ProcCatalogInfo treeInfo = (ProcCatalogInfo)treeNode.getUserObject();
            KDTreeNode parentNode = (KDTreeNode)treeNode.getParent();
            int processCatalogNameSize = processCatalogName.length;
            for (int k = 0; k < processCatalogNameSize; ++k) {
                treeInfo.setName(processCatalogName[k], ((LanguageInfo)langList.get(k)).getLocale());
            }
            int nIndex = parentNode.getIndex((TreeNode)treeNode);
            this.kdtProcCatalogTree.removeNodeFromParent((MutableTreeNode)treeNode);
            treeNode.setText(treeInfo.toString());
            this.kdtProcCatalogTree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)parentNode, nIndex);
            this.kdtProcCatalogTree.setSelectionNode((DefaultKingdeeTreeNode)treeNode);
            IProcCatalog tree = ProcCatalogFactory.getRemoteInstance();
            tree.update((IObjectPK)new ObjectUuidPK(treeInfo.getId()), (CoreBaseInfo)treeInfo);
            treeNode.setUserObject((Object)parentTreeInfo);
            this.bChangeProcCatalog = true;
        }
    }

    private boolean isLegal(String strName) {
        String regEx = "'|/|\"|\\\\";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(strName);
        boolean result = m.find();
        return result;
    }

    @Override
    public void actionAddRoot_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddRoot_actionPerformed(e);
        KDTreeNode rootNode = (KDTreeNode)this.kdtProcCatalogTree.getModel().getRoot();
        if (rootNode != null && rootNode.getUserObject() instanceof TreeBaseInfo) {
            ProcCatalogInfo rootInfo = (ProcCatalogInfo)rootNode.getUserObject();
            ProcCatalogInfo newInfo = null;
            int nIndex = rootNode.getChildCount();
            if (rootInfo.getId() == null) {
                newInfo = new ProcCatalogInfo();
                this.setInfoName(newInfo, nIndex, "rootNode");
                newInfo.setOrderNo(nIndex);
                newInfo.setNumber(this.getCodeRuleNumber(newInfo));
                rootInfo.setNumber(this.getCodeRuleNumber(rootInfo));
                IProcCatalogFacade facade = ProcCatalogFacadeFactory.getRemoteInstance();
                ArrayList list = facade.addSolutionAndNode(rootInfo, newInfo);
                rootInfo.setId(BOSUuid.read((String)list.get(1).toString()));
                rootInfo.setSolution((ProcCatalogSolutionInfo)list.get(0));
                rootInfo.setLevel(1);
                newInfo.setId(BOSUuid.read((String)list.get(2).toString()));
                newInfo.setSolution((ProcCatalogSolutionInfo)list.get(0));
                newInfo.setParent(rootInfo);
                newInfo.setLevel(2);
                this.bChangeProcCatalog = true;
                this.actionAddProcess.setEnabled(true);
            } else {
                newInfo = new ProcCatalogInfo();
                newInfo.setParent(rootInfo);
                newInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"newNode", (Locale)new Locale("L2")) + nIndex, new Locale("L2"));
                newInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"newNode", (Locale)new Locale("L3")) + nIndex, new Locale("L3"));
                newInfo.setOrderNo(nIndex);
                newInfo.setSolution(rootInfo.getSolution());
                newInfo.setNumber(this.getCodeRuleNumber(newInfo));
                newInfo.setLevel(2);
                IProcCatalog procCatalog = ProcCatalogFactory.getRemoteInstance();
                ObjectUuidPK pk = (ObjectUuidPK)procCatalog.addnew((CoreBaseInfo)newInfo);
                newInfo.setId(BOSUuid.read((String)pk.toString()));
                this.bChangeProcCatalog = true;
                this.actionAddProcess.setEnabled(true);
            }
            KDTreeNode newNode = new KDTreeNode((Object)newInfo);
            this.kdtProcCatalogTree.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)rootNode, nIndex);
            this.kdtProcCatalogTree.setSelectionNode((DefaultKingdeeTreeNode)newNode);
            this.kdtNodeName.requestFocus();
        }
    }

    private void setInfoName(ProcCatalogInfo newInfo, int nIndex, String resourceName) {
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            Locale local = languageInfo.getLocale();
            newInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)resourceName, (Locale)local) + nIndex, local);
        }
    }

    private String getCodeRuleNumber(ProcCatalogInfo procCatalogInfo) throws Exception {
        return ProcessCenterUtil.getCodeRuleNumber();
    }

    @Override
    public void actionAddChildNode_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddChildNode_actionPerformed(e);
        KDTreeNode parentNode = (KDTreeNode)this.kdtProcCatalogTree.getLastSelectedPathComponent();
        if (parentNode != null && parentNode.getUserObject() instanceof TreeBaseInfo) {
            ProcCatalogInfo parentInfo = (ProcCatalogInfo)parentNode.getUserObject();
            if (parentInfo.getLevel() > 10) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"nodeMaxNumber"));
                return;
            }
            IConfigurationItem configurationItem = ConfigurationItemFactory.getRemoteInstance();
            if (configurationItem.existConfigurationItem(parentInfo.getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"existConfigItem"));
                return;
            }
            ProcCatalogInfo newInfo = new ProcCatalogInfo();
            int nIndex = parentNode.getChildCount();
            newInfo.setParent(parentInfo);
            this.setInfoName(newInfo, nIndex, "newNode");
            newInfo.setOrderNo(nIndex);
            newInfo.setSolution(parentInfo.getSolution());
            newInfo.setNumber(this.getCodeRuleNumber(newInfo));
            newInfo.setLevel(parentInfo.getLevel() + 1);
            IProcCatalog tree = ProcCatalogFactory.getRemoteInstance();
            ObjectUuidPK pk = (ObjectUuidPK)tree.addnew((CoreBaseInfo)newInfo);
            newInfo.setId(BOSUuid.read((String)pk.toString()));
            KDTreeNode newNode = new KDTreeNode((Object)newInfo);
            this.kdtProcCatalogTree.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode, nIndex);
            this.kdtProcCatalogTree.setSelectionNode((DefaultKingdeeTreeNode)newNode);
            this.kdtNodeName.requestFocus();
            this.bChangeProcCatalog = true;
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"selectTreeNode"));
        }
    }

    @Override
    public void actionInsertNode_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertNode_actionPerformed(e);
        KDTreeNode treeNode = (KDTreeNode)this.kdtProcCatalogTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            ProcCatalogInfo parentTreeInfo = ((ProcCatalogInfo)treeNode.getUserObject()).getParent();
            KDTreeNode parentNode = (KDTreeNode)treeNode.getParent();
            int nIndex = 0;
            if (parentNode != null && parentNode.getUserObject() instanceof TreeBaseInfo) {
                nIndex = parentNode.getChildCount();
            }
            ProcCatalogInfo newTreeInfo = new ProcCatalogInfo();
            this.setInfoName(newTreeInfo, nIndex, "insertNode");
            newTreeInfo.setOrderNo(nIndex);
            newTreeInfo.innerSetParent(parentTreeInfo);
            newTreeInfo.setSolution(parentTreeInfo.getSolution());
            newTreeInfo.setNumber(this.getCodeRuleNumber(newTreeInfo));
            newTreeInfo.setLevel(parentTreeInfo.getLevel() + 1);
            IProcCatalog procCatalog = ProcCatalogFactory.getRemoteInstance();
            ObjectUuidPK pk = (ObjectUuidPK)procCatalog.insertProcCatalogNode(newTreeInfo);
            newTreeInfo.setId(BOSUuid.read((String)pk.toString()));
            ProcCatalogInfo childTreeInfo = null;
            KDTreeNode childNode = null;
            int nSize = parentNode.getChildCount();
            for (int i = nIndex; i < nSize; ++i) {
                childNode = (KDTreeNode)parentNode.getChildAt(i);
                childTreeInfo = (ProcCatalogInfo)childNode.getUserObject();
                childTreeInfo.setOrderNo(childTreeInfo.getOrderNo() + 1);
            }
            KDTreeNode newNode = new KDTreeNode((Object)newTreeInfo);
            this.kdtProcCatalogTree.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode, nIndex);
            this.kdtProcCatalogTree.setSelectionNode((DefaultKingdeeTreeNode)newNode);
            this.kdtNodeName.requestFocus();
            this.bChangeProcCatalog = true;
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"selectTreeNode"));
        }
    }

    @Override
    public void actionDeleteNode_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteNode_actionPerformed(e);
        KDTreeNode treeNode = (KDTreeNode)this.kdtProcCatalogTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            if (treeNode.getChildCount() == 0) {
                ProcCatalogInfo parentInfo;
                int nResponse;
                ProcCatalogInfo treeInfo = (ProcCatalogInfo)treeNode.getUserObject();
                IConfigurationItem configurationItem = ConfigurationItemFactory.getRemoteInstance();
                if (configurationItem.existConfigurationItem(treeInfo.getId().toString()) ? (nResponse = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"ifDeleteNodeAndProcess"))) == 2 : (nResponse = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"ifDeleteNode"))) == 2) {
                    return;
                }
                KDTreeNode parentNode = (KDTreeNode)treeNode.getParent();
                ProcCatalogInfo brotherInfo = null;
                KDTreeNode brotherNode = null;
                int nIndex = parentNode.getIndex((TreeNode)treeNode);
                int nNum = parentNode.getChildCount();
                for (int i = nIndex + 1; i < nNum; ++i) {
                    brotherNode = (KDTreeNode)parentNode.getChildAt(i);
                    brotherInfo = (ProcCatalogInfo)brotherNode.getUserObject();
                    brotherInfo.setOrderNo(brotherInfo.getOrderNo() - 1);
                }
                IProcCatalog procCatalog = ProcCatalogFactory.getRemoteInstance();
                procCatalog.deleteProcCatalogNode(treeInfo);
                List langList = KDBizMultiLangBox.getLanguageList();
                Iterator iter = langList.iterator();
                LanguageInfo languageInfo = null;
                while (iter.hasNext()) {
                    languageInfo = (LanguageInfo)iter.next();
                    this.kdtNodeName.setItemData(languageInfo, (Object)"");
                }
                this.kdtNodeName.setEditable(true);
                this.kdtProcCatalogTree.removeNodeFromParent((MutableTreeNode)treeNode);
                this.bChangeProcCatalog = true;
                if (parentNode.getChildCount() == 0 && (parentInfo = (ProcCatalogInfo)parentNode.getUserObject()).getId() != null && parentInfo.getId().toString().equals(procCatalog.getRootNodeByCU().getId().toString())) {
                    this.actionAddProcess.setEnabled(false);
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"notAllowDeleteParentNode"));
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"selectTreeNode"));
        }
    }

    @Override
    public void actionMoveUpNode_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveUpNode_actionPerformed(e);
        KDTreeNode treeNode = (KDTreeNode)this.kdtProcCatalogTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            ProcCatalogInfo parentTreeInfo = ((ProcCatalogInfo)treeNode.getUserObject()).getParent();
            KDTreeNode parentNode = (KDTreeNode)treeNode.getParent();
            int nIndex = 0;
            if (parentNode != null) {
                nIndex = parentNode.getIndex((TreeNode)treeNode);
            }
            if (nIndex > 0) {
                KDTreeNode brotherNode = (KDTreeNode)parentNode.getChildAt(nIndex - 1);
                ProcCatalogInfo brotherInfo = (ProcCatalogInfo)brotherNode.getUserObject();
                brotherInfo.setOrderNo(brotherInfo.getOrderNo() + 1);
                ProcCatalogInfo treeInfo = (ProcCatalogInfo)treeNode.getUserObject();
                treeInfo.setOrderNo(treeInfo.getOrderNo() - 1);
                IProcCatalog tree = ProcCatalogFactory.getRemoteInstance();
                tree.moveUpProcCatalogNode(brotherInfo, treeInfo);
                this.kdtProcCatalogTree.removeNodeFromParent((MutableTreeNode)treeNode);
                this.kdtProcCatalogTree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)parentNode, nIndex - 1);
            }
            this.kdtProcCatalogTree.setSelectionNode((DefaultKingdeeTreeNode)treeNode);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"selectTreeNode"));
        }
    }

    @Override
    public void actionMoveDownNode_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveDownNode_actionPerformed(e);
        KDTreeNode treeNode = (KDTreeNode)this.kdtProcCatalogTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            ProcCatalogInfo parentTreeInfo = ((ProcCatalogInfo)treeNode.getUserObject()).getParent();
            KDTreeNode parentNode = (KDTreeNode)treeNode.getParent();
            int nIndex = 0;
            int nNum = 0;
            if (parentNode != null) {
                nIndex = parentNode.getIndex((TreeNode)treeNode);
                nNum = parentNode.getChildCount();
            }
            if (nIndex < nNum - 1) {
                KDTreeNode brotherNode = (KDTreeNode)parentNode.getChildAt(nIndex + 1);
                ProcCatalogInfo brotherInfo = (ProcCatalogInfo)brotherNode.getUserObject();
                brotherInfo.setOrderNo(brotherInfo.getOrderNo() - 1);
                ProcCatalogInfo treeInfo = (ProcCatalogInfo)treeNode.getUserObject();
                treeInfo.setOrderNo(treeInfo.getOrderNo() + 1);
                IProcCatalog tree = ProcCatalogFactory.getRemoteInstance();
                tree.moveDownProcCatalogNode(treeInfo, brotherInfo);
                this.kdtProcCatalogTree.removeNodeFromParent((MutableTreeNode)treeNode);
                this.kdtProcCatalogTree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)parentNode, nIndex + 1);
            }
            this.kdtProcCatalogTree.setSelectionNode((DefaultKingdeeTreeNode)treeNode);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"selectTreeNode"));
        }
    }

    @Override
    public void actionAddProcess_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddProcess_actionPerformed(e);
        FilterItemInfo filterItem = new FilterItemInfo("CU", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId());
        FilterItemInfo filterItem2 = new FilterItemInfo("isDefault", (Object)"0");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(filterItem);
        filterInfo.getFilterItems().add(filterItem2);
        filterInfo.setMaskString(" #0 AND #1 ");
        IProcCatalogSolution solution = ProcCatalogSolutionFactory.getRemoteInstance();
        if (solution.exists(filterInfo)) {
            this.bChangeProcCatalog = false;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.cp.eip.pc.client.ConfigurationItemUI", (Map)uiContext);
            uiWindow.show();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"notCreateCatalog"));
        }
    }

    public void addProcess() throws Exception {
        FilterItemInfo filterItem = new FilterItemInfo("CU", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId());
        FilterItemInfo filterItem2 = new FilterItemInfo("isDefault", (Object)"0");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(filterItem);
        filterInfo.getFilterItems().add(filterItem2);
        filterInfo.setMaskString(" #0 AND #1 ");
        IProcCatalogSolution solution = ProcCatalogSolutionFactory.getRemoteInstance();
        if (solution.exists(filterInfo)) {
            this.bChangeProcCatalog = false;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.cp.eip.pc.client.ConfigurationItemUI", (Map)uiContext);
            uiWindow.show();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"notCreateCatalog"));
        }
    }

    @Override
    public void actionImportSetting_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportSetting_actionPerformed(e);
        int nResponse = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"ifImportSetting"));
        if (nResponse == 2) {
            return;
        }
        this.importSetting();
    }

    private void importSetting() throws Exception {
        int nResponse;
        IProcCatalogFacade procCatalogFacade = ProcCatalogFacadeFactory.getRemoteInstance();
        procCatalogFacade.importSetting(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.kdtProcCatalogTree.setModel(null);
        this.initTreeData();
        this.bChangeProcCatalog = true;
        if (this.bChangeProcCatalog && (nResponse = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"ifAddProcess"))) == 0) {
            this.addProcess();
        }
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.actionExitCurrent_actionPerformed(e);
    }

    protected void kdtNodeName_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            this.changeNodeName();
        }
    }
}

