/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.pc.IProcCatalog;
import com.kingdee.eas.cp.eip.pc.ProcCatalogException;
import com.kingdee.eas.cp.eip.pc.ProcCatalogFactory;
import com.kingdee.eas.cp.eip.pc.ProcCatalogInfo;
import com.kingdee.eas.cp.eip.pc.client.AbstractProcConditionSearchUI;
import com.kingdee.eas.cp.eip.pc.client.SelectorForPersonF7;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProcConditionSearchUI
extends AbstractProcConditionSearchUI {
    private static final Logger logger = Logger.getLogger((String)ProcConditionSearchUI.class.getName());
    private static Map cacheMap;

    public void setCacheMap() {
        cacheMap = new HashMap();
        if (this.kdcbProcCatalog.getSelectedItem() != null) {
            cacheMap.put(ProcConditionSearchParam.procCatalog, this.kdcbProcCatalog.getSelectedItem());
        }
        if (this.kdcbProcState.getSelectedItem() != null) {
            cacheMap.put(ProcConditionSearchParam.procState, this.kdcbProcState.getSelectedItem());
        }
        if (this.kddpStartDate.getValue() != null) {
            cacheMap.put(ProcConditionSearchParam.startDate, this.kddpStartDate.getValue());
        }
        if (this.kdbpProposer.getValue() != null) {
            cacheMap.put(ProcConditionSearchParam.proposer, this.kdbpProposer.getValue());
        }
        if (this.kddpEndDate.getValue() != null) {
            cacheMap.put(ProcConditionSearchParam.endDate, this.kddpEndDate.getValue());
        }
        if (this.kdbpHandler.getValue() != null) {
            cacheMap.put(ProcConditionSearchParam.handler, this.kdbpHandler.getValue());
        }
        if (this.kdcbIncludeHistory.isSelected()) {
            cacheMap.put(ProcConditionSearchParam.includeHistory, this.kdcbIncludeHistory.isSelected());
        }
        if (this.kdcbIfOver.isSelected()) {
            cacheMap.put(ProcConditionSearchParam.ifOver, this.kdcbIfOver.isSelected());
        }
    }

    public void initData() throws Exception {
        IProcCatalog procCatalog = ProcCatalogFactory.getRemoteInstance();
        ProcCatalogInfo procInfo2 = procCatalog.getRootNodeByCU();
        TreeBaseCollection collection = procCatalog.getAllChildren(procInfo2);
        this.kdcbProcCatalog.removeAllItems();
        this.kdcbProcCatalog.addItem(null);
        for (ProcCatalogInfo procInfo2 : collection) {
            if (!procInfo2.isIsLeaf()) continue;
            this.kdcbProcCatalog.addItem((Object)procInfo2);
        }
        this.kdcbProcState.removeAllItems();
        this.kdcbProcState.addItem(null);
        Iterator i = WfState.iterator();
        while (i.hasNext()) {
            this.kdcbProcState.addItem(i.next());
        }
        if (cacheMap != null && cacheMap.size() > 0) {
            if (cacheMap.get(ProcConditionSearchParam.procCatalog) != null) {
                this.kdcbProcCatalog.setSelectedItem(cacheMap.get(ProcConditionSearchParam.procCatalog));
            }
            if (cacheMap.get(ProcConditionSearchParam.procState) != null) {
                this.kdcbProcState.setSelectedItem(cacheMap.get(ProcConditionSearchParam.procState));
            }
            if (cacheMap.get(ProcConditionSearchParam.proposer) != null) {
                this.kdbpProposer.setValue(cacheMap.get(ProcConditionSearchParam.proposer));
            }
            if (cacheMap.get(ProcConditionSearchParam.startDate) != null) {
                this.kddpStartDate.setValue(cacheMap.get(ProcConditionSearchParam.startDate));
            }
            if (cacheMap.get(ProcConditionSearchParam.endDate) != null) {
                this.kddpEndDate.setValue(cacheMap.get(ProcConditionSearchParam.endDate));
            }
            if (cacheMap.get(ProcConditionSearchParam.handler) != null) {
                this.kdbpHandler.setValue(cacheMap.get(ProcConditionSearchParam.handler));
            }
            if (cacheMap.get(ProcConditionSearchParam.includeHistory) != null) {
                this.kdcbIncludeHistory.setSelected(((Boolean)cacheMap.get(ProcConditionSearchParam.includeHistory)).booleanValue());
            }
            if (cacheMap.get(ProcConditionSearchParam.ifOver) != null) {
                this.kdcbIfOver.setSelected(((Boolean)cacheMap.get(ProcConditionSearchParam.ifOver)).booleanValue());
            }
            return;
        }
        this.kdbpProposer.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        String endTime = DateTimeUtils.defaultDateString((java.util.Date)new Timestamp(System.currentTimeMillis())).substring(0, 10);
        this.kddpEndDate.setValue((Object)Date.valueOf(endTime));
        this.kddpStartDate.setValue((Object)DateTimeUtils.addMonth((java.util.Date)Date.valueOf(endTime), (int)-1));
    }

    public ProcConditionSearchUI() throws Exception {
        this.kdbpProposer.setQueryInfo("com.kingdee.eas.basedata.person.app.UnderlingUserByPersonQuery");
        this.kdbpProposer.setDisplayFormat("$name$");
        this.kdbpProposer.setEnabled(true);
        this.kdbpProposer.setCommitFormat("$id$");
        this.kdbpProposer.setEditFormat("$id$");
        this.kdbpProposer.setEntityViewInfo(this.getEntityViewInfo());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("All_Admins", "YES");
        SelectorForPersonF7 select = new SelectorForPersonF7((IUIObject)this, map);
        this.kdbpHandler.setSelector((KDPromptSelector)select);
        this.initData();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private EntityViewInfo getEntityViewInfo() throws EASBizException, BOSException {
        String personId = null;
        PersonInfo info = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        if (info == null) {
            return null;
        }
        personId = info.getId().toString();
        IPerson iPerson = PersonFactory.getRemoteInstance();
        iPerson = PersonFactory.getRemoteInstance();
        PositionInfo positionInfo = iPerson.getPrimaryPosition(BOSUuid.read((String)personId));
        if (positionInfo == null) {
            return null;
        }
        HierarchyInfo hierInfo = HierarchyFactory.getRemoteInstance().getDefaultHierarchy();
        if (hierInfo == null) {
            return null;
        }
        IPositionHierarchy iPH = PositionHierarchyFactory.getRemoteInstance();
        String oql = "where child='" + positionInfo.getId() + "' and hierarchy='" + hierInfo.getId() + "'";
        PositionHierarchyCollection phColl = iPH.getPositionHierarchyCollection(oql);
        PositionHierarchyInfo phInfo = null;
        if (phColl == null || phColl.size() <= 0) {
            return null;
        }
        phInfo = phColl.get(0);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("PH.longNumber", (Object)phInfo.getLongNumber()));
        filter.getFilterItems().add(new FilterItemInfo("PH.longNumber", (Object)(phInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString()));
        filter.setMaskString("#0 and (#1 or #2) and #3");
        evi.setFilter(filter);
        return evi;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        this.kdbpHandler.setValue(null);
        this.kdbpProposer.setValue(null);
        this.kdcbIfOver.setSelected(false);
        this.kdcbIncludeHistory.setSelected(false);
        if (this.kdcbProcCatalog.getItemCount() > 0) {
            this.kdcbProcCatalog.setSelectedIndex(0);
        }
        if (this.kdcbProcState.getItemCount() > 0) {
            this.kdcbProcState.setSelectedIndex(this.kdcbProcState.getItemCount() - 1);
        }
        this.kddpStartDate.setValue(null);
        this.kddpEndDate.setValue(null);
    }

    public void setParam(Object param) {
        Map result = (Map)param;
        int nSize = 0;
        this.kdbpProposer.setValue(result.get(ProcConditionSearchParam.proposer));
        this.kddpStartDate.setValue(result.get(ProcConditionSearchParam.startDate));
        this.kddpEndDate.setValue(result.get(ProcConditionSearchParam.endDate));
        this.kdbpHandler.setValue(result.get(ProcConditionSearchParam.handler));
        this.kdcbProcState.setSelectedIndex(0);
        WfState procState = (WfState)result.get(ProcConditionSearchParam.procState);
        if (procState != null) {
            nSize = this.kdcbProcState.getItemCount();
            for (int i = 0; i < nSize; ++i) {
                WfState info = (WfState)this.kdcbProcState.getItemAt(i);
                if (info == null || info.getName() == null || !info.getName().equals(procState.getName())) continue;
                this.kdcbProcState.setSelectedIndex(i);
                break;
            }
        }
        this.kdcbProcCatalog.setSelectedIndex(0);
        ProcCatalogInfo procCatalog = (ProcCatalogInfo)result.get(ProcConditionSearchParam.procCatalog);
        if (procCatalog != null) {
            nSize = this.kdcbProcCatalog.getItemCount();
            for (int i = 0; i < nSize; ++i) {
                ProcCatalogInfo info = (ProcCatalogInfo)this.kdcbProcCatalog.getItemAt(i);
                if (info == null || info.getId() == null || !info.getId().equals((Object)procCatalog.getId())) continue;
                this.kdcbProcCatalog.setSelectedIndex(i);
                break;
            }
        }
        this.kdcbIfOver.setSelected(((Boolean)result.get(ProcConditionSearchParam.ifOver)).booleanValue());
        this.kdcbIncludeHistory.setSelected(((Boolean)result.get(ProcConditionSearchParam.includeHistory)).booleanValue());
    }

    public Object getParam() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object object = null;
        object = this.kdbpHandler.getValue();
        result.put(ProcConditionSearchParam.handler, object);
        object = this.kdbpProposer.getValue();
        result.put(ProcConditionSearchParam.proposer, object);
        result.put(ProcConditionSearchParam.ifOver, this.kdcbIfOver.isSelected());
        result.put(ProcConditionSearchParam.includeHistory, this.kdcbIncludeHistory.isSelected());
        result.put(ProcConditionSearchParam.procCatalog, this.kdcbProcCatalog.getSelectedItem());
        result.put(ProcConditionSearchParam.procState, this.kdcbProcState.getSelectedItem());
        result.put(ProcConditionSearchParam.startDate, this.kddpStartDate.getValue());
        result.put(ProcConditionSearchParam.endDate, this.kddpEndDate.getValue());
        return result;
    }

    public boolean verify() {
        try {
            this.checkError();
            return true;
        }
        catch (ProcCatalogException ite) {
            MsgBox.showInfo((String)ite.getMessage());
            return false;
        }
    }

    public String getQuerySql() {
        boolean bFlag;
        String datetime;
        SimpleDateFormat format;
        StringBuffer strSql = new StringBuffer();
        Object objectTemp = null;
        objectTemp = this.kdbpProposer.getValue();
        if (objectTemp != null && objectTemp instanceof UserInfo) {
            strSql.append(" and b.FINITIATORID").append(" = ~!~").append(((UserInfo)objectTemp).getId()).append("~!~");
        }
        if ((objectTemp = this.kdbpHandler.getValue()) != null && objectTemp instanceof UserInfo) {
            strSql.append(" and a.FPERSONEMPID").append(" = ~!~").append(((UserInfo)objectTemp).getPerson().getId().toString()).append("~!~");
        }
        if ((objectTemp = this.kddpStartDate.getValue()) != null && objectTemp instanceof java.util.Date) {
            format = new SimpleDateFormat("yyyy-MM-dd");
            datetime = format.format(objectTemp);
            strSql.append(" and b.FCREATEDTIME>={").append(datetime).append(" 00:00:00.0").append("}");
        }
        if ((objectTemp = this.kddpEndDate.getValue()) != null && objectTemp instanceof java.util.Date) {
            format = new SimpleDateFormat("yyyy-MM-dd");
            datetime = format.format(objectTemp);
            strSql.append(" and b.FCREATEDTIME<={").append(datetime).append(" 23:59:59.9").append("}");
        }
        if ((objectTemp = this.kdcbProcState.getSelectedItem()) != null && objectTemp instanceof WfState) {
            strSql.append(" and b.FSTATE").append(" = ~!~").append(((WfState)objectTemp).getValue()).append("~!~");
        }
        if (bFlag = this.kdcbIncludeHistory.isSelected()) {
            strSql.append(" ~!~").append("ifInclude").append("~!~ ");
        }
        if (bFlag = this.kdcbIfOver.isSelected()) {
            strSql.append(" ~!~").append("ifOver").append("~!~ ");
        }
        if ((objectTemp = this.kdcbProcCatalog.getSelectedItem()) != null && objectTemp instanceof ProcCatalogInfo) {
            strSql.append(" and c.FLongNumber").append(" like ~!~").append(((ProcCatalogInfo)objectTemp).getLongNumber()).append("%~!~");
        } else {
            try {
                IProcCatalog procCatalog = ProcCatalogFactory.getRemoteInstance();
                ProcCatalogInfo procInfo = procCatalog.getRootNodeByCU();
                strSql.append(" and c.FLongNumber").append(" like ~!~").append(procInfo.getLongNumber()).append("%~!~");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.info((Object)("strSql:" + strSql));
        return strSql.toString();
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer("");
        FilterItemCollection fic = this.filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)this.getQuerySql()));
        return this.filterInfo;
    }

    private void checkError() throws ProcCatalogException {
        if (this.kddpStartDate.getValue() == null) {
            this.kddpStartDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.BEGINTIME_NOTNULL);
        }
        if (this.kddpEndDate.getValue() == null) {
            this.kddpEndDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.END_TIME_NOTNULL);
        }
        Date dtFrom = this.kddpStartDate.getSqlDate();
        Date dtTo = this.kddpEndDate.getSqlDate();
        if (((java.util.Date)dtFrom).toString().compareTo(((java.util.Date)dtTo).toString()) > 0) {
            this.kddpEndDate.setValue(null);
            this.kddpEndDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.STARTTIME_MUST_BIGGER_THAN_ENDTIME);
        }
    }

    public static class ProcConditionSearchParam
    implements Serializable {
        public static String proposer = "proposer";
        public static String startDate = "startDate";
        public static String endDate = "endDate";
        public static String handler = "handler";
        public static String procState = "procState";
        public static String procCatalog = "procCatalog";
        public static String ifOver = "ifOver";
        public static String includeHistory = "includeHistory";
    }
}

