/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.pc.IProcCatalog;
import com.kingdee.eas.cp.eip.pc.ProcCatalogException;
import com.kingdee.eas.cp.eip.pc.ProcCatalogFactory;
import com.kingdee.eas.cp.eip.pc.ProcCatalogInfo;
import com.kingdee.eas.cp.eip.pc.ProcCatalogNode;
import com.kingdee.eas.cp.eip.pc.client.AbstractProcessFindUI;
import com.kingdee.eas.cp.eip.pc.client.ProcessChooseTreeF7;
import com.kingdee.eas.cp.eip.pc.client.ProcessChooseTreeList;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ProcessFindUI
extends AbstractProcessFindUI {
    private static final Logger logger = Logger.getLogger((String)ProcessFindUI.class.getName());
    private static Map cacheMap;

    public void setCacheMap() {
        cacheMap = new HashMap();
        if (this.kdcbProcState.getSelectedItem() != null) {
            cacheMap.put(ProcConditionSearchParam.procState, this.kdcbProcState.getSelectedItem());
        }
        if (this.kddpStartDate.getValue() != null) {
            cacheMap.put(ProcConditionSearchParam.startDate, this.kddpStartDate.getValue());
        }
        if (this.kdbpProposer.getValue() != null) {
            cacheMap.put(ProcConditionSearchParam.proposer, this.kdbpProposer.getValue());
        }
        if (this.kddpEndDate.getValue() != null) {
            cacheMap.put(ProcConditionSearchParam.endDate, this.kddpEndDate.getValue());
        }
        if (this.kdcbIncludeHistory.isSelected()) {
            cacheMap.put(ProcConditionSearchParam.includeHistory, this.kdcbIncludeHistory.isSelected());
        }
    }

    public void initData() throws Exception {
        this.kdcbProcState.removeAllItems();
        this.kdcbProcState.addItem(null);
        Iterator i = WfState.iterator();
        while (i.hasNext()) {
            this.kdcbProcState.addItem(i.next());
        }
        String allSel = EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.processresource", (String)"allSelect");
        this.kdcbProcState.addItem((Object)allSel);
        if (cacheMap != null && cacheMap.size() > 0) {
            if (cacheMap.get(ProcConditionSearchParam.proposer) != null) {
                this.kdbpProposer.setValue(cacheMap.get(ProcConditionSearchParam.proposer));
            }
            if (cacheMap.get(ProcConditionSearchParam.startDate) != null) {
                this.kddpStartDate.setValue(cacheMap.get(ProcConditionSearchParam.startDate));
            }
            if (cacheMap.get(ProcConditionSearchParam.endDate) != null) {
                this.kddpEndDate.setValue(cacheMap.get(ProcConditionSearchParam.endDate));
            }
            if (cacheMap.get(ProcConditionSearchParam.includeHistory) != null) {
                this.kdcbIncludeHistory.setSelected(((Boolean)cacheMap.get(ProcConditionSearchParam.includeHistory)).booleanValue());
            }
            if (cacheMap.get(ProcConditionSearchParam.procCatalog) != null) {
                this.kdbpProcessCatalog.setValue(cacheMap.get(ProcConditionSearchParam.procCatalog));
            }
            return;
        }
        this.kdcbProcState.removeAllItems();
        this.kdcbProcState.addItem(null);
        Iterator i2 = WfState.iterator();
        while (i2.hasNext()) {
            this.kdcbProcState.addItem(i2.next());
        }
        this.kdcbProcState.addItem((Object)allSel);
        this.kdbpProposer.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        String endTime = DateTimeUtils.defaultDateString((java.util.Date)new Timestamp(System.currentTimeMillis())).substring(0, 10);
        this.kddpEndDate.setValue((Object)Date.valueOf(endTime));
        this.kddpStartDate.setValue((Object)DateTimeUtils.addMonth((java.util.Date)Date.valueOf(endTime), (int)-1));
    }

    public ProcessFindUI() throws Exception {
        ProcessChooseTreeF7 processChooseTreeF7 = new ProcessChooseTreeF7((IUIObject)this, false, false);
        this.kdbpProcessCatalog.setSelector((KDPromptSelector)processChooseTreeF7);
        this.kdbpProposer.setQueryInfo("com.kingdee.eas.basedata.person.app.UnderlingUserByPersonQuery");
        this.kdbpProposer.setDisplayFormat("$name$");
        this.kdbpProposer.setEnabled(true);
        this.kdbpProposer.setCommitFormat("$id$");
        this.kdbpProposer.setEditFormat("$number$");
        this.kdbpProposer.setEntityViewInfo(this.getEntityViewInfo());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("All_Admins", "YES");
        this.initData();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private EntityViewInfo getEntityViewInfo() throws EASBizException, BOSException {
        String personId = null;
        PersonInfo info = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        if (info == null) {
            return null;
        }
        personId = info.getId().toString();
        IPerson iPerson = PersonFactory.getRemoteInstance();
        iPerson = PersonFactory.getRemoteInstance();
        PositionInfo positionInfo = iPerson.getPrimaryPosition(BOSUuid.read((String)personId));
        if (positionInfo == null) {
            return null;
        }
        HierarchyInfo hierInfo = HierarchyFactory.getRemoteInstance().getDefaultHierarchy();
        if (hierInfo == null) {
            return null;
        }
        IPositionHierarchy iPH = PositionHierarchyFactory.getRemoteInstance();
        String oql = "where child='" + positionInfo.getId() + "' and hierarchy='" + hierInfo.getId() + "'";
        PositionHierarchyCollection phColl = iPH.getPositionHierarchyCollection(oql);
        PositionHierarchyInfo phInfo = null;
        if (phColl == null || phColl.size() <= 0) {
            return null;
        }
        phInfo = phColl.get(0);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("PH.longNumber", (Object)phInfo.getLongNumber()));
        filter.getFilterItems().add(new FilterItemInfo("PH.longNumber", (Object)(phInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString()));
        filter.setMaskString("#0 and (#1 or #2) and #3");
        evi.setFilter(filter);
        return evi;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        this.kdbpProposer.setValue(null);
        this.kdcbIncludeHistory.setSelected(false);
        if (this.kdbpProcessCatalog.getValue() != null) {
            this.kdbpProcessCatalog.setValue(null);
        }
        if (this.kdcbProcState.getItemCount() > 0) {
            this.kdcbProcState.setSelectedIndex(this.kdcbProcState.getItemCount() - 1);
        }
        this.kddpStartDate.setValue(null);
        this.kddpEndDate.setValue(null);
        this.txtSubject.setText(null);
    }

    public void setParam(Object param) {
        Map result = (Map)param;
        int nSize = 0;
        this.kdbpProposer.setValue(result.get(ProcConditionSearchParam.proposer));
        this.kddpStartDate.setValue(result.get(ProcConditionSearchParam.startDate));
        this.kddpEndDate.setValue(result.get(ProcConditionSearchParam.endDate));
        this.kdcbProcState.setSelectedIndex(0);
        WfState procState = (WfState)result.get(ProcConditionSearchParam.procState);
        if (procState != null) {
            nSize = this.kdcbProcState.getItemCount();
            for (int i = 0; i < nSize; ++i) {
                if (this.kdcbProcState.getItemAt(i) instanceof WfState) {
                    WfState info = (WfState)this.kdcbProcState.getItemAt(i);
                    if (info == null || info.getName() == null || !info.getName().equals(procState.getName())) continue;
                    this.kdcbProcState.setSelectedIndex(i);
                    break;
                }
                this.kdcbProcState.setSelectedIndex(i);
            }
        }
        ProcessChooseTreeList procChooseList = (ProcessChooseTreeList)result.get(ProcConditionSearchParam.procCatalog);
        this.kdbpProcessCatalog.setValue((Object)procChooseList);
        this.txtSubject.setText((String)result.get(ProcConditionSearchParam.subject));
        this.kdcbIncludeHistory.setSelected(((Boolean)result.get(ProcConditionSearchParam.includeHistory)).booleanValue());
    }

    public Object getParam() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object object = null;
        object = this.kdbpProposer.getValue();
        result.put(ProcConditionSearchParam.proposer, object);
        result.put(ProcConditionSearchParam.includeHistory, this.kdcbIncludeHistory.isSelected());
        result.put(ProcConditionSearchParam.procCatalog, this.kdbpProcessCatalog.getValue());
        result.put(ProcConditionSearchParam.procState, this.kdcbProcState.getSelectedItem());
        result.put(ProcConditionSearchParam.startDate, this.kddpStartDate.getValue());
        result.put(ProcConditionSearchParam.endDate, this.kddpEndDate.getValue());
        result.put(ProcConditionSearchParam.subject, this.txtSubject.getText());
        return result;
    }

    public boolean verify() {
        try {
            this.checkError();
            return true;
        }
        catch (ProcCatalogException ite) {
            MsgBox.showInfo((String)ite.getMessage());
            return false;
        }
    }

    public String getQuerySql() {
        boolean bFlag;
        String datetime;
        SimpleDateFormat format;
        StringBuffer strSql = new StringBuffer();
        Object objectTemp = null;
        objectTemp = this.kdbpProposer.getValue();
        if (objectTemp != null && objectTemp instanceof UserInfo) {
            strSql.append(" and b.FINITIATORID").append(" = ~!~").append(((UserInfo)objectTemp).getId()).append("~!~");
        }
        if ((objectTemp = this.kddpStartDate.getValue()) != null && objectTemp instanceof java.util.Date) {
            format = new SimpleDateFormat("yyyy-MM-dd");
            datetime = format.format(objectTemp);
            strSql.append(" and datediff(day,b.FCREATEDTIME,TO_DATE('" + datetime + "') )<=0 ");
        }
        if ((objectTemp = this.kddpEndDate.getValue()) != null && objectTemp instanceof java.util.Date) {
            format = new SimpleDateFormat("yyyy-MM-dd");
            datetime = format.format(objectTemp);
            strSql.append(" and datediff(day,B.FCREATEDTIME,TO_DATE('" + datetime + "') )>=0 ");
        }
        if ((objectTemp = this.kdcbProcState.getSelectedItem()) != null && objectTemp instanceof WfState) {
            strSql.append(" and b.FSTATE").append(" = ~!~").append(((WfState)objectTemp).getValue()).append("~!~");
        }
        if (bFlag = this.kdcbIncludeHistory.isSelected()) {
            strSql.append(" ~!~").append("ifInclude").append("~!~ ");
        }
        if ((objectTemp = this.txtSubject.getText()) != null && objectTemp.toString().length() > 0) {
            strSql.append(" and B.FPROCINSTTOPIC_" + SysContext.getSysContext().getLocale().toString() + " like '%" + objectTemp.toString() + "%'");
        }
        if ((objectTemp = this.kdbpProcessCatalog.getValue()) != null && objectTemp instanceof ProcessChooseTreeList) {
            ProcessChooseTreeList procChooseList = (ProcessChooseTreeList)objectTemp;
            String[] longnumber = procChooseList.getCatalogLongnumberList();
            if (longnumber.length > 0) {
                strSql.append(" and c.FLongNumber").append(" like ~!~").append(longnumber[0]).append("%~!~");
            }
        } else {
            try {
                IProcCatalog procCatalog = ProcCatalogFactory.getRemoteInstance();
                ProcCatalogInfo procInfo = procCatalog.getRootNodeByCU();
                strSql.append(" and c.FLongNumber").append(" like ~!~").append(procInfo.getLongNumber()).append("%~!~");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.info((Object)("strSql:" + strSql));
        return strSql.toString();
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer("");
        FilterItemCollection fic = this.filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)this.getQuerySql()));
        return this.filterInfo;
    }

    private void checkError() throws ProcCatalogException {
        if (this.kddpStartDate.getValue() == null) {
            this.kddpStartDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.BEGINTIME_NOTNULL);
        }
        if (this.kddpEndDate.getValue() == null) {
            this.kddpEndDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.END_TIME_NOTNULL);
        }
        Date dtFrom = this.kddpStartDate.getSqlDate();
        Date dtTo = this.kddpEndDate.getSqlDate();
        if (((java.util.Date)dtFrom).toString().compareTo(((java.util.Date)dtTo).toString()) > 0) {
            this.kddpEndDate.setValue(null);
            this.kddpEndDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.STARTTIME_MUST_BIGGER_THAN_ENDTIME);
        }
        String subject = this.txtSubject.getText();
        if (subject != null && subject.trim().length() > 0 && this.isLegal(subject)) {
            this.txtSubject.requestFocus();
            this.txtSubject.setText("");
            throw new ProcCatalogException(ProcCatalogException.SUBJECT_INPUT_ERROR);
        }
    }

    private boolean isLegal(String str) {
        String regor = "^.*[|~|`|\\||{|}|\\[|\\]|\uff5e|\uff40|\uff01|\u00b7|\uff03|\uffe5\uff5c\uff05|\u2026\u2026,|\u2014|\uff0a|\uff0c|\u3002|\uff1f||!|/|@|#|$|%|^|&|*|<|>|?|'|\\\\|].*$";
        Pattern p = Pattern.compile(regor);
        Matcher m = p.matcher(str);
        boolean result = m.find();
        return result;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object object = null;
        object = this.kdbpProposer.getValue();
        if (object != null && ((UserInfo)object).getId() != null) {
            cp.addCustomerParam(ProcConditionSearchParam.proposer, ((UserInfo)object).getId().toString());
        }
        cp.putBoolean(ProcConditionSearchParam.includeHistory, this.kdcbIncludeHistory.isSelected());
        object = this.kdbpProcessCatalog.getValue();
        if (object != null && ((ProcessChooseTreeList)object).getCatalogIdList() != null) {
            cp.addCustomerParam(ProcConditionSearchParam.procCatalog, ((ProcessChooseTreeList)object).getCatalogIdList());
            cp.addCustomerParam(ProcConditionSearchParam.procCatalogName, ((ProcessChooseTreeList)object).toString());
        }
        if ((object = this.kdcbProcState.getSelectedItem()) != null && object instanceof WfState && ((WfState)object).getValue() != null) {
            cp.addCustomerParam(ProcConditionSearchParam.procState, ((WfState)object).getValue());
        }
        if ((object = this.kddpStartDate.getValue()) != null) {
            cp.putDate(ProcConditionSearchParam.startDate, (java.util.Date)object);
        }
        if ((object = this.kddpEndDate.getValue()) != null) {
            cp.putDate(ProcConditionSearchParam.endDate, (java.util.Date)object);
        }
        cp.addCustomerParam(ProcConditionSearchParam.subject, this.txtSubject.getText());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        WfState procState;
        if (cp == null) {
            return;
        }
        String object = null;
        int nSize = 0;
        String id = cp.getCustomerParam(ProcConditionSearchParam.proposer);
        IObjectValue value = null;
        try {
            if (id != null) {
                value = DynamicObjectFactory.getRemoteInstance().getValue(BOSUuid.read((String)id).getType(), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
            this.kdbpProposer.setValue(value);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.kddpStartDate.setValue((Object)cp.getDate(ProcConditionSearchParam.startDate));
        this.kddpEndDate.setValue((Object)cp.getDate(ProcConditionSearchParam.endDate));
        this.kdcbProcState.setSelectedIndex(this.kdcbProcState.getItemCount() - 1);
        object = cp.getCustomerParam(ProcConditionSearchParam.procState);
        if (object != null && (procState = WfState.getEnum((String)object)) != null) {
            nSize = this.kdcbProcState.getItemCount();
            for (int i = 0; i < nSize; ++i) {
                WfState info = (WfState)this.kdcbProcState.getItemAt(i);
                if (info == null || info.getName() == null || !info.getName().equals(procState.getName())) continue;
                this.kdcbProcState.setSelectedIndex(i);
                break;
            }
        }
        this.kdbpProcessCatalog.setValue(this.getProcessCatalogList(cp));
        this.txtSubject.setText(cp.getCustomerParam(ProcConditionSearchParam.subject));
        this.kdcbIncludeHistory.setSelected(cp.getBoolean(ProcConditionSearchParam.includeHistory));
    }

    private Object getProcessCatalogList(CustomerParams cp) {
        ProcessChooseTreeList treeList = new ProcessChooseTreeList();
        ProcCatalogNode node = null;
        String str = cp.getCustomerParam(ProcConditionSearchParam.procCatalog);
        if (str == null || "".equals(str)) {
            return null;
        }
        String[] idLists = str.split(",");
        String str1 = cp.getCustomerParam(ProcConditionSearchParam.procCatalogName);
        if (str1 == null || "".equals(str1)) {
            return null;
        }
        String[] nameLists = str1.split(",");
        for (int i = 0; i < idLists.length; ++i) {
            node = new ProcCatalogNode();
            node.setId(idLists[i]);
            if (i < nameLists.length) {
                node.setName(nameLists[i]);
            }
            treeList.add(node);
        }
        return treeList;
    }

    public static void main(String[] args) {
        String regor = "^.*[|~|`|\\||{|}|\\[|\\]|\uff5e|\uff40|\uff01|\u00b7|\uff03|\uffe5\uff5c\uff05|\u2026\u2026,|\u2014|\uff0a|\uff0c|\u3002|\uff1f||!|/|@|#|$|%|^|&|*|<|>|?|'|\\\\|].*$";
        Pattern p = Pattern.compile(regor);
        Matcher m = p.matcher("wo shidl\uff01u jiawang");
        boolean result = m.find();
        System.out.print(result);
    }

    public static class ProcConditionSearchParam
    implements Serializable {
        public static String proposer = "proposer";
        public static String startDate = "startDate";
        public static String endDate = "endDate";
        public static String procState = "procState";
        public static String procCatalog = "procCatalog";
        public static String procCatalogName = "procCatalogName";
        public static String subject = "subject";
        public static String includeHistory = "includeHistory";
    }
}

