/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.eip.pc.client.AbstractUpdateEMailUI;
import com.kingdee.eas.cp.eip.pc.client.UpdateMessageException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpdateEMailUI
extends AbstractUpdateEMailUI {
    private static final Logger logger = CoreUIObject.getLogger(UpdateEMailUI.class);
    private String receiver = null;
    private String title = null;
    private String content = null;
    private IPerson iPerson = null;
    private boolean cancel = true;

    public boolean isCancel() {
        return this.cancel;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        Map context = this.getUIContext();
        HashMap map = (HashMap)context.get("this.is.save.message.to.me.when.child.change.data");
        map.put("updatemessage.cancel", this.cancel);
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.cancel = false;
        this.checkError();
        this.changeParentUIContext();
        this.actionExitCurrent_actionPerformed(e);
    }

    private void checkError() throws Exception {
        if (this.receiver == null) {
            throw new UpdateMessageException(UpdateMessageException.RECEIVER_NOT_NULL);
        }
        String tit = this.txtTitle.getText();
        String con = this.kdTxtContent.getText();
        if (tit == null || tit.trim().length() < 1) {
            throw new UpdateMessageException(UpdateMessageException.EMAIL_TITLE_NOT_NULL);
        }
        if (con == null || con.trim().length() < 1) {
            throw new UpdateMessageException(UpdateMessageException.EMAIL_CONTENT_NOT_NULL);
        }
        if (tit.trim().length() > 255) {
            throw new UpdateMessageException(UpdateMessageException.TITLE_NOT_BIGGER_255);
        }
        if (con.trim().length() > 500) {
            throw new UpdateMessageException(UpdateMessageException.CONTENT_NOT_BIGGER_THAN500);
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.cancel = true;
        this.actionExitCurrent_actionPerformed(e);
    }

    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        this.cancel = false;
        this.checkError();
        this.changeParentUIContext();
        this.actionExitCurrent_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setVisible(false);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UpdateEMailUI.this.btnSave_actionPerformed(e);
                }
                catch (Exception exc) {
                    UpdateEMailUI.this.handUIException(exc);
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UpdateEMailUI.this.btnCancel_actionPerformed(e);
                }
                catch (Exception exc) {
                    UpdateEMailUI.this.handUIException(exc);
                }
            }
        });
        Map context = this.getUIContext();
        this.receiver = (String)context.get("updatemessage.receiver");
        this.title = (String)context.get("updatemessage.title");
        this.content = (String)context.get("updatemessage.content");
        if (this.receiver != null) {
            this.iPerson = PersonFactory.getRemoteInstance();
            PersonInfo person = this.iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(this.receiver));
            this.kdpmtReceiver.setData((Object)person);
        }
        this.txtTitle.setText(this.title);
        this.kdTxtContent.setText(this.content);
    }

    private void changeParentUIContext() {
        Map context = this.getUIContext();
        HashMap map = (HashMap)context.get("this.is.save.message.to.me.when.child.change.data");
        this.receiver = ((PersonInfo)this.kdpmtReceiver.getData()).getId().toString();
        this.title = this.txtTitle.getText();
        this.content = this.kdTxtContent.getText();
        map.put("updatemessage.receiver", this.receiver);
        map.put("updatemessage.title", this.title);
        map.put("updatemessage.content", this.content);
    }
}

