/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.pc.IProcCatalog;
import com.kingdee.eas.cp.eip.pc.IProcCatalogFacade;
import com.kingdee.eas.cp.eip.pc.IProcCatalogSolution;
import com.kingdee.eas.cp.eip.pc.ProcCatalogCollection;
import com.kingdee.eas.cp.eip.pc.ProcCatalogFacadeFactory;
import com.kingdee.eas.cp.eip.pc.ProcCatalogFactory;
import com.kingdee.eas.cp.eip.pc.ProcCatalogInfo;
import com.kingdee.eas.cp.eip.pc.ProcCatalogSolutionFactory;
import com.kingdee.eas.cp.eip.pc.ProcCatalogSolutionInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ProcessCenterWebUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eip.pc.web.BuildAllProcessTreeUtil");
    private static final String procCatalogResource = "com.kingdee.eas.cp.eip.pc.ProcCatalogResource";

    public static String encodeHtmlEpecialChar(String html) {
        if (html == null) {
            return "";
        }
        if (html.indexOf("\n") > 0) {
            html = html.replaceAll("\n", " ");
        }
        if (html.indexOf("\r") > 0) {
            html = html.replaceAll("\n", " ");
        }
        if (html.indexOf("&") >= 0) {
            html = html.replaceAll("&", "&amp;");
        }
        if (html.indexOf("<") >= 0) {
            html = html.replaceAll("<", "&lt;");
        }
        if (html.indexOf(">") >= 0) {
            html = html.replaceAll(">", "&gt;");
        }
        if (html.indexOf("\"") >= 0) {
            html = html.replaceAll("\"", "&quot;");
        }
        if (html.indexOf("'") >= 0) {
            html = html.replaceAll("'", "&apos;");
        }
        if (html.indexOf("\uffe0") >= 0) {
            html = html.replaceAll("\uffe0", "&cent;");
        }
        if (html.indexOf("\u00a7") >= 0) {
            html = html.replaceAll("\u00a7", "&sect;");
        }
        if (html.indexOf("\u00d7") >= 0) {
            html.replaceAll("\u00d7", "&times;");
        }
        if (html.indexOf("\u00f7") >= 0) {
            html.replaceAll("\u00f7", "&divide;");
        }
        if (html.indexOf(" ") >= 0) {
            html.replaceAll(" ", "&nbsp;");
        }
        return html;
    }

    public static List makeProcDataForProcessUserStatChart(List list, int n) {
        ArrayList returnList = new ArrayList();
        if (list.size() < 2) {
            return returnList;
        }
        Iterator iterator = list.iterator();
        iterator.next();
        while (iterator.hasNext()) {
        }
        return null;
    }

    public static void getActdefByProc(Context ctx, String procDefID, List listId, List listName, boolean isReturnId, boolean isReturnName) throws BOSException {
        if (isReturnId && listId == null) {
            listId = new ArrayList<String>();
        }
        if (isReturnName && listName == null) {
            listName = new ArrayList<String>();
        }
        IEnactmentService service = (IEnactmentService)BOSObjectFactory.createBOSObject((Context)ctx, (String)"com.kingdee.bos.workflow.service.EnactmentServiceProxy");
        logger.error((Object)("-----------------procdefid------------------:" + procDefID));
        ProcessDefInfo info = service.getProcessDefInfo(procDefID);
        if (info == null) {
            return;
        }
        ProcessDef procDef = service.getProcessDefByDefineHashValue(info.getMd5HashValue());
        ActivityCollection activityCol = procDef.getActivitys();
        int size = activityCol.size();
        for (int i = 0; i < size; ++i) {
            ActivityDef activity = activityCol.get(i);
            if (activity instanceof SubflowActivityDef) {
                SubflowActivityDef subAci = (SubflowActivityDef)activity;
                String childProcID = subAci.getSubflowId();
                ProcessCenterWebUtil.getActdefByProc(ctx, childProcID, listId, listName, isReturnId, isReturnName);
            }
            if (!(activity instanceof ManpowerActivityDef)) continue;
            if (isReturnId) {
                String actdefid = activity.getID();
                listId.add(actdefid);
            }
            if (!isReturnName) continue;
            String actdefName = ((ManpowerActivityDef)activity).getName(new Locale("L2"));
            listName.add(actdefName);
        }
    }

    public static String makeProcDataToXMLData(ArrayList list, int nCols) {
        StringBuffer buffer = new StringBuffer();
        if (list == null || list.size() == 0 || list.size() == 1) {
            buffer.append("<root>");
            buffer.append("<reccordcount>");
            buffer.append(0);
            buffer.append("</reccordcount>");
            buffer.append("<data>");
            for (int j = 0; j < nCols; ++j) {
                buffer.append("");
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~!~");
            buffer.append("</data>");
            buffer.append("</root>");
            return buffer.toString();
        }
        return ProcessCenterWebUtil.makeProcDataToXMLData(list);
    }

    public static String makeErrorProcDataToXMLData(int nCols) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<root>");
        buffer.append("<reccordcount>");
        buffer.append(-1);
        buffer.append("</reccordcount>");
        buffer.append("<data>");
        buffer.append(EASResource.getString((String)procCatalogResource, (String)"GETDATA_FORLEDGER_ERROR"));
        buffer.append("</data>");
        buffer.append("</root>");
        return buffer.toString();
    }

    public static String makeProcDataToXMLData(ArrayList list) {
        StringBuffer buffer = new StringBuffer();
        if (list == null) {
            buffer.append("<root>");
            buffer.append("<reccordcount>");
            buffer.append(0);
            buffer.append("</reccordcount>");
            buffer.append("<data>");
            buffer.append("</data>");
            buffer.append("</root>");
            return buffer.toString();
        }
        int nSize = list.size();
        int nNum = 0;
        String[] dataArray = null;
        buffer.append("<root>");
        buffer.append("<reccordcount>");
        buffer.append(list.get(0));
        buffer.append("</reccordcount>");
        buffer.append("<data>");
        String tempData = "";
        for (int i = 1; i < nSize; ++i) {
            dataArray = (String[])list.get(i);
            nNum = dataArray.length;
            for (int j = 0; j < nNum; ++j) {
                tempData = ProcessCenterWebUtil.encodeHtmlEpecialChar(dataArray[j]);
                buffer.append(tempData);
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~!~");
        }
        buffer.append("</data>");
        buffer.append("</root>");
        return buffer.toString();
    }

    public static String makeAllProcDataToXMLData(ArrayList list, int nCols) {
        StringBuffer buffer = new StringBuffer();
        int nSize = list.size();
        if (list == null || nSize == 1) {
            buffer.append("<root>");
            buffer.append("<reccordcount>");
            buffer.append(0);
            buffer.append("</reccordcount>");
            buffer.append("<data>");
            for (int j = 0; j < nCols; ++j) {
                buffer.append("");
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~!~");
            buffer.append("</data>");
            buffer.append("</root>");
            return buffer.toString();
        }
        int nNum = 0;
        String[] dataArray = null;
        buffer.append("<root>");
        buffer.append("<reccordcount>");
        buffer.append(list.get(0));
        buffer.append("</reccordcount>");
        buffer.append("<data>");
        String tempData = "";
        for (int i = 1; i < nSize; ++i) {
            dataArray = (String[])list.get(i);
            nNum = dataArray.length;
            for (int j = 0; j < nNum; ++j) {
                tempData = ProcessCenterWebUtil.encodeHtmlEpecialChar(dataArray[j]);
                buffer.append(tempData);
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            if (dataArray[5] != null && dataArray[5].length() > 0) {
                buffer.append("#FFFDDF");
            } else {
                buffer.append("");
            }
            buffer.append("~!~");
        }
        buffer.append("</data>");
        buffer.append("</root>");
        return buffer.toString();
    }

    public static boolean isProcessAdmin(Context ctx, String orgID) throws EASBizException, BOSException {
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        IObjectPK userPK = ctx.getCaller();
        ctx.getUserName();
        ObjectUuidPK orgPK = new ObjectUuidPK(orgID);
        String PC_PERMISSION = "pc_catalog_manage";
        boolean success = false;
        success = iPermisstion.hasFunctionPermission(userPK, (IObjectPK)orgPK, PC_PERMISSION);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildAllProcessTree(Context ctx, String strCtrlUnitId) throws BOSException, EASBizException {
        String strProcessTree = null;
        ProcCatalogInfo rootInfo = null;
        String strSolutionId = null;
        ProcCatalogSolutionInfo solutionInfo = null;
        try {
            IProcCatalogSolution solution = ProcCatalogSolutionFactory.getLocalInstance(ctx);
            IProcCatalog procCatalog = ProcCatalogFactory.getRemoteInstance();
            FilterItemInfo filterItem = new FilterItemInfo("CU", (Object)strCtrlUnitId);
            FilterItemInfo filterItem2 = new FilterItemInfo("isDefault", (Object)"0");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(filterItem);
            filterInfo.getFilterItems().add(filterItem2);
            filterInfo.setMaskString(" #0 AND #1 ");
            if (!solution.exists(filterInfo)) {
                IProcCatalogFacade procFacade;
                IProcCatalogFacade iProcCatalogFacade = procFacade = ProcCatalogFacadeFactory.getRemoteInstance();
                synchronized (iProcCatalogFacade) {
                    if (!solution.exists(filterInfo)) {
                        procFacade.importSetting(strCtrlUnitId);
                    }
                }
            }
            solutionInfo = (ProcCatalogSolutionInfo)solution.getValue("select * where CU='" + strCtrlUnitId + "' and isDefault = 0 ");
            strSolutionId = solutionInfo.getId().toString();
            ProcCatalogCollection rootCol = procCatalog.getProcCatalogCollection("select * where solution = '" + strSolutionId + "' and isHasProc = 1 and parent is null order by createTime");
            if (rootCol != null && rootCol.size() > 0) {
                rootInfo = rootCol.get(0);
            }
            strProcessTree = ProcessCenterWebUtil.buildProcessTree(rootInfo, procCatalog, 1);
        }
        catch (Exception e) {
            logger.info((Object)("\u83b7\u53d6\u6d41\u7a0b\u6570\u636e\u5931\u8d25:" + e.getMessage()));
            String longNumber = "";
            if (rootInfo != null) {
                longNumber = rootInfo.getLongNumber();
            }
            strProcessTree = "insFld(foldersTree,gFld(\"" + ResourceBase.getString((String)procCatalogResource, (String)"allProcess", (Locale)ctx.getLocale()) + "\",\"JavaScript:postTree(\\\"listAllProcess\\\",\\\"" + longNumber + "\\\")\"))";
        }
        return strProcessTree;
    }

    public static String buildLedgerByList(String theFixColKey, String theFixColName, List keyList, List fieldList) {
        StringBuffer ledgerString = new StringBuffer("function kdLedger()\n");
        ledgerString.append("{\n");
        ledgerString.append("var oledgerID = document.all(\"procLedgerID\");\n");
        ledgerString.append("var sTitles = \"<rows>\";\n");
        ledgerString.append("sTitles += \"<row>\";\n");
        ledgerString.append("sTitles += \"<cell>" + theFixColKey + "</cell>\";\n");
        int i = 0;
        ledgerString.append("ledgerTitles=new Array();\n");
        for (String title : keyList) {
            String titleTemp = "sTitles += \"<cell>" + title + "</cell>\";\n";
            ledgerString.append(titleTemp);
            titleTemp = "ledgerTitles[" + i + "]='" + title + "';\n";
            ledgerString.append(titleTemp);
            titleTemp = "sTitles += \"<cell>" + title + "totalTime</cell>\";\n";
            ledgerString.append(titleTemp);
            titleTemp = "sTitles += \"<cell>" + title + "countcount</cell>\";\n";
            ledgerString.append(titleTemp);
            ++i;
        }
        ledgerString.append("sTitles += \"</row>\";\n");
        ledgerString.append("sTitles += \"</rows>\";\n");
        ledgerString.append("oledgerID.setTitles(sTitles);\n");
        ledgerString.append("var sCells = \"<cells>\";\n");
        String cellsTemp = "sCells += \"<cell Width='100' Align='center' Hidden='false' Lock='false' FieldName='" + theFixColName + "'/>\";\n";
        ledgerString.append(cellsTemp);
        for (String cell : fieldList) {
            cellsTemp = "sCells += \"<cell Width='100' Align='center' Hidden='false'  Sort='false' Lock='false' FieldName='" + cell + "'/>\";\n";
            ledgerString.append(cellsTemp);
            cellsTemp = "sCells += \"<cell Width='0' Align='center' Hidden='true'  Sort='false' Lock='false' FieldName='" + cell + "totalTime'/>\";\n";
            ledgerString.append(cellsTemp);
            cellsTemp = "sCells += \"<cell Width='0' Align='center' Hidden='true'  Sort='false' Lock='false' FieldName='" + cell + "count'/>\";\n";
            ledgerString.append(cellsTemp);
        }
        ledgerString.append("sCells += \"</cells>\";\n");
        ledgerString.append("oledgerID.setColProp(sCells);\n");
        ledgerString.append("oledgerID.load();\n ");
        ledgerString.append("}\n");
        System.out.println("################################");
        System.out.println(ledgerString.toString());
        return ledgerString.toString();
    }

    private static String buildProcessTree(ProcCatalogInfo treeInfo, IProcCatalog tree, int nLevel) throws BOSException, EASBizException {
        StringBuffer strProcessTree = new StringBuffer();
        if (treeInfo == null && nLevel == 1) {
            strProcessTree.append("aux").append(nLevel).append(" = insFld(foldersTree,gFld(\"").append(EASResource.getString((String)procCatalogResource, (String)"allProcess")).append("\",\"JavaScript:postTree(\\\"listAllProcess\\\",\\\"\\\")\"))");
            return strProcessTree.toString();
        }
        ProcCatalogCollection infoCollection = (ProcCatalogCollection)tree.getChildrenByOrdered(treeInfo);
        if (infoCollection == null || infoCollection.size() == 0) {
            if (nLevel != 1) {
                strProcessTree.append("aux").append(nLevel).append(" = insFld(aux").append(nLevel - 1).append(",gFld(\"").append(treeInfo.getName()).append("\",\"JavaScript:postTree(\\\"listAllProcess\\\",\\\"").append(treeInfo.getLongNumber()).append("\\\")\"))\n");
            } else {
                strProcessTree.append("aux").append(nLevel).append(" = insFld(foldersTree,gFld(\"").append(treeInfo.getName()).append("\",\"JavaScript:postTree(\\\"listAllProcess\\\",\\\"").append(treeInfo.getLongNumber()).append("\\\")\"))\n");
            }
            return strProcessTree.toString();
        }
        if (nLevel != 1) {
            strProcessTree.append("aux").append(nLevel).append(" = insFld(aux").append(nLevel - 1).append(",gFld(\"").append(treeInfo.getName()).append("\",\"JavaScript:postTree(\\\"listAllProcess\\\",\\\"").append(treeInfo.getLongNumber()).append("\\\")\"))\n");
        } else {
            strProcessTree.append("aux").append(nLevel).append(" = insFld(foldersTree,gFld(\"").append(treeInfo.getName()).append("\",\"JavaScript:postTree(\\\"listAllProcess\\\",\\\"").append(treeInfo.getLongNumber()).append("\\\")\"))\n");
        }
        ProcCatalogInfo childInfo = null;
        Vector vector = new Vector();
        boolean nIndex = false;
        Iterator i = infoCollection.iterator();
        while (i.hasNext()) {
            childInfo = (ProcCatalogInfo)i.next();
            strProcessTree.append(ProcessCenterWebUtil.buildProcessTree(childInfo, tree, nLevel + 1));
        }
        if (vector != null) {
            vector.clear();
            vector = null;
        }
        return strProcessTree.toString();
    }

    public static void login() {
        try {
            LoginHelper.login((String)"ss", (String)"", (String)"eas", (String)"cp50", (Locale)new Locale("L2"));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public static String getErrorInfo(Context ctx) {
        return EASCommonResource.getString((String)procCatalogResource, (String)"GETDATA_FORLEDGER_ERROR", (Locale)(ctx == null ? null : ctx.getLocale()));
    }

    public static void main(String[] arg) throws Exception {
    }
}

