/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.BaseMessageException;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.util.JSONUtil;
import com.kingdee.eas.base.message.util.MessageUtils;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.receiver.BasReceiverCollection;
import com.kingdee.eas.base.receiver.BasReceiverInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.mc.web.service.WebWorkFlowService;
import com.kingdee.eas.cp.eip.pc.IProcessServiceFacade;
import com.kingdee.eas.cp.eip.pc.ProcessServiceFacadeFactory;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class SendUrgentService
extends BuffaloService {
    private static Logger logger = Logger.getLogger((String)WebWorkFlowService.class.getName());
    private IPerson iPerson = null;

    public boolean SendUrgentMsg(String assignId, String receiver, String title, String content) throws BOSException, EASBizException {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Message message = null;
        IProcessServiceFacade urgentMsg = null;
        if (assignId == null || assignId.length() <= 0) {
            throw new BOSException("\u8be5\u4efb\u52a1\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        urgentMsg = ProcessServiceFacadeFactory.getRemoteInstance();
        message = urgentMsg.createNotificationMessage(assignId);
        String webSupport = message.getStringHeader("webSupport");
        Locale locale = (Locale)request.getSession().getAttribute("org.apache.struts.action.LOCALE");
        message.setStringHeader("webSupport", webSupport);
        message.setStringHeader("receiver", receiver);
        message.setLocaleStringHeader("title", title, locale);
        message.setLocaleStringHeader("body", content, locale);
        boolean result = urgentMsg.sendUrgentMessage(message);
        return result;
    }

    public boolean SendUrgentEmail(String assignId, String receiver, String title, String content) throws BOSException, EASBizException {
        String[] urgentEMail = null;
        IProcessServiceFacade urgentMsg = null;
        if (assignId != null && assignId.length() > 0) {
            urgentMsg = ProcessServiceFacadeFactory.getRemoteInstance();
            urgentEMail = urgentMsg.getDefaultUrgentEMailContent(assignId);
        }
        boolean isAudit = Boolean.valueOf((String)urgentEMail[8]);
        urgentEMail[0] = title;
        urgentEMail[3] = content;
        if (urgentEMail[4] != null) {
            this.iPerson = PersonFactory.getRemoteInstance();
            PersonInfo person = this.iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(urgentEMail[4]));
            urgentEMail[4] = person.getId().toString();
        }
        if (isAudit) {
            urgentEMail[3] = urgentEMail[3] + urgentEMail[9];
        }
        try {
            boolean result = urgentMsg.sendUrgentEmail(urgentEMail);
            return result;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean SendEmail(String receiver, String receiver_sec, String title, String content, String emailBosID) throws BOSException, EASBizException {
        return this.checkValidData(receiver, receiver_sec, title, content, emailBosID);
    }

    private boolean checkValidData(String receiver, String receiver_sec, String title, String content, String emailBosID) throws BOSException, EASBizException {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String[] receiverPerson = receiver.split(",");
        String[] receiversecPerson = receiver_sec.split(",");
        String[] rec1 = this.getEmailBypersonId(ctx, receiverPerson);
        if (rec1[1] != null && !"".equals(rec1[1])) {
            throw new BaseMessageException(BaseMessageException.RECEIVE_ERROR, new Object[]{rec1[1]});
        }
        if (rec1[0] == null || "".equals(rec1[0])) {
            throw new BaseMessageException(BaseMessageException.RECEIVE_CANNOT);
        }
        String[] rec2 = this.getEmailBypersonId(ctx, receiversecPerson);
        if (receiver_sec != null && !"".equals(receiver_sec)) {
            if (rec2[1] != null && !"".equals(rec2[1])) {
                throw new BaseMessageException(BaseMessageException.SECRECEIVE_ERROR, new Object[]{rec2[1]});
            }
            if (rec2[0] == null || "".equals(rec2[0])) {
                throw new BaseMessageException(BaseMessageException.REC_CANNOT);
            }
        }
        String[] attachmentIDs = AttachmentManagerFactory.getServerManager((Context)ctx).getAttachmentIDsByBoID(emailBosID.toString());
        if (title != null) {
            title = title.trim();
        }
        if (content != null) {
            content = content.trim();
        }
        return MessageCenterFactory.getRemoteInstance().sendEmail(title, content, rec1[0], rec2[0], attachmentIDs);
    }

    private String[] getEmailBypersonId(Context ctx, String[] personId) {
        StringBuffer user = new StringBuffer();
        String[] result = new String[]{"", ""};
        if (personId != null && personId.length > 0) {
            int n = 0;
            int length = personId.length;
            for (int i = 0; i < length; ++i) {
                if (n != length - 1) {
                    user.append("'").append(personId[i]).append("',");
                } else {
                    user.append("'").append(personId[i]).append("' ");
                }
                ++n;
            }
            StringBuffer emailAddress = new StringBuffer();
            StringBuffer noneEmailAddressPerson = new StringBuffer();
            String sql = " FName from t_pm_user a,T_BD_Person b where a.FPERSONID=b.FID and B.FID in(";
            String appendSql = "select b.FEMAIL FEMAIL,b.";
            String local = ctx.getLocale().toString();
            if (local.equals("l1")) {
                appendSql = appendSql + "FName_L1";
            } else if (local.equals("l2")) {
                appendSql = appendSql + "FName_L2";
            } else if (local.equals("l3")) {
                appendSql = appendSql + "FName_L3";
            }
            sql = appendSql + sql + user.toString() + ")";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    String tempEmailAddress = rs.getString("FEMAIL");
                    if (tempEmailAddress != null && !tempEmailAddress.equals("")) {
                        emailAddress.append(tempEmailAddress);
                        emailAddress.append(",");
                    } else {
                        noneEmailAddressPerson.append(rs.getString("FName"));
                        noneEmailAddressPerson.append(",");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result[0] = emailAddress.toString();
            result[1] = noneEmailAddressPerson.toString();
        }
        return result;
    }

    public boolean SendMSG(String receiver, String pritoty, String title, String content, String msgBosId) throws BOSException, EASBizException {
        System.out.println("SendMSG---title: " + title);
        System.out.println("SendMSG---content: " + content);
        System.out.println("SendMSG---msgBosId: " + msgBosId);
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        msgInfo.setId(BOSUuid.read((String)msgBosId));
        msgInfo.setNreceivers(this.getNReceiver(ctx, this.convertFromEscapeCharacters(receiver)));
        int pritotyValue = Integer.parseInt(pritoty);
        msgInfo.setPriority(MsgPriority.getEnum((int)pritotyValue));
        if (title != null) {
            title = title.trim();
        }
        msgInfo.setTitle(this.convertFromEscapeCharacters(title));
        if (content != null) {
            content = content.trim();
        }
        msgInfo.setBody(this.convertFromEscapeCharacters(content));
        msgInfo.setType(MsgType.ONLINE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        IUser iUser = UserFactory.getRemoteInstance();
        UserInfo userInfo = iUser.getUserInfo(ctx.getCaller());
        msgInfo.setSender(this.convertFromEscapeCharacters(userInfo.getName()));
        IBMCMessage iBMCMessage = BMCMessageFactory.getRemoteInstance();
        iBMCMessage.addHandMsg(msgInfo, (IObjectCollection)this.getReceiver(ctx, receiver));
        return true;
    }

    private String getNReceiver(Context ctx, String receiver) throws BOSException {
        StringBuffer bf = new StringBuffer();
        if (receiver != null) {
            String[] args = receiver.split(",");
            int length = args.length;
            IPerson iPerson = PersonFactory.getRemoteInstance();
            IUser iUser = UserFactory.getRemoteInstance();
            for (int i = 0; i < length; ++i) {
                String name = "";
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)args[i]));
                try {
                    PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)pk);
                    name = personInfo.getName();
                }
                catch (Exception e) {
                    logger.debug((Object)("receiverId is probably a userId:" + e.getMessage()), (Throwable)e);
                    try {
                        UserInfo userInfo = iUser.getUserInfo((IObjectPK)pk);
                        name = userInfo.getName();
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                bf.append(name);
                bf.append(",");
            }
        }
        return bf.substring(0, bf.length() - 1);
    }

    private BasReceiverCollection getReceiver(Context ctx, String receiver) throws EASBizException, BOSException, UuidException {
        MessageUtils mu = MessageUtils.init();
        BasReceiverCollection receivers = new BasReceiverCollection();
        if (receiver != null) {
            String[] args = receiver.split(",");
            int length = args.length;
            IPerson iPerson = PersonFactory.getRemoteInstance();
            IUser iUser = UserFactory.getRemoteInstance();
            for (int i = 0; i < length; ++i) {
                BasReceiverInfo info = null;
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)args[i]));
                try {
                    PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)pk);
                    info = mu.getRptReceiverInfo((Object)personInfo);
                }
                catch (Exception e) {
                    try {
                        UserInfo userInfo = iUser.getUserInfo((IObjectPK)pk);
                        info = mu.getRptReceiverInfo((Object)userInfo);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                receivers.add(info);
            }
        }
        return receivers;
    }

    public boolean SendUrgentMobile(String assignId, String receiver, String content, String priority) throws BOSException, EASBizException {
        boolean isAudit;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String[] urgentMobile = null;
        IProcessServiceFacade urgentMsg = null;
        if (assignId != null && assignId.length() > 0) {
            urgentMsg = ProcessServiceFacadeFactory.getRemoteInstance();
            urgentMobile = urgentMsg.getDefaultUrgentMobileContent(assignId);
        }
        urgentMobile[1] = priority;
        urgentMobile[0] = content;
        if (urgentMobile[4] != null) {
            this.iPerson = PersonFactory.getRemoteInstance();
            PersonInfo person = this.iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(urgentMobile[4]));
            urgentMobile[4] = person.getId().toString();
        }
        if (isAudit = Boolean.valueOf(urgentMobile[8]).booleanValue()) {
            String decision = "";
            if (!StringUtils.isEmpty((String)assignId)) {
                try {
                    EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
                    decision = service.getMultiApproveDecision(assignId);
                }
                catch (WfException e) {
                    logger.error((Object)"getMultiApproveDecision throws WfException!", (Throwable)e);
                }
            }
            if (!this.isDisableUrgentMoileDecision()) {
                if (!StringUtils.isEmpty((String)decision)) {
                    String tips = AppMsgUtil.constructMessage((String)decision);
                    urgentMobile[0] = urgentMobile[0] + "\u76f4\u63a5\u56de\u590d\u6570\u5b57\uff1a" + tips;
                } else {
                    String tip = "\u76f4\u63a5\u56de\u590d\u6570\u5b57\uff1a1:\u540c\u610f;2:\u4e0d\u540c\u610f";
                    urgentMobile[0] = urgentMobile[0] + tip;
                }
            }
        }
        boolean result = urgentMsg.sendUrgentMobile(urgentMobile);
        return result;
    }

    private boolean isDisableUrgentMoileDecision() {
        try {
            String mode = ParamManager.getParamValue(null, null, (String)"DisableUrgentMobileApprove");
            return Boolean.valueOf(mode);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return false;
        }
    }

    public boolean sendUrgentMessageByUserPeronAssign(String userPeronAssign) {
        boolean result = false;
        userPeronAssign = userPeronAssign.substring(1);
        return result;
    }

    public String isRunning(String assignAndPerson) throws BOSException, EASBizException {
        String assignIDList = "";
        String[] temp = assignAndPerson.split(";");
        String[] temp2 = null;
        if (temp.length == 1) {
            int size = temp.length;
            for (int i = 0; i < size; ++i) {
                temp2 = temp[i].split("\uff01");
                if (temp2.length != 3) continue;
                assignIDList = temp2[0];
            }
            return assignIDList;
        }
        return "";
    }

    public String convertFromEscapeCharacters(String str) {
        System.out.println("---convertFromEscapeCharacters before: " + str);
        String regEx = "&amp;";
        Pattern p = Pattern.compile(regEx);
        Matcher m1 = p.matcher(str);
        str = m1.replaceAll("&");
        regEx = "&apos;";
        p = Pattern.compile(regEx);
        m1 = p.matcher(str);
        str = m1.replaceAll("'");
        regEx = "&lt;";
        p = Pattern.compile(regEx);
        m1 = p.matcher(str);
        str = m1.replaceAll("<");
        regEx = "&gt;";
        p = Pattern.compile(regEx);
        m1 = p.matcher(str);
        str = m1.replaceAll(">");
        regEx = "&quot;";
        p = Pattern.compile(regEx);
        m1 = p.matcher(str);
        str = m1.replaceAll("\"");
        System.out.println("---convertFromEscapeCharacters after: " + str);
        return str;
    }

    public String checkMsgContentLengthLimit(int contentLength) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        ArrayList list = new ArrayList();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("ifExceed", "false");
        resultMap.put("log", "");
        int contentLengthLimit = 500;
        contentLengthLimit = ProcessCenterUtil.getMsgContentLengthLimit((Context)ctx);
        logger.info((Object)("\u6d88\u606f\u5185\u5bb9\u6700\u5927\u5b57\u7b26\u6570=" + contentLengthLimit));
        if (contentLength > contentLengthLimit) {
            resultMap.put("ifExceed", "true");
            String log = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.eip.mc.MessageCenter", (String)"contentLengthExceedLimit", (Locale)ctx.getLocale()), contentLengthLimit);
            resultMap.put("log", log);
        }
        list.add(resultMap);
        String result = JSONUtil.getJson4List(list, null);
        logger.info((Object)result);
        return result;
    }
}

