/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.stamp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.stamp.BillUtil;
import com.kingdee.eas.cp.stamp.CommonSealFactory;
import com.kingdee.eas.cp.stamp.CommonSealInfo;
import com.kingdee.eas.cp.stamp.CommonSealPermissionFactory;
import com.kingdee.eas.cp.stamp.CommonSealPermissionInfo;
import com.kingdee.eas.cp.stamp.ICommonSealPermission;
import com.kingdee.eas.cp.stamp.IManageLog;
import com.kingdee.eas.cp.stamp.IPersonalSealPermission;
import com.kingdee.eas.cp.stamp.LogResultEnum;
import com.kingdee.eas.cp.stamp.ManageLogFactory;
import com.kingdee.eas.cp.stamp.ManageLogInfo;
import com.kingdee.eas.cp.stamp.OperationEnum;
import com.kingdee.eas.cp.stamp.PersonalSealFactory;
import com.kingdee.eas.cp.stamp.PersonalSealInfo;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionFactory;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionInfo;
import com.kingdee.eas.cp.stamp.SealTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Timestamp;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class ManageLogUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.stamp.ManageLogUtil");
    private static String RES_STAMP = "com.kingdee.eas.cp.stamp.StampResource";

    public static IObjectPK beginLog(Context ctx, int operation, CoreBaseInfo model) {
        IObjectPK logPK = null;
        String sealID = null;
        String sealName = null;
        String permissionPersonID = null;
        String permissionPersonName = null;
        String operationDetail = null;
        int logResult = 1;
        int sealType = 1;
        ManageLogInfo manageLogInfo = new ManageLogInfo();
        boolean logFlag = true;
        try {
            if (operation == 1 || operation == 5 || operation == 3 || operation == 6) {
                logResult = 1;
                if (model instanceof CommonSealInfo) {
                    CommonSealInfo info = (CommonSealInfo)model;
                    sealID = info.getId().toString();
                    sealName = info.getName();
                    if (operation == 6) {
                        operationDetail = EASResource.getString((String)RES_STAMP, (String)"seal_delete");
                    }
                } else if (model instanceof PersonalSealInfo) {
                    sealType = 2;
                    PersonalSealInfo info = (PersonalSealInfo)model;
                    sealID = info.getId().toString();
                    sealName = info.getName();
                    if (operation == 6) {
                        operationDetail = EASResource.getString((String)RES_STAMP, (String)"seal_delete");
                    }
                } else if (model instanceof CommonSealPermissionInfo) {
                    CommonSealPermissionInfo info = (CommonSealPermissionInfo)model;
                    sealID = info.getSealName().getId().toString();
                    sealName = info.getSealName() == null ? null : CommonSealFactory.getLocalInstance(ctx).getCommonSealInfo((IObjectPK)new ObjectUuidPK(sealID)).getName();
                    permissionPersonID = info.getUser().getId().toString();
                    permissionPersonName = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(permissionPersonID)).getName();
                    operationDetail = EASResource.getString((String)RES_STAMP, (String)"permission_delete");
                    Object[] desc = new String[]{BillUtil.formatDate(info.getStartDate(), "yyyy-MM-dd"), BillUtil.formatDate(info.getEndDate(), "yyyy-MM-dd")};
                    operationDetail = MessageFormat.format(operationDetail, desc);
                } else if (model instanceof PersonalSealPermissionInfo) {
                    PersonalSealPermissionInfo info = (PersonalSealPermissionInfo)model;
                    sealType = 2;
                    sealID = info.getPersonalSealName().getId().toString();
                    sealName = info.getPersonalSealName() == null ? null : PersonalSealFactory.getLocalInstance(ctx).getPersonalSealInfo((IObjectPK)new ObjectUuidPK(sealID)).getName();
                    permissionPersonID = info.getUser().getId().toString();
                    permissionPersonName = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(permissionPersonID)).getName();
                    operationDetail = EASResource.getString((String)RES_STAMP, (String)"permission_delete");
                    Object[] desc = new String[]{BillUtil.formatDate(info.getStartDate(), "yyyy-MM-dd"), BillUtil.formatDate(info.getEndDate(), "yyyy-MM-dd")};
                    operationDetail = MessageFormat.format(operationDetail, desc);
                }
            } else if (operation == 4) {
                if (model instanceof CommonSealPermissionInfo) {
                    Object[] desc;
                    sealID = ((CommonSealPermissionInfo)model).getSealName() == null ? null : ((CommonSealPermissionInfo)model).getSealName().getId().toString();
                    sealName = ((CommonSealPermissionInfo)model).getSealName() == null ? null : ((CommonSealPermissionInfo)model).getSealName().getName();
                    permissionPersonID = ((CommonSealPermissionInfo)model).getUser().getId().toString();
                    permissionPersonName = ((CommonSealPermissionInfo)model).getUser().getName();
                    ICommonSealPermission commonPermission = ManageLogUtil.getCommonPermissionBizInterface(ctx);
                    CommonSealPermissionInfo info = commonPermission.getCommonSealPermissionInfo((IObjectPK)new ObjectUuidPK(model.getId()));
                    if (!BillUtil.isSameDay(((CommonSealPermissionInfo)model).getStartDate(), info.getStartDate())) {
                        String startDetail = EASResource.getString((String)RES_STAMP, (String)"startdate_change");
                        desc = new String[]{BillUtil.formatDate(info.getStartDate(), "yyyy-MM-dd"), BillUtil.formatDate(((CommonSealPermissionInfo)model).getStartDate(), "yyyy-MM-dd")};
                        operationDetail = MessageFormat.format(startDetail, desc);
                    }
                    if (!BillUtil.isSameDay(((CommonSealPermissionInfo)model).getEndDate(), info.getEndDate())) {
                        String endDetail = EASResource.getString((String)RES_STAMP, (String)"enddate_change");
                        desc = new String[]{BillUtil.formatDate(info.getEndDate(), "yyyy-MM-dd"), BillUtil.formatDate(((CommonSealPermissionInfo)model).getEndDate(), "yyyy-MM-dd")};
                        operationDetail = operationDetail == null ? MessageFormat.format(endDetail, desc) : operationDetail + ";" + MessageFormat.format(endDetail, desc);
                    }
                } else if (model instanceof PersonalSealPermissionInfo) {
                    Object[] desc;
                    sealID = ((PersonalSealPermissionInfo)model).getPersonalSealName() == null ? null : ((PersonalSealPermissionInfo)model).getPersonalSealName().getId().toString();
                    sealName = ((PersonalSealPermissionInfo)model).getPersonalSealName() == null ? null : ((PersonalSealPermissionInfo)model).getPersonalSealName().getName();
                    permissionPersonID = ((PersonalSealPermissionInfo)model).getUser().getId().toString();
                    permissionPersonName = ((PersonalSealPermissionInfo)model).getUser().getName();
                    IPersonalSealPermission personalPermission = ManageLogUtil.getPersonalPermissionBizInterface(ctx);
                    PersonalSealPermissionInfo info = personalPermission.getPersonalSealPermissionInfo((IObjectPK)new ObjectUuidPK(model.getId()));
                    if (!BillUtil.isSameDay(((PersonalSealPermissionInfo)model).getStartDate(), info.getStartDate())) {
                        String startDetail = EASResource.getString((String)RES_STAMP, (String)"startdate_change");
                        desc = new String[]{BillUtil.formatDate(info.getStartDate(), "yyyy-MM-dd"), BillUtil.formatDate(((PersonalSealPermissionInfo)model).getStartDate(), "yyyy-MM-dd")};
                        operationDetail = MessageFormat.format(startDetail, desc);
                    }
                    if (!BillUtil.isSameDay(((PersonalSealPermissionInfo)model).getEndDate(), info.getEndDate())) {
                        String endDetail = EASResource.getString((String)RES_STAMP, (String)"enddate_change");
                        desc = new String[]{BillUtil.formatDate(info.getEndDate(), "yyyy-MM-dd"), BillUtil.formatDate(((PersonalSealPermissionInfo)model).getEndDate(), "yyyy-MM-dd")};
                        String string = operationDetail = operationDetail == null ? MessageFormat.format(endDetail, desc) : operationDetail + ";" + MessageFormat.format(endDetail, desc);
                    }
                }
                if (operationDetail == null) {
                    logFlag = false;
                }
            } else if (operation == 2) {
                if (model instanceof CommonSealPermissionInfo) {
                    CommonSealPermissionInfo info = (CommonSealPermissionInfo)model;
                    sealID = info.getSealName() == null ? null : info.getSealName().getId().toString();
                    sealName = info.getSealName() == null ? null : info.getSealName().getName();
                    permissionPersonID = info.getUser().getId().toString();
                    permissionPersonName = info.getUser().getName();
                    operationDetail = EASResource.getString((String)RES_STAMP, (String)"permission_detail");
                    Object[] desc = new String[]{BillUtil.formatDate(info.getStartDate(), "yyyy-MM-dd"), BillUtil.formatDate(info.getEndDate(), "yyyy-MM-dd")};
                    operationDetail = MessageFormat.format(operationDetail, desc);
                } else if (model instanceof PersonalSealPermissionInfo) {
                    sealType = 2;
                    PersonalSealPermissionInfo info = (PersonalSealPermissionInfo)model;
                    sealID = info.getPersonalSealName() == null ? null : info.getPersonalSealName().getId().toString();
                    sealName = info.getPersonalSealName() == null ? null : info.getPersonalSealName().getName();
                    permissionPersonID = info.getUser().getId().toString();
                    permissionPersonName = info.getUser().getName();
                    operationDetail = EASResource.getString((String)RES_STAMP, (String)"permission_detail");
                    Object[] desc = new String[]{BillUtil.formatDate(info.getStartDate(), "yyyy-MM-dd"), BillUtil.formatDate(info.getEndDate(), "yyyy-MM-dd")};
                    operationDetail = MessageFormat.format(operationDetail, desc);
                }
            } else if (operation == 8 || operation == 7) {
                if (model instanceof CommonSealInfo) {
                    CommonSealInfo info = (CommonSealInfo)model;
                    sealID = info.getId().toString();
                    sealName = info.getName();
                } else if (model instanceof PersonalSealInfo) {
                    PersonalSealInfo info = (PersonalSealInfo)model;
                    sealID = info.getId().toString();
                    sealName = info.getName();
                }
            }
            ManageLogUtil.setCommonData(ctx, manageLogInfo, operation, sealType, logResult);
            ManageLogUtil.setLogData(manageLogInfo, sealID, sealName, permissionPersonID, permissionPersonName, operationDetail);
            if (logFlag) {
                logPK = ManageLogUtil.getLogBizInterface(ctx).save(manageLogInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        return logPK;
    }

    public static void afterLog(Context ctx, IObjectPK logPK) {
        if (logPK == null) {
            return;
        }
        try {
            ManageLogUtil.getLogBizInterface(ctx).upateLogStatus(logPK);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
    }

    private static IManageLog getLogBizInterface(Context ctx) throws BOSException {
        IManageLog appLog = null;
        try {
            appLog = ctx == null ? ManageLogFactory.getRemoteInstance() : ManageLogFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        return appLog;
    }

    private static ICommonSealPermission getCommonPermissionBizInterface(Context ctx) throws BOSException {
        ICommonSealPermission commonPermission = null;
        try {
            commonPermission = ctx == null ? CommonSealPermissionFactory.getRemoteInstance() : CommonSealPermissionFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        return commonPermission;
    }

    private static IPersonalSealPermission getPersonalPermissionBizInterface(Context ctx) throws BOSException {
        IPersonalSealPermission personalPermission = null;
        try {
            personalPermission = ctx == null ? PersonalSealPermissionFactory.getRemoteInstance() : PersonalSealPermissionFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        return personalPermission;
    }

    private static void setCommonData(Context ctx, ManageLogInfo manageLogInfo, int operation, int sealType, int logResult) {
        PersonInfo currPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        manageLogInfo.setOperationPersonID(currPerson.getId().toString());
        manageLogInfo.setOperationPersonName(currPerson.getName());
        manageLogInfo.setOperation(OperationEnum.getEnum(operation));
        manageLogInfo.setSealType(SealTypeEnum.getEnum(sealType));
        manageLogInfo.setOccurTime(new Timestamp(System.currentTimeMillis()));
        manageLogInfo.setCuID(cuInfo.getId().toString());
        manageLogInfo.setIsSuccessed(LogResultEnum.getEnum(logResult));
    }

    private static void setLogData(ManageLogInfo manageLogInfo, String sealID, String sealName, String permissionPersonID, String permissionPersonName, String operationDetail) {
        manageLogInfo.setSealID(sealID);
        manageLogInfo.setSealName(sealName);
        manageLogInfo.setPermissionPersonID(permissionPersonID);
        manageLogInfo.setPermissionPersonName(permissionPersonName);
        manageLogInfo.setOperationDetail(operationDetail);
    }
}

