/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.taskmng.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.AssignatePersonsInfo;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.monitor.PostParticipantUtil;
import com.kingdee.bos.workflow.participant.ActivityPersonsInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillBusinessUtil;
import com.kingdee.eas.base.form.model.bill.IOperationRoundExtend;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.base.form.model.list.ListApplication;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.base.form.web.DynamicWebFormPanel;
import com.kingdee.eas.base.form.web.IDynamicWebFormView;
import com.kingdee.eas.base.form.web.WfState;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.taskmng.AbstractTaskInfo;
import com.kingdee.eas.cp.taskmng.ITask;
import com.kingdee.eas.cp.taskmng.TaskFactory;
import com.kingdee.eas.cp.taskmng.TaskInfo;
import com.kingdee.eas.cp.taskmng.TaskTeamInfo;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ResourceUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TmWkUtil {
    private TaskTeamInfo info;
    private IFormApplication application;
    private FormOperation fo;
    private IObjectValue objValue;
    private int checkWfBefore = -1;
    public static final String CONFIRM_DATACHANGE = "@confirm_data_change";

    public TaskTeamInfo getInfo() {
        return this.info;
    }

    public void setInfo(TaskTeamInfo info) {
        this.info = info;
    }

    public FormOperation getFo() {
        return this.fo;
    }

    public void checkRight() throws EASBizException, BOSException {
        if (this.fo == null || this.fo.getPermissionItem() == null || this.fo.getPermissionItem().trim().length() == 0) {
            return;
        }
        String mainOrgId = null;
        OrgType orgType = BusinessProcessUtil.getOrgTypeFromEntity((Context)this.application.getContext(), (BOSObjectType)BOSObjectType.create((String)this.application.getForm().getBosType()));
        if (OrgType.ControlUnit.equals((Object)orgType)) {
            OrgUnitInfo orgUnit = ((DynamicFormApplication)this.application).getMainOrgUnit();
            if (orgUnit == null || orgUnit.getCU() == null) {
                orgUnit = (OrgUnitInfo)this.application.getContext().get((Object)orgType);
            }
            mainOrgId = orgUnit.getCU().getId().toString();
        } else {
            mainOrgId = this.application.getMainOrgId();
        }
        BusinessSeviceUtil.checkFunctionPermission((Context)this.application.getContext(), (String)mainOrgId, (String)this.fo.getPermissionItem());
    }

    public void checkModelChanged() throws EASBizException, BOSException {
        if (!(this.application instanceof BillApplication)) {
            return;
        }
        BillApplication application = (BillApplication)this.application;
        application.getBillModel().checkIsChanged(false);
    }

    public boolean confirmModelChanged(ActionArgs e) throws EASBizException, BOSException {
        String msg;
        if (e.isAfterConfirmed()) {
            return false;
        }
        if (!(this.application instanceof BillApplication)) {
            return false;
        }
        BillApplication application = (BillApplication)this.application;
        if (!application.getBillModel().isChanged()) {
            return false;
        }
        ((DynamicWebFormPanel)application.getBillView()).setAfterConfirmOperArgs(e);
        boolean isSave = OperationStatus.ADDNEW.equals(application.getBillView().getOperationStatus());
        if (!isSave && !(isSave = this.isStateForOperation(application.getBillModel().getBusinessInfo().getForm().getOperation("Save"), 0))) {
            FormOperation fo = application.getBillModel().getBusinessInfo().getForm().getOperation("Submit");
            boolean bl = isSave = fo == null;
        }
        if (isSave) {
            e.setDataChgOperation("Save");
            msg = "\u6570\u636e\u5df2\u7ecf\u4fee\u6539\uff0c\u8981\u5148\u4fdd\u5b58\u5417\uff1f";
        } else {
            e.setDataChgOperation("Submit");
            msg = "\u6570\u636e\u5df2\u7ecf\u4fee\u6539\uff0c\u8981\u5148\u63d0\u4ea4\u5417\uff1f";
        }
        application.showConfirm(CONFIRM_DATACHANGE, "\u6570\u636e\u4fee\u6539", msg, 1, "callService=bill.validate();");
        return true;
    }

    public void checkWfState() throws BOSException {
        if (this.fo.getOperation().equals("Save") && this.application.getView().getWfState().isFromWorkflow()) {
            return;
        }
        int checkWfBefore = this.getCheckWfBefore();
        if (checkWfBefore == 1) {
            throw new MatchAssignmentException("BizObject aleady in process. ");
        }
        if (checkWfBefore == 4) {
            throw new MatchAssignmentException("BizObject aleady in process but operation not match.Current operation:" + this.fo.getOperation());
        }
    }

    private int getCheckWfBefore() throws BOSException {
        if (this.checkWfBefore > -1) {
            return this.checkWfBefore;
        }
        WfState wfState = this.application.getView().getWfState();
        String billid = this.getBeOperatedBillId();
        this.checkWfBefore = wfState.checkBeforeAction(this.application.getContext(), billid, this.fo.getOperation());
        return this.checkWfBefore;
    }

    public void submitWfAssigment(boolean isTriggerWf) throws BOSException, EASBizException {
        if (this.checkWfBefore == 2) {
            WfState wfState = this.application.getView().getWfState();
            if (!wfState.submitAssigment(this.application.getContext(), this.fo.getOperation())) {
                this.application.getView().showMessage("\u5de5\u4f5c\u6d41\u4efb\u52a1\u63d0\u4ea4\u5931\u8d25");
            }
        } else if (isTriggerWf) {
            String pk = null;
            String formId = this.application.getForm().getId();
            String billName = this.application.getForm().getName();
            if (StringUtils.isEmpty(pk)) {
                return;
            }
            IObjectValue objValue = this.getObjectValue(pk);
            if (objValue == null) {
                return;
            }
            String billNumber = objValue.getString("number");
            String processDefID = (String)this.getInfo().get("relatingWf");
            if (processDefID != null) {
                this.submitTheProcess(billNumber, pk, formId, billName, processDefID);
                return;
            }
            String[][] eventParams = this.application.getForm().getEventParams();
            Object[] params = new Object[eventParams.length + 6];
            params[0] = this.application.getContext();
            params[1] = this.fo.getOperation();
            params[2] = pk;
            params[3] = formId;
            params[4] = billName;
            params[5] = billNumber;
            int size = params.length;
            for (int i = 6; i < size; ++i) {
                Object value;
                String key = eventParams[i - 6][1];
                params[i] = value = this.getEventParamValue(key);
            }
            BusinessSeviceUtil.triggerWfEvent((BOSObjectType)BOSObjectType.create((String)this.application.getForm().getBosType()), (Object[])params);
        }
    }

    private IObjectValue getObjectValue(String pk) throws BOSException {
        if (this.objValue != null) {
            return this.objValue;
        }
        this.objValue = this.application.getBillValue();
        return this.objValue;
    }

    private void submitTheProcess(String billNumber, String pk, String formId, String billName, String processDefID) throws BOSException, WfException {
        String userId = this.application.getContext().getCaller().toString();
        IEnactmentService wfService = EnactmentServiceFactory.createEnactService((Context)this.application.getContext());
        String msg = this.checkNextParticipants(wfService, processDefID, userId);
        if (msg != null) {
            this.showSelectNextPerson(processDefID);
            return;
        }
        this.submitTheProcess(processDefID, billNumber, pk, formId, billName, userId, wfService, null);
    }

    public void setObjValue(IObjectValue objValue) {
        this.objValue = objValue;
    }

    private void showSelectNextPerson(String processDefID) {
        DynamicFormApplication application = (DynamicFormApplication)this.application;
        String pageId = ((IDynamicWebFormView)application.getDynamicFormView()).getPageId();
        StringBuffer sb = new StringBuffer();
        sb.append(" var url = '").append("/easweb/workflow/designatePerformer2.jsf?' + ");
        sb.append(" \tExt.urlEncode({proDefId:'").append(processDefID).append("',pageId:'").append(pageId).append("',clear:true});");
        sb.append(" var config = {name:'SelectPersonDailog', title:'").append("\u9009\u62e9\u5904\u7406\u4eba").append("',X:700,Y:636};");
        sb.append(" var retVal = KDWin.openDialog(url, config);");
        sb.append("if(retVal) {this.server.call('callSubmitWfAfterSelectPerson',Ext.getCmp('bill').PageID, '").append(processDefID).append("');}");
        ((IDynamicWebFormView)application.getDynamicFormView()).outputScript(sb.toString());
    }

    private String checkNextParticipants(IEnactmentService wfService, String processDefID, String userId) throws WfException {
        String msg = null;
        AssignatePersonsInfo assignatePersons = wfService.checkPostActivitiesPersonsResult(processDefID, userId);
        if (assignatePersons != null) {
            msg = PostParticipantUtil.checkPostActivityPersons(null, (ActivityPersonsInfo[])assignatePersons.getActivityPersons());
        }
        return msg;
    }

    public void submitTheProcess(String processDefID, Map designatedPerformers) throws BOSException, WfException {
        if (designatedPerformers == null) {
            this.showSelectNextPerson(processDefID);
            return;
        }
        String billNumber = null;
        String pk = this.getBeOperatedBillId();
        String formId = this.application.getForm().getId();
        String billName = this.application.getForm().getName();
        IObjectValue objValue = this.getObjectValue(pk);
        billNumber = objValue.getString("number");
        String userId = this.application.getContext().getCaller().toString();
        IEnactmentService wfService = EnactmentServiceFactory.createEnactService((Context)this.application.getContext());
        this.submitTheProcess(processDefID, billNumber, pk, formId, billName, userId, wfService, designatedPerformers);
    }

    private void submitTheProcess(String processDefID, String billNumber, String pk, String formId, String billName, String userId, IEnactmentService wfService, Map designatedPerformers) throws BOSException, WfException {
        HashMap<String, Object> invokeContext = new HashMap<String, Object>();
        if (designatedPerformers != null) {
            invokeContext.putAll(designatedPerformers);
        }
        invokeContext.put("billidString", pk);
        invokeContext.put("formId", formId);
        invokeContext.put("billName", billName);
        invokeContext.put("billNo", billNumber);
        String[][] eventParams = this.application.getForm().getEventParams();
        int size = eventParams.length;
        for (int i = 0; i < size; ++i) {
            String key = eventParams[i][1];
            Object value = this.getEventParamValue(key);
            invokeContext.put(eventParams[i][0], value);
        }
        DynamicFormApplication application = (DynamicFormApplication)this.application;
        if (application.getDynamicFormView().getWfState().isManPowerActivity(application.getContext(), processDefID)) {
            HashMap<String, String> boMap = new HashMap<String, String>();
            boMap.put(pk, pk);
            wfService.createAndCompleteFiristActivity(processDefID, invokeContext, userId, boMap);
        } else {
            wfService.createAndCompleteFiristActivity(processDefID, invokeContext, userId);
        }
    }

    private Object getEventParamValue(String key) throws BOSException {
        Object value = null;
        value = this.application instanceof BillApplication ? ((DynamicFormApplication)this.application).searchValue(key, 0) : BillBusinessUtil.searchValue((DynamicFormApplication)((DynamicFormApplication)this.application), (IObjectValue)this.objValue, (String)key, (int)0);
        if (value instanceof IObjectValue) {
            value = ((IObjectValue)value).get("id").toString();
        }
        return value;
    }

    public boolean isAfterConfirmCancel(ActionArgs e) {
        return e.isAfterConfirmed() && e.getDataChgOperation() != null && e.getCofirmOption() == 2;
    }

    public boolean doConfirmation(ActionArgs e) throws BOSException, EASBizException {
        if (e.isAfterConfirmed() && e.getDataChgOperation() != null) {
            if (e.getCofirmOption() == 0 && this.application instanceof BillApplication) {
                BillApplication application = (BillApplication)this.application;
                FormOperation fo = application.getBillModel().getBusinessInfo().getForm().getOperation(e.getDataChgOperation());
                if (fo != null) {
                    this.invokeBeforeAction(fo);
                }
                this.updateBillState(fo, 0);
                if (e.getDataChgOperation().equals("Save")) {
                    application.save();
                } else {
                    application.submit();
                }
                this.afterOperation(fo);
            }
            return true;
        }
        if (this.fo.isConfirm() && !e.isAfterConfirmed() && this.application.getView() instanceof DynamicWebFormPanel) {
            int index;
            String msg = null;
            if (this.fo.getResource() != null && (index = this.fo.getResource().lastIndexOf(46)) > -1) {
                String resClassName = this.fo.getResource().substring(0, index);
                String resName = this.fo.getResource().substring(index + 1);
                msg = ResourceUtils.getMessageInOrder((String)resClassName, (String)resName, (String[])new String[]{this.fo.getName()});
            }
            if (msg == null) {
                msg = "\u51c6\u5907" + this.fo.getName() + "\u5f53\u524d\u6570\u636e\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f";
            }
            ((DynamicWebFormPanel)this.application.getView()).setAfterConfirmOperArgs(e);
            this.application.showConfirm("\u786e\u8ba4" + this.fo.getName(), msg);
            return false;
        }
        return true;
    }

    public void afterOperation(FormOperation fo) throws BOSException, EASBizException {
        if (fo.getCheckWfState() == 1) {
            this.submitWfAssigment("Submit".equalsIgnoreCase(fo.getOperation()));
        }
        List operationActions = fo.getAfterActions();
        FormActionUtil.invokeActions((IFormApplication)this.application, null, (List)operationActions, null, (int)0);
        DynamicFormApplication application = (DynamicFormApplication)this.application;
        ((IOperationRoundExtend)application.getDynamicFormView()).afterOperation(fo);
    }

    public void invokeBeforeAction(FormOperation fo) throws EASBizException, BOSException {
        List operationActions = fo.getBeforeActions();
        FormActionUtil.invokeActions((IFormApplication)this.application, null, (List)operationActions, null, (int)0);
    }

    public boolean isStateForOperation(FormOperation fo, int row) {
        boolean result = false;
        if (fo == null || fo.getStateField() == null || fo.getSuccessSateValue() == null || !(this.application instanceof BillApplication)) {
            return result;
        }
        BillApplication application = (BillApplication)this.application;
        Field stateField = application.getBillModel().getBusinessInfo().getField(fo.getStateField());
        if (stateField == null) {
            return result;
        }
        Object currentState = application.getValue(fo.getStateField(), row);
        if (currentState == null) {
            return result;
        }
        result = currentState.toString().equals(fo.getSuccessSateValue());
        return result;
    }

    public boolean updateBillState(FormOperation fo, int row) throws ActionCommonException, EASBizException, BOSException {
        boolean result = false;
        if (fo == null || fo.getStateField() == null || fo.getSuccessSateValue() == null) {
            return false;
        }
        DynamicFormApplication application = (DynamicFormApplication)this.application;
        Field stateField = application.getDynamicFormModel().getBusinessInfo().getField(fo.getStateField());
        if (stateField == null) {
            return false;
        }
        int elementType = stateField.getElementType();
        try {
            this.checkPreState(fo, row, elementType);
            if (elementType == 9) {
                BizEnumValueType enumType = this.getEnumType(stateField.getPropertyName());
                if (enumType == null) {
                    return false;
                }
                if (BizEnumValueType.INTEGER.equals((Object)enumType)) {
                    if (application instanceof BillApplication) {
                        application.setValue(fo.getStateField(), (Object)Integer.valueOf(fo.getSuccessSateValue()), row);
                    } else {
                        String prperty = application.getDynamicFormModel().getBusinessInfo().getFullPropertyName(stateField.getKey());
                        this.application.getBillValue().put(prperty, (Object)Integer.valueOf(fo.getSuccessSateValue()));
                    }
                    result = true;
                } else if (BizEnumValueType.STRING.equals((Object)enumType)) {
                    application.setValue(fo.getStateField(), (Object)fo.getSuccessSateValue(), row);
                    result = true;
                }
            } else if (elementType == 8) {
                application.setValue(fo.getStateField(), (Object)Boolean.valueOf(fo.getSuccessSateValue()), row);
                result = true;
            }
        }
        catch (NumberFormatException e1) {
            throw new BOSException((Throwable)e1);
        }
        catch (ClassNotFoundException e1) {
            throw new BOSException((Throwable)e1);
        }
        return result;
    }

    private void checkPreState(FormOperation fo, int row, int elementType) throws ClassNotFoundException, ActionCommonException, BOSException {
        if (elementType == 8) {
            return;
        }
        if (fo.getPreStateValue() == null || fo.getPreStateValue().length() == 0) {
            return;
        }
        String fieldKey = fo.getStateField();
        if (BillBusinessUtil.isEnabledState((IFormApplication)this.application, (FormOperation)fo, (int)row)) {
            return;
        }
        Object oldState = BillBusinessUtil.searchValue((DynamicFormApplication)((DynamicFormApplication)this.application), (IObjectValue)this.application.getBillValue(), (String)fieldKey, (int)row);
        Enum oldStateEnum = this.getEnum(fieldKey, oldState);
        throw new ActionCommonException(null, ResourceUtil.getMessage((String)"NOT_ALLOW", (String[])new String[]{oldStateEnum == null ? "\u7a7a" : oldStateEnum.toString(), fo.getName()}));
    }

    private Enum getEnum(String feildKey, Object enumValue) throws ClassNotFoundException {
        if (enumValue == null) {
            return null;
        }
        IntEnum oldStateEnum = null;
        DynamicFormApplication application = (DynamicFormApplication)this.application;
        int enumType = application.getDynamicFormModel().getBusinessInfo().getField(feildKey).getEnumType();
        String enumClassName = application.getDynamicFormModel().getBusinessInfo().getEnumInfo().get(String.valueOf(enumType)).getEnumClassName();
        if (enumValue instanceof Integer) {
            oldStateEnum = EnumUtils.getEnum(Class.forName(enumClassName), (int)((Integer)enumValue));
        } else if (enumValue instanceof String) {
            oldStateEnum = EnumUtils.getEnumByValue(Class.forName(enumClassName), (String)((String)enumValue));
        }
        return oldStateEnum;
    }

    private BizEnumValueType getEnumType(String propertyName) throws BOSException {
        if (propertyName == null) {
            return null;
        }
        PropertyInfo property = BusinessProcessUtil.getPropertyInfo((Context)this.application.getContext(), (BOSObjectType)BOSObjectType.create((String)this.application.getForm().getBosType()), (String)propertyName);
        if (!(property instanceof OwnPropertyInfo)) {
            return null;
        }
        BizEnumInfo enumInfo = ((OwnPropertyInfo)property).getEnumType();
        if (enumInfo == null) {
            return null;
        }
        BizEnumValueType enumType = enumInfo.getDataType();
        return enumType;
    }

    public void showSuccessMsg() {
        if (this.fo == null) {
            return;
        }
        String msg = ResourceUtil.getMessage((String)"SUCCESS", (String[])new String[]{this.fo.getName()});
        ((DynamicFormApplication)this.application).showMessage(this.fo.getOperation(), msg, 0, null);
    }

    public void requestObjIDForUpdate() throws EASBizException, BOSException {
        String pk = this.getBeOperatedBillId();
        if (StringUtils.isEmpty((String)pk)) {
            return;
        }
        ResourceUtil.requestObjIDForUpdate((Context)this.application.getContext(), (String)pk);
    }

    public void releaseObjIDForUpdate() throws BOSException {
        String pk = this.getBeOperatedBillId();
        if (StringUtils.isEmpty((String)pk)) {
            return;
        }
        MutexServiceControlFactory.getLocalInstance((Context)this.application.getContext()).releaseObjIDForUpdate(pk);
    }

    private String getBeOperatedBillId() throws BOSException {
        String pk = null;
        Object pkObj = ((DynamicFormApplication)this.application).getSelectedRowData(null, null);
        if (pkObj instanceof String) {
            pk = (String)pkObj;
        } else if (pkObj instanceof String[] && ((String[])pkObj).length > 0) {
            pk = ((String[])pkObj)[0];
        }
        return pk;
    }

    public IObjectPK beforeLogSevice() throws BOSException {
        String id = this.getBeOperatedBillId();
        IObjectValue objValue = this.getObjectValue(id);
        if (objValue == null) {
            return null;
        }
        String billNumber = objValue.getString("number");
        Object pkObj = objValue.get(objValue.getPKField());
        ObjectUuidPK pk = null;
        if (pkObj != null) {
            pk = new ObjectUuidPK(pkObj.toString());
        }
        return LogUtil.beginLogWithDescription((Context)this.application.getContext(), (String)this.fo.getOperation(), (BOSObjectType)objValue.getBOSType(), (IObjectPK)pk, (String)billNumber, (String)this.fo.getName());
    }

    public void afterLogSevice(IObjectPK logPk) {
        if (logPk == null) {
            return;
        }
        LogUtil.afterLog((Context)this.application.getContext(), (IObjectPK)logPk);
    }

    public static void submitFlow(ListApplication application, Context ctx, String pk) throws BOSException, EASBizException {
        IObjectValue objectValue = DAOHelper.getDAO().load(application.getContext(), pk, null);
        String formId = application.getListModel().getFormId();
        String billName = StringUtil.throwOffBlank(objectValue.getString("name"));
        String billNumber = objectValue.getString("number");
        String sourcePK = objectValue.get("id").toString();
        TaskTeamInfo taskTeamInfo = TmWkUtil.getTaskTeamById(ctx, pk);
        String processDefID = (String)taskTeamInfo.get("relatingWf");
        if (StringUtil.isEmpty((String)processDefID)) {
            application.showMessage("\u5f53\u524d\u5c0f\u7ec4\u6ca1\u6709\u5173\u8054\u6d41\u7a0b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return;
        }
        if (processDefID != null) {
            String userId = application.getContext().getCaller().toString();
            IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)application.getContext());
            HashMap<String, String> invokeContext = new HashMap<String, String>();
            invokeContext.put("billidString", pk);
            invokeContext.put("formId", formId);
            invokeContext.put("billName", billName);
            invokeContext.put("billNo", billNumber);
            wfService.createAndCompleteFiristActivity(processDefID, invokeContext, userId);
            application.showMessage("\u63d0\u4ea4\u6210\u529f\uff01");
            application.getListView().refresh();
            return;
        }
        BusinessSeviceUtil.triggerWfEvent((Context)application.getContext(), (BOSObjectType)objectValue.getBOSType(), (String)"Submit", (String)pk, (String)formId, (String)billName, (String)billNumber);
    }

    private static TaskTeamInfo getTaskTeamById(Context ctx, String pk) {
        AbstractTaskInfo info = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pk));
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add("TaskTeam.*");
            view.setFilter(filterInfo);
            view.setSelector(coll);
            ITask taskService = TaskFactory.getLocalInstance(ctx);
            CoreBaseCollection collection = taskService.getCollection(view);
            if (collection != null && collection.size() > 0) {
                info = (TaskInfo)collection.get(0);
            }
            return info.getTaskTeam();
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }
}

