/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.uc.dianji.util;

import com.kingdee.eas.cp.uc.dianji.entity.Message;
import com.kingdee.eas.cp.uc.dianji.entity.Sms;
import com.kingdee.eas.cp.uc.dianji.entity.Ug;
import com.kingdee.eas.cp.uc.dianji.entity.User;
import com.kingdee.eas.cp.uc.dianji.util.MessageExt;
import com.kingdee.eas.cp.uc.dianji.util.Util;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.ArrayList;

public class GK_MS_API {
    private String ip;
    private int port;
    private String authorization;

    public void init(String ip, int port) {
        this.ip = ip;
        this.port = port;
        this.authorization = null;
    }

    public void init(String ip, int port, String user, String pwd) {
        this.ip = ip;
        this.port = port;
        this.authorization = Util.encode((user + ":" + Util.str2MD5(pwd)).getBytes());
        System.out.println("authorization: " + this.authorization);
        System.out.println();
    }

    public String sendRequest(String xml) {
        StringBuffer recv_buf = new StringBuffer(100);
        try {
            System.out.println(xml);
            byte[] cs = xml.getBytes("UTF-8");
            String httpHeader = null;
            httpHeader = this.authorization == null ? "POST /api/gkmsapi HTTP/1.1.\r\nAccept:*/*\r\nContent-type:application/binary;charset=utf-8\r\nHost: " + this.ip + "\r\nContent-Length: " + cs.length + "\r\nConnection: " + "Close\r\nCache-Control: no-cache\r\n\r\n" : "POST /api/gkmsapi HTTP/1.1.\r\nAccept:*/*\r\nContent-type:application/binary;charset=utf-8\r\nAuthorization: Basic " + this.authorization + "\r\nHost: " + this.ip + "\r\nContent-Length: " + cs.length + "\r\nConnection:" + " Close\r\nCache-Control: no-cache\r\n\r\n";
            Socket socket = new Socket(this.ip, this.port);
            OutputStream out = socket.getOutputStream();
            out.write(httpHeader.getBytes());
            out.write(cs);
            out.flush();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String line = input.readLine();
            while (line != null) {
                recv_buf.append(line);
                line = input.readLine();
            }
            out.close();
            input.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        String res = "";
        try {
            res = new String(recv_buf.toString().getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (res.indexOf("<response") > 0) {
            res = res.substring(res.indexOf("<response"));
        }
        res = res.toString();
        System.out.println(res);
        return res;
    }

    public String sendMessage(Message mes, String messageID) {
        return this.sendRequest(mes.toXml(messageID));
    }

    public String sendMessageExt(MessageExt mes, String messageID) {
        return this.sendRequest(mes.toXml(messageID));
    }

    public String addUser(User user, String messageID) {
        String str = "<request type=\"user\" subtype=\"adduser\" msid=\"" + messageID + "\">" + "<message>" + user + "</message></request>";
        return this.sendRequest(str);
    }

    public String delUser(String user_id, String account, String gid, String messageID) {
        String str = "<request type=\"user\" subtype=\"deluser\" msid=\"" + messageID + "\">" + "<message><user user_id=\"" + user_id + "\" account=\"" + account + "\" gid=\"" + gid + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String delUser(User user, String messageID) {
        String str = "<request type=\"user\" subtype=\"deluser\" msid=\"" + messageID + "\">" + "<message>" + user + "</message></request>";
        return this.sendRequest(str);
    }

    public String modPass(String user_id, String account, String gid, String pwd, String md5_pwd, String messageID) {
        String str = "<request type=\"user\" subtype=\"modpass\" msid=\"" + messageID + "\"><message><user user_id=\"" + user_id + "\" account=\"" + account + "\" gid=\"" + gid + "\" password=\"" + pwd + "\" md5_pwd=\"" + md5_pwd + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String updPwd(User user, String messageID) {
        String str = "<request type=\"user\" subtype=\"modpass\" msid=\"" + messageID + "\">" + "<message>" + user + "</message></request>";
        return this.sendRequest(str);
    }

    public String updUser(User user, String messageID) {
        String str = "<request type=\"user\" subtype=\"upduser\" msid=\"" + messageID + "\"><message>" + user + "</message></request>";
        return this.sendRequest(str);
    }

    public String setSms(String user_id, String account, String gid, String num, String type, String messageID) {
        String str = "<request type=\"user\" subtype=\"setsms\" msid=\"" + messageID + "\" ><message><user user_id=\"" + user_id + "\" account=\"" + account + "\" gid=\"" + gid + "\" /><sms num=\"" + num + "\" type=\"" + type + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String setSms(Sms sms, String messageID) {
        String str = "<request type=\"user\" subtype=\"setsms\" msid=\"" + messageID + "\" ><message>" + sms + "</message></request>";
        return this.sendRequest(str);
    }

    public String getAllUser(String messageID) {
        String str = "<request type=\"user\" subtype=\"getalluser\" msid=\"" + messageID + "\"></request>";
        return this.sendRequest(str);
    }

    public String getUser(String user_id, String account, String gid, String messageID) {
        String str = "<request type=\"user\" subtype=\"getuser\" msid=\"" + messageID + "\"><message><user user_id=\"" + user_id + "\" account=\"" + account + "\" gid=\"" + gid + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String getUserInfo(User user, String messageID) {
        String str = "<request type=\"user\" subtype=\"getuser\" msid=\"" + messageID + "\"><message>" + user + "</message></request>";
        return this.sendRequest(str);
    }

    public String checkOnline(ArrayList users, String messageID) {
        StringBuffer sb = new StringBuffer();
        sb.append("<request type=\"user\" subtype=\"chkonline\" msid=\"");
        sb.append(messageID);
        sb.append("\" ><users>");
        int size = users.size();
        for (int i = 0; i < size; ++i) {
            User user = (User)users.get(i);
            sb.append(user.toString());
        }
        sb.append("</users></request>");
        return this.sendRequest(sb.toString());
    }

    public String addUg(Ug ug, String messageID) {
        String str = "<request type=\"ug\" subtype=\"addug\" msid=\"" + messageID + "\"><message>" + ug + "</message></request>";
        return this.sendRequest(str);
    }

    public String delUg(String code, String messageID) {
        String str = "<request type=\"ug\" subtype=\"delug\" msid=\"" + messageID + "\"><message><ug code=\"" + code + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String delUg(Ug ug, String messageID) {
        String str = "<request type=\"ug\" subtype=\"delug\" msid=\"" + messageID + "\"><message>" + ug + "</message></request>";
        return this.sendRequest(str);
    }

    public String updUg(Ug ug, String messageID) {
        String str = "<request type=\"ug\" subtype=\"updug\" msid=\"" + messageID + "\"><message>" + ug + "</message></request>";
        return this.sendRequest(str);
    }

    public String getAllUgs(String messageID) {
        String str = "<request type=\"ug\" subtype=\"getallugs\" msid=\"" + messageID + "\" ></request>";
        return this.sendRequest(str);
    }

    public String getUgInfo(String code, String messageID) {
        String str = "<request type=\"ug\" subtype=\"getuginfo\" msid=\"" + messageID + "\"><message><ug code=\"" + code + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String getUgInfo(Ug ug, String messageID) {
        String str = "<request type=\"ug\" subtype=\"getuginfo\" msid=\"" + messageID + "\"><message>" + ug + "</message></request>";
        return this.sendRequest(str);
    }

    public String getChildUg(String code, String messageID) {
        String str = "<request type=\"ug\" subtype=\"getchildug\" msid=\"" + messageID + "\"><message><ug code=\"" + code + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String getChildUg(Ug ug, String messageID) {
        String str = "<request type=\"ug\" subtype=\"getchildug\" msid=\"" + messageID + "\"><message>" + ug + "</message></request>";
        return this.sendRequest(str);
    }

    public String addUserToUg(String account, String code, String messageID) {
        String str = "<request type=\"ug\" subtype=\"addusertoug\" msid=\"" + messageID + "\"><message><ug code=\"" + code + "\" /><user account=\"" + account + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String addUserToUg(Ug ug, User user, String messageID) {
        String str = "<request type=\"ug\" subtype=\"addusertoug\" msid=\"" + messageID + "\"><message>" + ug + user + "</message></request>";
        return this.sendRequest(str);
    }

    public String delUserFromUg(String account, String code, String messageID) {
        String str = "<request type=\"ug\" subtype=\"deluserfromug\" msid=\"" + messageID + "\"><message><ug code=\"" + code + "\" /><user account=\"" + account + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String delUserFromUg(Ug ug, User user, String messageID) {
        String str = "<request type=\"ug\" subtype=\"deluserfromug\" msid=\"" + messageID + "\"><message>" + ug + user + "</message></request>";
        return this.sendRequest(str);
    }

    public String getChildUser(String code, String messageID) {
        String str = "<request type=\"ug\" subtype=\"getchilduser\" msid=\"" + messageID + "\"><message><ug code=\"" + code + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String getChildUser(Ug ug, String messageID) {
        String str = "<request type=\"ug\" subtype=\"getchilduser\" msid=\"" + messageID + "\"><message>" + ug + "</message></request>";
        return this.sendRequest(str);
    }

    public String getUserUgs(String account, String messageID) {
        String str = "<request type=\"ug\" subtype=\"getuserugs\" msid=\"" + messageID + "\"><message><user account=\"" + account + "\" />\" /></message></request>";
        return this.sendRequest(str);
    }

    public String getUserUgs(User user, String messageID) {
        String str = "<request type=\"ug\" subtype=\"getuserugs\" msid=\"" + messageID + "\"><message>" + user + "</message></request>";
        return this.sendRequest(str);
    }

    public String passportLogin(String gid, String passport, String messageID) {
        String str = "<request type=\"login\" subtype=\"passport\" msid=\"" + messageID + "\"><message><user GID=\"" + gid + "\" /><passport>" + passport + "</passport></message></request>";
        return this.sendRequest(str);
    }

    public String passportLogin(String gid, String zoneid, String passport, String messageID) {
        String str = "<request type=\"login\" subtype=\"passport\" msid=\"" + messageID + "\"><message><user gid=\"" + gid + "\" zoneid=\"" + zoneid + "\" /><passport>" + passport + "</passport></message></request>";
        return this.sendRequest(str);
    }

    public String oaLogin(String account, String pwd, int type, String messageID) {
        StringBuffer str = new StringBuffer(100);
        str.append("<request type=\"login\" subtype=\"oalogin\" msid=\"");
        str.append(messageID);
        str.append("\"><message><user account=\"");
        str.append(account);
        str.append("\" pwd=\"");
        str.append(pwd);
        str.append("\" type=\"");
        if (type != 0) {
            str.append("md5");
        }
        str.append("\"></user></message></request>");
        return this.sendRequest(str.toString());
    }

    public String oaLogin(String gid, String zoneid, String pwd, int type, String messageID) {
        StringBuffer str = new StringBuffer(100);
        str.append("<request type=\"login\" subtype=\"oalogin\" msid=\"");
        str.append(messageID);
        str.append("\"><message><user gid=\"");
        str.append(gid);
        str.append("\" zoneid=\"");
        str.append(zoneid);
        str.append("\" pwd=\"");
        str.append(pwd);
        str.append("\" type=\"");
        if (type != 0) {
            str.append("md5");
        }
        str.append("\"></user></message></request>");
        return this.sendRequest(str.toString());
    }

    public String serverControl(String action, String messageID) {
        String str = "<request type=\"service\" subtype=\"\" msid=\"" + messageID + "\"><message><control action=\"" + action + "\" /></message></request>";
        return this.sendRequest(str);
    }

    public String updUgs(ArrayList vUgs, String messageID) {
        StringBuffer sb = new StringBuffer();
        sb.append("<request type=\"sync\" subtype=\"all_ug\" msid=\"" + messageID + "\"><message><ugs>");
        for (int i = 0; i < vUgs.size(); ++i) {
            Ug ug = (Ug)vUgs.get(i);
            sb.append(ug.toString());
        }
        sb.append("</ugs></message></request>");
        return this.sendRequest(sb.toString());
    }

    public String updUsers(ArrayList vUsers, String messageID) {
        StringBuffer sb = new StringBuffer();
        sb.append("<request type=\"sync\" subtype=\"all_user\" msid=\"" + messageID + "\"><message><users>");
        for (int i = 0; i < vUsers.size(); ++i) {
            User user = (User)vUsers.get(i);
            sb.append(user.toString());
        }
        sb.append("</users></message></request>");
        return this.sendRequest(sb.toString());
    }

    public String getOnlineNum(String messageID) {
        StringBuffer sb = new StringBuffer();
        sb.append("<request type=\"user\" subtype=\"onlinenum\" msid=\"" + messageID + "\" ><message></message></request>");
        return this.sendRequest(sb.toString());
    }
}

