/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BillMessagePlugin
extends AbstractBillPlugin {
    private HashMap personPositionMap;
    private HashMap positionOrgMap;
    private HashMap positionCompanyMap;
    private static final String fieldKey = "FtxtPerson_Position";
    private static final String complex_split_str1 = ",";
    private static final String complex_split_str2 = ";";
    boolean isAddNew = false;
    boolean isFromBotp = false;

    public void onLoad() {
        super.onLoad();
        try {
            PersonInfo personInfo = (PersonInfo)this.application.getValue("basedataAuthor", 0);
            if (this.isAddNew && personInfo != null && !this.isFromBotp) {
                String personId = personInfo.getId().toString();
                this.setDefalutPositionByPersonID(personId);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (this.personPositionMap != null) {
            Iterator iterator = this.personPositionMap.keySet().iterator();
            String personKey = "";
            String personid = "";
            String propertyName = null;
            BusinessInfo business = this.application.getBillModel().getBusinessInfo();
            while (iterator.hasNext()) {
                personKey = iterator.next().toString();
                if (business.getField(personKey) == null) continue;
                String value = this.personPositionMap.get(personKey).toString();
                propertyName = business.getField(personKey).getPropertyName();
                if (this.application.getBillValue().getObjectValue(propertyName) == null) continue;
                personid = this.application.getBillValue().getObjectValue(propertyName).get("id") == null ? "" : this.application.getBillValue().getObjectValue(propertyName).get("id").toString();
                this.bindPositionF7Data(personid, personKey);
            }
        }
    }

    private void setDefalutPositionByPersonID(String personId) throws EASBizException, BOSException {
        PositionMemberCollection pmc = this.getAllPositionByPersonID(personId);
        CtrlUnitInfo currentCU = ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext());
        AdminOrgUnitInfo currentAdmin = ContextUtil.getCurrentAdminUnit((Context)this.application.getContext());
        PositionInfo defaultPosition = null;
        if (currentAdmin != null) {
            defaultPosition = this.getDefaultPositon(currentCU, currentAdmin, pmc);
        } else {
            defaultPosition = pmc.get(0).getPosition();
            this.setPositonFilter(pmc);
        }
        if (defaultPosition != null) {
            this.application.setValue("basedataPosition", (Object)defaultPosition, 0);
            this.application.setValue("basedataDept", (Object)defaultPosition.getAdminOrgUnit(), 0);
            AdminOrgUnitInfo company = this.getCompany(this.application.getContext(), defaultPosition.getAdminOrgUnit());
            this.application.setValue("basedataCompany", (Object)company, 0);
        } else {
            this.application.setValue("basedataPosition", null, 0);
            this.application.setValue("basedataDept", null, 0);
            this.application.setValue("basedataCompany", null, 0);
        }
    }

    private PositionInfo getDefaultPositon(CtrlUnitInfo CU, AdminOrgUnitInfo adminOrg, PositionMemberCollection pmc) throws EASBizException, BOSException {
        if (pmc.get(0).isIsPrimary() && pmc.get(0).getPosition().getAdminOrgUnit().getLongNumber().indexOf(adminOrg.getLongNumber()) >= 0) {
            this.setPositonFilter(pmc);
            return pmc.get(0).getPosition();
        }
        ArrayList<PositionInfo> hasPosition = new ArrayList<PositionInfo>();
        for (int i = 1; i < pmc.size(); ++i) {
            if (pmc.get(i).getPosition().getAdminOrgUnit().getLongNumber().indexOf(adminOrg.getLongNumber()) < 0) continue;
            hasPosition.add(pmc.get(i).getPosition());
        }
        if (hasPosition.size() == 1) {
            this.setPositonFilter(pmc);
            return (PositionInfo)hasPosition.get(0);
        }
        if (hasPosition.size() > 1) {
            StringBuffer oql = new StringBuffer();
            oql.append(" ID in (''");
            for (int n = 0; n < hasPosition.size(); ++n) {
                oql.append(",'").append(((PositionInfo)hasPosition.get(n)).getId().toString()).append("'");
            }
            oql.append(")");
            this.application.setFieldFilter("basedataPosition", oql.toString());
            return null;
        }
        adminOrg = AdminOrgUnitFactory.getLocalInstance((Context)this.application.getContext()).getAdminOrgUnitCollection("select id,name,parent.* where id = '" + adminOrg.getId() + "'").get(0);
        if (adminOrg.getParent().getCU().getId().toString().equals(CU.getId().toString())) {
            return this.getDefaultPositon(CU, adminOrg.getParent(), pmc);
        }
        this.setPositonFilter(pmc);
        return pmc.get(0).getPosition();
    }

    private void setPositonFilter(PositionMemberCollection pmc) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append(" ID in (''");
        for (int n = 0; n < pmc.size(); ++n) {
            oql.append(",'").append(pmc.get(n).getPosition().getId().toString()).append("'");
        }
        oql.append(")");
        this.application.setFieldFilter("basedataPosition", oql.toString());
    }

    public void afterBindData() throws EASBizException, BOSException {
        super.afterBindData();
        RuleStatus ruleStatus = this.application.getBillModel().getRuleStatus();
        if (!(ruleStatus != null && ruleStatus.isExist() || this.application.getBillValue().getString("number") != null || OperationStatus.EDIT != this.application.getBillView().getOperationStatus())) {
            Entity mainEntity = this.application.getBillModel().getBusinessInfo().getEntity(0);
            for (Field field : mainEntity.getFields()) {
                if (field.getElementType() != 12) continue;
                this.application.setEnabled(field.getKey(), true);
            }
        }
    }

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        block3: {
            this.isAddNew = OperationStatus.ADDNEW.equals(param.billOperation);
            this.loadPersonPositionMap();
            this.isFromBotp = "CreateTo".equals((String)this.application.getCustomParameter("botpFunc"));
            try {
                HashMap aMap;
                ObjectUpdateLock lockIns;
                Context ctx = this.application.getContext();
                String billID = param.billPk;
                if (!OperationStatus.EDIT.equals(param.billOperation)) break block3;
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                String userName = user.getName();
                if (MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(billID, userName) || (lockIns = (ObjectUpdateLock)(aMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).getObjIDForUpdateList()).get(billID + ctx.getAIS())) == null) break block3;
                if (userName.equals(lockIns.getUserName()) || this.isOverTimeLock(lockIns.getCreatedTime(), new Date())) {
                    MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(billID);
                    MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(billID, userName);
                    break block3;
                }
                String message = "\u5bf9\u4e0d\u8d77\uff0c{0}\u6b63\u5728\u7f16\u8f91\u6b64\u5355\u636e\uff0c\u8bf7\u7a0d\u7b49\uff01";
                message = MessageFormat.format(message, lockIns.getUserName());
                throw new EASBizException(new NumericExceptionSubItem("", message));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return super.onInitialize(param);
    }

    public void beforeCloseForm() throws BOSException {
        try {
            String billID = (String)this.application.getCustomParameter("billId");
            MutexServiceControlFactory.getLocalInstance((Context)this.application.getContext()).releaseObjIDForUpdate(billID);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        super.beforeCloseForm();
    }

    private boolean isOverTimeLock(Date lockDate, Date currentDate) {
        boolean flag = false;
        long mins = 60000L;
        if ((currentDate.getTime() - lockDate.getTime()) / mins >= 60L) {
            flag = true;
        }
        return flag;
    }

    private void loadPersonPositionMap() {
        BusinessInfo business = this.application.getBillModel().getBusinessInfo();
        Field field = business.getField(fieldKey);
        if (field != null) {
            this.personPositionMap = new HashMap();
            this.positionOrgMap = new HashMap();
            this.positionCompanyMap = new HashMap();
            String relation = field.getDefValue();
            if (!StringUtils.isEmpty((String)relation)) {
                relation = relation.replaceAll("\"", "");
                String[] keyValue = relation.split(complex_split_str2);
                for (int n = 0; n < keyValue.length; ++n) {
                    if (StringUtils.isEmpty((String)keyValue[n])) continue;
                    String[] item = keyValue[n].split(complex_split_str1);
                    if (item.length >= 2) {
                        this.personPositionMap.put(item[0].toLowerCase().trim(), item[1].trim());
                    }
                    if (item.length >= 3 && !StringUtils.isEmpty((String)item[2].trim())) {
                        this.positionOrgMap.put(item[1].toLowerCase().trim(), item[2].trim());
                    }
                    if (item.length < 4 || StringUtils.isEmpty((String)item[3].trim())) continue;
                    this.positionCompanyMap.put(item[1].toLowerCase().trim(), item[3].trim());
                }
            }
        }
    }

    private void bindPositionF7Data(String personId, String fieldKey) {
        String oql = "";
        if (personId != null && !"".equals(personId.trim())) {
            List positionList = this.getPositionByPersonID(personId);
            oql = " ID in (''";
            for (int n = 0; n < positionList.size(); ++n) {
                oql = oql + ",'" + positionList.get(n).toString() + "'";
            }
            oql = oql + ")";
        }
        try {
            this.application.setFieldFilter(this.personPositionMap.get(fieldKey.toLowerCase()).toString(), oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void bindOrgByPosition(String positionId, String fieldKey) {
        try {
            this.application.setValue(this.positionOrgMap.get(fieldKey.toLowerCase()).toString(), positionId == null ? null : this.getAdminOrgUnitByPositionID(this.application.getContext(), positionId), 0);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void bindCompanyByPosition(String positionId, String fieldKey) {
        try {
            this.application.setValue(this.positionCompanyMap.get(fieldKey.toLowerCase()).toString(), positionId == null ? null : this.getCompany(this.application.getContext(), this.getAdminOrgUnitByPositionID(this.application.getContext(), positionId)), 0);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void dataChanged(DataChangeCommandArg dataChangeCommandArg) {
        String positionId;
        String personId;
        String key = dataChangeCommandArg.getKey();
        if ("basedataAuthor".equalsIgnoreCase(key)) {
            try {
                if (dataChangeCommandArg.getNewValue() == null || ((PersonInfo)dataChangeCommandArg.getNewValue()).getId() == null) {
                    return;
                }
                personId = ((PersonInfo)dataChangeCommandArg.getNewValue()).getId().toString();
                this.setDefalutPositionByPersonID(personId);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else if ("basedataPosition".equalsIgnoreCase(key)) {
            if (dataChangeCommandArg.getNewValue() == null || ((PositionInfo)dataChangeCommandArg.getNewValue()).getId() == null) {
                return;
            }
            positionId = ((PositionInfo)dataChangeCommandArg.getNewValue()).getId().toString();
            try {
                AdminOrgUnitInfo adminOrg = this.getAdminOrgUnitByPositionID(this.application.getContext(), positionId);
                this.application.setValue("basedataDept", (Object)adminOrg, 0);
                AdminOrgUnitInfo company = this.getCompany(this.application.getContext(), adminOrg);
                this.application.setValue("basedataCompany", (Object)company, 0);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (this.personPositionMap != null && this.personPositionMap.containsKey(key.toLowerCase())) {
            personId = dataChangeCommandArg.getNewValue() == null ? null : ((PersonInfo)dataChangeCommandArg.getNewValue()).getId().toString();
            this.bindPositionF7Data(personId, key);
        }
        if (this.positionOrgMap != null && this.positionOrgMap.containsKey(key.toLowerCase())) {
            positionId = dataChangeCommandArg.getNewValue() == null ? null : ((PositionInfo)dataChangeCommandArg.getNewValue()).getId().toString();
            this.bindOrgByPosition(positionId, key);
        }
        if (this.positionCompanyMap != null && this.positionCompanyMap.containsKey(key.toLowerCase())) {
            positionId = dataChangeCommandArg.getNewValue() == null ? null : ((PositionInfo)dataChangeCommandArg.getNewValue()).getId().toString();
            this.bindCompanyByPosition(positionId, key);
        }
    }

    private List getPositionByPersonID(String personid) {
        LinkedList<String> result = new LinkedList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("select position.id ");
        sb.append(" where person.id = '");
        sb.append(personid);
        sb.append("'");
        try {
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)this.application.getContext());
            PositionMemberCollection pmColl = ipm.getPositionMemberCollection(sb.toString());
            int size = pmColl.size();
            for (int i = 0; i < size; ++i) {
                result.add(pmColl.get(i).getPosition().getId().toString());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    private PositionMemberCollection getAllPositionByPersonID(String personid) {
        LinkedList result = new LinkedList();
        StringBuffer sb = new StringBuffer();
        sb.append("select isPrimary,position.id,position.name,position.number,position.adminOrgUnit.longnumber,position.adminOrgUnit.parent.id,position.adminOrgUnit.unitLayerType.id,position.CU.id");
        sb.append(" where person.id = '");
        sb.append(personid);
        sb.append("' order by isPrimary desc,position.number asc");
        PositionMemberCollection pmColl = null;
        try {
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)this.application.getContext());
            pmColl = ipm.getPositionMemberCollection(sb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return pmColl;
    }

    private AdminOrgUnitInfo getCompany(Context ctx, AdminOrgUnitInfo adminOrgUnitInfo) {
        AdminOrgUnitInfo adminInfo = null;
        try {
            if (this.isCompanyOrUnit(adminOrgUnitInfo)) {
                return adminOrgUnitInfo;
            }
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            adminInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitInfo.getParent().getId().toString()));
            return this.getCompany(ctx, adminInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return adminInfo;
        }
    }

    private boolean isCompanyOrUnit(AdminOrgUnitInfo orgUnit) {
        String UNIT = "00000000-0000-0000-0000-00000000000162824988";
        String COMPANY = "00000000-0000-0000-0000-00000000000262824988";
        if (null != orgUnit && null != orgUnit.getUnitLayerType()) {
            return "00000000-0000-0000-0000-00000000000162824988".equals(orgUnit.getUnitLayerType().getId().toString()) || "00000000-0000-0000-0000-00000000000262824988".equals(orgUnit.getUnitLayerType().getId().toString());
        }
        return true;
    }

    public AdminOrgUnitInfo getAdminOrgUnitByPositionID(Context ctx, String positionId) {
        AdminOrgUnitInfo info = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select adminOrgUnit.id,adminOrgUnit.name,adminOrgUnit.unitLayerType.id,adminOrgUnit.parent.id,id,number,name");
            sb.append(" where id = '");
            sb.append(positionId);
            sb.append("'");
            IPosition ipm = PositionFactory.getLocalInstance((Context)ctx);
            PositionCollection pmColl = ipm.getPositionCollection(sb.toString());
            if (pmColl.size() > 0) {
                info = pmColl.get(0).getAdminOrgUnit();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return info;
    }

    public AdminOrgUnitInfo getHeightOrgByUserID(Context ctx, String personId) {
        AdminOrgUnitInfo info = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select position.* ,position.adminOrgUnit.*,isPrimary,id,number,name,parent");
            sb.append(" where person.id = '");
            sb.append(personId);
            sb.append("'");
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection pmColl = ipm.getPositionMemberCollection(sb.toString());
            int size = pmColl.size();
            for (int i = 0; i < size; ++i) {
                if (pmColl.get(i).getPosition() == null || !pmColl.get(i).isIsPrimary()) continue;
                info = pmColl.get(i).getPosition().getAdminOrgUnit();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return info;
    }

    private AdminOrgUnitInfo getCompany() {
        String UNIT = "00000000-0000-0000-0000-00000000000162824988";
        String COMPANY = "00000000-0000-0000-0000-00000000000262824988";
        Context ctx = this.application.getContext();
        AdminOrgUnitInfo orgUnitInfo = null;
        if (null != ContextUtil.getCurrentAdminUnit((Context)ctx) && null != ContextUtil.getCurrentAdminUnit((Context)ctx).getUnitLayerType()) {
            orgUnitInfo = "00000000-0000-0000-0000-00000000000162824988".equals(ContextUtil.getCurrentAdminUnit((Context)ctx).getUnitLayerType().getId().toString()) || "00000000-0000-0000-0000-00000000000262824988".equals(ContextUtil.getCurrentAdminUnit((Context)ctx).getUnitLayerType().getId().toString()) ? ContextUtil.getCurrentAdminUnit((Context)ctx) : (AdminOrgUnitInfo)ctx.get((Object)OrgType.Admin);
        }
        return orgUnitInfo;
    }
}

