/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.form.extend.attachment.AttachmentCollection;
import com.kingdee.eas.base.form.extend.attachment.AttachmentFactory;
import com.kingdee.eas.base.form.extend.attachment.AttachmentInfo;
import com.kingdee.eas.base.form.extend.attachment.AttachmentTypeEnum;
import com.kingdee.eas.base.form.extend.attachment.IAttachment;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.mc.web.WfWafUtil;
import com.kingdee.eas.cp.wfm.utils.CommonUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.httpclient.util.DateUtil;

public class DocContentBillPlugin
extends AbstractBillPlugin {
    private String layoutId;
    private String nodeId;
    private String flowId;
    private String flowTemplateId = null;
    private OperationStatus operationStatus;
    private final String NOT_SAVED_ATTACHEMNT_CTRL_KEY = "NOT_SAVED_ATTACHEMNT_CTRL_KEY";
    private final String ATTACHMENT_FORMID = "5QaE3qg8RO2/SIe+AB/IaJp+rpI=";

    public boolean onInitialize(OpenBillParameter param) throws BOSException, EASBizException {
        this.operationStatus = param.billOperation;
        this.layoutId = this.application.getBillView().getLayoutInfo().getId();
        if (param.wfState != null) {
            this.nodeId = param.wfState.getNodeID();
            this.flowId = param.wfState.getProcDefId();
        }
        this.flowTemplateId = (String)this.application.getCustomParameter("flowTempId");
        return super.onInitialize(param);
    }

    public void onLoad() {
        super.onLoad();
        String contentId = (String)this.application.getValue("FtxtContentId", 0);
        if (StringUtils.isEmpty((String)contentId) || "null".equals(contentId)) {
            try {
                this.application.setValue("FtxtContentId", (Object)BOSUuid.create((String)"40E7BFAC").toString(), 0);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public void doCustomOperation(String operation) throws BOSException, EASBizException {
        Context ctx = this.application.getContext();
        String billId = this.application.getBillModel().getPKValue();
        String billName = this.application.getBillModel().getBillValue().getString("title");
        if ("viewDoc".equalsIgnoreCase(operation)) {
            this.deleteNotSavedAttachment(ctx);
            AttachmentInfo attachment = null;
            String txtContentId = (String)this.application.getValue("FtxtContentId", 0);
            if (!StringUtil.isEmpty((String)billId) && !"null".equals(billId)) {
                IObjectValue model = null;
                try {
                    model = CommonUtil.loadObjectValue(ctx, billId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (model == null) {
                    this.application.showMessage("\u65b0\u589e\u672a\u4fdd\u5b58\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u7f16\u8f91\u6b63\u6587,\u8bf7\u4fdd\u5b58\u540e\u91cd\u8bd5\uff01");
                    return;
                }
                String contentId = model.getString("docContentid");
                if (!StringUtil.isEmpty((String)contentId) && !"null".equals(contentId)) {
                    attachment = DocContentBillPlugin.getAttachmentById(ctx, contentId);
                    if (attachment == null && (attachment = this.newAttachment(ctx, txtContentId, billId, billName, this.flowTemplateId)) != null && attachment.getControlKey() != null && attachment.getControlKey().startsWith("NOT_SAVED_ATTACHEMNT_CTRL_KEY")) {
                        attachment.setControlKey(attachment.getControlKey().substring("NOT_SAVED_ATTACHEMNT_CTRL_KEY".length()));
                        AttachmentFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)attachment);
                    }
                } else {
                    attachment = this.newAttachment(ctx, txtContentId, billId, billName, this.flowTemplateId);
                    model.setString("docContentId", attachment.getString("id"));
                    DynamicObjectFactory.getLocalInstance((Context)ctx).update(BOSUuid.read((String)billId).getType(), (IObjectPK)new ObjectUuidPK(billId), model);
                }
            } else {
                attachment = DocContentBillPlugin.getAttachmentById(ctx, txtContentId);
                if (attachment == null) {
                    attachment = this.newAttachment(ctx, txtContentId, txtContentId, billName, this.flowTemplateId);
                }
            }
            String url = "/easweb/servlet/BillServlet";
            StringBuffer params = new StringBuffer();
            WfWafUtil.appendParam((StringBuffer)params, (String)"formID", (String)"5QaE3qg8RO2/SIe+AB/IaJp+rpI=", (boolean)true);
            WfWafUtil.appendParam((StringBuffer)params, (String)"billId", (String)(!StringUtil.isEmpty((String)billId) && !"null".equals(billId) ? billId : txtContentId), (boolean)true);
            WfWafUtil.appendParam((StringBuffer)params, (String)"documentBosId", (String)attachment.getId().toString(), (boolean)true);
            WfWafUtil.appendParam((StringBuffer)params, (String)"attachmentType", (String)"DYN_FRAMEWORK", (boolean)false);
            WfWafUtil.appendParam((StringBuffer)params, (String)"extName", (String)"doc", (boolean)false);
            WfWafUtil.appendParam((StringBuffer)params, (String)"pLayoutId", (String)this.layoutId, (boolean)true);
            WfWafUtil.appendParam((StringBuffer)params, (String)"nodeId", (String)this.nodeId, (boolean)true);
            WfWafUtil.appendParam((StringBuffer)params, (String)"flowId", (String)this.flowId, (boolean)true);
            WfWafUtil.appendParam((StringBuffer)params, (String)"pflowTempId", (String)this.flowTemplateId, (boolean)true);
            if (OperationStatus.VIEW.equals(this.operationStatus)) {
                WfWafUtil.appendParam((StringBuffer)params, (String)"operate", (String)"view", (boolean)false);
            } else {
                WfWafUtil.appendParam((StringBuffer)params, (String)"operate", (String)"edit", (boolean)false);
            }
            this.application.popupWindow(url + params, "openNewWindow", "viewDoc", "\u6b63\u6587\u5185\u5bb9", 800, 640);
        }
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        String billId;
        IObjectValue model;
        String contentId;
        Context ctx;
        AttachmentInfo attachemntInfo;
        if (("SAVE".equalsIgnoreCase(operation.getOperation()) || "SUBMIT".equalsIgnoreCase(operation.getOperation())) && (attachemntInfo = DocContentBillPlugin.getAttachmentById(ctx = this.application.getContext(), contentId = (model = CommonUtil.loadObjectValue(ctx, billId = this.application.getBillModel().getPKValue())).getString("docContentId"))) != null && attachemntInfo.getControlKey() != null && attachemntInfo.getControlKey().startsWith("NOT_SAVED_ATTACHEMNT_CTRL_KEY")) {
            attachemntInfo.setBillId(BOSUuid.read((String)billId));
            attachemntInfo.setControlKey(attachemntInfo.getControlKey().substring("NOT_SAVED_ATTACHEMNT_CTRL_KEY".length()));
            AttachmentFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)attachemntInfo);
        }
        super.afterOperation(operation);
    }

    public void afterBotp(IObjectCollection destBills) throws EASBizException, BOSException {
        super.afterBotp(destBills);
    }

    public static AttachmentInfo getAttachmentById(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
        AttachmentInfo attachment = null;
        String oql = "select id,controlKey,hasAcceptRevision where id='" + id + "'";
        AttachmentCollection coll = iAttachment.getAttachmentCollection(oql);
        if (coll != null && coll.size() > 0) {
            attachment = coll.get(0);
        }
        return attachment;
    }

    private void deleteNotSavedAttachment(Context ctx) throws BOSException, EASBizException {
        IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("controlKey", (Object)"NOT_SAVED_ATTACHEMNT_CTRL_KEY%", CompareType.LIKE);
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        Date d = c.getTime();
        FilterItemInfo filterItem2 = new FilterItemInfo("createTime", (Object)d, CompareType.LESS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem2);
        iAttachment.delete(filter);
    }

    private AttachmentInfo newAttachment(Context ctx, String contentId, String billId, String billName, String flowTempId) throws EASBizException, BOSException {
        int dotIndex;
        AttachmentInfo attachment = null;
        attachment = new AttachmentInfo();
        if (!StringUtil.isEmpty((String)billId) && !"null".equals(billId)) {
            attachment.setBillId(BOSUuid.read((String)billId));
        } else {
            attachment.setBillId(BOSUuid.create((String)"40E7BFAC"));
        }
        if (!StringUtil.isEmpty((String)contentId)) {
            attachment.setId(BOSUuid.read((String)contentId));
        }
        if ((dotIndex = (billName = StringUtil.isEmpty((String)billName) ? "\u6d41\u7a0b\u6b63\u6587" : billName).lastIndexOf(46)) < 0) {
            attachment.setName(billName);
        } else {
            attachment.setName(billName.substring(0, dotIndex));
            attachment.setExtName(billName.substring(dotIndex + 1));
        }
        attachment.setNumber(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
        attachment.setControlKey("Foffice".toUpperCase());
        attachment.setAttachmentType(AttachmentTypeEnum.office);
        attachment.setControlKey("NOT_SAVED_ATTACHEMNT_CTRL_KEY" + attachment.getControlKey());
        byte[] fileData = this.getDefaultWordDoc(ctx, flowTempId);
        attachment.setFileData(fileData);
        attachment.setSizeInByte(fileData.length);
        attachment.setSize(StringUtil4File.getFileSizeRepresentation((long)fileData.length, (Context)ctx));
        attachment.setExtName("doc");
        attachment.setDescription("\u6d41\u7a0b\u7ba1\u7406\u6b63\u6587\u5185\u5bb9");
        AttachmentFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)attachment);
        return attachment;
    }

    private byte[] getDefaultWordDoc(Context ctx, String flowTempId) {
        if (StringUtils.isEmpty((String)flowTempId)) {
            return this.getEmptyWordDoc();
        }
        AttachmentInfo ai = null;
        try {
            ai = DocContentBillPlugin.getOfficeDocTemplate(ctx, flowTempId);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return ai == null ? this.getEmptyWordDoc() : ai.getFileData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getEmptyWordDoc() {
        byte[] bytes = new byte[]{0, 1, 127};
        String emptyDocPath = "/server/deploy/easweb.ear/eas_web.war/cp/odm/emptyDoc.doc";
        String eas_home = System.getProperty("EAS_HOME");
        emptyDocPath = eas_home + emptyDocPath;
        System.out.println("************************* cp.odm.util.OdmUtil SystemPath:" + emptyDocPath + "********************************");
        File wordDoc = new File(emptyDocPath);
        if (wordDoc.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(wordDoc);
                bytes = new byte[fis.available()];
                fis.read(bytes);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return bytes;
    }

    private static AttachmentInfo getOfficeDocTemplate(Context ctx, String flowTempId) throws BOSException {
        IAttachment facade = AttachmentFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)flowTempId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("controlKey", (Object)"FOFFICETEMPLATE", CompareType.EQUALS));
        evi.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("creator.id"));
        evi.setSelector(selector);
        AttachmentCollection attachs = facade.getAttachmentCollection(evi);
        AttachmentInfo attachment = null;
        if (attachs != null && attachs.size() > 0) {
            attachment = attachs.get(0);
        }
        return attachment;
    }
}

