/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoFactory;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoInfo;
import com.kingdee.eas.base.form.extend.flow.IDocumentInfo;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.extend.flow.TemplateTypeFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateTypeInfo;
import com.kingdee.eas.base.form.extend.flow.UsedStateEnum;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillApplicationHelper;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.BeforeCommandArg;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfm.WorkflowStatus;
import com.kingdee.eas.cp.wfm.utils.CommonUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class FlowDraftListPlugin
extends ListPlugin {
    public void onBeforeQuery(BeforeQueryArg arg) {
        super.onBeforeQuery(arg);
        try {
            UserInfo user = (UserInfo)this.application.getListModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
            String personId = UserFactory.getLocalInstance((Context)this.application.getContext()).getUserInfo((IObjectPK)new ObjectUuidPK(user.getId().toString())).getPerson().getId().toString();
            arg.setFilterBy(" FWorkflowStatus=0 and ( t1.FProposerId='" + personId + "' or t1.fcreatorid='" + user.getId().toString() + "') and t1.FTemplateID in (select fid from t_bas_template where FFlowDirStr like 'com.kingdee.eas.cp.wfm%' or FFlowDirStr is null)");
            arg.setOrderBy(" t1.FRequestTime desc,t1.FDocNumber ");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void beforeBarItemClick(BeforeCommandArg beforeCommandArg) throws BOSException {
        String[] pks = this.application.getListView().getSelectedBillIds();
        if (beforeCommandArg.getKey().equalsIgnoreCase("mnuEditView") || "mnuEditModify".equalsIgnoreCase(beforeCommandArg.getKey())) {
            beforeCommandArg.setCancel(true);
            try {
                if (pks == null || pks.length == 0) {
                    this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
                    return;
                }
                if (pks.length > 1) {
                    this.application.showMessage("\u4e0d\u80fd\u9009\u62e9\u591a\u884c\u6570\u636e\uff01");
                    return;
                }
                IObjectValue objectValue = DAOHelper.getDAO().load(this.application.getContext(), pks[0], null);
                String formId = objectValue.get("formID") == null ? "" : objectValue.get("formID").toString();
                String layoutId = objectValue.get("layoutID") == null ? "" : objectValue.get("layoutID").toString();
                String srcBillPk = objectValue.get("sourcePK") == null ? "" : objectValue.get("sourcePK").toString();
                OperationStatus viewOrEdit = "mnuEditView".equalsIgnoreCase(beforeCommandArg.getKey()) ? OperationStatus.VIEW : OperationStatus.EDIT;
                this.application.operateBill(viewOrEdit, formId, layoutId, srcBillPk);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable e) {
                throw new BOSException(e);
            }
        } else if ("mnuEditDelete".equalsIgnoreCase(beforeCommandArg.getKey())) {
            if (pks == null || pks.length == 0) {
                this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
                return;
            }
            beforeCommandArg.setCancel(true);
            this.application.showConfirm("confirmDelete", "\u8bf7\u786e\u8ba4", "\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", 8189);
        }
    }

    public void fireAfterConfirm(String id, int returnOption) throws EASBizException, BOSException {
        if ("confirmDelete".equals(id) && returnOption == 0) {
            String[] pks = this.application.getListView().getSelectedBillIds();
            for (int i = 0; i < pks.length; ++i) {
                IObjectValue objectValue = DAOHelper.getDAO().load(this.application.getContext(), pks[i], null);
                try {
                    IObjectValue objectValueBill = DAOHelper.getDAO().load(this.application.getContext(), objectValue.get("sourcePK").toString(), null);
                    IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)this.application.getContext());
                    iBTPManager.removeAllRelation((CoreBillBaseInfo)objectValueBill);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                DocumentInfoFactory.getLocalInstance((Context)this.application.getContext()).delete((IObjectPK)new ObjectUuidPK(pks[i]));
                DynamicObjectFactory.getLocalInstance((Context)this.application.getContext()).delete(BOSUuid.read((String)objectValue.get("sourcePK").toString()).getType(), (IObjectPK)new ObjectUuidPK(objectValue.get("sourcePK").toString()));
            }
            this.application.getListView().refresh();
        }
    }

    public void doCustomOperation(String operation) {
        String[] pks = null;
        try {
            pks = this.application.getListView().getSelectedBillIds();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        if (pks == null || pks.length == 0) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
            return;
        }
        if (pks.length > 1) {
            this.application.showMessage("\u4e0d\u80fd\u9009\u62e9\u591a\u884c\u6570\u636e\uff01");
            return;
        }
        if ("Submit".equalsIgnoreCase(operation)) {
            try {
                IObjectValue objectValue = DAOHelper.getDAO().load(this.application.getContext(), pks[0], null);
                DocumentInfoInfo info = (DocumentInfoInfo)objectValue;
                TemplateInfo templateInfo = TemplateFactory.getLocalInstance((Context)this.application.getContext()).getTemplateInfo((IObjectPK)new ObjectUuidPK(info.getTemplateId()));
                PersonInfo person = ContextUtil.getCurrentUserInfo((Context)this.application.getContext()).getPerson();
                if (!FlowDraftListPlugin.checkHasPermission(this.application.getContext(), templateInfo.getId().toString(), person == null ? null : person.getId().toString(), ContextUtil.getCurrentUserInfo((Context)this.application.getContext()).getId().toString(), templateInfo.getCU().getId().toString())) {
                    this.application.showMessage("\u60a8\u6ca1\u6709\u8be5\u6d41\u7a0b\u7684\u65b0\u589e\u6743\u9650\uff0c\u4e0d\u80fd\u63d0\u4ea4\u7533\u8bf7");
                    return;
                }
                if (templateInfo.getUsedState().getValue() == 0 || templateInfo.getUsedState().getValue() == 1) {
                    this.application.showMessage("\u60a8\u63d0\u4ea4\u7684\u6d41\u7a0b\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u63d0\u4ea4\u7533\u8bf7\uff01");
                    return;
                }
                TemplateTypeInfo templateTypeInfo = TemplateTypeFactory.getLocalInstance((Context)this.application.getContext()).getTemplateTypeInfo((IObjectPK)new ObjectUuidPK(templateInfo.getTemplateType().getId().toString()));
                if (templateTypeInfo.getUsedState().equals((Object)UsedStateEnum.disable)) {
                    this.application.showMessage("\u8be5\u6d41\u7a0b\u6a21\u677f\u7684\u7c7b\u578b\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u63d0\u4ea4\u7533\u8bf7\uff01");
                    return;
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            try {
                IDocumentInfo docService = DocumentInfoFactory.getLocalInstance((Context)this.application.getContext());
                DocumentInfoInfo docInfo = docService.getDocumentInfoInfo((IObjectPK)new ObjectUuidPK(pks[0]));
                String sourcePK = docInfo.getSourcePK();
                String formId = docInfo.getFormID();
                this.submitFlow(formId, sourcePK);
                this.changeStatusToInApprove(pks[0]);
                this.application.showMessage("\u8be5\u6d41\u7a0b\u5355\u636e\u63d0\u4ea4\u6210\u529f\uff01");
            }
            catch (Exception e) {
                this.application.showMessage("\u8be5\u6d41\u7a0b\u5355\u636e\u63d0\u4ea4\u5931\u8d25\uff01");
                e.printStackTrace();
            }
        } else if ("Print".equalsIgnoreCase(operation)) {
            try {
                IObjectValue objectValue = DAOHelper.getDAO().load(this.application.getContext(), pks[0], null);
                DocumentInfoInfo info = (DocumentInfoInfo)objectValue;
                TemplateInfo templateInfo = TemplateFactory.getLocalInstance((Context)this.application.getContext()).getTemplateInfo((IObjectPK)new ObjectUuidPK(info.getTemplateId()));
                String formId = templateInfo.getFormID();
                String layoutId = templateInfo.getLayoutID();
                String[] srcBillPks = new String[]{info.getSourcePK()};
                this.application.getListView().print(formId, layoutId, srcBillPks);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public void afterOperation(FormOperation formOperation) {
        try {
            this.application.getListView().refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void submitFlow(String formId, String pk) throws BOSException, EASBizException, Exception {
        OpenBillParameter param = new OpenBillParameter();
        param.setFormId(formId);
        param.billPk = pk;
        BillApplicationHelper helper = BillApplicationHelper.getInstance((Context)this.application.getContext(), (OpenBillParameter)param, null);
        BillApplication billApp = helper.newBillApplication();
        helper.loadData(null);
        FormActionUtil.invokeBillFunction((IFormApplication)billApp, (String)"Submit", null);
    }

    private void submitFlow(String pk) throws BOSException, EASBizException {
        IObjectValue objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
        String formId = this.application.getListModel().getFormId();
        String billName = this.application.getListModel().getBusinessInfo().getForm().getName_L2();
        String billNumber = objectValue.getString("number");
        String sourcePK = objectValue.get("sourcePK").toString();
        IDocumentInfo docService = DocumentInfoFactory.getLocalInstance((Context)this.application.getContext());
        DocumentInfoInfo docInfo = docService.getDocumentInfoInfo((IObjectPK)new ObjectUuidPK(pk));
        String templateId = docInfo.getTemplateId();
        TemplateInfo templateInfo = TemplateFactory.getLocalInstance((Context)this.application.getContext()).getTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
        String processDefID = templateInfo.getFlowId();
        if (processDefID != null) {
            String userId = this.application.getContext().getCaller().toString();
            IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)this.application.getContext());
            HashMap<String, String> invokeContext = new HashMap<String, String>();
            invokeContext.put("billidString", sourcePK);
            invokeContext.put("formId", formId);
            invokeContext.put("billName", billName);
            invokeContext.put("billNo", billNumber);
            wfService.createAndCompleteFiristActivity(processDefID, invokeContext, userId);
            docInfo.setFlowID(processDefID);
            docService.save((CoreBaseInfo)docInfo);
            return;
        }
        BusinessSeviceUtil.triggerWfEvent((Context)this.application.getContext(), (BOSObjectType)objectValue.getBOSType(), (String)"Submit", (String)pk, (String)formId, (String)billName, (String)billNumber);
    }

    public static boolean checkHasPermission(Context ctx, String temid, String perId, String userId, String tempcuid) {
        try {
            String sql1;
            String currCUid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            String sql = "select fid from T_WFM_TemplatePermission where FControlUnitID='" + currCUid + "' and FTemplateID='" + temid + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() == 0 ? tempcuid.equals("eThjryu4wEKoEK1veu3ZzDUlqpQ=") && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql1 = "select fid from T_WFM_TemplatePermission where fisAllCU=1 and FTemplateID='" + temid + "'"))).size() != 0 : FlowDraftListPlugin.checkNewPermission(ctx, temid, perId, currCUid)) {
                return true;
            }
            if (tempcuid.equals("eThjryu4wEKoEK1veu3ZzDUlqpQ=") && FlowDraftListPlugin.checkUserAllAdminOrgByUserID(ctx, temid, perId, currCUid)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static boolean checkUserAllAdminOrgByUserID(Context ctx, String tempid, String userId, String currcuid) throws Exception {
        Vector<String> vecOrgID = new Vector<String>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select position.* ,position.adminOrgUnit.* ");
            sb.append(" where person.id = '");
            sb.append(userId);
            sb.append("'");
            AdminOrgUnitInfo adminOrg = null;
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection pmColl = ipm.getPositionMemberCollection(sb.toString());
            int size = pmColl.size();
            for (int i = 0; i < size; ++i) {
                String admincuid;
                if (pmColl.get(i).getPosition() == null || vecOrgID.contains(admincuid = (adminOrg = pmColl.get(i).getPosition().getAdminOrgUnit()).getCU().getId().toString())) continue;
                if (!admincuid.equals(currcuid) && FlowDraftListPlugin.checkNewPermission(ctx, tempid, userId, admincuid)) {
                    return true;
                }
                vecOrgID.add(admincuid);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("\u4e0d\u80fd\u627e\u5230\u5f53\u524d\u7528\u6237\u6240\u5728\u7684\u90e8\u95e8!");
        }
        return false;
    }

    static boolean checkNewPermission(Context ctx, String temid, String perId, String cuid) {
        try {
            ArrayList<AdminOrgUnitInfo> neworg = new ArrayList<AdminOrgUnitInfo>();
            StringBuffer selectSql = new StringBuffer();
            StringBuffer selectSql1 = new StringBuffer();
            AdminOrgUnitInfo info = null;
            selectSql.append("select biz.fid  from ");
            selectSql.append("T_wfm_TemplatePermission biz  \n");
            selectSql.append("left join ");
            selectSql.append("T_wfm_TemplatePermissionNewOrg admin on admin.fparentid = biz.fid \n");
            selectSql.append("where (\n");
            selectSql.append("   ('" + perId + "' in (select person.FPersonID from T_wfm_TemplatePNP person where person.fparentid = biz.fid)");
            selectSql1.append("select admin.FOrgID  from ");
            selectSql1.append("T_wfm_TemplatePermission biz  \n");
            selectSql1.append("inner join ");
            selectSql1.append("T_wfm_TemplatePermissionNewOrg admin on admin.fparentid = biz.fid \n");
            selectSql1.append("where biz.FTemplateID='" + temid + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql1.toString());
            while (rs.next()) {
                info = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(rs.getString(1)));
                neworg.add(info);
            }
            if (neworg.size() > 0) {
                selectSql.append(" or ");
                Vector<String> vecOrgID = new Vector<String>();
                StringBuffer sb = new StringBuffer();
                sb.append("select position.* ,position.adminOrgUnit.* ");
                sb.append(" where person.id = '");
                sb.append(perId);
                sb.append("'");
                AdminOrgUnitInfo adminOrg = null;
                IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
                PositionMemberCollection pmColl = ipm.getPositionMemberCollection(sb.toString());
                boolean check = false;
                int size = pmColl.size();
                for (int i = 0; i < size; ++i) {
                    if (pmColl.get(i).getPosition() == null || vecOrgID.contains((adminOrg = pmColl.get(i).getPosition().getAdminOrgUnit()).getId().toString())) continue;
                    int orgsize = neworg.size();
                    for (int j = 0; j < orgsize; ++j) {
                        if (check || adminOrg.getLongNumber().indexOf(((AdminOrgUnitInfo)neworg.get(j)).getLongNumber()) < 0) continue;
                        check = true;
                    }
                    vecOrgID.add(adminOrg.getId().toString());
                }
                if (!check) {
                    selectSql.append("1=0 ");
                } else if (check) {
                    selectSql.append("1=1 ");
                }
            }
            selectSql.append("\t) or biz.FNewPerType='1') \n");
            selectSql.append("    AND biz.FTemplateID = '");
            selectSql.append(temid);
            selectSql.append("' and biz.FControlUnitID='" + cuid + "'  \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    private void changeStatusToInApprove(String pk) throws BOSException, EASBizException {
        IDocumentInfo documentService = DocumentInfoFactory.getLocalInstance((Context)this.application.getContext());
        DocumentInfoInfo docInfo = documentService.getDocumentInfoInfo((IObjectPK)new ObjectUuidPK(pk));
        docInfo.setWorkflowStatus(com.kingdee.eas.base.form.extend.flow.WorkflowStatus.inApprove);
        documentService.update((IObjectPK)new ObjectUuidPK(pk), (CoreBaseInfo)docInfo);
        IObjectValue objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
        String sourcePK = objectValue.get("sourcePK").toString();
        IObjectValue newObjectValue = CommonUtil.loadObjectValue(this.application.getContext(), sourcePK);
        newObjectValue.put("workflowStatus", (Object)WorkflowStatus.inApprove);
        newObjectValue.put("id", (Object)BOSUuid.read((String)sourcePK));
        DynamicObjectFactory.getLocalInstance((Context)this.application.getContext()).update(BOSUuid.read((String)sourcePK).getType(), (IObjectPK)new ObjectUuidPK(sourcePK), newObjectValue);
    }
}

