/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.IContextProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.KDNoteWebServerHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentHandleFacade;
import com.kingdee.eas.base.attachment.util.WebAttachmentItem;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.expression.ExpressionEvaluator;
import com.kingdee.eas.base.form.extend.attachment.AttachmentCollection;
import com.kingdee.eas.base.form.extend.attachment.IOfficeHistory;
import com.kingdee.eas.base.form.extend.attachment.OfficeHistoryCollection;
import com.kingdee.eas.base.form.extend.attachment.OfficeHistoryFactory;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoCollection;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoFactory;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoInfo;
import com.kingdee.eas.base.form.extend.flow.IDocumentInfo;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.extend.flow.WorkflowStatus;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.FormCondition;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.DynamicFormPrintDataProvider;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillApplicationHelper;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.list.ListApplication;
import com.kingdee.eas.base.form.web.DynamicWebFormPanel;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.ContentTypeEnum;
import com.kingdee.eas.cp.dm.DMArchiveException;
import com.kingdee.eas.cp.dm.archive.ArchiveDocumentImpl;
import com.kingdee.eas.cp.dm.archive.ArchiveDocumentParamsInfo;
import com.kingdee.eas.cp.dm.archive.ArchiveResultInfo;
import com.kingdee.eas.cp.wfm.WfmArchiveArchivePersonCollection;
import com.kingdee.eas.cp.wfm.WfmArchiveArchivePersonFactory;
import com.kingdee.eas.cp.wfm.WfmArchiveCollection;
import com.kingdee.eas.cp.wfm.WfmArchiveFactory;
import com.kingdee.eas.cp.wfm.WfmArchiveInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArchiveHelper {
    private static Logger log = Logger.getLogger(ArchiveHelper.class);

    public static void pige(Context ctx, DynamicWebFormPanel webFormPanel, IObjectValue objectValue, String templatePath, String categoryId, Object provider) throws Exception {
        int i;
        String billId = objectValue.get("id").toString();
        String workflowStatus = (String)objectValue.get("workflowStatus");
        log.info((Object)("ArchiveHelper:pige()-----------begin----billId = " + billId + ",workflowStatus = " + workflowStatus));
        if (workflowStatus != null && workflowStatus.equals("4")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String dateStr = "(" + sdf.format(new Date()) + ")";
            objectValue.put("title", (Object)(objectValue.get("title") + dateStr));
        }
        ArchiveDocumentParamsInfo paramsInfo = ArchiveHelper.contructParams(objectValue, categoryId);
        ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
        final Context context = ctx;
        KDNoteWebServerHelper webServerHelper = new KDNoteWebServerHelper();
        webServerHelper.setBosContext(ctx);
        webServerHelper.setContextProvider(new IContextProvider(){

            public IBizContext getBizContext(Context bosCtx) {
                IBizContext ctx = null;
                try {
                    ctx = KDNoteHelper.makeContext((Context)context);
                }
                catch (ConnectException e) {
                    log.error((Object)"get context error:", (Throwable)e);
                    return null;
                }
                return ctx;
            }
        });
        log.info((Object)("ArchiveHelper:pige()------webServerHelper.exportPDF()-----begin--billId = " + billId));
        webServerHelper.exportPDF(templatePath, provider, (OutputStream)bodyStream);
        log.info((Object)("ArchiveHelper:pige()------webServerHelper.exportPDF()-----end,bodyStream.size = " + bodyStream.size()));
        ByteArrayInputStream bodyInputStream = new ByteArrayInputStream(bodyStream.toByteArray());
        log.info((Object)("ArchiveHelper:pige()------getAttachmentCollectionBy-----begin--billId = " + billId));
        com.kingdee.eas.base.attachment.AttachmentCollection attachmentList = ArchiveHelper.getAttachmentCollectionBy(billId, ctx);
        if (null != attachmentList) {
            log.info((Object)("ArchiveHelper:pige()------getAttachmentCollectionBy-----end--attachmentList.size = " + attachmentList.size()));
        } else {
            log.info((Object)"ArchiveHelper:pige()------getAttachmentCollectionBy-----end--attachmentList is null! ");
        }
        log.info((Object)("ArchiveHelper:pige()------getAttachmentCollection-----begin--billId = " + billId));
        AttachmentCollection officeList = com.kingdee.eas.base.form.extend.attachment.AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentCollection("where billId='" + billId + "' and attachmentType=" + 1);
        if (null != attachmentList) {
            log.info((Object)("ArchiveHelper:pige()------getAttachmentCollection-----end--officeList.size = " + officeList.size()));
        } else {
            log.info((Object)"ArchiveHelper:pige()------getAttachmentCollection-----end--officeList is null! ");
        }
        String title = "";
        int attachmentLength = attachmentList == null ? 0 : attachmentList.size();
        int officeLength = officeList == null ? 0 : officeList.size();
        InputStream[] historyStreams = ArchiveHelper.getOfficeHistory(ctx, billId);
        int historyLength = historyStreams == null ? 0 : historyStreams.length;
        int length = attachmentLength + officeLength + historyLength;
        InputStream[] fileStreams = new InputStream[length];
        String[] fileNames = new String[length];
        for (i = 0; i < officeLength; ++i) {
            title = officeList.get(i).getName();
            fileStreams[i] = new ByteArrayInputStream(officeList.get(i).getFileData());
            fileNames[i] = "Office\u6b63\u6587---" + title + "." + officeList.get(i).getExtName();
        }
        while (i < length - historyLength) {
            if (attachmentList.get(i - officeLength) != null && attachmentList.get(i - officeLength).getFile() == null) {
                try {
                    byte[] files = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(attachmentList.get(i - officeLength).getId().toString());
                    attachmentList.get(i - officeLength).setFile(files);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
            if (null != attachmentList.get(i - officeLength) && null != attachmentList.get(i - officeLength).getFile()) {
                fileStreams[i] = new ByteArrayInputStream(attachmentList.get(i - officeLength).getFile());
            }
            fileNames[i] = attachmentList.get(i - officeLength).getName() + "." + attachmentList.get(i - officeLength).getSimpleName();
            ++i;
        }
        int len = 0;
        while (i < length) {
            if (len < historyLength) {
                fileStreams[i] = historyStreams[len];
                fileNames[i] = title + "_\u8349\u7a3f" + (len + 1) + ".doc";
                ++len;
            }
            ++i;
        }
        ArchiveDocumentImpl arch = new ArchiveDocumentImpl();
        arch.archiveDocument(ctx, paramsInfo, (InputStream)bodyInputStream, fileStreams, fileNames);
    }

    public static void pigeonhole(ListApplication application, String billId, String userId, Object provider) throws EASBizException, BOSException {
        Context ctx = application.getContext();
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserByID((IObjectPK)new ObjectUuidPK(userId));
        String curPersonId = userInfo.getPerson().getId().toString();
        IDocumentInfo iDoc = DocumentInfoFactory.getLocalInstance((Context)ctx);
        DocumentInfoCollection docCol = iDoc.getDocumentInfoCollection("select * where sourcePK = '" + billId + "'");
        if (docCol != null && docCol.size() > 0) {
            DocumentInfoInfo docInfo = docCol.get(0);
            IObjectValue objectValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(BOSUuid.read((String)billId).getType(), (IObjectPK)new ObjectUuidPK(billId));
            String workflowStatus = (String)objectValue.get("workflowStatus");
            if (!"2".equals(workflowStatus) && !"4".equals(workflowStatus)) {
                application.showMessage("\u53ea\u6709\u5df2\u5b8c\u6210\u7684\u5355\u636e\u624d\u53ef\u4ee5\u5f52\u6863\uff01");
                return;
            }
            String templateId = docInfo.getTemplateId();
            try {
                WfmArchiveCollection archiveCol = null;
                String oql = "select wfmTemplate.id,archivePath,printPath,isOverallCU,isAllowRePige,categoryPath.id,categoryPath.isArchive,pigeonholeScheme,archiveSetEntry.* where wfmTemplate.id='" + templateId + "'";
                archiveCol = WfmArchiveFactory.getLocalInstance(ctx).getWfmArchiveCollection(oql);
                if (archiveCol == null || archiveCol.size() == 0) {
                    String tempName = "";
                    String typeId = docInfo.getTemplateId();
                    if (typeId != null && !"".equals(typeId)) {
                        TemplateInfo tempInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(typeId.toString()));
                        tempName = tempInfo.getName();
                    }
                    application.showMessage("\u8be5\u6d41\u7a0b\u6a21\u677f(" + tempName + ")\u6ca1\u6709\u5f52\u6863\u65b9\u6848\uff01");
                    return;
                }
                WfmArchiveInfo wfmArchiveInfo = ArchiveHelper.filterConditions((DynamicFormApplication)application, archiveCol, "list", billId);
                if (wfmArchiveInfo == null) {
                    application.showMessage("\u6ca1\u6709\u6ee1\u8db3\u5f52\u6863\u6761\u4ef6\u7684\u5f52\u6863\u65b9\u6848\uff01");
                    return;
                }
                ArchiveHelper.checkPigePermission(ctx, curPersonId, wfmArchiveInfo);
                String templatePath = wfmArchiveInfo.getPrintPath().split(",")[0];
                String categoryId = wfmArchiveInfo.getCategoryPath().getId().toString();
                if (wfmArchiveInfo.getCategoryPath() != null && !wfmArchiveInfo.getCategoryPath().isIsArchive()) {
                    application.showMessage("\u8be5\u680f\u76ee\u6ca1\u6709\u8bbe\u7f6e\u4e3a\u5141\u8bb8\u5f52\u6863\uff01");
                    return;
                }
                if (workflowStatus != null && workflowStatus.equals(WorkflowStatus.archived.getValue() + "") && !wfmArchiveInfo.isIsAllowRePige()) {
                    application.showMessage("\u8be5\u6d41\u7a0b\u6a21\u677f\u4e0d\u5141\u8bb8\u91cd\u590d\u5f52\u6863\uff01");
                    return;
                }
                String title = objectValue.get("title").toString();
                ArchiveHelper.pige(ctx, (DynamicWebFormPanel)application.getListView(), objectValue, templatePath, categoryId, provider);
                objectValue.put("title", (Object)title);
                if (workflowStatus != null && !workflowStatus.equals(WorkflowStatus.archived)) {
                    objectValue.put("workflowStatus", (Object)(WorkflowStatus.archived.getValue() + ""));
                    DynamicObjectFactory.getLocalInstance((Context)ctx).update(BOSUuid.read((String)billId).getType(), (IObjectPK)new ObjectUuidPK(billId), objectValue);
                    ArchiveHelper.updateDocInfoStatus(ctx, objectValue.getString("id"), WorkflowStatus.archived);
                }
                application.showMessage("\u5f52\u6863\u6210\u529f\uff01");
            }
            catch (DMArchiveException e) {
                if (DMArchiveException.ARCHIVEERROR.getCode().equals(e.getSubCode())) {
                    application.showMessage("\u5f52\u6863\u5f02\u5e38\uff08FTP\u670d\u52a1\u5668\u53ef\u80fd\u8fde\u63a5\u4e0d\u6b63\u5e38\uff01)");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info((Object)e.getMessage());
                String nonPermission = "";
                if (e.getMessage() != null && e.getMessage().startsWith("Non_Archive_Permission")) {
                    nonPermission = "(\u6ca1\u6709\u5f52\u6863\u6743\u9650)";
                }
                application.showMessage("\u5f52\u6863\u5931\u8d25\uff01" + nonPermission);
            }
        } else {
            application.showMessage("\u8be5\u5355\u636e\u5df2\u4e0d\u5b8c\u6574\uff08\u7f3a\u5931documentInfo\u8bb0\u5f55\uff09\uff01");
        }
    }

    public static void pigeonhole(ListApplication application, String billId, String userId) throws EASBizException, BOSException {
        Context ctx = application.getContext();
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserByID((IObjectPK)new ObjectUuidPK(userId));
        String curPersonId = userInfo.getPerson().getId().toString();
        IDocumentInfo iDoc = DocumentInfoFactory.getLocalInstance((Context)ctx);
        DocumentInfoCollection docCol = iDoc.getDocumentInfoCollection("select * where sourcePK = '" + billId + "'");
        if (docCol != null && docCol.size() > 0) {
            DocumentInfoInfo docInfo = docCol.get(0);
            IObjectValue objectValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(BOSUuid.read((String)billId).getType(), (IObjectPK)new ObjectUuidPK(billId));
            String workflowStatus = (String)objectValue.get("workflowStatus");
            if (!"2".equals(workflowStatus) && !"4".equals(workflowStatus)) {
                application.showMessage("\u53ea\u6709\u5df2\u5b8c\u6210\u7684\u5355\u636e\u624d\u53ef\u4ee5\u5f52\u6863\uff01");
                return;
            }
            String templateId = docInfo.getTemplateId();
            try {
                WfmArchiveCollection archiveCol = null;
                String oql = "select wfmTemplate.id,archivePath,printPath,isOverallCU,isAllowRePige,categoryPath.id,categoryPath.isArchive,pigeonholeScheme,archiveSetEntry.* where wfmTemplate.id='" + templateId + "'";
                archiveCol = WfmArchiveFactory.getLocalInstance(ctx).getWfmArchiveCollection(oql);
                if (archiveCol == null || archiveCol.size() == 0) {
                    String tempName = "";
                    String typeId = docInfo.getTemplateId();
                    if (typeId != null && !"".equals(typeId)) {
                        TemplateInfo tempInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(typeId.toString()));
                        tempName = tempInfo.getName();
                    }
                    application.showMessage("\u8be5\u6d41\u7a0b\u6a21\u677f(" + tempName + ")\u6ca1\u6709\u5f52\u6863\u65b9\u6848\uff01");
                    return;
                }
                WfmArchiveInfo wfmArchiveInfo = ArchiveHelper.filterConditions((DynamicFormApplication)application, archiveCol, "list", billId);
                if (wfmArchiveInfo == null) {
                    application.showMessage("\u6ca1\u6709\u6ee1\u8db3\u5f52\u6863\u6761\u4ef6\u7684\u5f52\u6863\u65b9\u6848\uff01");
                    return;
                }
                ArchiveHelper.checkPigePermission(ctx, curPersonId, wfmArchiveInfo);
                String templatePath = wfmArchiveInfo.getPrintPath().split(",")[0];
                String categoryId = wfmArchiveInfo.getCategoryPath().getId().toString();
                if (wfmArchiveInfo.getCategoryPath() != null && !wfmArchiveInfo.getCategoryPath().isIsArchive()) {
                    application.showMessage("\u8be5\u680f\u76ee\u6ca1\u6709\u8bbe\u7f6e\u4e3a\u5141\u8bb8\u5f52\u6863\uff01");
                    return;
                }
                if (workflowStatus != null && workflowStatus.equals(WorkflowStatus.archived.getValue() + "") && !wfmArchiveInfo.isIsAllowRePige()) {
                    application.showMessage("\u8be5\u6d41\u7a0b\u6a21\u677f\u4e0d\u5141\u8bb8\u91cd\u590d\u5f52\u6863\uff01");
                    return;
                }
                String title = objectValue.get("title").toString();
                ArchiveHelper.pige(ctx, (DynamicWebFormPanel)application.getListView(), objectValue, templatePath, categoryId);
                objectValue.put("title", (Object)title);
                if (workflowStatus != null && !workflowStatus.equals(WorkflowStatus.archived)) {
                    objectValue.put("workflowStatus", (Object)(WorkflowStatus.archived.getValue() + ""));
                    DynamicObjectFactory.getLocalInstance((Context)ctx).update(BOSUuid.read((String)billId).getType(), (IObjectPK)new ObjectUuidPK(billId), objectValue);
                    ArchiveHelper.updateDocInfoStatus(ctx, objectValue.getString("id"), WorkflowStatus.archived);
                }
                application.showMessage("\u5f52\u6863\u6210\u529f\uff01");
            }
            catch (DMArchiveException e) {
                if (DMArchiveException.ARCHIVEERROR.getCode().equals(e.getSubCode())) {
                    application.showMessage("\u5f52\u6863\u5f02\u5e38\uff08FTP\u670d\u52a1\u5668\u53ef\u80fd\u8fde\u63a5\u4e0d\u6b63\u5e38\uff01)");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info((Object)e.getMessage());
                String nonPermission = "";
                if (e.getMessage() != null && e.getMessage().startsWith("Non_Archive_Permission")) {
                    nonPermission = "(\u6ca1\u6709\u5f52\u6863\u6743\u9650)";
                }
                application.showMessage("\u5f52\u6863\u5931\u8d25\uff01" + nonPermission);
            }
        } else {
            application.showMessage("\u8be5\u5355\u636e\u5df2\u4e0d\u5b8c\u6574\uff08\u7f3a\u5931documentInfo\u8bb0\u5f55\uff09\uff01");
        }
    }

    private static WfmArchiveInfo filterConditions(DynamicFormApplication application, WfmArchiveCollection archiveCol, String billOrList, String billPk) {
        String startCondId = null;
        WfmArchiveInfo wfmArchiveInfo = null;
        block4: for (int i = 0; i < archiveCol.size(); ++i) {
            if (archiveCol.get(i).getArchiveSetEntry() == null) {
                wfmArchiveInfo = archiveCol.get(i);
                continue;
            }
            for (int j = 0; j < archiveCol.size(); ++j) {
                if (archiveCol.get(j).getArchiveSetEntry().getSeq() != i + 1) continue;
                startCondId = archiveCol.get(j).getArchiveSetEntry().getStartConditionID();
                FormCondition fc = null;
                if (billOrList.equals("list")) {
                    fc = ((ListApplication)application).getForm().getFormCondition(startCondId);
                } else if (billOrList.equals("bill")) {
                    fc = ((BillApplication)application).getForm().getFormCondition(startCondId);
                }
                if (fc == null || StringUtils.isEmpty((String)fc.getConditon())) {
                    wfmArchiveInfo = archiveCol.get(j);
                    break block4;
                }
                try {
                    String formId = application.getDynamicFormModel().getBusinessInfo().getForm().getId();
                    OpenBillParameter param = new OpenBillParameter();
                    param.setFormId(formId);
                    param.billPk = billPk;
                    param.billOperation = OperationStatus.VIEW;
                    BillApplicationHelper helper = BillApplicationHelper.getInstance((Context)application.getContext(), (OpenBillParameter)param, null);
                    BillApplication billApp = helper.newBillApplication();
                    helper.loadData(null);
                    IObjectValue objectValue = DAOHelper.getDAO().load(application.getContext(), billPk, application.getDynamicFormModel().getBusinessInfo().getSelector());
                    ExpressionEvaluator exprEvaluator = new ExpressionEvaluator((DynamicFormApplication)billApp, application.getDynamicFormModel().getBusinessInfo(), objectValue, fc.getConditon(), 0);
                    Object result = exprEvaluator.evaluate();
                    if (result == null || !(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue block4;
                    wfmArchiveInfo = archiveCol.get(j);
                    break block4;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    continue block4;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    continue block4;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue block4;
                }
            }
        }
        return wfmArchiveInfo;
    }

    public static boolean pigeonhole(BillApplication application, String billId) throws EASBizException, BOSException {
        Context ctx = application.getContext();
        IDocumentInfo iDoc = DocumentInfoFactory.getLocalInstance((Context)ctx);
        DocumentInfoCollection docCol = iDoc.getDocumentInfoCollection("select * where sourcePK = '" + billId + "'");
        if (docCol != null && docCol.size() > 0) {
            DocumentInfoInfo docInfo = docCol.get(0);
            IObjectValue objectValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(BOSUuid.read((String)billId).getType(), (IObjectPK)new ObjectUuidPK(billId));
            String workflowStatus = (String)objectValue.get("workflowStatus");
            if (!"2".equals(workflowStatus) && !"4".equals(workflowStatus)) {
                log.info((Object)"\u53ea\u6709\u5df2\u5b8c\u6210\u7684\u5355\u636e\u624d\u53ef\u4ee5\u5f52\u6863\uff01");
                return false;
            }
            String templateId = docInfo.getTemplateId();
            try {
                WfmArchiveCollection archiveCol = null;
                String oql = "select wfmTemplate.id,archivePath,printPath,isOverallCU,isAllowRePige,categoryPath.id,categoryPath.isArchive,pigeonholeScheme,archiveSetEntry.* where wfmTemplate.id='" + templateId + "'";
                archiveCol = WfmArchiveFactory.getLocalInstance(ctx).getWfmArchiveCollection(oql);
                if (archiveCol == null || archiveCol.size() == 0) {
                    String tempName = "";
                    String typeId = docInfo.getTemplateId();
                    if (typeId != null && !"".equals(typeId)) {
                        TemplateInfo tempInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(typeId.toString()));
                        tempName = tempInfo.getName();
                    }
                    log.info((Object)("\u8be5\u6d41\u7a0b\u6a21\u677f(" + tempName + ")\u6ca1\u6709\u5f52\u6863\u65b9\u6848\uff01"));
                    return false;
                }
                WfmArchiveInfo wfmArchiveInfo = ArchiveHelper.filterConditions((DynamicFormApplication)application, archiveCol, "bill", billId);
                if (wfmArchiveInfo == null) {
                    log.info((Object)"\u6ca1\u6709\u6ee1\u8db3\u5f52\u6863\u6761\u4ef6\u7684\u5f52\u6863\u65b9\u6848\uff01");
                    return false;
                }
                String templatePath = wfmArchiveInfo.getPrintPath().split(",")[0];
                String categoryId = wfmArchiveInfo.getCategoryPath().getId().toString();
                if (wfmArchiveInfo.getCategoryPath() != null && !wfmArchiveInfo.getCategoryPath().isIsArchive()) {
                    log.info((Object)"\u8be5\u680f\u76ee\u6ca1\u6709\u8bbe\u7f6e\u4e3a\u5141\u8bb8\u5f52\u6863\uff01");
                    return false;
                }
                if (workflowStatus != null && workflowStatus.equals(WorkflowStatus.archived.getValue() + "") && !wfmArchiveInfo.isIsAllowRePige()) {
                    log.info((Object)"\u8be5\u6d41\u7a0b\u6a21\u677f\u4e0d\u5141\u8bb8\u91cd\u590d\u5f52\u6863\uff01");
                    return false;
                }
                String title = objectValue.get("title").toString();
                ArchiveHelper.pige(ctx, (DynamicWebFormPanel)application.getBillView(), objectValue, templatePath, categoryId);
                objectValue.put("title", (Object)title);
                if (workflowStatus != null && !workflowStatus.equals(WorkflowStatus.archived)) {
                    objectValue.put("workflowStatus", (Object)(WorkflowStatus.archived.getValue() + ""));
                    DynamicObjectFactory.getLocalInstance((Context)ctx).update(BOSUuid.read((String)billId).getType(), (IObjectPK)new ObjectUuidPK(billId), objectValue);
                    ArchiveHelper.updateDocInfoStatus(ctx, objectValue.getString("id"), WorkflowStatus.archived);
                }
                log.info((Object)"\u5f52\u6863\u6210\u529f\uff01");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info((Object)e.getMessage());
                String nonPermission = "";
                if (e.getMessage() != null && e.getMessage().startsWith("Non_Archive_Permission")) {
                    nonPermission = "(\u6ca1\u6709\u5f52\u6863\u6743\u9650)";
                }
                log.info((Object)("\u5f52\u6863\u5931\u8d25\uff01" + nonPermission));
                return false;
            }
            return true;
        }
        return false;
    }

    private static void updateDocInfoStatus(Context ctx, String billId, WorkflowStatus workflowStatus) {
        try {
            IDocumentInfo iDocumentInfo = DocumentInfoFactory.getLocalInstance((Context)ctx);
            DocumentInfoInfo docInfo = iDocumentInfo.getDocumentInfoInfo("where sourcePK='" + billId + "'");
            docInfo.setWorkflowStatus(workflowStatus);
            ObjectUuidPK pk = new ObjectUuidPK(docInfo.getId().toString());
            iDocumentInfo.update((IObjectPK)pk, (CoreBaseInfo)docInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void pige(Context ctx, DynamicWebFormPanel webFormPanel, IObjectValue objectValue, String templatePath, String categoryId) throws Exception {
        int i;
        String billId = objectValue.get("id").toString();
        String workflowStatus = (String)objectValue.get("workflowStatus");
        log.info((Object)("ArchiveHelper:pige()-----------begin----billId = " + billId + ",workflowStatus = " + workflowStatus));
        if (workflowStatus != null && workflowStatus.equals("4")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String dateStr = "(" + sdf.format(new Date()) + ")";
            objectValue.put("title", (Object)(objectValue.get("title") + dateStr));
        }
        ArchiveDocumentParamsInfo paramsInfo = ArchiveHelper.contructParams(objectValue, categoryId);
        ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
        final Context context = ctx;
        KDNoteWebServerHelper webServerHelper = new KDNoteWebServerHelper();
        webServerHelper.setBosContext(ctx);
        webServerHelper.setContextProvider(new IContextProvider(){

            public IBizContext getBizContext(Context bosCtx) {
                IBizContext ctx = null;
                try {
                    ctx = KDNoteHelper.makeContext((Context)context);
                }
                catch (ConnectException e) {
                    log.error((Object)"get context error:", (Throwable)e);
                    return null;
                }
                return ctx;
            }
        });
        log.info((Object)("ArchiveHelper:pige()------webServerHelper.exportPDF()-----begin--billId = " + billId));
        webServerHelper.exportPDF(templatePath, ArchiveHelper.getDataProvider(webFormPanel, billId), (OutputStream)bodyStream);
        log.info((Object)("ArchiveHelper:pige()------webServerHelper.exportPDF()-----end,bodyStream.size = " + bodyStream.size()));
        ByteArrayInputStream bodyInputStream = new ByteArrayInputStream(bodyStream.toByteArray());
        log.info((Object)("ArchiveHelper:pige()------getAttachmentCollectionBy-----begin--billId = " + billId));
        com.kingdee.eas.base.attachment.AttachmentCollection attachmentList = ArchiveHelper.getAttachmentCollectionBy(billId, ctx);
        if (null != attachmentList) {
            log.info((Object)("ArchiveHelper:pige()------getAttachmentCollectionBy-----end--attachmentList.size = " + attachmentList.size()));
        } else {
            log.info((Object)"ArchiveHelper:pige()------getAttachmentCollectionBy-----end--attachmentList is null! ");
        }
        log.info((Object)("ArchiveHelper:pige()------getAttachmentCollection-----begin--billId = " + billId));
        AttachmentCollection officeList = com.kingdee.eas.base.form.extend.attachment.AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentCollection("where billId='" + billId + "' and attachmentType=" + 1);
        if (null != attachmentList) {
            log.info((Object)("ArchiveHelper:pige()------getAttachmentCollection-----end--officeList.size = " + officeList.size()));
        } else {
            log.info((Object)"ArchiveHelper:pige()------getAttachmentCollection-----end--officeList is null! ");
        }
        String title = "";
        int attachmentLength = attachmentList == null ? 0 : attachmentList.size();
        int officeLength = officeList == null ? 0 : officeList.size();
        InputStream[] historyStreams = ArchiveHelper.getOfficeHistory(ctx, billId);
        int historyLength = historyStreams == null ? 0 : historyStreams.length;
        int length = attachmentLength + officeLength + historyLength;
        InputStream[] fileStreams = new InputStream[length];
        String[] fileNames = new String[length];
        for (i = 0; i < attachmentLength; ++i) {
            if (attachmentList.get(i) != null && attachmentList.get(i).getFile() == null) {
                try {
                    byte[] files = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(attachmentList.get(i).getId().toString());
                    attachmentList.get(i).setFile(files);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
            if (null != attachmentList.get(i) && null != attachmentList.get(i).getFile()) {
                fileStreams[i] = new ByteArrayInputStream(attachmentList.get(i).getFile());
            }
            fileNames[i] = attachmentList.get(i).getName() + "." + attachmentList.get(i).getSimpleName();
        }
        while (i < length - historyLength) {
            title = officeList.get(i - attachmentLength).getName();
            fileStreams[i] = new ByteArrayInputStream(officeList.get(i - attachmentLength).getFileData());
            fileNames[i] = "Office\u6b63\u6587---" + title + "." + officeList.get(i - attachmentLength).getExtName();
            ++i;
        }
        int len = 0;
        while (i < length) {
            if (len < historyLength) {
                fileStreams[i] = historyStreams[len];
                fileNames[i] = title + "_\u8349\u7a3f" + (len + 1) + ".doc";
                ++len;
            }
            ++i;
        }
        ArchiveDocumentImpl arch = new ArchiveDocumentImpl();
        ArchiveResultInfo resInfo = arch.archiveDocument(ctx, paramsInfo, (InputStream)bodyInputStream, fileStreams, fileNames);
    }

    public static boolean isArchiveEnable(ListApplication application, String billId) throws EASBizException, BOSException {
        Context ctx = application.getContext();
        String userId = ContextUtil.getCurrentUserInfo((Context)application.getContext()).getId().toString();
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserByID((IObjectPK)new ObjectUuidPK(userId));
        String curPersonId = userInfo.getPerson().getId().toString();
        IDocumentInfo iDoc = DocumentInfoFactory.getLocalInstance((Context)ctx);
        DocumentInfoCollection docCol = iDoc.getDocumentInfoCollection("select * where sourcePK = '" + billId + "'");
        if (docCol != null && docCol.size() > 0) {
            DocumentInfoInfo docInfo = docCol.get(0);
            IObjectValue objectValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(BOSUuid.read((String)billId).getType(), (IObjectPK)new ObjectUuidPK(billId));
            String workflowStatus = (String)objectValue.get("workflowStatus");
            if (!"2".equals(workflowStatus)) {
                return false;
            }
            String templateId = docInfo.getTemplateId();
            WfmArchiveCollection archiveCol = null;
            String oql = "select wfmTemplate.id,archivePath,printPath,isOverallCU,isAllowRePige,categoryPath.id,categoryPath.isArchive where wfmTemplate.id='" + templateId + "'";
            if (!ArchiveHelper.isAllCUShared(ctx, templateId)) {
                TemplateInfo templateInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
                oql = oql + " and cu.id='" + templateInfo.getCU().getId().toString() + "'";
            }
            if ((archiveCol = WfmArchiveFactory.getLocalInstance(ctx).getWfmArchiveCollection(oql)) == null || archiveCol.size() == 0) {
                return false;
            }
            try {
                ArchiveHelper.checkPigePermission(ctx, curPersonId, archiveCol.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (workflowStatus != null && workflowStatus.equals("4")) {
                return false;
            }
        }
        return true;
    }

    public static boolean isArchiveEnable(ListApplication application, String[] billIds) throws EASBizException, BOSException {
        for (int i = 0; i < billIds.length; ++i) {
            if (ArchiveHelper.isArchiveEnable(application, billIds[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllCUShared(Context ctx, String templateId) {
        TemplateInfo templateInfo = null;
        try {
            templateInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return "eThjryu4wEKoEK1veu3ZzDUlqpQ=".equals(templateInfo.getCU().getId().toString());
    }

    private static com.kingdee.eas.base.attachment.AttachmentCollection getAttachmentCollectionBy(String billId, Context context) throws BOSException {
        com.kingdee.eas.base.attachment.AttachmentCollection attachmentCollection = null;
        IAttachment attachment = AttachmentFactory.getLocalInstance((Context)context);
        List webAttachList = ArchiveHelper.getAttachmentListBy(billId, context);
        if (webAttachList != null && webAttachList.size() > 0) {
            EntityViewInfo evi = ArchiveHelper.getEntityViewInfo4AttachmentInfo(webAttachList);
            attachmentCollection = attachment.getAttachmentCollection(evi);
        }
        return attachmentCollection;
    }

    private static List getAttachmentListBy(String billId, Context context) throws BOSException {
        IAttachmentHandleFacade attachHandler = AttachmentHandleFacadeFactory.getLocalInstance((Context)context);
        return attachHandler.getWebAttachment(billId);
    }

    private static EntityViewInfo getEntityViewInfo4AttachmentInfo(List attachments) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(ArchiveHelper.getAttachmentInfoFilter(attachments));
        evi.setSelector(ArchiveHelper.getAttachmentInfoSelector());
        return evi;
    }

    private static FilterInfo getAttachmentInfoFilter(List attachments) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ArchiveHelper.getAttachmentIds(attachments), CompareType.INCLUDE));
        return filter;
    }

    private static String getAttachmentIds(List attachments) {
        StringBuffer ids = new StringBuffer("");
        Iterator it = attachments.iterator();
        while (it.hasNext()) {
            ids.append(((WebAttachmentItem)it.next()).getId().toString());
            ids.append(",");
        }
        return ids.toString();
    }

    private static SelectorItemCollection getAttachmentInfoSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("creator.id"));
        selector.add(new SelectorItemInfo("creator.name"));
        selector.add(new SelectorItemInfo("lastUpdateUser.id"));
        selector.add(new SelectorItemInfo("lastUpdateUser.name"));
        return selector;
    }

    protected static String getTemplateCategory(String templatePath) {
        if (templatePath.endsWith(".r1-print")) {
            return "r1-print";
        }
        if (templatePath.endsWith(".kdrs-form")) {
            return "kdrs-form";
        }
        return null;
    }

    public static Object getDataProvider(DynamicWebFormPanel webFormPanel, String id) throws BOSException {
        DynamicFormPrintDataProvider provider = null;
        provider = webFormPanel.getPrintDataProvider();
        provider.setBillIds(new String[]{id});
        return provider;
    }

    private static ArchiveDocumentParamsInfo contructParams(IObjectValue model, String categoryId) {
        if (model == null) {
            return null;
        }
        ArchiveDocumentParamsInfo params = new ArchiveDocumentParamsInfo();
        params.setBizID(model.get("id").toString());
        params.setNumber((String)model.get("number"));
        params.setTitle((String)model.get("title"));
        params.setDocNumber((String)model.get("number"));
        params.setCreateTime((Timestamp)model.get("createtime"));
        params.setAuthor((PersonInfo)model.getObjectValue("proposer"));
        params.setMark("guidang");
        String doccontentid = model.getString("doccontentid");
        if (!StringUtils.isEmpty((String)doccontentid) && !"null".equals(doccontentid)) {
            params.setModuleName("odm");
        } else {
            params.setModuleName("wfm");
        }
        params.setVersion(" ");
        params.setArchive(true);
        params.setCategoryId(categoryId);
        params.setContentType(ContentTypeEnum.PDF);
        return params;
    }

    public static void checkPigePermission(Context ctx, String personId, WfmArchiveInfo wfmArchiveInfo) throws Exception {
        WfmArchiveArchivePersonCollection personCol = WfmArchiveArchivePersonFactory.getLocalInstance(ctx).getWfmArchiveArchivePersonCollection("select id,archivePerson.id where parent.id='" + wfmArchiveInfo.getId().toString() + "'");
        int n = personCol.size();
        for (int i = 0; i < n; ++i) {
            String pigePersonId = personCol.get(i).getArchivePerson().getId().toString();
            if (!personId.equals(pigePersonId)) continue;
            return;
        }
        throw new Exception("Non_Archive_Permission");
    }

    public static String getBarItemKeyByOperateName(ListApplication application, String operateName) {
        String barItemKey = "";
        boolean hasFound = false;
        Set allBarItemKeys = application.getListView().getAllBarItemKeys();
        for (int i = 0; !hasFound && i < allBarItemKeys.size(); ++i) {
            String barKey = allBarItemKeys.toArray()[i].toString();
            List actionList = application.getListView().getBarItemActionList(barKey);
            for (int j = 0; !hasFound && actionList != null && j < actionList.size(); ++j) {
                Action action = (Action)actionList.get(j);
                String[] params = action.getParameters();
                if (params == null || params.length <= 0 || !operateName.equals(params[0])) continue;
                barItemKey = barKey;
                hasFound = true;
            }
        }
        return barItemKey;
    }

    private static InputStream[] getOfficeHistory(Context ctx, String billId) throws EASBizException, BOSException, SQLException {
        IOfficeHistory iOfficeHistory = OfficeHistoryFactory.getLocalInstance((Context)ctx);
        OfficeHistoryCollection coll = iOfficeHistory.getOfficeHistoryCollection(ArchiveHelper.getFliterInfo(ctx, billId));
        InputStream[] inputStream = null;
        if (coll != null) {
            inputStream = new InputStream[coll.size()];
            for (int i = 0; i < coll.size(); ++i) {
                inputStream[i] = new ByteArrayInputStream(coll.get(i).getFileData());
            }
        }
        return inputStream;
    }

    private static EntityViewInfo getFliterInfo(Context ctx, String billId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Set set = ArchiveHelper.getAttachmentIds(ctx, billId, "FOFFICE");
        filterInfo.getFilterItems().add(new FilterItemInfo("attachmentId", (Object)set, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().clear();
        viewInfo.getSorter().add(sortInfo);
        return viewInfo;
    }

    private static Set getAttachmentIds(Context ctx, String billId, String officeKey) {
        HashSet<String> set = new HashSet<String>();
        StringBuffer sql = new StringBuffer("select FID from T_BAS_BillAttachment ");
        sql.append(" where FBillId='" + billId + "'");
        sql.append(" and FControlKey='" + officeKey + "'");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows != null) {
                while (rows.next()) {
                    set.add(rows.getString("FID"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return set;
    }
}

