/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoCollection;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoFactory;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoInfo;
import com.kingdee.eas.base.form.extend.flow.IDocumentInfo;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillApplicationHelper;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.assistant.TaxDataInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerKindEnum;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.EquipmentPropertyEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupDetialCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupDetialInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.mm.qm.utils.DateUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfm.WorkflowStatus;
import com.kingdee.eas.cp.wfm.bill.app.AbstractWFBillBaseControllerBean;
import com.kingdee.eas.cp.wfm.utils.ArchiveHelper;
import com.kingdee.eas.cp.wfm.utils.BasedataImportHelper;
import com.kingdee.eas.cp.wfm.utils.CommonUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class WFBillBaseControllerBean
extends AbstractWFBillBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.wfm.bill.app.WFBillBaseControllerBean");

    @Override
    protected void _setDraft(Context ctx, String billIDString) throws BOSException {
        try {
            this.setStatus(ctx, billIDString, WorkflowStatus.draft);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _setInApprove(Context ctx, String billIDString) throws BOSException {
        try {
            this.setStatus(ctx, billIDString, WorkflowStatus.inApprove);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _setPass(Context ctx, String billIDString) throws BOSException {
        try {
            this.setStatus(ctx, billIDString, WorkflowStatus.pass);
            this.saveFileCenterRecord(ctx, billIDString);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _setUnPass(Context ctx, String billIDString) throws BOSException {
        try {
            this.setStatus(ctx, billIDString, WorkflowStatus.unPass);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private void setStatus(Context ctx, String billID, WorkflowStatus workflowStatus) throws BOSException, EASBizException {
        System.out.println("$$$$$$$$$$$$$$$$$$^^^^^^^^^^^^^$$$$$$$$$:" + billID);
        if (billID != null && !billID.toString().equals("")) {
            IObjectValue objectValue = CommonUtil.loadObjectValue(ctx, billID);
            objectValue.put("workflowStatus", (Object)workflowStatus);
            objectValue.put("id", (Object)BOSUuid.read((String)billID));
            DynamicObjectFactory.getLocalInstance((Context)ctx).update(BOSUuid.read((String)billID).getType(), (IObjectPK)new ObjectUuidPK(billID), objectValue);
            DocumentInfoInfo docInfo = null;
            IDocumentInfo iDocument = DocumentInfoFactory.getLocalInstance((Context)ctx);
            DocumentInfoCollection docCol = iDocument.getDocumentInfoCollection("select id, sourcePK, workflowStatus,templateType.packageName where sourcePK='" + billID.toString() + "'");
            if (docCol.size() > 0) {
                docInfo = docCol.get(0);
                if (workflowStatus.getValue().equals("0")) {
                    docInfo.setWorkflowStatus(com.kingdee.eas.base.form.extend.flow.WorkflowStatus.draft);
                } else if (workflowStatus.getValue().equals("1")) {
                    docInfo.setWorkflowStatus(com.kingdee.eas.base.form.extend.flow.WorkflowStatus.inApprove);
                } else if (workflowStatus.getValue().equals("3")) {
                    docInfo.setApprovedTime(new Timestamp(System.currentTimeMillis()));
                    docInfo.setWorkflowStatus(com.kingdee.eas.base.form.extend.flow.WorkflowStatus.unPass);
                } else if (workflowStatus.getValue().equals("2")) {
                    docInfo.setApprovedTime(new Timestamp(System.currentTimeMillis()));
                    docInfo.setWorkflowStatus(com.kingdee.eas.base.form.extend.flow.WorkflowStatus.pass);
                    try {
                        if ("com.kingdee.eas.cp.odm".equalsIgnoreCase(docInfo.getTemplateType().getPackageName())) {
                            this.pushMessagToXt(ctx, billID.toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                iDocument.save((CoreBaseInfo)docInfo);
            }
        }
    }

    @Override
    protected boolean _archiveToDM(Context ctx, String billIDString) throws BOSException {
        boolean result = false;
        String formId = null;
        IDocumentInfo iDocument = DocumentInfoFactory.getLocalInstance((Context)ctx);
        DocumentInfoCollection docCol = iDocument.getDocumentInfoCollection("select id, sourcePK,formID where sourcePK='" + billIDString + "'");
        if (docCol != null && docCol.size() > 0) {
            formId = docCol.get(0).getFormID();
        }
        OpenBillParameter param = new OpenBillParameter();
        param.billOperation = OperationStatus.VIEW;
        param.billPk = billIDString;
        param.setFormId(formId);
        try {
            BillApplication application = BillApplicationHelper.getInstance((Context)ctx, (OpenBillParameter)param, null).newBillApplication();
            result = ArchiveHelper.pigeonhole(application, billIDString);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            result = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        if (result) {
            this.saveFileCenterRecord(ctx, billIDString);
        }
        return result;
    }

    @Override
    protected void _importMaterialData(Context ctx, String billidString, boolean materialCheck) throws BOSException {
        StringBuffer str = new StringBuffer(" select * from CT_WFM_Material1213_Entry1 ");
        str.append(" where fisaudit=2 and fcreatematerialresult!=1 and Fbill1ID='" + billidString + "'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            IObjectValue objectValue = CommonUtil.loadObjectValue(ctx, billidString);
            CtrlUnitInfo cu = (CtrlUnitInfo)objectValue.get("CU");
            this.saveMaterialInfo(ctx, rows, materialCheck, cu);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private void saveMaterialInfo(Context ctx, IRowSet rows, boolean materialCheck, CtrlUnitInfo cu) throws SQLException {
        if (rows == null) {
            return;
        }
        try {
            while (rows.next()) {
                String seqUnit;
                String volumnUnit;
                String weightUnit;
                String lengthUnit;
                String baseunitid;
                MaterialInfo materialInfo = new MaterialInfo();
                if (cu != null) {
                    materialInfo.setCU(cu);
                    materialInfo.setAdminCU(cu);
                }
                materialInfo.setNumber(rows.getString("fnumber"));
                materialInfo.setName(rows.getString("fname_l1"));
                materialInfo.setModel(rows.getString("fmodel"));
                materialInfo.setShortName(rows.getString("fsimplename"));
                materialInfo.setAlias(rows.getString("falias"));
                materialInfo.setHelpCode(rows.getString("fhelpcode"));
                materialInfo.setForeignname(rows.getString("fforeignname"));
                String groupid = rows.getString("fmaterialgroupid");
                if (!StringUtils.isEmpty((String)groupid) && !"null".equals(groupid)) {
                    materialInfo.setMaterialGroup(this.getMaterialGroupInfo(ctx, groupid));
                }
                if (!StringUtils.isEmpty((String)(baseunitid = rows.getString("fbaseunitid"))) && !"null".equals(baseunitid)) {
                    materialInfo.setBaseUnit(this.getMeasureUnitInfo(ctx, baseunitid));
                }
                String asstAttrTypeID = rows.getString("fassistattrid");
                materialInfo.setAssistAttr(this.getAsstAttrTypeInfo(ctx, asstAttrTypeID));
                String assistunit = rows.getString("fassistunitid");
                if (!StringUtils.isEmpty((String)assistunit) && !"null".equals(assistunit)) {
                    materialInfo.setAssistUnit(this.getMeasureUnitInfo(ctx, assistunit));
                }
                if (!StringUtils.isEmpty((String)(lengthUnit = rows.getString("fsequnitid"))) && !"null".equals(lengthUnit)) {
                    materialInfo.setLengthUnit(this.getMeasureUnitInfo(ctx, lengthUnit.trim()));
                }
                if (!StringUtils.isEmpty((String)(weightUnit = rows.getString("fweightUnitid"))) && !"null".equals(weightUnit)) {
                    materialInfo.setWeightUnit(this.getMeasureUnitInfo(ctx, weightUnit));
                }
                if (!StringUtils.isEmpty((String)(volumnUnit = rows.getString("fVolumnUnitid"))) && !"null".equals(volumnUnit)) {
                    materialInfo.setVolumnUnit(this.getMeasureUnitInfo(ctx, volumnUnit));
                }
                if (!StringUtils.isEmpty((String)(seqUnit = rows.getString("fsequenceunitid"))) && !"null".equals(seqUnit)) {
                    materialInfo.setSeqUnit(this.getMeasureUnitInfo(ctx, seqUnit));
                }
                materialInfo.setRegisteredmark(rows.getString("fregisteredmark"));
                materialInfo.setWarrantnumber(rows.getString("fwarrantnumber"));
                materialInfo.setPricePrecision(rows.getInt("fpriceprecision") == 0 ? 0 : rows.getInt("fpriceprecision") - 1);
                materialInfo.setBarCode(rows.getString("fbarCode"));
                materialInfo.setPictureNumber(rows.getString("fpictureNumber"));
                materialInfo.setEquipProperty(this.getEquipmentPropertyEnum(rows.getInt("fequipproperty")));
                materialInfo.setIsWeighted(rows.getBoolean("fisweighted"));
                materialInfo.setIsOutsourcedPart(rows.getBoolean("ffisoutsourcedpart"));
                materialInfo.setUseAsstAttrRelation(rows.getBoolean("fuseasstattrrelation"));
                materialInfo.setStatus(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED);
                BigDecimal zero = new BigDecimal(0);
                BigDecimal length = rows.getBigDecimal("flength");
                materialInfo.setLength(zero.compareTo(length) == 0 ? null : length);
                BigDecimal width = rows.getBigDecimal("fwidth");
                materialInfo.setWidth(zero.compareTo(width) == 0 ? null : width);
                BigDecimal height = rows.getBigDecimal("fheight");
                materialInfo.setHeight(zero.compareTo(height) == 0 ? null : height);
                BigDecimal grossweight = rows.getBigDecimal("fgrossweight");
                materialInfo.setGrossWeight(zero.compareTo(grossweight) == 0 ? null : grossweight);
                BigDecimal netweight = rows.getBigDecimal("fnetweight");
                materialInfo.setNetWeight(zero.compareTo(netweight) == 0 ? null : netweight);
                BigDecimal volume = rows.getBigDecimal("fvolume");
                materialInfo.setVolume(zero.compareTo(volume) == 0 ? null : volume);
                materialInfo.setEffectedStatus(2);
                materialInfo.setId(BOSUuid.create((String)"4409E7F0"));
                if (materialCheck) {
                    materialInfo.setStatus(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED);
                } else {
                    materialInfo.setStatus(com.kingdee.eas.basedata.master.material.UsedStatusEnum.UNAPPROVE);
                }
                materialInfo.put("materialGroupDetails", (Object)this.getMaterialGroupDetialCollection(ctx, rows.getString("fid")));
                this.saveMaterialInfo(ctx, materialInfo, rows.getString("fid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private MaterialGroupDetialCollection getMaterialGroupDetialCollection(Context ctx, String materialBillId) {
        MaterialGroupDetialCollection mgColl = new MaterialGroupDetialCollection();
        StringBuffer str = new StringBuffer(" select fdynprop02id,fdynprop03 from CT_WFM_MaterialMateri_Entry1 ");
        str.append(" where fbill2id='" + materialBillId + "'");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            String mgDetailID = "";
            String mgStandardID = "";
            while (rows.next()) {
                mgDetailID = rows.getString("fdynprop02id");
                mgStandardID = rows.getString("fdynprop03");
                if (mgDetailID == null || "".equals(mgDetailID.trim())) continue;
                MaterialGroupDetialInfo mgdInfo = new MaterialGroupDetialInfo();
                MaterialGroupStandardInfo standardInfo = new MaterialGroupStandardInfo();
                standardInfo.setId(BOSUuid.read((String)mgStandardID));
                mgdInfo.setMaterialGroupStandard(standardInfo);
                MaterialGroupInfo item = new MaterialGroupInfo();
                item.setId(BOSUuid.read((String)mgDetailID));
                mgdInfo.setMaterialGroup(item);
                mgColl.add(mgdInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return mgColl;
    }

    private EquipmentPropertyEnum getEquipmentPropertyEnum(int value) {
        if (value == 0) {
            return EquipmentPropertyEnum.EQUIPMENT;
        }
        if (value == 1) {
            return EquipmentPropertyEnum.SPARE_PART;
        }
        if (value == 2) {
            return EquipmentPropertyEnum.TOOL;
        }
        return EquipmentPropertyEnum.DEFAULT;
    }

    private boolean saveMaterialInfo(Context ctx, MaterialInfo info, String fid) {
        boolean flag = false;
        try {
            MaterialFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)info);
            this.saveMaterialAttachment(ctx, info.getId().toString(), fid);
            try {
                this.updateStatus(ctx, fid, info.getId().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (EASBizException e) {
            this.saveErrorMsg(ctx, e.getMessage(), fid);
            e.printStackTrace();
        }
        catch (BOSException e) {
            this.saveErrorMsg(ctx, e.getMessage(), fid);
            e.printStackTrace();
        }
        catch (Exception e) {
            this.saveErrorMsg(ctx, e.getMessage(), fid);
            e.printStackTrace();
        }
        return flag;
    }

    private boolean saveMaterialAttachment(Context ctx, String billID, String fid) {
        boolean result = false;
        StringBuffer str = new StringBuffer();
        str.append("select bo.fid,bo.fboid,att.fid as attachmentid,att.fcreatetime,att.fname_l2 ");
        str.append("from T_BAS_BoAttchAsso bo ,t_bas_attachment att ");
        str.append("where bo.fboid =  '" + fid + "' ");
        str.append("and bo.fattachmentid = att.fid ");
        str.append("order by att.fcreatetime desc ");
        String attchID = "";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            boolean needPic = true;
            while (rows.next()) {
                attchID = rows.getString("attachmentid");
                IAttachment attach = AttachmentFactory.getLocalInstance((Context)ctx);
                AttachmentInfo sourceAttach = attach.getAttachmentInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)attchID)));
                AttachmentInfo ai = new AttachmentInfo();
                if (needPic && ("jpg".equalsIgnoreCase(sourceAttach.getSimpleName()) || "png".equalsIgnoreCase(sourceAttach.getSimpleName()) || "gif".equalsIgnoreCase(sourceAttach.getSimpleName()))) {
                    ai.setNumber("picture");
                    needPic = false;
                } else {
                    ai.setNumber(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(DateUtils.now()));
                }
                ai.setFile(sourceAttach.getFile());
                ai.setIsShared(sourceAttach.isIsShared());
                ai.setName(sourceAttach.getName());
                ai.setSharedDesc(sourceAttach.getSharedDesc());
                ai.setSimpleName(sourceAttach.getSimpleName());
                ai.setType(sourceAttach.getType());
                ai.setSize(sourceAttach.getSize());
                ai.setSizeInByte(sourceAttach.getSizeInByte());
                ai.setShareRange(sourceAttach.getShareRange());
                ai.setAttachID(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(DateUtils.now()));
                ai.getBoAttchAsso().add(WFBillBaseControllerBean.makeBoAttchAssoInfo(billID));
                ai.setBeizhu(sourceAttach.getBeizhu());
                attach.addnew(ai);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static BoAttchAssoInfo makeBoAttchAssoInfo(String boID) {
        BoAttchAssoInfo baai = new BoAttchAssoInfo();
        baai.setBoID(boID);
        baai.setAssoType(Resrcs.getString((String)"NewAttachment"));
        baai.setAssoBusObjType(BOSUuid.read((String)boID).getType().toString());
        return baai;
    }

    private void updateStatus(Context ctx, String fid, String targetMaterialID) {
        StringBuffer str = new StringBuffer(" update CT_WFM_Material1213_Entry1 set fcreatematerialresult=1,fcreateMaterialnote='',FtargetMaterialID='" + targetMaterialID + "' where fid='" + fid + "'");
        try {
            DbUtil.execute((Context)ctx, (String)str.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void saveErrorMsg(Context ctx, String msg, String fid) {
        if (!StringUtils.isEmpty((String)msg) && msg.length() > 50) {
            msg = msg.substring(0, 50);
        }
        StringBuffer str = new StringBuffer(" update CT_WFM_Material1213_Entry1 set fcreatematerialresult=2,fcreateMaterialnote='" + msg + "' where fid='" + fid + "'");
        try {
            DbUtil.execute((Context)ctx, (String)str.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private MaterialGroupInfo getMaterialGroupInfo(Context ctx, String pkid) {
        MaterialGroupInfo materialGroupInfo = null;
        try {
            try {
                materialGroupInfo = MaterialGroupFactory.getLocalInstance((Context)ctx).getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(pkid));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return materialGroupInfo;
    }

    private MeasureUnitInfo getMeasureUnitInfo(Context ctx, String pkid) {
        MeasureUnitInfo measureUnitInfo = null;
        try {
            try {
                measureUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(pkid));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return measureUnitInfo;
    }

    private AsstAttrTypeInfo getAsstAttrTypeInfo(Context ctx, String pkid) {
        AsstAttrTypeInfo item = null;
        if (!StringUtils.isEmpty((String)pkid) && !"null".equals(pkid)) {
            try {
                item = AsstAttrTypeFactory.getLocalInstance((Context)ctx).getAsstAttrTypeInfo((IObjectPK)new ObjectUuidPK(pkid));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return item;
    }

    @Override
    protected void _importCustomerData(Context ctx, String billID, boolean customerCheck) throws BOSException {
        StringBuffer str = new StringBuffer(" select * from CT_WFM_CustomerMainKD_Entry1 ");
        str.append(" where fisaudit=2 and fCreateCustomerResult!=1 and Fbill1ID='" + billID + "'");
        boolean result = false;
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            if (rows.size() == 0) {
                result = true;
            }
            IObjectValue objectValue = CommonUtil.loadObjectValue(ctx, billID);
            CtrlUnitInfo cu = (CtrlUnitInfo)objectValue.get("CU");
            while (rows.next()) {
                if (!this.saveCustomerInfo(ctx, rows, customerCheck, cu)) continue;
                result = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (!result) {
            throw new BOSException("\u751f\u6210\u5ba2\u6237\u4e3b\u6570\u636e\u5931\u8d25");
        }
    }

    private boolean saveCustomerInfo(Context ctx, IRowSet rows, boolean customerCheck, CtrlUnitInfo cu) {
        boolean result = false;
        try {
            String fid = rows.getString("fid");
            CustomerInfo si = this.translate2CustomerInfo(ctx, rows, customerCheck, cu);
            try {
                BasedataImportHelper.importCustomer(ctx, si);
                result = true;
                this.saveMaterialAttachment(ctx, si.getId().toString(), fid);
                try {
                    StringBuffer str = new StringBuffer(" update CT_WFM_CustomerMainKD_Entry1 set fCreateCustomerResult=1,fCreateCustomerNote='',FtargetCustomerID='" + si.getId().toString() + "' where fid='" + fid + "'");
                    this.updateBill(ctx, str.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (!StringUtils.isEmpty((String)msg) && msg.length() > 50) {
                    msg = msg.substring(0, 50);
                }
                StringBuffer str = new StringBuffer(" update CT_WFM_CustomerMainKD_Entry1 set fCreateCustomerResult=2,fCreateCustomerNote='" + msg + "' where fid='" + fid + "'");
                this.updateBill(ctx, str.toString());
                e.printStackTrace();
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    @Override
    protected void _importSupplierData(Context ctx, String billID, boolean supplierCheck) throws BOSException {
        StringBuffer str = new StringBuffer(" select * from CT_WFM_SupplierKD_Entry1 ");
        str.append(" where fisaudit=2 and fCreateSupplierResult!=1 and Fbill1ID='" + billID + "'");
        boolean result = false;
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            if (rows.size() == 0) {
                result = true;
            }
            IObjectValue objectValue = CommonUtil.loadObjectValue(ctx, billID);
            CtrlUnitInfo cu = (CtrlUnitInfo)objectValue.get("CU");
            cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cu.getId()));
            while (rows.next()) {
                if (!this.saveSupplierInfo(ctx, rows, supplierCheck, cu)) continue;
                result = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (!result) {
            throw new BOSException("\u751f\u6210\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5931\u8d25");
        }
    }

    private boolean saveSupplierInfo(Context ctx, IRowSet rows, boolean supplierCheck, CtrlUnitInfo cu) {
        boolean result = false;
        try {
            String fid = rows.getString("fid");
            SupplierInfo si = this.translate2SupplieInfo(ctx, rows, supplierCheck, cu);
            try {
                BasedataImportHelper.importSupplier(ctx, si);
                result = true;
                this.saveMaterialAttachment(ctx, si.getId().toString(), fid);
                try {
                    StringBuffer str = new StringBuffer(" update CT_WFM_SupplierKD_Entry1 set fCreateSupplierResult=1,fCreateSupplierNote='',FtargetSupplierID='" + si.getId().toString() + "' where fid='" + fid + "'");
                    this.updateBill(ctx, str.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (!StringUtils.isEmpty((String)msg) && msg.length() > 50) {
                    msg = msg.substring(0, 50);
                }
                StringBuffer str = new StringBuffer(" update CT_WFM_SupplierKD_Entry1 set fCreateSupplierResult=2,fCreateSupplierNote='" + msg + "' where fid='" + fid + "'");
                this.updateBill(ctx, str.toString());
                e.printStackTrace();
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    private void updateBill(Context ctx, String sql) {
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private SupplierGroupDetailCollection getSupplierGroupDetailCollection(Context ctx, String billID) {
        SupplierGroupDetailCollection mgColl = new SupplierGroupDetailCollection();
        StringBuffer str = new StringBuffer(" select FBrowseGroupClassifyID,FEntryStandardID,FBrowseGroupClassifyName from CT_WFM_SupplierKDEntr_Entry1 ");
        str.append(" where fbill2id='" + billID + "'");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            String mgDetailID = "";
            String mgStandardID = "";
            while (rows.next()) {
                mgDetailID = rows.getString("FBrowseGroupClassifyID");
                mgStandardID = rows.getString("FEntryStandardID");
                if (StringUtils.isEmpty((String)mgDetailID)) continue;
                SupplierGroupDetailInfo info = new SupplierGroupDetailInfo();
                CSSPGroupStandardInfo standardInfo = new CSSPGroupStandardInfo();
                standardInfo.setId(BOSUuid.read((String)mgStandardID));
                info.setSupplierGroupStandard(standardInfo);
                CSSPGroupInfo item = new CSSPGroupInfo();
                item.setId(BOSUuid.read((String)mgDetailID));
                info.setSupplierGroup(item);
                info.setSupplierGroupFullName(rows.getString("FBrowseGroupClassifyName"));
                mgColl.add(info);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return mgColl;
    }

    private SupplierInfo translate2SupplieInfo(Context ctx, IRowSet rows, boolean supplierCheck, CtrlUnitInfo cu) {
        SupplierInfo si;
        block17: {
            si = null;
            if (rows != null) {
                si = new SupplierInfo();
                BigDecimal zero = new BigDecimal(0);
                try {
                    IndustryInfo item;
                    BigDecimal taxRate;
                    if (cu != null) {
                        si.setCU(cu);
                        si.setAdminCU(cu);
                    }
                    si.setNumber(rows.getString("fnumber"));
                    si.setName(rows.getString("fname_l2"));
                    si.setIsInternalCompany(rows.getBoolean("FIsInternalCompany"));
                    if (!StringUtils.isEmpty((String)rows.getString("FInternalCompanyID"))) {
                        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
                        companyOrgUnitInfo.setId(BOSUuid.read((String)rows.getString("FInternalCompanyID")));
                        si.setInternalCompany(companyOrgUnitInfo);
                    }
                    si.setSimpleName(rows.getString("FSimpleName"));
                    si.setForeignName(rows.getString("FForeignName"));
                    si.setMnemonicCode(rows.getString("FMnemonicCode"));
                    si.setArtificialPerson(rows.getString("FArtificialPerson"));
                    si.setTaxRegisterNo(rows.getString("FTaxRegisterNo"));
                    si.setBizRegisterNo(rows.getString("FBizRegisterNo"));
                    si.setBusiExequatur(rows.getString("FBusiExequatur"));
                    si.setBusiLicence(rows.getString("FBusiLicence"));
                    if (!StringUtils.isEmpty((String)rows.getString("FTaxDataID"))) {
                        TaxDataInfo item2 = new TaxDataInfo();
                        item2.setId(BOSUuid.read((String)rows.getString("FTaxDataID")));
                        si.setTaxData(item2);
                    }
                    si.setTaxRate((taxRate = rows.getBigDecimal("FTaxRate")) == null || zero.compareTo(taxRate) == 0 ? null : taxRate);
                    si.setGSPAuthentication(rows.getString("FGSPAuthentication"));
                    si.setBarCode(rows.getString("FBarCode"));
                    if (!StringUtils.isEmpty((String)rows.getString("FIndustryID"))) {
                        item = new IndustryInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FIndustryID")));
                        si.setIndustry(item);
                    }
                    if (!StringUtils.isEmpty((String)rows.getString("FCountryID"))) {
                        item = new CountryInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FCountryID")));
                        si.setCountry((CountryInfo)item);
                    }
                    if (!StringUtils.isEmpty((String)rows.getString("FCityID"))) {
                        item = new CityInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FCityID")));
                        si.setCity((CityInfo)item);
                    }
                    if (!StringUtils.isEmpty((String)rows.getString("FProvinceID"))) {
                        item = new ProvinceInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FProvinceID")));
                        si.setProvince((ProvinceInfo)item);
                    }
                    if (!StringUtils.isEmpty((String)rows.getString("FRegionIID"))) {
                        item = new RegionInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FRegionIID")));
                        si.setRegion((RegionInfo)item);
                    }
                    si.setAddress(rows.getString("FAddress"));
                    si.setIsCarrier(rows.getBoolean("FIsCarrier"));
                    si.setIsOuter(rows.getBoolean("FIsOuter"));
                    si.setEffectedStatus(EffectedStatusEnum.EFFECTED);
                    si.setId(BOSUuid.create((String)"37C67DFC"));
                    if (supplierCheck) {
                        si.setUsedStatus(UsedStatusEnum.APPROVED);
                    } else {
                        si.setUsedStatus(UsedStatusEnum.UNAPPROVE);
                    }
                    SupplierGroupDetailCollection coll = this.getSupplierGroupDetailCollection(ctx, rows.getString("fid"));
                    si.put("supplierGroupDetails", (Object)coll);
                    CSSPGroupStandardInfo groupInfo = null;
                    if (coll == null) break block17;
                    int size = coll.size();
                    for (int n = 0; n < size; ++n) {
                        try {
                            groupInfo = CSSPGroupStandardFactory.getLocalInstance((Context)ctx).getCSSPGroupStandardInfo("select * where id ='" + coll.get(n).getSupplierGroupStandard().getId() + "'");
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                        if (groupInfo == null || !StandardTypeEnum.basicStandard.equals((Object)groupInfo.getIsBasic())) continue;
                        si.setBrowseGroup(coll.get(n).getSupplierGroup());
                        break;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return si;
    }

    private CustomerInfo translate2CustomerInfo(Context ctx, IRowSet rows, boolean supplierCheck, CtrlUnitInfo cu) {
        CustomerInfo si;
        block17: {
            si = null;
            if (rows != null) {
                si = new CustomerInfo();
                BigDecimal zero = new BigDecimal(0);
                try {
                    BigDecimal taxRate;
                    IndustryInfo item;
                    if (cu != null) {
                        si.setCU(cu);
                        si.setAdminCU(cu);
                    }
                    si.setNumber(rows.getString("fnumber"));
                    si.setName(rows.getString("fname_l2"));
                    si.setIsInternalCompany(rows.getBoolean("FIsInternalCompany"));
                    if (!StringUtils.isEmpty((String)rows.getString("FInternalCompanyID"))) {
                        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
                        companyOrgUnitInfo.setId(BOSUuid.read((String)rows.getString("FInternalCompanyID")));
                        si.setInternalCompany(companyOrgUnitInfo);
                    }
                    si.setSimpleName(rows.getString("FSimpleName"));
                    si.setForeignName(rows.getString("FForeignName"));
                    si.setMnemonicCode(rows.getString("FMnemonicCode"));
                    si.setCustomerKind(CustomerKindEnum.getEnum((String)rows.getString("FCustomerKind")));
                    si.setBizRegisterNo(rows.getString("FBizRegisterNo"));
                    si.setBusiLicence(rows.getString("FBusiLicence"));
                    si.setBusiExequatur(rows.getString("FBusiExequatur"));
                    si.setGSPAuthentication(rows.getString("FGSPAuthentication"));
                    si.setTaxRegisterNo(rows.getString("FTxRegisterNo"));
                    si.setArtificialPerson(rows.getString("FArtificialPerson"));
                    if (!StringUtils.isEmpty((String)rows.getString("FIndustryID"))) {
                        item = new IndustryInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FIndustryID")));
                        si.setIndustry(item);
                    }
                    si.setBarCode(rows.getString("FBarCode"));
                    if (!StringUtils.isEmpty((String)rows.getString("FCountryID"))) {
                        item = new CountryInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FCountryID")));
                        si.setCountry((CountryInfo)item);
                    }
                    if (!StringUtils.isEmpty((String)rows.getString("FProvinceID"))) {
                        item = new ProvinceInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FProvinceID")));
                        si.setProvince((ProvinceInfo)item);
                    }
                    if (!StringUtils.isEmpty((String)rows.getString("FCityID"))) {
                        item = new CityInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FCityID")));
                        si.setCity((CityInfo)item);
                    }
                    if (!StringUtils.isEmpty((String)rows.getString("FRegionID"))) {
                        item = new RegionInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FRegionID")));
                        si.setRegion((RegionInfo)item);
                    }
                    if (!StringUtils.isEmpty((String)rows.getString("FTaxDataID"))) {
                        item = new TaxDataInfo();
                        item.setId(BOSUuid.read((String)rows.getString("FTaxDataID")));
                        si.setTaxData((TaxDataInfo)item);
                    }
                    si.setTaxRate((taxRate = rows.getBigDecimal("FTaxRate")) == null || zero.compareTo(taxRate) == 0 ? null : taxRate);
                    si.setAddress(rows.getString("FAddress"));
                    si.setEffectedStatus(EffectedStatusEnum.EFFECTED);
                    si.setIsCredited(rows.getBoolean("FIsCredited"));
                    si.setInvoiceType(PayInvoiceTypeEnum.getEnum((String)rows.getString("FInvoiceType")));
                    si.setId(BOSUuid.create((String)"BF0C040E"));
                    if (supplierCheck) {
                        si.setUsedStatus(UsedStatusEnum.APPROVED);
                    } else {
                        si.setUsedStatus(UsedStatusEnum.UNAPPROVE);
                    }
                    CustomerGroupDetailCollection coll = this.getCustomerGroupDetailCollection(ctx, rows.getString("fid"));
                    si.put("customerGroupDetails", (Object)coll);
                    CSSPGroupStandardInfo groupInfo = null;
                    if (coll == null) break block17;
                    int size = coll.size();
                    for (int n = 0; n < size; ++n) {
                        try {
                            groupInfo = CSSPGroupStandardFactory.getLocalInstance((Context)ctx).getCSSPGroupStandardInfo("select * where id ='" + coll.get(n).getCustomerGroupStandard().getId() + "'");
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                        if (groupInfo == null || !StandardTypeEnum.basicStandard.equals((Object)groupInfo.getIsBasic())) continue;
                        si.setBrowseGroup(coll.get(n).getCustomerGroup());
                        break;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return si;
    }

    private CustomerGroupDetailCollection getCustomerGroupDetailCollection(Context ctx, String billID) {
        CustomerGroupDetailCollection mgColl = new CustomerGroupDetailCollection();
        StringBuffer str = new StringBuffer(" select fBrowseGroupClassifyID,FEntryStandardID,fBrowseGroupClassifyName from CT_WFM_CustomerMainKD_Entry2 ");
        str.append(" where fbill2id='" + billID + "'");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            String mgDetailID = "";
            String mgStandardID = "";
            while (rows.next()) {
                mgDetailID = rows.getString("fBrowseGroupClassifyID");
                mgStandardID = rows.getString("FEntryStandardID");
                if (StringUtils.isEmpty((String)mgDetailID)) continue;
                CustomerGroupDetailInfo info = new CustomerGroupDetailInfo();
                CSSPGroupStandardInfo standardInfo = new CSSPGroupStandardInfo();
                standardInfo.setId(BOSUuid.read((String)mgStandardID));
                info.setCustomerGroupStandard(standardInfo);
                CSSPGroupInfo item = new CSSPGroupInfo();
                item.setId(BOSUuid.read((String)mgDetailID));
                info.setCustomerGroup(item);
                info.setCustomerGroupFullName(rows.getString("fBrowseGroupClassifyName"));
                mgColl.add(info);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return mgColl;
    }

    @Override
    protected void _recoverCodingHistory(Context ctx, String billIDString) throws BOSException {
        Class<?> cls = null;
        try {
            cls = Class.forName("com.kingdee.eas.cp.odm.app.CodingHistoryControllerBean");
            Object obj = cls.newInstance();
            Method setConextMethod = cls.getMethod("recoverCodingHistory", Context.class, String.class);
            setConextMethod.invoke(obj, ctx, billIDString);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _odmBotp(Context ctx, String destBillIds) throws BOSException {
        if (StringUtils.isEmpty((String)destBillIds) || "null".equals(destBillIds)) {
            return;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName("com.kingdee.eas.cp.odm.app.OdmBotpFacadeControllerBean");
            Object obj = cls.newInstance();
            Method setConextMethod = cls.getMethod("odmBotp", Context.class, String.class);
            setConextMethod.invoke(obj, ctx, destBillIds);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean _updateBill(Context ctx, String billIDString, String key1, String varPro1, String key2, Date varPro2, String key3, BOSUuid varPro3) throws BOSException {
        if (!StringUtils.isEmpty((String)billIDString)) {
            boolean needupdate = false;
            try {
                IObjectValue objectValue = CommonUtil.loadObjectValue(ctx, billIDString);
                objectValue.put("id", (Object)BOSUuid.read((String)billIDString));
                String propertyName = null;
                if (!StringUtils.isEmpty((String)key1) && !StringUtils.isEmpty((String)(propertyName = this.getFieldPropertyNameByKey(ctx, billIDString, key1)))) {
                    objectValue.put(propertyName, (Object)varPro1);
                    needupdate = true;
                }
                if (!StringUtils.isEmpty((String)key2) && !StringUtils.isEmpty((String)(propertyName = this.getFieldPropertyNameByKey(ctx, billIDString, key2)))) {
                    Timestamp ts = null;
                    if (varPro2 != null) {
                        ts = new Timestamp(varPro2.getTime());
                    }
                    objectValue.put(propertyName, ts);
                    needupdate = true;
                }
                if (!StringUtils.isEmpty((String)key3) && !StringUtils.isEmpty((String)(propertyName = this.getFieldPropertyNameByKey(ctx, billIDString, key3)))) {
                    IObjectValue info = null;
                    if (varPro3 != null) {
                        info = CommonUtil.loadObjectValue(ctx, varPro3.toString());
                    }
                    objectValue.put(propertyName, info);
                    needupdate = true;
                }
                if (!needupdate) {
                    return true;
                }
                DynamicObjectFactory.getLocalInstance((Context)ctx).update(BOSUuid.read((String)billIDString).getType(), (IObjectPK)new ObjectUuidPK(billIDString), objectValue);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private String getFieldPropertyNameByKey(Context ctx, String billIDString, String key) {
        String sql = "select formField.FpropertyName as FpropertyName from t_bas_documentinfo docInfo,t_bas_formfield formField where docInfo.FSourcePk = '" + billIDString + "' and formField.fkey = '" + key + "' and docInfo.FFormID = formField.FFormID";
        logger.info((Object)("WFBillBase log:::::+" + sql));
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                return rowSet.getString("FpropertyName");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected boolean _passAssignment(Context ctx, String destBillId, String sendNote, boolean sendMessage, boolean sendMail) throws BOSException {
        boolean result = true;
        Class<?> cls = null;
        try {
            cls = Class.forName("com.kingdee.eas.cp.odm.util.SelectBillPassPersonUtil");
            Object obj = cls.newInstance();
            Method setConextMethod = cls.getMethod("passAssignment", Context.class, String.class, String.class, Boolean.class, Boolean.class);
            setConextMethod.invoke(obj, ctx, destBillId, sendNote, new Boolean(sendMessage), new Boolean(sendMail));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void saveFileCenterRecord(Context ctx, String billId) {
        if (StringUtils.isEmpty((String)billId) || "null".equals(billId)) {
            return;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName("com.kingdee.eas.cp.odm.app.OdmFacadeControllerBean");
            Object obj = cls.newInstance();
            Method setConextMethod = cls.getMethod("saveFileCenterRecord", Context.class, String.class);
            setConextMethod.invoke(obj, ctx, billId);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("saveFileCenterRecord is ClassNotFoundException error:" + e));
        }
        catch (InstantiationException e) {
            logger.error((Object)("saveFileCenterRecord is InstantiationException error:" + e));
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("saveFileCenterRecord is IllegalAccessException error:" + e));
        }
        catch (SecurityException e) {
            logger.error((Object)("saveFileCenterRecord is SecurityException error:" + e));
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("saveFileCenterRecord is NoSuchMethodException error:" + e));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("saveFileCenterRecord is IllegalArgumentException error:" + e));
        }
        catch (InvocationTargetException e) {
            logger.error((Object)("saveFileCenterRecord is InvocationTargetException error:" + e));
        }
    }

    private void pushMessagToXt(Context ctx, String billId) {
        if (StringUtils.isEmpty((String)billId) || "null".equals(billId)) {
            return;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName("com.kingdee.eas.cp.odm.app.OdmFacadeControllerBean");
            Object obj = cls.newInstance();
            Method setConextMethod = cls.getMethod("pushMessagToXt", Context.class, String.class);
            setConextMethod.invoke(obj, ctx, billId);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("pushMessagToXt is ClassNotFoundException error:" + e));
        }
        catch (InstantiationException e) {
            logger.error((Object)("pushMessagToXt is InstantiationException error:" + e));
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("pushMessagToXt is IllegalAccessException error:" + e));
        }
        catch (SecurityException e) {
            logger.error((Object)("pushMessagToXt is SecurityException error:" + e));
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("pushMessagToXt is NoSuchMethodException error:" + e));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("pushMessagToXt is IllegalArgumentException error:" + e));
        }
        catch (InvocationTargetException e) {
            logger.error((Object)("pushMessagToXt is InvocationTargetException error:" + e));
        }
    }
}

