/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.extend.flow.ITemplate;
import com.kingdee.eas.base.form.extend.flow.TemplateCollection;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryCollection;
import com.kingdee.eas.ep.CoreBillBaseCustomInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public abstract class AbstractMainBillPlugin
extends AbstractBillPlugin {
    protected String entryFormID;
    protected String entryTemplateID;
    protected String billType;
    protected String approveUrl = "/easweb/cp/wfm/materialAuditEdit.jsf";
    protected static final String TEMPLATE_ID = "flowTempId";
    protected String nodeId;
    protected String flowId;
    protected boolean isAddNew = false;
    protected String operationAddEntry = "addEntry";
    protected String operationInsertEntry = "insertEntry";
    protected String operationEditEntry = "editEntry";
    protected String operationDeleteEntry = "deleteEntry";
    protected String operationViewEntry = "viewEntry";
    protected String operationApproveEntry = "approve";
    protected String operationDisapproveEntry = "disapprove";
    protected String entriesKey = "Fentries";

    protected abstract void initParams();

    public boolean beforeCustomOperation(String operation) throws EASBizException, BOSException {
        int num;
        if (this.operationAddEntry.equals(operation) || this.operationInsertEntry.equals(operation)) {
            return this.verifyModel();
        }
        if ((this.operationAddEntry.equals(operation) || this.operationInsertEntry.equals(operation) || this.operationEditEntry.equals(operation) || this.operationDeleteEntry.equals(operation) || this.operationViewEntry.equals(operation) || this.operationApproveEntry.equals(operation) || this.operationDisapproveEntry.equals(operation)) && StringUtils.isEmpty((String)this.entryTemplateID)) {
            this.application.showMessage("\u672a\u627e\u5230\u5168\u5c40\u5171\u4eab\u7684\u660e\u7ec6\u5355\u636e,\u8bf7\u5148\u53d1\u5e03\u5168\u5c40\u5171\u4eab\u7684\u660e\u7ec6\u5355\u636e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            return false;
        }
        if ((this.operationEditEntry.equals(operation) || this.operationDeleteEntry.equals(operation) || this.operationApproveEntry.equals(operation) || this.operationDisapproveEntry.equals(operation)) && (num = this.application.getBillView().getSelectedRow(this.entriesKey)) == -1) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002");
            return false;
        }
        return true;
    }

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        this.initParams();
        this.isAddNew = OperationStatus.ADDNEW.equals(param.billOperation);
        this.nodeId = "";
        this.flowId = "";
        if (param.wfState != null) {
            this.nodeId = param.wfState.getNodeID();
            this.flowId = param.wfState.getProcDefId();
        }
        if (this.flowId == null) {
            this.nodeId = "-1";
            this.flowId = "DRAFT";
        }
        if (this.nodeId == null) {
            this.nodeId = "-1";
        }
        if (this.getTemplateInfo(this.entryFormID) != null) {
            this.entryTemplateID = this.getTemplateInfo(this.entryFormID).getId().toString();
        }
        return super.onInitialize(param);
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        if (!this.beforeCustomOperation(operation)) {
            return;
        }
        if (this.operationAddEntry.equals(operation)) {
            this.addEntry();
        } else if (this.operationInsertEntry.equals(operation)) {
            this.insertEntry();
        } else if (this.operationEditEntry.equals(operation)) {
            this.editEntry();
        } else if (this.operationDeleteEntry.equals(operation)) {
            this.deleteEntry();
        } else if (this.operationViewEntry.equals(operation)) {
            this.viewEntry();
        } else if (this.operationApproveEntry.equalsIgnoreCase(operation) || this.operationDisapproveEntry.equalsIgnoreCase(operation)) {
            this.approveEntry(operation);
        }
    }

    protected void approveEntry(String operation) throws BOSException {
        CoreBillBaseCustomInfo customInfo = (CoreBillBaseCustomInfo)this.application.getBillModel().getBillValue();
        DAOHelper.getDAO().update(this.application.getContext(), (IObjectValue)customInfo);
        String id = "";
        if (customInfo != null) {
            int num = this.application.getBillView().getSelectedRow(this.entriesKey);
            CoreBillBaseCustomEntryCollection coll2 = (CoreBillBaseCustomEntryCollection)customInfo.get("entries1");
            if (num == -1) {
                this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002");
                return;
            }
            if (num != -1 && coll2 != null && coll2.size() > 0 && num <= coll2.size()) {
                id = coll2.get(num).getId().toString();
            }
        }
        id = id == null ? "" : id;
        String url = "";
        try {
            url = this.approveUrl + "?billType=" + this.billType + "&type=" + operation + "&id=" + URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        this.application.popupWindow(url, "openDialog", "update", "\u5ba1\u6279\u610f\u89c1", 335, 185);
    }

    protected void addEntry() throws BOSException {
        String url = this.getEntryUrl();
        url = url + "&status=ADDNEW";
        this.application.popupWindow(url, "openDialog", "addEntry", "\u660e\u7ec6", 850, 775);
    }

    protected void insertEntry() throws BOSException {
        int num = this.application.getBillView().getSelectedRow(this.entriesKey);
        String url = this.getEntryUrl();
        url = url + "&seq=" + num;
        url = url + "&status=ADDNEW";
        this.application.popupWindow(url, "openDialog", "insertEntry", "\u660e\u7ec6", 850, 775);
    }

    protected void editEntry() throws BOSException {
        String id = "";
        CoreBillBaseCustomInfo customInfo = (CoreBillBaseCustomInfo)this.application.getBillModel().getBillValue();
        if (customInfo != null) {
            int num = this.application.getBillView().getSelectedRow(this.entriesKey);
            CoreBillBaseCustomEntryCollection coll2 = (CoreBillBaseCustomEntryCollection)customInfo.get("entries1");
            if (num != -1 && coll2 != null && coll2.size() > 0) {
                id = coll2.get(num).getId().toString();
            }
        }
        try {
            String url = this.getEntryUrl();
            url = url + "&pk=" + URLEncoder.encode(id, "UTF-8");
            url = url + "&status=EDIT";
            this.application.popupWindow(url, "openDialog", "EDIT", "\u660e\u7ec6", 850, 775);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    protected void deleteEntry() throws BOSException {
    }

    protected void viewEntry() throws BOSException {
        String id = "";
        CoreBillBaseCustomInfo customInfo = (CoreBillBaseCustomInfo)this.application.getBillModel().getBillValue();
        if (customInfo != null) {
            int num = this.application.getBillView().getSelectedRow(this.entriesKey);
            CoreBillBaseCustomEntryCollection coll2 = (CoreBillBaseCustomEntryCollection)customInfo.get("entries1");
            if (num == -1) {
                if (coll2 != null && coll2.size() > 0) {
                    id = coll2.get(0).getId().toString();
                } else {
                    this.application.showMessage("\u6ca1\u6709\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u5148\u5f55\u5165\u660e\u7ec6\u3002");
                    return;
                }
            }
            if (num != -1 && coll2 != null && coll2.size() > 0 && num <= coll2.size()) {
                id = coll2.get(num).getId().toString();
            }
        }
        try {
            String url = this.getEntryUrl();
            url = url + "&pk=" + URLEncoder.encode(id, "UTF-8");
            url = url + "&status=VIEW";
            this.application.popupWindow(url, "openDialog", "view", "\u660e\u7ec6", 850, 775);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private boolean verifyModel() {
        CoreBillBaseCustomInfo customInfo = (CoreBillBaseCustomInfo)this.application.getBillModel().getBillValue();
        if (customInfo != null && customInfo.getId() == null) {
            this.application.showMessage("\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002");
            return false;
        }
        return true;
    }

    private TemplateInfo getTemplateInfo(String formID) throws EASBizException, BOSException {
        ITemplate templateService = null;
        TemplateInfo templateInfo = null;
        try {
            templateService = TemplateFactory.getLocalInstance((Context)this.application.getContext());
            String oql = "select id where formId='" + formID + "'";
            oql = oql + " and (CU = '" + ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext()).getId().toString() + "' OR CU = '" + "eThjryu4wEKoEK1veu3ZzDUlqpQ=" + "')";
            TemplateCollection col = templateService.getTemplateCollection(oql);
            if (col != null && col.size() > 0) {
                templateInfo = templateService.getTemplateInfo((IObjectPK)new ObjectUuidPK(col.get(0).getId()));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return templateInfo;
    }

    protected String getEntryUrl() {
        String url = "";
        try {
            url = "/easweb/servlet/BillServlet?formID=" + URLEncoder.encode(this.entryFormID, "UTF-8");
            url = url + "&parentPageId=" + URLEncoder.encode(((WebBillEditPanel)this.application.getBillView()).getPageId());
            url = url + "&nodeId=" + URLEncoder.encode(this.nodeId, "UTF-8");
            url = url + "&flowId=" + URLEncoder.encode(this.flowId, "UTF-8");
            url = url + "&flowTempId=" + URLEncoder.encode(this.entryTemplateID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }
}

