/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.extend.flow.ITemplate;
import com.kingdee.eas.base.form.extend.flow.TemplateCollection;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillBusinessUtil;
import com.kingdee.eas.base.form.model.bill.BillModel;
import com.kingdee.eas.base.form.model.bill.IDList;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.form.model.command.BeforeCommandArg;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.util.ExpressionUtil;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.mc.web.WfWafUtil;
import com.kingdee.eas.dynbusiness.config.Property;
import com.kingdee.eas.dynbusiness.config.PropertyCheckConfigItems;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryCollection;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryInfo;
import com.kingdee.eas.ep.CoreBillBaseCustomInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class MaterialInfoPlugin
extends AbstractBillPlugin {
    private static final String NODECONTROLBOSTYPE = "30551B26";
    private static final String PERMISSION_ITEM = "bd_material_view";
    private static final String CHECK_REQUIRED = "checkRequired";
    private static final String EMPTY_EXPRESSION_NULL = "@this == null";
    private String formId = null;
    private String nodeId;
    private String seq;
    private String flowId;
    private String layoutId;

    public void activate() {
        super.activate();
    }

    public void afterBarItemClick(CommandArg commandArg) throws EASBizException, BOSException {
        super.afterBarItemClick(commandArg);
    }

    public void afterBindData() throws EASBizException, BOSException {
        super.afterBindData();
        this.setNodeControlPolicy();
    }

    public void beforeValidate(PropertyCheckConfigItems checkItems) throws EASBizException, BOSException {
        super.beforeValidate(checkItems);
        BusinessInfo business = this.application.getBillModel().getBusinessInfo();
        if (checkItems == null) {
            checkItems = PropertyCheckConfigItems.defineForRequiredValidation((String)business.getForm().getBosType());
        }
        PropertyCheckConfigItems tempCheckItems = PropertyCheckConfigItems.defineForRequiredValidation((String)business.getForm().getBosType());
        String pk = this.getPk();
        IObjectValue objectValue = null;
        if (pk != null) {
            objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
            for (IObjectValue rowData : (IObjectCollection)objectValue.get("fieldEntrys")) {
                Object key = rowData.get("key");
                if (key == null) continue;
                boolean isMustInput = rowData.getBoolean("isMustInput");
                Field field = business.getField(key.toString());
                if (!isMustInput || field.isMustInput()) continue;
                Property property = new Property(field.getKey(), this.getLongPropertyName(business, field));
                if (field.getZeroEmpty() == 1) {
                    property.setEmptyExpression(EMPTY_EXPRESSION_NULL);
                }
                tempCheckItems.addRequiredProperty(property);
            }
        }
        checkItems.merge((Object)tempCheckItems);
    }

    private String getLongPropertyName(BusinessInfo business, Field field) {
        String propertyName = field.getPropertyName();
        if (StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        if (ExpressionUtil.isFieldName((String)propertyName)) {
            propertyName = ExpressionUtil.removeFormatSymbol((String)propertyName);
            field.setPropertyName(propertyName);
            return propertyName;
        }
        Entity entity = business.getEntity(field.getEntityKey());
        if (entity.getEntityType() == 1) {
            String entryName = entity.getEntryName();
            propertyName = entryName + "." + propertyName;
        }
        return propertyName;
    }

    public void afterBotp(IObjectCollection destBills) throws EASBizException, BOSException {
        super.afterBotp(destBills);
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        this.application.getBillView().setParentRefresh(true);
        super.afterOperation(operation);
    }

    public void afterCreateNewData() throws EASBizException, BOSException {
        CoreBillBaseCustomEntryInfo info = (CoreBillBaseCustomEntryInfo)this.application.getBillModel().getBillValue();
        info.setBOSUuid("id", BOSUuid.create((String)"C03F56CA"));
        this.builderData();
    }

    private void builderData() throws EASBizException, BOSException {
        IObjectValue objValue = this.application.getBillModel().getBillValue();
        IObjectCollection materialGroupCollection = this.application.getBillModel().getEntryData(this.application.getBillModel().getBusinessInfo().getEntity("FMaterialGroupEntry"));
        this.builderMaterialData(materialGroupCollection);
    }

    private void builderMaterialData(IObjectCollection materialGroupCollection) throws EASBizException, BOSException {
        MaterialGroupStandardCollection mgStandardColl = this.getMaterialGroupStandardCollection();
        if (mgStandardColl == null) {
            return;
        }
        Hashtable mapfields = this.getMaterialGroupStandardObject(materialGroupCollection);
        int size = mgStandardColl.size();
        for (int n = 0; n < size; ++n) {
            this.application.getBillModel().createNewEntryRow("FMaterialGroupEntry");
            this.application.setValue("FEntryStandardSeq", (Object)new Integer(n + 1), n);
            this.application.setValue("FEntryStandardName", (Object)mgStandardColl.get(n).getName(), n);
            this.application.setValue("FEntryMaterialGroup", mapfields.get("FEntryMaterialGroup"), n);
            this.application.setValue("FEntryGroupStandardID", (Object)mgStandardColl.get(n).getId(), n);
        }
    }

    private Hashtable getMaterialGroupStandardObject(IObjectCollection materialGroupCollection) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (materialGroupCollection != null) {
            for (IObjectValue rowData : materialGroupCollection) {
                Object key = rowData.get("dynProp03");
                if (key == null) continue;
                map.put(key.toString(), rowData.get("dynProp02"));
            }
        }
        return map;
    }

    private MaterialGroupStandardCollection getMaterialGroupStandardCollection() throws BOSException {
        String currentCUID = ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext()).getId().toString();
        String oql = "select id,name where standardType != 1 and cu in ('" + currentCUID + "','00000000-0000-0000-0000-000000000000CCE7AED4' ) ";
        MaterialGroupStandardCollection mgsColl = MaterialGroupStandardFactory.getLocalInstance((Context)this.application.getContext()).getMaterialGroupStandardCollection(oql);
        return mgsColl;
    }

    public void attachApplication(BillApplication application) {
        super.attachApplication(application);
    }

    public void beforeBarItemClick(BeforeCommandArg beforeCommandArg) throws EASBizException, BOSException {
        super.beforeBarItemClick(beforeCommandArg);
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        if (operation.getOperation().equalsIgnoreCase("save")) {
            return false;
        }
        return super.beforeOperation(operation);
    }

    public boolean beforeSaveOrSubmitData() {
        return false;
    }

    private void lockAttachment(boolean isLock) {
        this.application.lockElement("Fbtn3", isLock);
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        block33: {
            String oldStatus = this.application.getBillView().getOperationStatus().getStatus();
            if ("checkMaterialName".equals(operation)) {
                CoreBillBaseCustomEntryInfo customInfo = (CoreBillBaseCustomEntryInfo)this.application.getBillModel().getBillValue();
                String name = customInfo.getString("name_l1");
                name = name == null ? "" : name;
                String url = "";
                try {
                    url = "/easweb/cp/wfm/materialInfoList.jsf?name=" + URLEncoder.encode(name, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
                this.application.popupWindow(url, "openDialog", "update", "\u7269\u6599\u8be6\u7ec6\u4fe1\u606f", 750, 450);
            } else if ("saveMaterial".equalsIgnoreCase(operation)) {
                try {
                    if (this.validateBeforeSaveOrSubmit() && this.saveMaterialInfo()) {
                        this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u6210\u529f\u3002");
                        ((BillModel)this.application.getBillModel()).setChanged(false);
                        this.lockAttachment(false);
                    }
                }
                catch (DataAccessException da) {
                    this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff1a" + da.getMessage());
                }
            } else if ("saveAndAdd".equalsIgnoreCase(operation)) {
                try {
                    if (this.validateBeforeSaveOrSubmit() && this.saveMaterialInfo()) {
                        ((BillModel)this.application.getBillModel()).setChanged(false);
                        this.application.createNewData();
                        this.lockAttachment(true);
                    }
                }
                catch (DataAccessException da) {
                    this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff1a" + da.getMessage());
                }
            } else if ("colseWindow".equalsIgnoreCase(operation)) {
                this.application.close();
            } else if ("previousdata".equalsIgnoreCase(operation)) {
                if (OperationStatus.VIEW.equals(OperationStatus.getStatus((String)oldStatus))) {
                    this.application.navigate("previous");
                    this.application.getBillView().load(this.application.getBillValue().getString("id"));
                } else if (this.validateBeforeSaveOrSubmit()) {
                    try {
                        if (!this.saveMaterialInfo()) break block33;
                        ((BillModel)this.application.getBillModel()).setChanged(false);
                        this.application.navigate("previous");
                        this.application.getBillView().setOperationStatus(OperationStatus.getStatus((String)oldStatus));
                        this.application.getBillView().load(this.application.getBillValue().getString("id"));
                        if (OperationStatus.EDIT.equals(OperationStatus.getStatus((String)oldStatus)) || OperationStatus.ADDNEW.equals(OperationStatus.getStatus((String)oldStatus))) {
                            this.lockAttachment(false);
                            break block33;
                        }
                        this.lockAttachment(true);
                    }
                    catch (DataAccessException da) {
                        this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff1a" + da.getMessage());
                    }
                }
            } else if ("nextdata".equalsIgnoreCase(operation)) {
                if (OperationStatus.VIEW.equals(OperationStatus.getStatus((String)oldStatus))) {
                    this.application.navigate("next");
                    this.application.getBillView().load(this.application.getBillValue().getString("id"));
                } else if (this.validateBeforeSaveOrSubmit()) {
                    try {
                        if (!this.saveMaterialInfo()) break block33;
                        ((BillModel)this.application.getBillModel()).setChanged(false);
                        this.application.navigate("next");
                        this.application.getBillView().setOperationStatus(OperationStatus.getStatus((String)oldStatus));
                        this.application.getBillView().load(this.application.getBillValue().getString("id"));
                        if (OperationStatus.EDIT.equals(OperationStatus.getStatus((String)oldStatus)) || OperationStatus.ADDNEW.equals(OperationStatus.getStatus((String)oldStatus))) {
                            this.lockAttachment(false);
                            break block33;
                        }
                        this.lockAttachment(true);
                    }
                    catch (DataAccessException da) {
                        this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff1a" + da.getMessage());
                    }
                }
            } else if ("distributeHistory".equalsIgnoreCase(operation)) {
                String targetMaterialId = this.application.getBillValue().getString("targetmaterialid");
                String url = "/easweb/cp/wfm/materialDistributeHistory.jsf" + WfWafUtil.appendParam((String)"materialid", (String)targetMaterialId, (boolean)true).toString();
                this.application.popupWindow(url, "openDialog", "distributeHistory", "\u67e5\u770b\u6d41\u7a0b\u56fe", 750, 450);
            }
        }
        super.doCustomOperation(operation);
    }

    private boolean validateBeforeSaveOrSubmit() {
        boolean result = false;
        try {
            if (this.application.getBillView().getLayoutInfo().getFormAppearance().isValidateBeforeSaving()) {
                PropertyCheckConfigItems checkItems = null;
                try {
                    if (this.application.getBillModel().getBusinessInfo().getCheckItems() != null) {
                        checkItems = (PropertyCheckConfigItems)this.application.getBillModel().getBusinessInfo().getCheckItems().clone();
                    }
                }
                catch (CloneNotSupportedException e) {
                    throw new BOSException((Throwable)e);
                }
                this.beforeValidate(checkItems);
                BillBusinessUtil.validateAtSave((PropertyCheckConfigItems)checkItems, (String)this.application.getForm().getBosType(), (DynamicFormApplication)this.application, (IObjectValue)this.application.getBillValue());
            }
            result = true;
        }
        catch (ActionCommonException e) {
            this.application.showMessage(e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean saveMaterialInfo() throws DataAccessException {
        WebBillEditPanel panel = (WebBillEditPanel)this.application.getDynamicFormView().getParentFormView();
        CoreBillBaseCustomInfo customInfo = (CoreBillBaseCustomInfo)panel.getBillModel().getBillValue();
        CoreBillBaseCustomEntryCollection coll = (CoreBillBaseCustomEntryCollection)customInfo.get("entries1");
        CoreBillBaseCustomEntryInfo entryInfo = (CoreBillBaseCustomEntryInfo)this.application.getBillModel().getBillValue();
        if (entryInfo.get("number") == null) {
            this.application.showMessage("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return false;
        }
        BigDecimal zero = new BigDecimal(0);
        if ((entryInfo.get("length") != null && zero.compareTo((BigDecimal)entryInfo.get("length")) != 0 || entryInfo.get("width") != null && zero.compareTo((BigDecimal)entryInfo.get("width")) != 0 || entryInfo.get("height") != null && zero.compareTo((BigDecimal)entryInfo.get("height")) != 0) && entryInfo.get("sequnit") == null) {
            this.application.showMessage("\u5f53\u957f\u5ea6\u3001\u5bbd\u5ea6\u3001\u9ad8\u5ea6\u6216\u8005\u4f53\u79ef\u6709\u4e00\u4e2a\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u957f\u5ea6\u5355\u4f4d\u5fc5\u5f55\uff01");
            return false;
        }
        if ((entryInfo.get("grossweight") != null && zero.compareTo((BigDecimal)entryInfo.get("grossweight")) != 0 || entryInfo.get("netweight") != null && zero.compareTo((BigDecimal)entryInfo.get("netweight")) != 0) && entryInfo.get("weightunit") == null) {
            this.application.showMessage("\u5f53\u6bdb\u91cd\u6216\u8005\u51c0\u91cd\u6709\u4e00\u4e2a\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u91cd\u91cf\u5355\u4f4d\u5fc5\u5f55\uff01");
            return false;
        }
        if (entryInfo.get("volume") != null && zero.compareTo((BigDecimal)entryInfo.get("volume")) != 0 && entryInfo.get("volumnunit") == null) {
            this.application.showMessage("\u5f53\u4f53\u79ef\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u4f53\u79ef\u5355\u4f4d\u5fc5\u5f55\uff01");
            return false;
        }
        if (entryInfo.get("isaudit") != null && entryInfo.getInt("isaudit") == 3 && (entryInfo.get("auditnote") == null || StringUtils.isEmpty((String)entryInfo.get("auditnote").toString()))) {
            this.application.showMessage("\u8bf7\u8f93\u5165\u5ba1\u6279\u610f\u89c1\uff01");
            return false;
        }
        if (coll != null) {
            if (this.seq != null && !"".equals(this.seq)) {
                coll.insertObject(Integer.valueOf(this.seq).intValue(), (IObjectValue)entryInfo);
                this.seq = "";
            } else {
                coll.add(entryInfo);
            }
        } else {
            CoreBillBaseCustomEntryCollection entryCollection = new CoreBillBaseCustomEntryCollection();
            entryCollection.add(entryInfo);
            customInfo.put("entries1", (Object)entryCollection);
        }
        DAOHelper.getDAO().update(this.application.getContext(), (IObjectValue)customInfo);
        this.loadIdList();
        return true;
    }

    public void fireButtonClick(CommandArg commandArg) throws EASBizException, BOSException {
        super.fireButtonClick(commandArg);
    }

    public String getCustomWorkFlowID() throws EASBizException, BOSException {
        return super.getCustomWorkFlowID();
    }

    public void onGetFieldFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
        if ("FEntryMaterialGroup".equalsIgnoreCase(arg.getKey())) {
            String oql = " CU.ID in (" + this.getCUIDCondition(this.getAllCUID(ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext()))) + ")";
            if (!MaterialInfo.isAllowNonLeafGroup()) {
                oql = oql + " and isLeaf = 1 ";
            }
            try {
                String standardid = String.valueOf(this.application.getValue("FEntryGroupStandardID", arg.getRowIndex()));
                oql = oql + " and GROUPSTANDARD.ID = '" + standardid + "'";
                this.application.setFieldFilter("FEntryMaterialGroup", oql);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        super.onGetFieldFilter(arg);
    }

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        this.nodeId = (String)this.application.getCustomParameter("nodeId");
        this.seq = (String)this.application.getCustomParameter("seq");
        this.flowId = (String)this.application.getCustomParameter("flowId");
        this.formId = "Ln9B6rZTTqC30p4u1SiBqZp+rpI=";
        return super.onInitialize(param);
    }

    public void onLoad() {
        super.onLoad();
        String oql = " groupStandard.standardType = 1 and CU.ID in (" + this.getCUIDCondition(this.getAllCUID(this.getCU4Material())) + ")";
        if (!MaterialInfo.isAllowNonLeafGroup()) {
            oql = oql + " and isLeaf = 1 ";
        }
        try {
            this.application.setFieldFilter("Fbasedata", oql);
            this.application.getContext().put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.loadIdList();
    }

    private String getCUIDCondition(List ids) {
        String cuids = "";
        for (int i = 0; i < ids.size(); ++i) {
            cuids = i != 0 ? cuids + ",'" + ids.get(i) + "'" : "'" + ids.get(i) + "'";
        }
        return cuids;
    }

    private List getAllCUID(CtrlUnitInfo currentCU) {
        String currentCULongNumer = currentCU.getLongNumber();
        String currentCUID = currentCU.getId().toString();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.getCUFilter(currentCUID, currentCULongNumer));
        SelectorItemCollection si = new SelectorItemCollection();
        si.add(new SelectorItemInfo("id"));
        ev.setSelector(si);
        ArrayList<String> cuIDs = new ArrayList<String>();
        try {
            CtrlUnitCollection ctrlUnitColl = CtrlUnitFactory.getLocalInstance((Context)this.application.getContext()).getCtrlUnitCollection(ev);
            int size = ctrlUnitColl.size();
            for (int i = 0; i < size; ++i) {
                cuIDs.add(ctrlUnitColl.get(i).getId().toString());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return cuIDs;
    }

    private FilterInfo getCUFilter(String currentCUID, String currentCULongNumer) {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)currentCUID));
        String[] lnSecs = currentCULongNumer.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            if (i != 0) {
                sb.append("!");
            }
            sb.append(lnSecs[i]);
            lnUps.add(sb.toString());
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo("longNumber", lnUps, CompareType.INCLUDE));
            fi.setMaskString("#0 or #1");
        }
        return fi;
    }

    private void loadIdList() {
        ((WebBillEditPanel)this.application.getBillView()).setIdList(this.getIdList());
    }

    private IDList getIdList() {
        LinkedList<String> ids = new LinkedList<String>();
        String pk = this.application.getBillValue().getString("id");
        StringBuffer str = new StringBuffer(" select fid from CT_WFM_Material1213_Entry1  where  Fbill1ID in (select Fbill1ID from CT_WFM_Material1213_Entry1 where fid = '" + pk + "') order by fseq");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)this.application.getContext(), (String)str.toString());
            while (rows.next()) {
                ids.add(rows.getString("fid"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new IDList(ids, pk);
    }

    public boolean onRefreshApperanceForWf() throws EASBizException, BOSException {
        return super.onRefreshApperanceForWf();
    }

    public void refresh() {
        super.refresh();
    }

    private boolean verifyModel() {
        return true;
    }

    private void setNodeControlPolicy() throws EASBizException, BOSException {
        String pk = this.getPk();
        IObjectValue objectValue = null;
        TemplateInfo templateInfo = this.getTemplateInfo();
        if (pk != null) {
            objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
            if (templateInfo != null && templateInfo.getFlowNodeKey() != null) {
                String nodeDesc = objectValue.getString("nodeDesc");
                this.application.setControlText(templateInfo.getFlowNodeKey(), nodeDesc == null ? "" : nodeDesc);
            }
            this.setControlCtl((IObjectCollection)objectValue.get("fieldEntrys"));
            this.setControlCtl((IObjectCollection)objectValue.get("containerEntrys"));
            this.setControlCtl((IObjectCollection)objectValue.get("operationEntrys"));
            if (Boolean.FALSE.equals(objectValue.get("isAddAccessory"))) {
                this.application.lockAttachmentOperation("mnuNew");
            }
            if (Boolean.FALSE.equals(objectValue.get("isEditAccessory"))) {
                this.application.lockAttachmentOperation("mnuEdit");
            }
            if (Boolean.FALSE.equals(objectValue.get("isViewAccessory"))) {
                this.application.lockAttachmentOperation("mnuView");
            }
            if (Boolean.FALSE.equals(objectValue.get("isDeleteAccessory"))) {
                this.application.lockAttachmentOperation("mnuDelete");
            }
            if (Boolean.FALSE.equals(objectValue.get("isModifyAccessory"))) {
                this.application.lockAttachmentOperation("mnuEditAttachment");
            }
        }
    }

    private void setControlCtl(IObjectCollection entryCollection) {
        for (IObjectValue rowData : entryCollection) {
            boolean isLock;
            Object key = rowData.get("key");
            if (key == null) continue;
            boolean isHide = rowData.getBoolean("isHide");
            if (isHide) {
                this.application.hideElement(key.toString(), isHide);
            }
            if (isLock = rowData.getBoolean("isLock")) {
                this.application.lockElement(key.toString(), isLock);
            }
            boolean isMustInput = rowData.getBoolean("isMustInput");
            BusinessInfo business = this.application.getBillModel().getBusinessInfo();
            Field field = business.getField(key.toString());
            if (!isMustInput || field.isMustInput()) continue;
            this.application.setMustInput(key.toString(), isMustInput);
        }
    }

    private String getPk() {
        FilterInfo filter = new FilterInfo();
        if ("-1".equals(this.nodeId)) {
            this.flowId = "DRAFT";
        }
        if (this.flowId != null) {
            filter.appendFilterItem("flowId", (Object)this.flowId);
        }
        filter.appendFilterItem("flowNodeId", (Object)this.nodeId);
        filter.appendFilterItem("formId", (Object)this.formId);
        System.out.println("##############materialInfoPlugin  filter=" + filter.toSql());
        try {
            IObjectPK[] pks = DAOHelper.getDAO().getPKList(this.application.getContext(), BOSObjectType.create((String)NODECONTROLBOSTYPE), filter, null);
            if (pks.length > 0) {
                return pks[0].toString();
            }
            return null;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private TemplateInfo getTemplateInfo() throws EASBizException, BOSException {
        ITemplate templateService = null;
        TemplateInfo templateInfo = null;
        try {
            templateService = TemplateFactory.getLocalInstance((Context)this.application.getContext());
            TemplateCollection col = templateService.getTemplateCollection("select id where formId='" + this.formId + "'");
            if (col != null && col.size() > 0) {
                templateInfo = templateService.getTemplateInfo((IObjectPK)new ObjectUuidPK(col.get(0).getId()));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return templateInfo;
    }

    private CtrlUnitInfo getCU4Material() {
        CtrlUnitInfo cu = null;
        if (this.getDefaultMainBizOrg() instanceof CtrlUnitInfo) {
            cu = (CtrlUnitInfo)this.getDefaultMainBizOrg();
        }
        if (cu == null) {
            cu = ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext());
        }
        return cu;
    }

    private OrgUnitInfo getDefaultMainBizOrg() {
        try {
            CtrlUnitInfo currentMainOrg;
            OrgUnitInfo[] mainOrgs = this.getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(ContextUtil.getCurrentUserInfo((Context)this.application.getContext()).getId().toString()), MaterialInfoPlugin.getMainBizOrgType(), PERMISSION_ITEM);
            if (mainOrgs == null || mainOrgs.length == 0) {
                return null;
            }
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
            if ((currentMainOrg = ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext())) != null && mainOrgs.length > 0) {
                for (int i = 0; i < mainOrgs.length; ++i) {
                    if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                    return currentMainOrg;
                }
            }
            if (mainOrgs.length > 0) {
                return mainOrgs[0];
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    private OrgUnitInfo[] getAuthorizedBizOrgUnits(IObjectPK userPK, OrgType orgType, String permissionItem) {
        OrgUnitCollection collection = this.getAuthOrgByPermItem(userPK, orgType, permissionItem);
        OrgUnitCollection bizOrgs = this.getOrgUnitInfosByType(collection, orgType);
        if (bizOrgs == null) {
            return new OrgUnitInfo[0];
        }
        int size = bizOrgs.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = bizOrgs.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    private OrgUnitCollection getAuthOrgByPermItem(IObjectPK userPK, OrgType orgType, String permItem) {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = null;
        FullOrgUnitCollection result = null;
        try {
            permission = PermissionFactory.getLocalInstance((Context)this.application.getContext());
            result = permission.getAuthorizedOrg(userPK, orgType, null, permItem);
        }
        catch (EASBizException e) {
            return collection;
        }
        catch (BOSException e) {
            return collection;
        }
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    private OrgUnitCollection getOrgUnitInfosByType(OrgUnitCollection orgs, OrgType orgType) {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            ICtrlUnit iCompany = CtrlUnitFactory.getLocalInstance((Context)this.application.getContext());
            CtrlUnitCollection collection = iCompany.getCtrlUnitCollection(view);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    results.add((OrgUnitInfo)collection.get(i));
                }
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

