/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bi.subject.journal;

import com.kingdee.bos.Context;
import com.kingdee.eas.bi.subject.BaseVarProvider;
import com.kingdee.eas.bi.subject.VarException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JournalProvider
extends BaseVarProvider {
    public JournalProvider(Context context) {
        super(context);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOrgID() throws VarException {
        String condition = this.buildSQL4LongNumbers(this.getLongNumbers());
        String orgID = this.getMacroValue("CompanyMacro");
        ResultSet resultSet = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        StringBuffer SQL = new StringBuffer("SELECT DISTINCT (FID) FROM DW_DIM_ORG_COMPANY ");
        SQL.append("WHERE FID = ? ");
        SQL.append(condition);
        try {
            connection = this.getJDBCConnection();
            preparedStatement = connection.prepareStatement(SQL.toString());
            preparedStatement.setString(1, orgID);
            resultSet = preparedStatement.executeQuery();
            String companyIDs = "";
            while (resultSet.next()) {
                companyIDs = companyIDs + "'" + resultSet.getString(1) + "',";
            }
            orgID = companyIDs + "'" + orgID + "'";
        }
        catch (SQLException e) {
            try {
                throw new VarException("\u6570\u636e\u5e93\u5f02\u5e38", e);
                catch (Exception e2) {
                    throw new VarException("\u672a\u77e5\u5f02\u5e38", e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)preparedStatement, (Connection)connection);
        return orgID;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set getLongNumbers() throws VarException {
        String orgID = this.getMacroValue("CompanyMacro");
        if (orgID == null) throw new VarException("\u5f53\u524d\u516c\u53f8ID\u4e3a\u7a7a");
        if (orgID.length() <= 0) {
            throw new VarException("\u5f53\u524d\u516c\u53f8ID\u4e3a\u7a7a");
        }
        ResultSet resultSet = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        StringBuffer SQL = new StringBuffer("SELECT DISTINCT (D.FLONGNUMBER)");
        SQL.append("FROM DW_FACT_JOURNALBALANCE A, DW_DIM_ORG_COMPANY D ");
        SQL.append("WHERE A.FCOMPANYID IN ");
        SQL.append("(SELECT DISTINCT (B.FID) FROM DW_DIM_ORG_COMPANY B, DW_DIM_ORG_COMPANY C ");
        SQL.append("WHERE C.FPARENTID = ? AND CHARINDEX(C.FLONGNUMBER,B.FLONGNUMBER) = 1) ");
        SQL.append("AND D.FID = A.FCOMPANYID ");
        ArrayList<String> longNumbers = new ArrayList<String>();
        Set longNumbersSet = new HashSet();
        try {
            connection = this.getJDBCConnection();
            preparedStatement = connection.prepareStatement(SQL.toString());
            preparedStatement.setString(1, orgID);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                longNumbers.add(resultSet.getString(1));
            }
            longNumbersSet = this.getPaternityCompanyIDs(longNumbers);
        }
        catch (SQLException e) {
            try {
                throw new VarException("\u6570\u636e\u5e93\u5f02\u5e38", e);
                catch (Exception e2) {
                    throw new VarException("\u672a\u77e5\u5f02\u5e38", e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)preparedStatement, (Connection)connection);
        return longNumbersSet;
    }

    private Set getPaternityCompanyIDs(List longNumbers) {
        HashSet<String> allnumbers = new HashSet<String>();
        for (int i = 0; i < longNumbers.size(); ++i) {
            String longNumber = (String)longNumbers.get(i);
            String[] numbers = longNumber.split("!");
            if (numbers == null || numbers.length <= 0) continue;
            StringBuffer number4StrBuffer = new StringBuffer("");
            for (int j = 0; j < numbers.length; ++j) {
                number4StrBuffer.append(numbers[j]);
                String number = number4StrBuffer.toString();
                allnumbers.add(number);
                number4StrBuffer.append("!");
            }
        }
        return allnumbers;
    }

    private String buildSQL4LongNumbers(Set longNumbersSet) {
        StringBuffer condition = new StringBuffer("");
        Iterator iterator = longNumbersSet.iterator();
        while (iterator.hasNext()) {
            condition.append("OR FLONGNUMBER = ").append("'").append(iterator.next()).append("' ");
        }
        return condition.toString();
    }
}

