/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bizframework.billconfig.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.bizframework.billconfig.BillConfigureBizException;
import com.kingdee.eas.bizframework.billconfig.util.BillConfigureHelper;
import com.kingdee.eas.common.EASBizException;
import java.util.HashMap;
import java.util.Map;

public class BillConfigureCache {
    private static Map<String, JoinQueryInfo> joinQueryInfoMap = new HashMap<String, JoinQueryInfo>();
    private static Map<String, EntityObjectInfo> entityObjectInfoMap = new HashMap<String, EntityObjectInfo>();
    private static Map<String, Map<String, String>> entityEnumSourceMap = new HashMap<String, Map<String, String>>();
    private static Map<String, String> entryNameMap = new HashMap<String, String>();
    private static Map<String, Map<String, String>> joinQueryKeyMap = new HashMap<String, Map<String, String>>();
    private static IMetaDataLoader loader = null;

    public static JoinQueryInfo getQueryInfo(Context ctx, String queryPK) throws EASBizException {
        JoinQueryInfo queryInfo = joinQueryInfoMap.get(queryPK);
        if (queryInfo == null) {
            loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
            MetaDataPK myQueryPK = MetaDataPK.create((String)queryPK);
            queryInfo = (JoinQueryInfo)loader.get(MetaDataTypeList.JOINQUERY, (IMetaDataPK)myQueryPK);
            try {
                queryInfo.validate();
            }
            catch (Exception e) {
                throw new BillConfigureBizException(BillConfigureBizException.QUERYERROR, new Object[]{queryPK});
            }
            joinQueryInfoMap.put(queryPK, queryInfo);
        }
        return queryInfo;
    }

    public static EntityObjectInfo getEntityObjectInfo(Context ctx, String bosType) throws EASBizException {
        EntityObjectInfo entityObjectInfo = entityObjectInfoMap.get(bosType);
        if (entityObjectInfo == null) {
            try {
                loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
                entityObjectInfo = loader.getEntity(BOSObjectType.create((String)bosType));
                entityObjectInfoMap.put(bosType, entityObjectInfo);
            }
            catch (Exception e) {
                throw new BillConfigureBizException(BillConfigureBizException.BOSTYPEERROR, new Object[]{bosType});
            }
        }
        return entityObjectInfo;
    }

    public static String getEntityFieldEnumSource(Context ctx, String bosType, String fieldName) throws EASBizException {
        String enumSource;
        Map<String, String> fieldMap = entityEnumSourceMap.get(bosType);
        if (fieldMap == null) {
            entityEnumSourceMap.put(bosType, new HashMap());
        }
        if ((enumSource = entityEnumSourceMap.get(bosType).get(fieldName)) == null && (enumSource = BillConfigureHelper.getEnumSource(ctx, bosType, fieldName)) != null) {
            entityEnumSourceMap.get(bosType).put(fieldName, enumSource);
        }
        return enumSource;
    }

    public static String getEntityEntryName(Context ctx, String bosType) throws EASBizException {
        String billEntryName = entryNameMap.get(bosType);
        if (billEntryName == null) {
            EntityObjectInfo entity = BillConfigureCache.getEntityObjectInfo(ctx, bosType);
            billEntryName = BillConfigureHelper.getBillEntryPropertyName(entity);
            entryNameMap.put(bosType, billEntryName);
        }
        return billEntryName;
    }

    public static Map getJoinQueryKey(Context ctx, String queryPK) throws EASBizException {
        Map<String, String> keyMap = joinQueryKeyMap.get(queryPK);
        if (keyMap == null) {
            joinQueryKeyMap.put(queryPK, new HashMap());
            keyMap = joinQueryKeyMap.get(queryPK);
        }
        JoinQueryInfo queryInfo = BillConfigureCache.getQueryInfo(ctx, queryPK);
        QueryFieldCollection keyProp = queryInfo.getQueryPK().getKeyPropertys();
        QueryFieldInfo queryFieldInfo = null;
        int size = keyProp.size();
        for (int i = 0; i < size; ++i) {
            queryFieldInfo = keyProp.get(i);
            keyMap.put(queryFieldInfo.getName(), queryFieldInfo.getName());
        }
        return keyMap;
    }
}

