/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractAutoImportInfo;
import com.kingdee.eas.tools.datatask.AutoImportCollection;
import com.kingdee.eas.tools.datatask.AutoImportFactory;
import com.kingdee.eas.tools.datatask.AutoImportInfo;
import com.kingdee.eas.tools.datatask.IAutoImport;
import com.kingdee.eas.tools.datatask.RunStateEnum;
import com.kingdee.eas.tools.datatask.client.AbstractAutoImportDefineEditUI;
import com.kingdee.eas.tools.datatask.client.FileChooserPromptBox;
import com.kingdee.eas.tools.datatask.runtime.AutImportSchedulerManager;
import com.kingdee.eas.tools.datatask.runtime.AutoImportExecutor;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class AutoImportDefineEditUI
extends AbstractAutoImportDefineEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoImportDefineEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.tools.datatask.AutoImportResource";
    private boolean scheduleisChanged = false;

    public AutoImportDefineEditUI() throws Exception {
        this.initUI();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.putSpinnerToEditData();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.putEditDataToSpinner();
    }

    private void initUI() {
        this.prmtFilePath = new FileChooserPromptBox((Component)((Object)this), "OPEN");
        this.prmtFilePath.setRequired(true);
        SpinnerNumberModel snm = new SpinnerNumberModel(0, 0, 5, 1);
        this.txtPriority.setModel((SpinnerModel)snm);
        this.comboState.setEditable(false);
        this.comboState.setEnabled(false);
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuItemEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnSchedule.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.menuItemSchedule.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.btnExecute.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.menuItemExecute.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.btnState(true);
    }

    private void btnState(boolean enable) {
        this.btnExecute.setEnabled(enable);
        this.btnDisable.setEnabled(enable);
        this.btnEnable.setEnabled(enable);
        this.menuItemEnable.setEnabled(enable);
        this.menuItemDisable.setEnabled(enable);
        this.menuItemExecute.setEnabled(enable);
        this.btnSave.setVisible(false);
        this.actionCopy.setVisible(false);
    }

    private void putEditDataToSpinner() {
        this.txtPriority.getModel().setValue(new Double(this.editData.getPriority()));
        this.prmtFilePath.setValue((Object)this.editData.getFilePath());
    }

    private void putSpinnerToEditData() {
        if (this.txtPriority.getModel().getValue() instanceof Double) {
            this.editData.setPriority(((Double)this.txtPriority.getModel().getValue()).shortValue());
        } else {
            this.editData.setPriority(((Integer)this.txtPriority.getModel().getValue()).shortValue());
        }
        if (this.prmtFilePath.getData() != null) {
            this.editData.setFilePath(this.prmtFilePath.getData().toString());
        }
    }

    @Override
    public void actionSchedule_actionPerformed(ActionEvent e) throws Exception {
        String tempSchedule;
        if (this.editData.getState().equals((Object)RunStateEnum.enable)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"cannteditinenable"));
            return;
        }
        String schedule = "";
        if (this.editData.getScheduleContent() != null && !this.editData.getScheduleContent().trim().equalsIgnoreCase("")) {
            schedule = this.editData.getScheduleContent().trim();
        }
        boolean readonly = false;
        if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW) || this.getOprtState().equalsIgnoreCase(OprtState.EDIT) && this.editData.getState().equals((Object)RunStateEnum.enable)) {
            readonly = true;
        }
        if ((tempSchedule = ProcessSchedulePlan.open((Object)((Object)this), (String)schedule, (boolean)readonly)) != null) {
            if (!tempSchedule.equals(schedule)) {
                this.scheduleisChanged = true;
            }
            schedule = tempSchedule;
            this.editData.setScheduleContent(schedule);
        }
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getState().equals((Object)RunStateEnum.enable)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"mustdisable"));
            return;
        }
        if (this.editData.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"mustsavedata"));
            return;
        }
        String id = this.editData.getId().toString();
        ((IAutoImport)this.getBizInterface()).enableTask(id);
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(id)));
        this.loadFields();
        this.invalidate();
    }

    private void updateData(AutoImportInfo info) throws Exception {
        SelectorItemCollection coll = new SelectorItemCollection();
        SelectorItemInfo itemInfo = new SelectorItemInfo("state");
        coll.add(itemInfo);
        this.getBizInterface().updatePartial((CoreBaseInfo)info, coll);
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getState().equals((Object)RunStateEnum.disable)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"mustenable"));
            return;
        }
        if (this.editData.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"mustsavedata"));
            return;
        }
        String id = this.editData.getId().toString();
        ((IAutoImport)this.getBizInterface()).disableTask(id);
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(id)));
        this.loadFields();
        this.invalidate();
    }

    @Override
    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"mustsavedata"));
            return;
        }
        AutoImportExecutor executor = new AutoImportExecutor();
        executor.run(this.editData.getId().toString());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"7_AutoImportDefineEditUI"));
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.scheduleisChanged) {
            AutImportSchedulerManager manager = AutImportSchedulerManager.getInstance();
            manager.resumeScheduler(this.editData.getScheduleContent().trim());
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected IObjectValue createNewData() {
        AutoImportInfo info = new AutoImportInfo();
        try {
            AutoImportCollection coll = ((IAutoImport)this.getBizInterface()).getAutoImportCollection("select  scheduleContent ");
            AbstractAutoImportInfo tmpInfo = null;
            if (coll != null && coll.size() > 0) {
                tmpInfo = coll.get(0);
            }
            if (tmpInfo != null) {
                info.setScheduleContent(tmpInfo.getScheduleContent());
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        info.setState(RunStateEnum.disable);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AutoImportFactory.getRemoteInstance();
    }

    public void verifyInput(ActionEvent e) throws Exception {
        if (this.isNull(this.editData.getNumber())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"numberisnull"));
            throw new AbortException();
        }
        if (this.isNull(this.editData.getName())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"nameisnull"));
            throw new AbortException();
        }
        if (this.isNull(this.editData.getImportObject())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"selecttemplate"));
            throw new AbortException();
        }
        if (this.isNull(this.editData.getFilePath())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"sltfilepath"));
            throw new AbortException();
        }
        if (this.isNull(this.editData.getScheduleContent())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"setschedule"));
            throw new AbortException();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("importObject.*"));
        sic.add(new SelectorItemInfo("filePath"));
        sic.add(new SelectorItemInfo("scheduleContent"));
        sic.add(new SelectorItemInfo("priority"));
        return sic;
    }

    private boolean isNull(Object str) {
        return str == null || str.equals("");
    }
}

