/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AutoImportCollection;
import com.kingdee.eas.tools.datatask.AutoImportFactory;
import com.kingdee.eas.tools.datatask.AutoImportInfo;
import com.kingdee.eas.tools.datatask.IAutoImport;
import com.kingdee.eas.tools.datatask.RunStateEnum;
import com.kingdee.eas.tools.datatask.client.AbstractAutoImportDefineListUI;
import com.kingdee.eas.tools.datatask.client.AutoImportDefineEditUI;
import com.kingdee.eas.tools.datatask.runtime.AutImportSchedulerManager;
import com.kingdee.eas.tools.datatask.runtime.AutoImportExecutor;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class AutoImportDefineListUI
extends AbstractAutoImportDefineListUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoImportDefineListUI.class);
    private static boolean isStartUpdateMonitorThread = false;
    private static final String RESOURCE = "com.kingdee.eas.tools.datatask.AutoImportResource";

    public AutoImportDefineListUI() throws Exception {
        this.initIcon();
        this.btnState(true);
        this.updateMonitorTime();
        this.startScheduleService();
        this.synActionStatewithSelectTableRow();
    }

    private void initIcon() {
        this.btnRun.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.menuItemRun.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.btnCancel.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnCancelCancel.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnSchedule.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.menuItemSchedule.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.actionCancel.setVisible(true);
        this.actionCancelCancel.setVisible(true);
        this.menuBiz.setVisible(true);
        this.menuBiz.setEnabled(true);
    }

    private void startScheduleService() throws Exception {
        AutoImportInfo aiInfo;
        IAutoImport ai;
        AutoImportCollection coll;
        AutImportSchedulerManager manager = AutImportSchedulerManager.getInstance();
        if (!manager.isStartSchedule() && (coll = (ai = (IAutoImport)this.getBizInterface()).getAutoImportCollection()).size() > 0 && (aiInfo = coll.get(0)) != null && aiInfo.getScheduleContent() != null) {
            String schedule = aiInfo.getScheduleContent().trim();
            manager.resumeScheduler(schedule);
        }
    }

    private void updateMonitorTime() throws Exception {
        if (!isStartUpdateMonitorThread) {
            UpdateOperatorTimeRunnable runnable = new UpdateOperatorTimeRunnable();
            runnable.setTickOutTime(600000L);
            runnable.setAction(this.actionForMonitor);
            Thread t = new Thread(runnable);
            t.start();
            isStartUpdateMonitorThread = true;
        }
    }

    private void btnState(boolean enable) {
        this.btnRun.setEnabled(enable);
        this.btnCancel.setEnabled(enable);
        this.btnCancelCancel.setEnabled(enable);
        this.actionForMonitor.setVisible(false);
        this.actionRun.setEnabled(enable);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.synActionStatewithSelectTableRow();
    }

    protected String getEditUIName() {
        return AutoImportDefineEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AutoImportFactory.getRemoteInstance();
    }

    protected void setActionState() {
        super.setActionState();
        this.synActionStatewithSelectTableRow();
    }

    private void synActionStatewithSelectTableRow() {
        if (this.tblMain.getRowCount() <= 0) {
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(false);
            this.actionRun.setEnabled(false);
            this.actionSchedule.setEnabled(false);
            return;
        }
        this.actionSchedule.setEnabled(true);
        this.actionRun.setEnabled(true);
        if (this.getSelectRowState().equals(RunStateEnum.enable.getValue())) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
        } else {
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setEnabled(false);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkTableHasData();
        this.checkSelected();
        if (this.getSelectRowState().equals(RunStateEnum.disable.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"mustenable"));
            return;
        }
        String id = this.getSelectedKeyValue();
        ((IAutoImport)this.getBizInterface()).disableTask(id);
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkTableHasData();
        this.checkSelected();
        if (this.getSelectRowState().equals(RunStateEnum.enable.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"mustdisable"));
            return;
        }
        String id = this.getSelectedKeyValue();
        ((IAutoImport)this.getBizInterface()).enableTask(id);
        this.refresh(e);
    }

    private Object getSelectRowState() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        int index = selectBlock.getTop();
        IRow row = this.tblMain.getRow(index);
        Object o = row.getCell("state").getValue();
        BizEnumValueInfo tmp = (BizEnumValueInfo)o;
        return tmp.getValue();
    }

    private void updateData(AutoImportInfo info) throws Exception {
        SelectorItemCollection coll = new SelectorItemCollection();
        SelectorItemInfo itemInfo = new SelectorItemInfo("state");
        coll.add(itemInfo);
        this.getBizInterface().updatePartial((CoreBaseInfo)info, coll);
    }

    @Override
    public void actionRun_actionPerformed(ActionEvent e) throws Exception {
        this.checkTableHasData();
        String id = this.getSelectedKeyValue();
        AutoImportExecutor executor = new AutoImportExecutor();
        executor.run(id);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"7_AutoImportDefineEditUI"));
    }

    @Override
    public void actionForMonitor_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionSchedule_actionPerformed(ActionEvent e) throws Exception {
        this.checkTableHasData();
        String schedule = this.getSchedule();
        String tempSchedule = ProcessSchedulePlan.open((Object)((Object)this), (String)schedule.trim(), (boolean)false);
        if (tempSchedule != null && !tempSchedule.equals("")) {
            IAutoImport ai = (IAutoImport)this.getBizInterface();
            ai.updateSchedule(tempSchedule.trim());
            AutImportSchedulerManager manager = AutImportSchedulerManager.getInstance();
            manager.resumeScheduler(tempSchedule.trim());
        }
    }

    private String getSchedule() throws Exception {
        String schedule = "";
        IAutoImport ai = (IAutoImport)this.getBizInterface();
        AutoImportCollection aiColl = ai.getAutoImportCollection();
        if (aiColl != null && aiColl.size() > 0) {
            AutoImportInfo aiInfo = aiColl.get(0);
            return aiInfo.getScheduleContent();
        }
        return schedule;
    }

    private void checkTableHasData() throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"noautoimportdata"));
            throw new AbortException();
        }
    }

    private class UpdateOperatorTimeRunnable
    implements Runnable {
        private ItemAction action = null;
        private long time = 0L;

        private UpdateOperatorTimeRunnable() {
        }

        public void setAction(ItemAction action) {
            this.action = action;
        }

        public void setTickOutTime(long time) {
            this.time = time;
        }

        @Override
        public void run() {
            while (true) {
                long minSleepTime = 60000L;
                long sleepTime = this.time - 60000L;
                if (sleepTime < 0L) {
                    sleepTime = minSleepTime;
                }
                this.action.actionPerformed(new ActionEvent((Object)AutoImportDefineListUI.this, 111, "actionperformed"));
                try {
                    Thread.currentThread();
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

