/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.DynQueryListUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tools.datatask.DIETemplate;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.IDIETemplate;
import com.kingdee.eas.tools.datatask.ITemplateFolder;
import com.kingdee.eas.tools.datatask.TemplateFolderFactory;
import com.kingdee.eas.tools.datatask.TemplateFolderInfo;
import com.kingdee.eas.tools.datatask.client.AbstractDIETemplateListUI;
import com.kingdee.eas.tools.datatask.client.DIETemplateEditUI;
import com.kingdee.eas.tools.datatask.client.TemplateExport;
import com.kingdee.eas.tools.datatask.client.TemplateFolderEditUI;
import com.kingdee.eas.tools.datatask.client.TemplateUtils;
import com.kingdee.eas.tools.datatask.client.UDWizardContainerUI;
import com.kingdee.eas.tools.datatask.client.UIUtil;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DIETemplateListUI
extends AbstractDIETemplateListUI {
    private static final Logger logger = CoreUIObject.getLogger(DIETemplateListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.tools.datatask.DatataskResource";
    private Set<String> expandedNodes = new HashSet<String>();
    private TreeExpandRecordListener treeExpandListener = new TreeExpandRecordListener();
    CommonQueryDialog dialog = null;
    private TreeSelectionListener treeSelectionListener;
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public DIETemplateListUI() throws Exception {
        this.addAssisFunction();
    }

    protected boolean isIgnoreCUFilter() {
        return false;
    }

    protected int getTreeExpandLevel() {
        return 10;
    }

    @Override
    public void actionExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        DatataskParameter param = this.getExportParam1();
        if (param == null) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        String number = param.solutionName;
        String[] tmp = number.split("\\.");
        number = tmp[tmp.length - 1];
        String sheetName = param.alias;
        TemplateExport te = new TemplateExport(number, sheetName);
        te.setParentComp((Component)((Object)this));
        try {
            String filePath = te.export();
            if (filePath != null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResourceJoinUtil.getString(RESOURCE, "templatefilepath", new Object[]{this.formatStr(filePath)}));
            }
        }
        catch (Exception ex) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResourceJoinUtil.getString(RESOURCE, "exporttemplatefilefail", new Object[]{ex.getMessage()}));
        }
    }

    private String formatStr(String str) {
        StringBuilder lineStr = new StringBuilder();
        int len = str.length();
        int group = str.length() / 39;
        for (int i = 0; i < group; ++i) {
            lineStr.append(str.substring(i * 39, (i + 1) * 39) + "\n");
        }
        if (len - lineStr.length() - group > 0) {
            lineStr.append(str.substring(group * 39, len - 1));
        }
        return lineStr.toString();
    }

    protected DatataskParameter getExportParam1() {
        DatataskParameter param = new DatataskParameter();
        this.initSelectTemplate(param);
        param.datataskMode = 64;
        return param;
    }

    private void initSelectTemplate(DatataskParameter param) {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            String number;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            ICell cell = row.getCell("number");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            String longNumber = cell.getValue().toString();
            String[] tmp = longNumber.split("!");
            param.solutionName = number = tmp[tmp.length - 1];
            param.solutionName = row.getCell("number").getValue().toString();
            cell = row.getCell("sheetName");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            param.alias = cell.getValue() != null ? cell.getValue().toString() : "sheet1";
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.expandRootNode();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void expandRootNode() {
        TreeModel model = this.treeMain.getModel();
        if (model != null && model.getRoot() != null && model.getRoot() instanceof TreeNode) {
            TreeNode node = (TreeNode)model.getRoot();
            TreeNode node1 = node.getChildAt(0);
            this.treeMain.expandPath(new TreePath(new Object[]{node, node1}));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getLongNumberFieldName() {
        return "parentFolder.longNumber";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setVisible(true);
        this.btnMoveTree.setVisible(true);
        this.btnMoveTree.setText("");
        this.btnAddTemplateFolder.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnAddTemplateFolder.setFactType(1);
        this.btnAddTemplateFolder.setText(null);
        this.btnAddTemplateFolder.setIcon(EASResource.getIcon((String)"imgTree_new"));
        this.menuItemAddTemplateFolder.setIcon(EASResource.getIcon((String)"imgTree_new"));
        this.btnExportTemplate.setIcon(EASResource.getIcon((String)"imgTbtn_dcdwj"));
        this.menuItemExportTemplate.setIcon(EASResource.getIcon((String)"imgTbtn_dcdwj"));
        this.btnViewTemplateFolder.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnViewTemplateFolder.setFactType(1);
        this.btnViewTemplateFolder.setText(null);
        this.btnViewTemplateFolder.setIcon(EASResource.getIcon((String)"imgTree_view"));
        this.btnEditTemplateFolder.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnEditTemplateFolder.setFactType(1);
        this.btnEditTemplateFolder.setText(null);
        this.btnEditTemplateFolder.setIcon(EASResource.getIcon((String)"imgTree_edit"));
        this.btnDelTemplateFolder.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnDelTemplateFolder.setFactType(1);
        this.btnDelTemplateFolder.setText(null);
        this.btnDelTemplateFolder.setIcon(EASResource.getIcon((String)"imgTree_delete"));
        this.treeView.getControlPane().add((Component)this.btnAddTemplateFolder);
        this.treeView.getControlPane().add((Component)this.btnViewTemplateFolder);
        this.treeView.getControlPane().add((Component)this.btnEditTemplateFolder);
        this.treeView.getControlPane().add((Component)this.btnDelTemplateFolder);
        this.treeView.getControlPane().add((Component)this.btnMoveTree);
    }

    private IUIWindow showDialog(String strUI, Map map, String status) throws Exception {
        map.put("Owner", this);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(strUI, map, null, status);
            curDialog.show();
            return curDialog;
        }
        catch (UIException ex1) {
            ex1.printStackTrace();
            return null;
        }
    }

    protected boolean isIncludeAllChildren() {
        return true;
    }

    @Override
    public void actionAddTemplateFolder_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelect();
        KDTreeNode node = TemplateUtils.getSelectTreeNode(this.treeMain);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        if (node != null) {
            uiContext.put((Object)"parentFolder", (Object)this.getTemplateFolderInfo(node));
        }
        this.showDialog(TemplateFolderEditUI.class.getName(), (Map)uiContext, OprtState.ADDNEW);
        this.initTree();
        this.refreshList();
    }

    @Override
    public void actionViewTemplateFolder_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelect();
        KDTreeNode node = TemplateUtils.getSelectTreeNode(this.treeMain);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        if (node != null) {
            TemplateFolderInfo tmp = this.getTemplateFolderInfo(node);
            TemplateFolderInfo tmpParent = this.getTemplateFolderInfo((KDTreeNode)node.getParent());
            uiContext.put((Object)"parentFolder", (Object)tmpParent);
            uiContext.put((Object)"ID", (Object)tmp.getId().toString());
        }
        this.showDialog(TemplateFolderEditUI.class.getName(), (Map)uiContext, OprtState.VIEW);
        this.initTree();
        this.refreshList();
    }

    private TemplateFolderInfo getTemplateFolderInfo(KDTreeNode node) {
        Object tmpO = node.getUserObject();
        TemplateFolderInfo parentTFInfo = null;
        if (tmpO != null) {
            parentTFInfo = (TemplateFolderInfo)tmpO;
        }
        return parentTFInfo;
    }

    protected String getRootName() {
        return null;
    }

    protected Object getRootObject() {
        return null;
    }

    @Override
    public void actionDelTemplateFolder_actionPerformed(ActionEvent e) throws Exception {
        int a;
        if (this.isCanDelSltedNode() && (a = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"confirmRemove"))) == 0) {
            KDTreeNode node = TemplateUtils.getSelectTreeNode(this.treeMain);
            TemplateFolderInfo tfInfo = this.getTemplateFolderInfo(node);
            ITemplateFolder iTF = TemplateFolderFactory.getRemoteInstance();
            iTF.delete((IObjectPK)new ObjectUuidPK(tfInfo.getId()));
            this.treeMain.removeNodeFromParent((MutableTreeNode)node);
            this.refreshList();
        }
    }

    private boolean isCanDelSltedNode() {
        KDTreeNode node = TemplateUtils.getSelectTreeNode(this.treeMain);
        if (node.getChildCount() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"cannotRemoveWithSon"));
            return false;
        }
        return true;
    }

    @Override
    public void actionEditTemplateFolder_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelect();
        KDTreeNode node = TemplateUtils.getSelectTreeNode(this.treeMain);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        if (node != null) {
            TemplateFolderInfo tmp = this.getTemplateFolderInfo(node);
            TemplateFolderInfo tmpParent = this.getTemplateFolderInfo((KDTreeNode)node.getParent());
            uiContext.put((Object)"parentFolder", (Object)tmpParent);
            uiContext.put((Object)"ID", (Object)tmp.getId().toString());
        }
        this.showDialog(TemplateFolderEditUI.class.getName(), (Map)uiContext, OprtState.EDIT);
        this.initTree();
        this.refreshList();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelect();
        super.actionAddNew_actionPerformed(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (e.getPrevSelectBlock() == null) {
            return;
        }
        if (e.getPrevSelectBlock().equals((Object)e.getSelectBlock()) || e.getSelectBlock().getBeginRow() == e.getSelectBlock().getEndRow()) {
            // empty if block
        }
    }

    public Map getUIContext() {
        Map tmp = super.getUIContext();
        KDTreeNode node = TemplateUtils.getSelectTreeNode(this.treeMain);
        if (node != null) {
            TemplateFolderInfo info = this.getTemplateFolderInfo(node);
            tmp.put("parentFolder", info);
        }
        return tmp;
    }

    private void checkSelect() {
        KDTreeNode node = TemplateUtils.getSelectTreeNode(this.treeMain);
        if (this.treeMain.getModel().getChildCount(this.treeMain.getModel().getRoot()) > 0 && node == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"selectOneNode"));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TemplateFolderFactory.getRemoteInstance();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DIETemplateFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return DIETemplateEditUI.class.getName();
    }

    protected void refresh(ActionEvent e) throws Exception {
        ItemAction action = this.getActionFromActionEvent(e);
        if (e != null && action != null && (action.equals(this.actionRemove) || action.equals(this.actionEdit))) {
            this.actionRefresh_actionPerformed(e);
        } else {
            this.actionRefresh_actionPerformed(e);
        }
    }

    private void addAssisFunction() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F11"), "DataCenterFunction");
        final Map map = this.getUIContext();
        map.put("busType", new Integer(2));
        this.getActionMap().put("DataCenterFunction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.base.forewarn.client.TestForewarnUI", map, null, null);
                    uiWindow.show();
                }
                catch (UIException e1) {
                    logger.info((Object)"", (Throwable)e1);
                }
            }
        });
        final Map uiContext = this.getUIContext();
        map.put("busType", new Integer(2));
        this.getActionMap().put("DynQueryFunction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                uiContext.put("Owner", this);
                uiContext.put("parentUIName", DIETemplateListUI.class.getName());
                uiContext.put("queryFullName", DIETemplateListUI.this.mainQueryPK.getFullName());
                IUIWindow window = UIUtil.showDialog(DynQueryListUI.class.getName(), uiContext, OprtState.ADDNEW, (Component)((Object)DIETemplateListUI.this));
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F9"), "DIEFunction");
        map.put("busType", new Integer(2));
        this.getActionMap().put("DIEFunction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.tools.datatask.client.DEToolSolutionListUI", map, null, null);
                    uiWindow.show();
                }
                catch (UIException e1) {
                    logger.info((Object)"", (Throwable)e1);
                }
            }
        });
    }

    @Override
    public void actionAddNewUserDefine_actionPerformed(ActionEvent e) throws Exception {
        Map ctx = this.getUIContext();
        ctx.put("selectedData", this.getSelectedKeyValue());
        IUIWindow window = this.showDialog(UDWizardContainerUI.class.getName(), ctx, OprtState.ADDNEW);
        UDWizardContainerUI ui = (UDWizardContainerUI)window.getUIObject();
        if (!ui.isCanceled()) {
            this.btnRefresh.doClick();
        }
        if (window != null) {
            window.close();
        }
        DIETemplate template = new DIETemplate();
        CacheServiceFactory.getInstance().discardType(template.getType());
    }

    @Override
    public void actionRemoveUserDefineTemplate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.isSelectedUserDefineTemplate()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"cannotRemoveSysTemplate"));
            return;
        }
        super.actionRemove_actionPerformed(e);
        DIETemplate template = new DIETemplate();
        CacheServiceFactory.getInstance().discardType(template.getType());
    }

    private boolean isSelectedUserDefineTemplate() throws Exception {
        IDIETemplate dt = (IDIETemplate)this.getBizInterface();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("fieldEntries.isAutoMapping"));
        DIETemplateInfo info = dt.getDIETemplateInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), selector);
        DIETemplateFieldEntryCollection coll = info.getFieldEntries();
        if (coll == null) {
            return true;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            DIETemplateFieldEntryInfo entryInfo = coll.get(i);
            if (entryInfo.isIsAutoMapping()) continue;
            return false;
        }
        return true;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = DIETemplateListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName()) && !this.isFirstDefaultQuery()) {
            if (this.dialog == null) {
                this.dialog = this.initCommonQueryDialog();
                this.dialog.setMaxReturnCountVisible(true);
            }
            if (this.dialog.show()) {
                this.tHelper.setDialog(this.dialog);
                this.MaxReturnRowCount = iQuery.getMaxNumView(((Object)((Object)this)).getClass().getName(), queryName);
                this.mainQuery.getSorter().clear();
                this.mainQuery = this.getEntityViewInfo((EntityViewInfo)this.dialog.getEntityViewInfoResult().clone());
                this.setDefaultEntityViewInfo(this.dialog.getEntityViewInfoResult());
                if (this.mainQuery.getSorter() != null && this.mainQuery.getSorter().size() > 0) {
                    this.setIsIgnoreOrder(true);
                }
                this.doQuery(this.dialog);
                this.setLocatePre(true);
                this.execQuery();
                this.setIsIgnoreOrder(false);
            } else {
                this.tHelper.setDialog(this.dialog);
                SysUtil.abort();
            }
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.treeMain_valueChanged(null);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelect();
        super.actionMoveTree_actionPerformed(e);
    }

    protected void initTree() throws Exception {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        this.treeSelectionListener = listeners[0];
        this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        this.treeMain.removeTreeWillExpandListener((TreeWillExpandListener)this.treeExpandListener);
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)this.getTreeInitialLevel(), (int)this.getTreeExpandLevel(), (FilterInfo)this.getDefaultFilterForTree(), (SelectorItemCollection)this.getSelectorForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeWillExpandListener((TreeWillExpandListener)this.treeExpandListener);
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
        this.initPopmenu();
        this.expandNodes();
        if (this.treeMain.getRowCount() > 0) {
            this.treeMain.setSelectionRow(0);
        }
    }

    private void expandNodes() {
        Object rootObj = this.treeMain.getModel().getRoot();
        this.treeMain.expandRow(0);
        if (!(rootObj instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)rootObj;
        Stack<TreeNode> pathNodes = new Stack<TreeNode>();
        this.doExpand(rootNode, pathNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExpand(DefaultMutableTreeNode node, Stack<TreeNode> pathNodes) {
        block5: {
            pathNodes.push(node);
            try {
                CoreBaseInfo coreBaseInfo = DIETemplateListUI.tryCastToBizObject(node.getUserObject());
                if (coreBaseInfo == null) break block5;
                String id = coreBaseInfo.getId().toString();
                if (this.expandedNodes.contains(id)) {
                    this.treeMain.expandPath(new TreePath(pathNodes.toArray(new TreeNode[pathNodes.size()])));
                    ArrayList childrenObjs = Collections.list(node.children());
                    for (Object childObj : childrenObjs) {
                        if (!(childObj instanceof DefaultMutableTreeNode)) continue;
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childObj;
                        this.doExpand(childNode, pathNodes);
                    }
                    break block5;
                }
                return;
            }
            finally {
                pathNodes.pop();
            }
        }
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi.supportExecutionWithoutFilters();
    }

    private static CoreBaseInfo tryCastToBizObject(Object obj) {
        if (obj instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            Object userObject = node.getUserObject();
            if (userObject instanceof CoreBaseInfo) {
                return (CoreBaseInfo)userObject;
            }
        } else if (obj instanceof CoreBaseInfo) {
            return (CoreBaseInfo)obj;
        }
        return null;
    }

    private class TreeExpandRecordListener
    implements TreeWillExpandListener {
        private boolean isExpanding = false;

        private TreeExpandRecordListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            if (this.isExpanding) {
                return;
            }
            this.isExpanding = true;
            try {
                TreePath path = event.getPath();
                Object nodeObj = path.getLastPathComponent();
                CoreBaseInfo coreBaseInfo = DIETemplateListUI.tryCastToBizObject(nodeObj);
                if (coreBaseInfo != null) {
                    String id = coreBaseInfo.getId().toString();
                    DIETemplateListUI.this.expandedNodes.add(id);
                }
                if (nodeObj instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObj;
                    for (Object childNodeObj : Collections.list(node.children())) {
                        if (!(childNodeObj instanceof DefaultMutableTreeNode)) continue;
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)childNodeObj;
                        Stack<TreeNode> expandPath = new Stack<TreeNode>();
                        expandPath.addAll(Arrays.asList(node.getPath()));
                        DIETemplateListUI.this.doExpand(child, expandPath);
                    }
                }
            }
            finally {
                this.isExpanding = false;
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            Object[] nodeObjs = path.getPath();
            CoreBaseInfo coreBaseInfo = DIETemplateListUI.tryCastToBizObject(nodeObjs[nodeObjs.length - 1]);
            if (coreBaseInfo != null) {
                String id = coreBaseInfo.getId().toString();
                DIETemplateListUI.this.expandedNodes.remove(id);
            }
        }
    }
}

