/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.ReturnInfo;
import com.kingdee.eas.tools.datatask.util.FileTransferInfo;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import java.io.FileOutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class DlgDataGridExport {
    private static Logger logger = Logger.getLogger(DlgDataGridExport.class);
    private DatataskParameter param;
    private String fileSavePath;
    private boolean isSuccess;

    public void exportFile() throws Exception {
        this.isSuccess = true;
        if (this.param == null) {
            this.isSuccess = false;
            return;
        }
        FileDialog fd = new FileDialog(new Shell(), 8192);
        fd.setFilterExtensions(new String[]{"*.xlsx"});
        this.fileSavePath = fd.open();
        if (this.fileSavePath == null) {
            this.isSuccess = false;
            return;
        }
        this.downLoadFile();
    }

    public void buildDatataskParameter(String title, String queryPK, String selector, String filterItems, String sorterItems, String columnModel) {
        DatataskParameter param = new DatataskParameter();
        param.setContextParam(new HashMap());
        param.putContextParam("title", title);
        param.putContextParam("filterItems", filterItems);
        param.putContextParam("sorterItems", sorterItems);
        param.putContextParam("selector", selector);
        param.putContextParam("mainQueryPK", queryPK);
        param.putContextParam("columnModel", columnModel);
        param.setFileUuId(GlobalFunction.getUuID());
        param.setLogUuID(GlobalFunction.getUuID());
        param.setFileType("xlsx");
        this.param = param;
    }

    private void downLoadFile() throws Exception {
        try (FileOutputStream os = null;){
            IDatataskRunServer iDatatask = DatataskRunServerFactory.getRemoteInstance();
            ReturnInfo rs = iDatatask.dataGridExport(this.param);
            long filesize = (Long)rs.getData();
            HashMap<String, Object> downMap = new HashMap<String, Object>();
            String fileName = this.param.getFileUuId() + "." + this.param.getFileType();
            FileTransferInfo fileTrans = null;
            downMap.put("fileName", fileName);
            os = new FileOutputStream(this.fileSavePath);
            for (long pos = 0L; filesize > pos; pos += (long)fileTrans.getReadSize()) {
                downMap.put("pos", pos);
                rs = iDatatask.downLoadFile(downMap);
                fileTrans = (FileTransferInfo)rs.getData();
                os.write(fileTrans.getBuf(), 0, fileTrans.getReadSize());
            }
        }
    }

    public boolean IsSuccess() {
        return this.isSuccess;
    }
}

