/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.DatataskMode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.IDIETemplate;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.ImportModeEnum;
import com.kingdee.eas.tools.datatask.ReturnInfo;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.client.DiscardUtil;
import com.kingdee.eas.tools.datatask.client.DlgEASDatataskImportLog;
import com.kingdee.eas.tools.datatask.client.DlgEASDatataskLog;
import com.kingdee.eas.tools.datatask.client.PermCheckUtil;
import com.kingdee.eas.tools.datatask.client.TemplateExport;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalCSVDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalTextDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalXmlDataReader;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.tools.datatask.runtime.UploadFileToServerHelper;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.tools.datatask.util.GlobalInfo;
import com.kingdee.eas.tools.datatask.util.ZipUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.apache.poi.util.RecordFormatException;

public class DlgEASDatatask
extends KDDialog
implements ActionListener,
ComponentListener {
    private static final Logger logger = Logger.getLogger(DlgEASDatatask.class);
    private ArrayList params = null;
    private ArrayList logs = null;
    private boolean isDone = false;
    private int mode = 8;
    private static long MaxFileSize = 0xA00000L;
    public boolean isOK = false;
    private KDPanel pnlInfos = new KDPanel();
    private KDPanel pnlBtns = new KDPanel();
    private static KDStatusBar statusBar = null;
    private KDProgressBar progressBar = new KDProgressBar();
    private KDComboBox cbxMoreExcels = new KDComboBox();
    private KDLabel lblBizs = new KDLabel();
    private KDLabel lblFile = new KDLabel();
    private KDTextField txtFile = new KDTextField();
    private KDLabelContainer lblcFile = new KDLabelContainer();
    private KDLabelContainer lblcBizs = new KDLabelContainer();
    private KDWorkButton btnOpen = new KDWorkButton("", (Icon)GlobalInfo.getIcon("tbtn_open"));
    private KDSeparator separator = new KDSeparator();
    private KDButton btnExportTemplate2 = new KDButton();
    private KDButton btnImportTemplate = new KDButton();
    private KDButton btnOk = new KDButton();
    private KDButton btnCancel = new KDButton();
    private KDPanel pnlCanHide = new KDPanel();
    private KDPanel blankPanel = new KDPanel();
    private KDLabelContainer lcSheet = new KDLabelContainer();
    private KDLabel lblSheet = new KDLabel(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"sheet"));
    private KDComboBox comboSheets = new KDComboBox();
    private KDWorkButton btnRefreshSheet = new KDWorkButton("", EASResource.getIcon((String)"imgTbtn_refresh"));
    private KDButtonGroup bgRadio = new KDButtonGroup();
    private KDPanel ImportModePanel = new KDPanel();
    KDButtonGroup btnImportGroup = new KDButtonGroup();
    private KDRadioButton btnAddNew = new KDRadioButton();
    private KDRadioButton btnOverWrite = new KDRadioButton();
    private final int nWidth = 450;
    private final int nHeight = 345;
    private final int nMinOffset = 3;
    private final int nMaxOffset = 10;
    private final int nDlgBorderHeight = 27;
    private final int nDlgBorderWidth = 8;
    private boolean isSltSheet = false;
    private String uuid = null;
    private DlgEASDatataskLog dlgLog = null;
    private DlgEASDatataskImportLog impDlgLog = null;
    private ExternalStructInfo structInfo = null;
    private boolean permCheck = true;
    private KDPanel pnlErrorHandleMode = new KDPanel();
    KDButtonGroup btnErrorGroup = new KDButtonGroup();
    private KDRadioButton btnReturnRightnow = new KDRadioButton();
    private KDRadioButton btnReturnWhenFinish = new KDRadioButton();
    private KDComboBox comboErrorHandleMode = new KDComboBox();
    private KDLabel LabelWizard = new KDLabel(EASResource.getIcon((String)"imgTransfers_pic260"));
    private KDLabelContainer LabelProcess = new KDLabelContainer(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importing"));
    private Context mainOrgContext = null;
    private boolean noStopRequested = true;
    private Thread progressThread = null;

    public DlgEASDatatask(Frame parent, ArrayList params, int mode) {
        this(parent, params, mode, false);
    }

    public DlgEASDatatask(Dialog parent, ArrayList params, int mode) {
        this(parent, params, mode, false);
    }

    public DlgEASDatatask(Dialog parent, ArrayList params, int mode, boolean isSltSheet) {
        super(parent);
        this.init(params, mode, isSltSheet);
    }

    public DlgEASDatatask(Frame parent, ArrayList params, int mode, boolean isSltSheet) {
        super(parent);
        this.init(params, mode, isSltSheet);
    }

    private void init(ArrayList params, int mode, boolean isSltSheet) {
        this.checkPerm(params, mode);
        if (!this.permCheck) {
            return;
        }
        this.params = params;
        this.mode = mode;
        if (this.mode == 0) {
            this.mode = 8;
        }
        this.isSltSheet = isSltSheet;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void checkPerm(ArrayList params, int mode) {
        DatataskParameter dp = (DatataskParameter)params.get(0);
        try {
            DIETemplateCollection coll;
            IDIETemplate iTemplate = DIETemplateFactory.getRemoteInstance();
            String templateNumber = null;
            if (dp.solutionName != null) {
                templateNumber = dp.solutionName.substring(dp.solutionName.lastIndexOf(46) + 1);
            }
            if ((coll = iTemplate.getDIETemplateCollection("where number = '" + templateNumber + "'")) != null && coll.size() > 0) {
                DIETemplateInfo dieTemplateInfo = coll.get(0);
                if (DatataskMode.isImpMode(mode)) {
                    this.showResult(PermCheckUtil.hasFunctionPermision(dieTemplateInfo.getImportPermName()));
                } else {
                    this.showResult(PermCheckUtil.hasFunctionPermision(dieTemplateInfo.getExportPermName()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void showResult(String[][] permCheckResult) {
        String s = permCheckResult[0][0];
        if ("error".equals(s)) {
            this.permCheck = false;
            MsgBox.showError((Component)((Object)this), (String)permCheckResult[0][1]);
        }
        if ("false".equals(s)) {
            this.permCheck = false;
            MsgBox.showInfo((Component)((Object)this), (String)permCheckResult[0][1]);
        }
    }

    public void setHideOverBox(boolean isHide) {
    }

    private void initGUIControl() {
        this.lblFile.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"file"));
        this.txtFile.setText("");
        this.lblBizs.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"bizModuleName"));
        this.lblcFile.setBoundEditor((JComponent)this.txtFile);
        this.lblcFile.setBoundLabel((JLabel)this.lblFile);
        this.lblcFile.setBoundLabelUnderline(true);
        this.lblcFile.setBoundLabelLength(80);
        this.initSltSheetsComboBox();
        this.lcSheet.add((Component)this.comboSheets);
        this.lcSheet.setBoundEditor((JComponent)this.comboSheets);
        this.lcSheet.setBoundLabel((JLabel)this.lblSheet);
        this.lcSheet.setBoundLabelUnderline(true);
        this.lcSheet.setBoundLabelLength(80);
        this.LabelProcess.setBoundEditor((JComponent)this.progressBar);
        this.lcSheet.setBoundLabelUnderline(true);
        this.lcSheet.setBoundLabelLength(80);
        this.btnExportTemplate2.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exporttemplate"));
        this.btnImportTemplate.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importtemplate"));
        this.btnOk.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"ok"));
        this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"cancel"));
        this.btnExportTemplate2.setMnemonic(84);
        this.btnOpen.setToolTipText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"selectfile"));
        this.btnRefreshSheet.setToolTipText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"refreshsheet"));
        this.txtFile.setEditable(false);
        this.txtFile.setAccessAuthority(1);
        this.setStatusBar(null);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.changeByMode();
        this.btnAddNew.setName("btnAddNew");
        this.btnAddNew.setText(ImportModeEnum.ADDNEW.getAlias());
        this.btnOverWrite.setName("btnOverWrite");
        this.btnOverWrite.setText(ImportModeEnum.OVERWRITE.getAlias());
        this.btnImportGroup.add((AbstractButton)this.btnAddNew);
        this.btnImportGroup.add((AbstractButton)this.btnOverWrite);
        this.btnReturnRightnow.setName("btnReturnRightNow");
        this.btnReturnRightnow.setText(ErrorHandleModeEnum.ReturnRightnow.getAlias());
        this.btnReturnWhenFinish.setName("btnReturnWhenFinish");
        this.btnReturnWhenFinish.setText(ErrorHandleModeEnum.ReturnWhenFinish.getAlias());
        this.btnErrorGroup.add((AbstractButton)this.btnReturnRightnow);
        this.btnErrorGroup.add((AbstractButton)this.btnReturnWhenFinish);
        this.btnReturnRightnow.setSelected(true);
        if (this.isSltSheet && DatataskMode.isImpMode(this.mode)) {
            this.initCbxImportModel();
        }
    }

    private void initCbxImportModel() {
        Object tmp = this.params.get(0);
        if (!(tmp instanceof DatataskParameter)) {
            logger.error((Object)"params is not instance of DatataskParameter.");
            return;
        }
        DatataskParameter dp = (DatataskParameter)tmp;
        String templateNumber = null;
        if (dp.solutionName != null) {
            templateNumber = dp.solutionName.substring(dp.solutionName.lastIndexOf(46) + 1);
        }
        try {
            IDIETemplate iTemplate = DIETemplateFactory.getRemoteInstanceWithObjectContext(this.mainOrgContext);
            DIETemplateCollection coll = iTemplate.getDIETemplateCollection("where number = '" + templateNumber + "'");
            if (coll != null && coll.size() > 0) {
                this.btnAddNew.setEnabled(false);
                this.btnOverWrite.setEnabled(false);
                DIETemplateInfo info = coll.get(0);
                if (info.isAllowAddNewImport()) {
                    this.btnAddNew.setEnabled(true);
                    this.btnAddNew.setSelected(true);
                }
                if (info.isAllowOverWriteImport()) {
                    this.btnOverWrite.setEnabled(true);
                }
                if (!this.btnAddNew.isEnabled() && this.btnOverWrite.isEnabled()) {
                    this.btnOverWrite.setSelected(true);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void initUIContentLayout() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        KDPanel panelProcess = new KDPanel();
        panelProcess.add((Component)this.LabelProcess);
        this.pnlInfos.setLayout((LayoutManager)new GridBagLayout());
        this.pnlInfos.add((Component)this.lblcFile, (Object)new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlInfos.add((Component)this.btnOpen, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 1, 0, 0), 0, 0));
        this.pnlErrorHandleMode.setLayout((LayoutManager)new BorderLayout());
        this.pnlErrorHandleMode.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"dataErrorHandle")));
        this.pnlErrorHandleMode.setToolTipText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"dataErrorHandle"));
        this.pnlErrorHandleMode.add((Component)this.btnReturnRightnow, (Object)"North");
        this.pnlErrorHandleMode.add((Component)this.btnReturnWhenFinish, (Object)"South");
        this.pnlBtns.setLayout((LayoutManager)new GridBagLayout());
        if (this.mode == 1) {
            this.LabelProcess.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exporting"));
            this.btnOk.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"export"));
            this.pnlBtns.add((Component)this.separator, (Object)new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.pnlBtns.add((Component)this.btnExportTemplate2, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 10, 8, 10), -10, 0));
            this.pnlBtns.add((Component)this.blankPanel, (Object)new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 8, 0), 0, 0));
            this.pnlBtns.add((Component)this.btnOk, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 0, 8, 0), 20, 0));
            this.pnlBtns.add((Component)this.btnCancel, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 8, 10), 20, 0));
        } else if (DatataskMode.isImpMode(this.mode)) {
            this.btnOk.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"import"));
            this.LabelProcess.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importing"));
            this.pnlBtns.add((Component)this.separator, (Object)new GridBagConstraints(0, 0, 5, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.pnlBtns.add((Component)this.btnExportTemplate2, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 10, 8, 0), -10, 0));
            this.pnlBtns.add((Component)this.blankPanel, (Object)new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 8, 0), 0, 0));
            this.pnlBtns.add((Component)this.btnOk, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 0, 8, 0), 20, 0));
            this.pnlBtns.add((Component)this.btnCancel, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 8, 10), 20, 0));
        } else if (32 == this.mode) {
            this.LabelProcess.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importing"));
            this.pnlBtns.add((Component)this.separator, (Object)new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.pnlBtns.add((Component)this.blankPanel, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 8, 0), 0, 0));
            this.pnlBtns.add((Component)this.btnImportTemplate, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 0, 8, 0), 10, 0));
            this.pnlBtns.add((Component)this.btnCancel, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 8, 10), 0, 0));
        } else if (64 == this.mode) {
            this.LabelProcess.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exporting"));
            this.pnlBtns.add((Component)this.separator, (Object)new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.pnlBtns.add((Component)this.blankPanel, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 8, 0), 0, 0));
            this.pnlBtns.add((Component)this.btnExportTemplate2, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 0, 8, 0), 0, 0));
            this.pnlBtns.add((Component)this.btnCancel, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 8, 10), 0, 0));
        }
        if (this.isSltSheet && DatataskMode.isImpMode(this.mode)) {
            this.ImportModePanel.setLayout((LayoutManager)new BorderLayout());
            this.ImportModePanel.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importMode")));
            this.ImportModePanel.setToolTipText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importMode"));
            this.ImportModePanel.add((Component)this.btnAddNew, (Object)"North");
            this.ImportModePanel.add((Component)this.btnOverWrite, (Object)"South");
            this.pnlCanHide.setLayout((LayoutManager)new GridBagLayout());
            this.pnlCanHide.add((Component)this.lcSheet, (Object)new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlCanHide.add((Component)this.btnRefreshSheet, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 1, 0, 0), 0, 0));
            contentPane.add((Component)this.LabelWizard, new GridBagConstraints(0, 0, 1, 5, 0.0, 1.0, 12, 2, new Insets(10, 10, 0, 0), 1, 1));
            contentPane.add((Component)this.pnlInfos, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 0, 10), 0, 0));
            contentPane.add((Component)this.pnlCanHide, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 0, 10), 0, 0));
            contentPane.add((Component)this.pnlErrorHandleMode, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 0, 10), 0, 0));
            contentPane.add((Component)this.ImportModePanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 0, 10), 0, 0));
            contentPane.add((Component)this.LabelProcess, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 15, 2, new Insets(0, 10, 10, 10), 0, 0));
            contentPane.add((Component)this.pnlBtns, new GridBagConstraints(0, 5, 5, 1, 0.5, 0.5, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            contentPane.add((Component)this.LabelWizard, new GridBagConstraints(0, 0, 1, 4, 0.0, 1.0, 12, 2, new Insets(10, 10, 0, 0), 1, 1));
            contentPane.add((Component)this.pnlInfos, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 0, 10), 0, 0));
            contentPane.add((Component)this.pnlErrorHandleMode, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 0, 10), 0, 0));
            contentPane.add((Component)this.ImportModePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 0, 10), 0, 0));
            contentPane.add((Component)this.LabelProcess, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 15, 2, new Insets(0, 10, 10, 10), 0, 0));
            contentPane.add((Component)this.pnlBtns, new GridBagConstraints(0, 4, 4, 1, 0.5, 0.5, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.LabelProcess.setVisible(false);
    }

    private void initListener() {
        this.addComponentListener(this);
        this.btnOpen.addActionListener((ActionListener)this);
        this.btnImportTemplate.addActionListener((ActionListener)this);
        this.btnOk.addActionListener((ActionListener)this);
        this.btnCancel.addActionListener((ActionListener)this);
        this.btnRefreshSheet.addActionListener((ActionListener)this);
        this.btnExportTemplate2.addActionListener((ActionListener)this);
    }

    private void jbInit() {
        this.setResizable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - this.nWidth) / 2, (screenSize.height - this.nHeight) / 2, 450, 345);
        this.getRootPane().setDefaultButton((JButton)this.btnOk);
        this.initGUIControl();
        this.initUIContentLayout();
        this.initListener();
    }

    private void initSltSheetsComboBox() {
        this.comboSheets.removeAllItems();
        for (int i = 0; i < this.params.size(); ++i) {
            DatataskParameter param = (DatataskParameter)this.params.get(i);
            if (param.alias == null || param.alias.trim().compareTo("") == 0) continue;
            String[] sheetNames = param.alias.split(":");
            for (int j = 0; j < sheetNames.length; ++j) {
                this.comboSheets.addItem((Object)sheetNames[j]);
            }
        }
    }

    public void setMainOrgContext(Context ctx) {
        this.mainOrgContext = ctx;
    }

    public Context getMainOrgContext() {
        return this.mainOrgContext;
    }

    private void initErrorHandleBox() {
        this.comboErrorHandleMode.removeAllItems();
        this.comboErrorHandleMode.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
        this.comboErrorHandleMode.addItem((Object)ErrorHandleModeEnum.ReturnWhenTen);
        this.comboErrorHandleMode.addItem((Object)ErrorHandleModeEnum.ReturnWhenFifty);
        this.comboErrorHandleMode.addItem((Object)ErrorHandleModeEnum.ReturnWhenhundred);
        this.comboErrorHandleMode.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        this.comboErrorHandleMode.setSelectedIndex(0);
    }

    private void changeByMode() {
        DatataskParameter tmp = (DatataskParameter)this.params.get(0);
        String alias = tmp.alias;
        if (this.mode == 1 || this.mode == 64) {
            this.setTitle(alias + " " + EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"export"));
        } else if (DatataskMode.isImpMode(this.mode)) {
            this.setTitle(alias + " " + EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"import"));
        }
    }

    private void refreshSheet() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.disableButtons();
        Thread refreshThread = new Thread(){

            @Override
            public void run() {
                String fileExtension = GlobalFunction.getFileExtension(DlgEASDatatask.this.getFileName());
                ArrayList sheetNames = null;
                try {
                    AbstractExternalDataReader reader;
                    if ("xls".equalsIgnoreCase(fileExtension)) {
                        reader = new ExternalExcelDataReader();
                        sheetNames = ((ExternalExcelDataReader)reader).getSheetNameCollection(DlgEASDatatask.this.getFileName());
                    }
                    if ("xlsx".equalsIgnoreCase(fileExtension)) {
                        reader = new ExternalExcelXDataReader();
                        sheetNames = ((ExternalExcelXDataReader)reader).getSheetNameCollection(DlgEASDatatask.this.getFileName());
                    }
                }
                catch (RecordFormatException e) {
                    DlgEASDatatask.this.txtFile.setText("");
                    ExceptionRunnable exRun = new ExceptionRunnable();
                    String msg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"recordFormatException");
                    exRun.setExMsg(msg);
                    SwingUtilities.invokeLater(exRun);
                    return;
                }
                catch (Exception err) {
                    ExceptionRunnable exRun = new ExceptionRunnable();
                    exRun.setExMsg(err.getMessage());
                    SwingUtilities.invokeLater(exRun);
                    logger.error((Object)("open excel file error:" + err));
                    return;
                }
                EndRunnable endRun = new EndRunnable();
                endRun.setSheetNames(sheetNames);
                SwingUtilities.invokeLater(endRun);
            }
        };
        refreshThread.start();
    }

    private void toDefaultCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void onBtnExportTemplateClicked() {
        DatataskParameter param = (DatataskParameter)this.params.get(0);
        param.getContextParam().put("exportTemplateOnly", "true");
        this.onBtnOKClicked();
    }

    private void invokeImportTask(DatataskParameter params) throws Exception {
        DiscardUtil.clearCache(null);
        this.getIdatatask().runSingleTask(params);
        String serverFileName = params.getErrDataFileName();
        if (!StringUtils.isEmpty((String)serverFileName) && params.getContextParam().get("errorHandleMode").equals((Object)ErrorHandleModeEnum.ReturnWhenFinish)) {
            File clientFile = File.createTempFile(serverFileName.substring(0, serverFileName.lastIndexOf(".")), "." + params.getFileType());
            params.setClientErrFile(clientFile.getAbsolutePath());
            byte[] fileByte = this.getIdatatask().getExportFile(serverFileName);
            if (fileByte != null) {
                this.writeFile(fileByte, clientFile.getAbsolutePath());
            }
        }
    }

    private void invokeExportTask(DatataskParameter params) throws Exception {
        ReturnInfo res = this.getIdatatask().runSingleTask(params);
        TaskLog log = this.getIdatatask().getTaskLog(this.uuid);
        log.setLogType("exportlog");
        try {
            if (log.getTaskState().equals((Object)TaskStateEnum.FAILEND)) {
                log.addException(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"84_DlgEASDatatask"), new Exception(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"85_DlgEASDatatask")), 0);
                this.getIdatatask().writeTaskLog(log);
                return;
            }
            List fileList = (List)res.getData();
            byte[] fileByte = null;
            String openFile = params.getOpenFileName();
            ZipUtil zip = new ZipUtil();
            for (String fileName : fileList) {
                fileByte = this.getIdatatask().getExportFile(fileName);
                if (fileByte == null) continue;
                zip.unGzipFile(fileByte, openFile);
            }
            zip.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            log.setTaskState(TaskStateEnum.FAILEND);
            log.addException(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"84_DlgEASDatatask"), new Exception(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"85_DlgEASDatatask")), 0);
            this.getIdatatask().writeTaskLog(log);
            throw e;
        }
    }

    private int[] randomArr(int[] send, int size) {
        SecureRandom r = new SecureRandom();
        int len = send.length;
        for (int n = 0; n < len; ++n) {
            send[n] = n;
        }
        int[] returnValue = new int[size];
        for (int i = 0; i < size; ++i) {
            int temp1 = Math.abs(r.nextInt()) % len;
            returnValue[i] = send[temp1];
            int temp2 = send[temp1];
            send[temp1] = send[len - 1];
            send[len - 1] = temp2;
            --len;
        }
        return returnValue;
    }

    private DatataskParameter getImportParams() throws Exception {
        Object file = null;
        String fileName = this.getFileName();
        String fileType = GlobalFunction.getFileExtension(fileName);
        DatataskParameter param = (DatataskParameter)this.params.get(0);
        if (this.comboSheets.getItemCount() > 0 && this.isSltSheet) {
            param.alias = this.comboSheets.getSelectedItem().toString();
        }
        param.setLogUuID(this.uuid);
        param.setFileType(fileType);
        if ("xlsx".equalsIgnoreCase(fileType)) {
            param.setErrDataFileName(this.getErrDataFileName(fileName));
        }
        if (this.btnAddNew.isSelected()) {
            param.datataskMode = 8;
        } else if (this.btnOverWrite.isSelected()) {
            param.datataskMode = 16;
        } else if (this.isSltSheet) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"configTemplateImportMode"));
            SysUtil.abort();
        } else {
            param.datataskMode = 8;
        }
        UploadFileToServerHelper helper = new UploadFileToServerHelper();
        String serverTmpFileName = helper.uploadFile(fileName);
        param.setOpenFileName(serverTmpFileName);
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String sulutionName = null;
        if (param.getSolutionName() != null) {
            String[] strs = param.getSolutionName().split("\\.");
            sulutionName = strs[strs.length - 1];
        }
        map.put("solu", sulutionName);
        map.put("soluName", param.getAlias());
        map.put("seq", 1);
        list.add(map);
        String json = JSONUtils.convertObjectToJson(null, list);
        ReturnInfo rs = this.getExcelInfo(this.uuid, serverTmpFileName, json);
        if (rs != null && "error".equals(rs.getMsg())) {
            MsgBox.showError((String)rs.getData().toString());
            SysUtil.abort();
        }
        this.addErrorHandleMode(param);
        return param;
    }

    public ReturnInfo getExcelInfo(String fileUuId, String fileName, String importParam) {
        ReturnInfo rs = new ReturnInfo();
        try {
            IDatataskRunServer iDatatask = DatataskRunServerFactory.getRemoteInstance();
            rs = iDatatask.getMultiExcelInfo(fileUuId, fileName, importParam);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rs;
    }

    private String getErrDataFileName(String fileName) {
        return System.currentTimeMillis() + ".xlsx";
    }

    private DatataskParameter getExportParams() {
        String fileName = this.getFileName();
        String fileType = GlobalFunction.getFileExtension(fileName);
        DatataskParameter param = (DatataskParameter)this.params.get(0);
        if (this.comboSheets.getItemCount() > 0 && this.isSltSheet) {
            param.alias = this.comboSheets.getSelectedItem().toString();
        }
        param.setLogUuID(this.uuid);
        param.setFileType(fileType);
        param.setOpenFileName(fileName);
        this.addErrorHandleMode(param);
        return param;
    }

    private void addErrorHandleMode(DatataskParameter param) {
        ErrorHandleModeEnum errorHandleMode = null;
        if (this.btnReturnRightnow.isSelected()) {
            errorHandleMode = ErrorHandleModeEnum.ReturnRightnow;
        } else if (this.btnReturnWhenFinish.isSelected()) {
            errorHandleMode = ErrorHandleModeEnum.ReturnWhenFinish;
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"configErrorHandleMode"));
            SysUtil.abort();
        }
        param.getContextParam().put("errorHandleMode", errorHandleMode);
    }

    private void invokeServer() throws Exception {
        DatataskParameter tmp = (DatataskParameter)this.params.get(0);
        if (DatataskMode.isImpMode(tmp.datataskMode)) {
            DatataskParameter importParam = this.getImportParams();
            this.invokeImportTask(importParam);
        } else if (tmp.datataskMode == 1 || tmp.datataskMode == 64) {
            DatataskParameter exportParam = this.getExportParams();
            this.invokeExportTask(exportParam);
        } else if (tmp.datataskMode == 32) {
            DatataskParameter importParam = this.getImportParams();
            importParam.datataskMode = 32;
            this.invokeImportTask(importParam);
        }
    }

    private IDatataskRunServer getIdatatask() throws BOSException {
        return DatataskRunServerFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(byte[] fileBytes, String filePath) throws Exception {
        try (FileOutputStream fs = null;){
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            fs = new FileOutputStream(file);
            fs.write(fileBytes);
            fs.flush();
        }
    }

    private void enableButtons() {
        this.btnOk.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnOpen.setEnabled(true);
        this.btnExportTemplate2.setEnabled(true);
        this.txtFile.setEnabled(true);
        this.cbxMoreExcels.setEnabled(true);
        this.btnRefreshSheet.setEnabled(true);
        this.btnRefreshSheet.setEnabled(true);
        this.comboSheets.setEnabled(true);
        this.setDefaultCloseOperation(2);
    }

    private void disableButtons() {
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.btnOpen.setEnabled(false);
        this.btnExportTemplate2.setEnabled(false);
        this.txtFile.setEnabled(false);
        this.cbxMoreExcels.setEnabled(false);
        this.btnRefreshSheet.setEnabled(false);
        this.comboSheets.setEnabled(false);
        this.setDefaultCloseOperation(0);
    }

    private void onFinishedRunning() {
        this.progressBar.setValue(100);
        this.LabelProcess.setVisible(false);
        this.enableButtons();
    }

    private void onPreparedToRun() {
        this.progressBar.setValue(0);
        this.progressBar.setVisible(true);
        this.LabelProcess.setVisible(true);
        this.increaseValue();
        this.disableButtons();
    }

    private void increaseValue() {
        Runnable increaseRun = new Runnable(){

            @Override
            public void run() {
                while (DlgEASDatatask.this.noStopRequested) {
                    try {
                        Thread.sleep(50L);
                        DlgEASDatatask.this.progressBar.setValue(DlgEASDatatask.this.progressBar.getValue() + 5);
                        if (DlgEASDatatask.this.progressBar.getValue() >= DlgEASDatatask.this.progressBar.getMaximum()) {
                            DlgEASDatatask.this.progressBar.setValue(DlgEASDatatask.this.progressBar.getMinimum());
                        }
                        DlgEASDatatask.this.repaint();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.progressThread = new Thread(increaseRun);
        this.progressThread.start();
    }

    public void stopProgressRequest() {
        this.noStopRequested = false;
        this.progressThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidFile(String filePath) {
        boolean bl;
        String fileExtension = GlobalFunction.getFileExtension(filePath);
        ArrayList sheetNames = null;
        try {
            String msg;
            int confirm;
            AbstractExternalDataReader reader;
            if ("xls".equalsIgnoreCase(fileExtension) && (sheetNames = ((ExternalExcelDataReader)(reader = new ExternalExcelDataReader())).getSheetNameCollection(filePath)).size() > 20) {
                String msg2 = EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "16_DioMainUI", new Object[]{20});
                MsgBox.showError((Component)((Object)this), (String)msg2);
                return false;
            }
            if ("xlsx".equalsIgnoreCase(fileExtension) && (sheetNames = ((ExternalExcelXDataReader)(reader = new ExternalExcelXDataReader())).getSheetNameCollection(filePath)).size() > 20 && (confirm = MsgBox.showConfirm2((String)(msg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"onlyHandleOneSheet")))) == 2) {
                return false;
            }
        }
        catch (FileNotFoundException e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fileopened"));
            return false;
        }
        catch (IOException e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"readFileError"));
            return false;
        }
        catch (Exception e) {
            if ("xlsx".equalsIgnoreCase(fileExtension)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"readFileError"));
                return false;
            }
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            return false;
        }
        FileInputStream f = null;
        try {
            f = new FileInputStream(filePath);
            if (f != null && DatataskMode.isImpMode(this.mode) && (long)f.available() > MaxFileSize) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importfiletoolarge"));
                boolean msg = false;
                return msg;
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"17_DlgEASDatatask"));
            bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)e);
            bl = false;
            return bl;
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                    f = null;
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return true;
    }

    private void onBtnImportTemplateClicked() {
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.equals("")) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importDocument"));
            return;
        }
        if (!this.isValidFile(filePath)) {
            return;
        }
        if (!GlobalFunction.isSupportFileType(filePath)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"supportfiletype"));
            return;
        }
        String file = this.getFileName();
        String fileType = GlobalFunction.getFileExtension(file);
        AbstractExternalDataReader reader = null;
        String alias = null;
        if (this.comboSheets.getItemCount() > 0 && this.isSltSheet) {
            alias = this.comboSheets.getSelectedItem().toString();
        }
        Locale locale = SysContext.getSysContext().getLocale();
        try {
            String sheetName;
            if (fileType.equalsIgnoreCase("xls")) {
                reader = new ExternalExcelDataReader();
                reader.setLocacle(locale);
                sheetName = alias;
                reader.openFile(file, sheetName);
            }
            if (fileType.equalsIgnoreCase("xlsx")) {
                reader = new ExternalExcelXDataReader();
                reader.setLocacle(locale);
                sheetName = alias;
                ((ExternalExcelXDataReader)reader).setIsImportTemplate(true);
                reader.openFile(file, sheetName);
            } else if (fileType.equalsIgnoreCase("csv")) {
                reader = new ExternalCSVDataReader();
                reader.setLocacle(locale);
                reader.openFile(file);
            } else if (fileType.equalsIgnoreCase("txt")) {
                reader = new ExternalTextDataReader();
                reader.setLocacle(locale);
                reader.openFile(file);
            } else if (fileType.equalsIgnoreCase("xml")) {
                reader = new ExternalXmlDataReader();
                reader.setLocacle(locale);
                reader.openFile(file);
            }
        }
        catch (FileFormatNotStandardException e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            return;
        }
        if (reader != null) {
            this.structInfo = reader.getExternalStructInfo();
        }
        this.isOK = true;
        this.hide();
    }

    public ExternalStructInfo getExternalStructInfo() {
        return this.structInfo;
    }

    private void onBtnOKClicked() {
        this.noStopRequested = true;
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.equals("")) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importDocument"));
            return;
        }
        if (DatataskMode.isImpMode(this.mode) && !this.isValidFile(filePath)) {
            return;
        }
        if (!GlobalFunction.isSupportFileType(filePath)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"supportfiletype"));
            return;
        }
        this.uuid = GlobalFunction.getUuID();
        this.onPreparedToRun();
        Thread taskThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TaskLog taskLog = null;
                try {
                    DlgEASDatatask.this.invokeServer();
                    taskLog = DlgEASDatatask.this.getIdatatask().getTaskLog(DlgEASDatatask.this.uuid);
                    UpdateUIRunnable update = new UpdateUIRunnable();
                    update.setTaskLog(taskLog);
                    SwingUtilities.invokeLater(update);
                    DlgEASDatatask.this.isOK = true;
                }
                catch (Exception e) {
                    DlgEASDatatask.this.isOK = false;
                    UpdateUIRunnable update = new UpdateUIRunnable();
                    update.setException(e);
                    SwingUtilities.invokeLater(update);
                    return;
                }
                finally {
                    DlgEASDatatask.this.clearLog(DlgEASDatatask.this.uuid);
                    DlgEASDatatask.this.stopProgressRequest();
                }
            }
        };
        taskThread.start();
    }

    private void onBtnCancelClicked() {
        this.isOK = false;
        this.hide();
    }

    private void onBtnOpenClicked() {
        String sFileName = null;
        try {
            if (DatataskMode.isImpMode(this.mode)) {
                sFileName = GlobalFunction.excelFileChoose((Component)((Object)this));
            } else if (this.mode == 1) {
                sFileName = GlobalFunction.excelFileSaver((Component)((Object)this));
            } else if (this.mode == 32) {
                sFileName = GlobalFunction.excelFileChoose((Component)((Object)this));
            } else if (this.mode == 64) {
                sFileName = GlobalFunction.excelFileSaver((Component)((Object)this));
            }
        }
        catch (Exception err) {
            MsgBox.showError((String)err.getMessage());
            return;
        }
        if (sFileName != null && !sFileName.equals("")) {
            this.txtFile.setText(sFileName);
            String fileExtension = GlobalFunction.getFileExtension(sFileName);
            this.HideOrVisibleSheet(fileExtension);
            if (DatataskMode.isImpMode(this.mode) && !this.isValidFile(sFileName)) {
                return;
            }
            if (this.isSltSheet && ("xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension))) {
                this.refreshSheet();
            }
        }
        this.initUIContentLayout();
        this.btnOk.requestFocusInWindow();
    }

    private void HideOrVisibleSheet(String fileType) {
        if ("xls".equalsIgnoreCase(fileType) || "xlsx".equalsIgnoreCase(fileType)) {
            this.lcSheet.setVisible(true);
            this.btnRefreshSheet.setVisible(true);
        } else {
            this.lcSheet.setVisible(false);
            this.btnRefreshSheet.setVisible(false);
        }
    }

    public void setDatataskMode(int mode) {
        this.mode = mode;
    }

    public String getFileName() {
        return this.txtFile.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnOk)) {
            this.onBtnOKClicked();
        } else if (e.getSource().equals(this.btnCancel)) {
            this.onBtnCancelClicked();
        } else if (e.getSource().equals(this.btnOpen)) {
            this.onBtnOpenClicked();
        } else if (e.getSource().equals(this.btnImportTemplate)) {
            this.onBtnImportTemplateClicked();
        } else if (e.getSource().equals(this.btnExportTemplate2)) {
            this.exportTemplate();
        } else if (e.getSource().equals(this.btnRefreshSheet)) {
            String filePath = this.txtFile.getText();
            if (filePath == null || filePath.equals("")) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importDocument"));
                return;
            }
            this.refreshSheet();
        }
        this.btnOk.requestFocusInWindow();
    }

    private void exportTemplate() {
        DatataskParameter param = (DatataskParameter)this.params.get(0);
        String number = param.solutionName;
        String[] tmp = number.split("\\.");
        number = tmp[tmp.length - 1];
        String sheetName = param.alias;
        TemplateExport te = new TemplateExport(number, sheetName);
        te.setParentComp((Component)((Object)this));
        try {
            String filePath = te.export();
            if (filePath != null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templatefilepath", new Object[]{filePath}));
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "exporttemplatefilefail", new Object[]{e.getMessage()}));
        }
    }

    private String formatStr(String str) {
        StringBuilder lineStr = new StringBuilder();
        int len = str.length();
        int group = str.length() / 39;
        for (int i = 0; i < group; ++i) {
            lineStr.append(str.substring(i * 39, (i + 1) * 39) + "\n");
        }
        if (len - lineStr.length() - group > 0) {
            lineStr.append(str.substring(group * 39, len - 1));
        }
        return lineStr.toString();
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    private void updateLogUI(TaskLog log) {
        if (log == null) {
            return;
        }
        if (log.getTaskState().equals((Object)TaskStateEnum.FAILEND)) {
            if (this.dlgLog == null) {
                String title = null;
                if (this.mode == 1 || this.mode == 64) {
                    title = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"dataexportlog");
                    this.dlgLog = new DlgEASDatataskLog(this, log, title);
                    this.dlgLog.setModal(true);
                    this.clearLog(log.getLogUuID());
                    this.dlgLog.show();
                    this.dlgLog.dispose();
                    this.dlgLog = null;
                } else {
                    title = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"dataImportLog");
                    this.impDlgLog = new DlgEASDatataskImportLog(this, this.getFileName(), log, title);
                    this.impDlgLog.setModal(true);
                    this.impDlgLog.setParm(this.params);
                    this.impDlgLog.setMode(this.mode);
                    this.impDlgLog.setIsSltSheet(this.isSltSheet);
                    this.clearLog(log.getLogUuID());
                    this.dispose();
                    this.impDlgLog.show();
                    this.impDlgLog.dispose();
                    this.impDlgLog = null;
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exportFailed") + log.getErrorDetail(0)));
            }
        } else if (log.getTaskState().equals((Object)TaskStateEnum.SUCCESSEND)) {
            this.clearLog(log.getLogUuID());
            if (this.mode == 1 || this.mode == 64) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exportSucceeded"));
                this.dispose();
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importSucceeded"));
                this.dispose();
            }
        }
    }

    private void clearLog(String uuid) {
        IDatataskRunServer idatatask = null;
        try {
            idatatask = this.getIdatatask();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (idatatask != null && uuid != null) {
            try {
                idatatask.clearTaskLog(uuid);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setFile(String filePath) {
        this.txtFile.setText(filePath);
    }

    public void show() {
        if (this.permCheck) {
            super.show();
        }
    }

    private class UpdateUIRunnable
    implements Runnable {
        private TaskLog _log = null;
        private Exception _e = null;

        private UpdateUIRunnable() {
        }

        public void setTaskLog(TaskLog log) {
            this._log = log;
        }

        public void setException(Exception e) {
            this._e = e;
        }

        @Override
        public void run() {
            if (this._log != null) {
                DlgEASDatatask.this.onFinishedRunning();
                DlgEASDatatask.this.updateLogUI(this._log);
                return;
            }
            if (this._e != null && this._e instanceof FileNotFoundException) {
                DlgEASDatatask.this.onFinishedRunning();
                MsgBox.showInfo((Component)((Object)DlgEASDatatask.this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile"));
                return;
            }
            if (this._e != null && this._e instanceof IOException) {
                DlgEASDatatask.this.onFinishedRunning();
                MsgBox.showInfo((Component)((Object)DlgEASDatatask.this), (String)this._e.getMessage());
                return;
            }
            if (this._e != null) {
                DlgEASDatatask.this.onFinishedRunning();
                ExceptionHandler.handle((Component)((Object)DlgEASDatatask.this), (Throwable)this._e);
                return;
            }
        }
    }

    private class EndRunnable
    implements Runnable {
        private ArrayList sheetNamesColl;

        private EndRunnable() {
        }

        public void setSheetNames(ArrayList sheetNames) {
            this.sheetNamesColl = sheetNames;
        }

        @Override
        public void run() {
            DatataskParameter dp;
            DlgEASDatatask.this.comboSheets.removeAllItems();
            if (this.sheetNamesColl != null) {
                int size = this.sheetNamesColl.size();
                for (int i = 0; i < size; ++i) {
                    DlgEASDatatask.this.comboSheets.addItem(this.sheetNamesColl.get(i));
                }
            }
            if (DlgEASDatatask.this.params.get(0) instanceof DatataskParameter && (dp = (DatataskParameter)DlgEASDatatask.this.params.get(0)) != null) {
                DlgEASDatatask.this.comboSheets.setSelectedItem((Object)dp.alias);
            }
            DlgEASDatatask.this.toDefaultCursor();
            DlgEASDatatask.this.enableButtons();
        }
    }

    private class ExceptionRunnable
    implements Runnable {
        private String exMsg;

        private ExceptionRunnable() {
        }

        public void setExMsg(String msg) {
            this.exMsg = msg;
        }

        @Override
        public void run() {
            MsgBox.showInfo((Component)((Object)DlgEASDatatask.this), (String)this.exMsg);
            DlgEASDatatask.this.toDefaultCursor();
            DlgEASDatatask.this.enableButtons();
        }
    }
}

