/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.tools.datatask.task.util.FileType;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;

public class FileSelector
implements KDPromptSelector {
    private KDFileChooser fc;
    private int retVal;
    private File retFile;
    private Component parentComp;
    private String lastSelectPath = System.getProperty("user.home");
    private String type = "";
    private String defFileName = null;

    public FileSelector(Component parentComp, String chooserType) {
        this(parentComp, chooserType, FileType.xlsx);
    }

    public FileSelector(Component parentComp, String chooserType, FileType defaultFileType) {
        this.type = chooserType;
        this.fc = new KDFileChooser(this.lastSelectPath);
        SimpleFileFilter ff = null;
        if ("OPEN".equals(chooserType)) {
            ff = new SimpleFileFilter(new String[]{"csv", "txt", "xml", "xls", "xlsx"});
            this.fc.setFileFilter((FileFilter)ff);
        } else {
            HashMap<FileType, SimpleFileFilter> filterMap = new HashMap<FileType, SimpleFileFilter>();
            SimpleFileFilter ff1 = new SimpleFileFilter(FileType.csv.toString(), FileType.csv.getDesc());
            SimpleFileFilter ff2 = new SimpleFileFilter(FileType.txt.toString(), FileType.txt.getDesc());
            SimpleFileFilter ff3 = new SimpleFileFilter(FileType.xml.toString(), FileType.xml.getDesc());
            SimpleFileFilter ff4 = new SimpleFileFilter(FileType.xls.toString(), FileType.xls.getDesc());
            SimpleFileFilter ff5 = new SimpleFileFilter(FileType.xlsx.toString(), FileType.xlsx.getDesc());
            this.fc.addChoosableFileFilter((FileFilter)ff5);
            this.fc.addChoosableFileFilter((FileFilter)ff4);
            this.fc.addChoosableFileFilter((FileFilter)ff1);
            this.fc.addChoosableFileFilter((FileFilter)ff2);
            this.fc.addChoosableFileFilter((FileFilter)ff3);
            filterMap.put(FileType.csv, ff1);
            filterMap.put(FileType.txt, ff2);
            filterMap.put(FileType.xml, ff3);
            filterMap.put(FileType.xls, ff4);
            filterMap.put(FileType.xlsx, ff5);
            this.fc.setFileFilter((FileFilter)filterMap.get(defaultFileType));
        }
        this.fc.setFileSelectionMode(0);
        this.fc.setMultiSelectionEnabled(false);
        this.parentComp = parentComp;
    }

    public void show() {
        boolean isFileValid = false;
        while (!isFileValid) {
            if ("OPEN".equals(this.type)) {
                this.retVal = this.fc.showOpenDialog(this.parentComp);
                if (this.retVal == 1) break;
                this.retFile = this.fc.getSelectedFile();
                if (this.retFile.exists()) {
                    isFileValid = true;
                    this.lastSelectPath = this.retFile.getPath();
                    continue;
                }
                MsgBox.showInfo((Component)this.parentComp, (String)Resrcs.getString((String)"FileNotExisted"));
                this.retFile = null;
                continue;
            }
            this.retVal = this.fc.showSaveDialog(this.parentComp);
            if (this.retVal == 1) break;
            this.retFile = this.fc.getSelectedFile();
            String fileName = this.retFile.getAbsolutePath();
            int lastSepP = fileName.lastIndexOf(File.separator);
            int indexP = fileName.lastIndexOf(".");
            if (indexP < 0 || indexP > 0 && indexP < lastSepP) {
                String description = "";
                if (this.fc.getFileFilter() instanceof SimpleFileFilter) {
                    description = ((SimpleFileFilter)this.fc.getFileFilter()).getDescription();
                }
                String extendName = null;
                extendName = description.indexOf("csv") >= 0 ? "csv" : (description.indexOf("txt") >= 0 ? "txt" : (description.indexOf("xlsx") >= 0 ? "xlsx" : (description.indexOf("xls") >= 0 ? "xls" : (description.indexOf("xml") >= 0 ? "xml" : "txt"))));
                fileName = new StringBuffer(fileName).append(".").append(extendName).toString();
                this.retFile = new File(fileName);
            }
            if (!GlobalFunction.isSupportFileType(fileName)) {
                MsgBox.showInfo((Component)this.parentComp, (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"supportfiletype"));
                isFileValid = false;
                continue;
            }
            if (this.retFile.exists()) {
                int result = MsgBox.showConfirm2((Component)this.parentComp, (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fileHasExisted"));
                if (result == 0) {
                    isFileValid = true;
                    this.lastSelectPath = this.retFile.getPath();
                    continue;
                }
                isFileValid = false;
                continue;
            }
            isFileValid = true;
            this.lastSelectPath = this.retFile.getPath();
        }
    }

    public boolean isCanceled() {
        boolean hasBeenCanceled = true;
        if (this.retVal == 0) {
            hasBeenCanceled = false;
        }
        return hasBeenCanceled;
    }

    public Object getData() {
        return this.retFile;
    }

    public String getDefFileName() {
        return this.defFileName;
    }

    public void setDefFileName(String defFileName) {
        this.defFileName = defFileName;
        if (defFileName != null) {
            this.fc.setSelectedFile(new File(defFileName));
        }
    }
}

