/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tools.datatask.DatataskMode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.client.AbstractMultiTaskIEUI;
import com.kingdee.eas.tools.datatask.client.DlgEASDatataskLog;
import com.kingdee.eas.tools.datatask.client.TemplateExport;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.UploadFileToServerHelper;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.tools.datatask.util.GlobalInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MultiTaskIEUI
extends AbstractMultiTaskIEUI {
    private static final Logger logger = CoreUIObject.getLogger(MultiTaskIEUI.class);
    private int mode = 8;
    private ArrayList params = null;
    private boolean isConfirm = false;
    private static final String TB_SHEETTABNAME = "excelTabName";
    private static final String TB_ISSELECT = "isSelect";
    private static final String TB_TASKNAME = "taskName";
    private boolean isExcelFile = false;
    private DlgEASDatataskLog dlgLog = null;
    private String uuid;
    private static KDStatusBar statusBar = null;
    private boolean noStopRequested = true;
    private Thread progressThread = null;

    public MultiTaskIEUI() throws Exception {
        this.btnOpenFile.setIcon((Icon)GlobalInfo.getIcon("tbtn_open"));
        this.panelProgress.setVisible(false);
        this.pageContentPanel.setBorder(null);
        this.imgPanel.setBorder(null);
        this.txtFile.setAccessAuthority(1);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getParameter();
        this.initTable();
        this.setBtnState(true);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void getParameter() {
        this.params = (ArrayList)this.getUIContext().get("params");
        this.mode = (Integer)this.getUIContext().get("mode");
    }

    private void setBtnState(boolean state) {
        this.btnCancel.setEnabled(state);
        this.btnConfirm.setEnabled(state);
        this.btnOpenFile.setEnabled(state);
        this.chkUpdate.setEnabled(state);
        this.btnExportTemplate.setEnabled(state);
        this.btnExportTemplate.setVisible(true);
    }

    private void initTable() {
        if (this.params == null || this.params.size() <= 0) {
            return;
        }
        this.tHelper.init();
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            DatataskParameter dp = (DatataskParameter)this.params.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell(TB_ISSELECT).setValue((Object)new Boolean(true));
            row.getCell(TB_TASKNAME).setValue((Object)dp.alias);
            row.setUserObject((Object)dp);
        }
    }

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        String sFileName = null;
        FilesPathInfo fpInfo = null;
        try {
            if (DatataskMode.isImpMode(this.mode)) {
                fpInfo = GlobalFunction.excelFileChoose((Component)((Object)this), true, this.getAlltFilePath());
                sFileName = fpInfo.getFilePath() != null ? fpInfo.getFilePath()[0] : null;
            } else if (this.mode == 1) {
                sFileName = GlobalFunction.excelFileSaver((Component)((Object)this));
            }
        }
        catch (Exception err) {
            MsgBox.showError((String)err.getMessage());
            return;
        }
        if (sFileName != null && !sFileName.equals("")) {
            if (fpInfo != null) {
                this.txtFile.setText(fpInfo.toString());
            }
            this.txtFile.setUserObject((Object)fpInfo);
            String fileExtension = GlobalFunction.getFileExtension(sFileName);
            if (!this.isValidFile(sFileName)) {
                return;
            }
            if ("xls".equalsIgnoreCase(fileExtension)) {
                this.isExcelFile = true;
                this.changeHideTableCol("xls");
                this.refreshSheet();
            } else {
                this.isExcelFile = false;
                this.changeHideTableCol("txt");
            }
        }
    }

    private void changeHideTableCol(String type) {
        if ("xls".equals(type)) {
            this.tblMain.getColumn(TB_ISSELECT).getStyleAttributes().setHided(false);
            this.tblMain.getColumn(TB_SHEETTABNAME).getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn(TB_ISSELECT).getStyleAttributes().setHided(false);
            this.tblMain.getColumn(TB_SHEETTABNAME).getStyleAttributes().setHided(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidFile(String filePath) {
        String fileExtension = GlobalFunction.getFileExtension(filePath);
        if ("xls".equalsIgnoreCase(fileExtension)) {
            try {
                ExternalExcelDataReader reader = new ExternalExcelDataReader();
                ArrayList sheetNames = null;
                sheetNames = reader.getSheetNameCollection(filePath);
                if (sheetNames.size() > 20) {
                    String msg = EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "16_DioMainUI", new Object[]{20});
                    MsgBox.showError((Component)((Object)this), (String)msg);
                    return false;
                }
            }
            catch (Exception e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                return false;
            }
        }
        FileInputStream f = null;
        try {
            f = new FileInputStream(filePath);
            if (f != null && DatataskMode.isImpMode(this.mode) && (long)f.available() > 0xA00000L) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importfiletoolarge"));
                boolean sheetNames = false;
                return sheetNames;
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"17_DlgEASDatatask"));
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = false;
        this.getUIWindow().hide();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.actionConfirm();
        this.isConfirm = true;
    }

    public boolean isConFirm() {
        return this.isConfirm;
    }

    private boolean verifyInput() {
        String filePath = this.getFirstFileName();
        if (filePath == null || filePath.equals("")) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importDocument"));
            return false;
        }
        if (!this.isValidFile(filePath)) {
            return false;
        }
        if (!GlobalFunction.isSupportFileType(filePath)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"supportfiletype"));
            return false;
        }
        int rowCount = this.tblMain.getRowCount();
        boolean hasSelected = false;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean isSlt = (Boolean)row.getCell(TB_ISSELECT).getValue();
            if (!isSlt.booleanValue() || !"xls".equalsIgnoreCase(GlobalFunction.getFileExtension(filePath))) continue;
            String value = (String)row.getCell(TB_SHEETTABNAME).getValue();
            if (value == null || value.trim().equals("")) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"selectsheet"));
                return false;
            }
            hasSelected = true;
        }
        if (!hasSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"selectimporttask"));
            return false;
        }
        return true;
    }

    private IDatataskRunServer getInterface() throws BOSException {
        return DatataskRunServerFactory.getRemoteInstance();
    }

    private void actionConfirm() {
        if (!this.verifyInput()) {
            return;
        }
        this.uuid = GlobalFunction.getUuID();
        this.onPreparedToRun();
        Thread taskThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TaskLog taskLog = new TaskLog();
                try {
                    IDatataskRunServer drs = MultiTaskIEUI.this.getInterface();
                    FilesPathInfo fpInfo = MultiTaskIEUI.this.getAlltFilePath();
                    String[] paths = fpInfo.getFilePath();
                    ArrayList params = null;
                    for (int i = 0; i < paths.length; ++i) {
                        params = i == 0 ? MultiTaskIEUI.this.getFirstParams() : MultiTaskIEUI.this.getParams(params, paths[i]);
                        drs.runMuitiTask(params, true);
                        TaskLog tmpLog = drs.getTaskLog(MultiTaskIEUI.this.uuid);
                        MultiTaskIEUI.this.updateTaskLogSubject(tmpLog, paths[i]);
                        taskLog.addTaskLog(tmpLog);
                    }
                    UpdateUIRunnable update = new UpdateUIRunnable();
                    update.setTaskLog(taskLog);
                    SwingUtilities.invokeLater(update);
                }
                catch (Exception e) {
                    UpdateUIRunnable update = new UpdateUIRunnable();
                    update.setException(e);
                    SwingUtilities.invokeLater(update);
                    return;
                }
                finally {
                    MultiTaskIEUI.this.clearLog(MultiTaskIEUI.this.uuid);
                }
            }
        };
        taskThread.start();
    }

    private void updateTaskLogSubject(TaskLog log, String path) {
        int size = log.getErrorDetailCount();
        for (int i = 0; i < size; ++i) {
            log.setErrorSubject(i, EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "18_MultiTaskIEUI", new Object[]{path, log.getErrorSubject(i)}));
        }
    }

    private ArrayList getParams(ArrayList result, String filePath) throws Exception {
        String serverTmpFileName = "";
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            DatataskParameter dp = (DatataskParameter)result.get(i);
            if (i == 0) {
                UploadFileToServerHelper helper = new UploadFileToServerHelper();
                serverTmpFileName = helper.uploadFile(filePath);
            }
            dp.setOpenFileName(serverTmpFileName);
        }
        return result;
    }

    private ArrayList getFirstParams() throws Exception {
        int tmpmode = 8;
        tmpmode = this.chkUpdate.isSelected() ? 16 : 8;
        String fileName = this.getFirstFileName();
        String fileType = GlobalFunction.getFileExtension(fileName);
        int rowCount = this.tblMain.getRowCount();
        ArrayList<DatataskParameter> result = new ArrayList<DatataskParameter>();
        boolean isReadFile = false;
        String serverTmpFileName = "";
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean isSlt = (Boolean)row.getCell(TB_ISSELECT).getValue();
            if (!isSlt.booleanValue()) continue;
            DatataskParameter dp = (DatataskParameter)row.getUserObject();
            dp.alias = (String)row.getCell(TB_SHEETTABNAME).getValue();
            dp.setFileType(fileType);
            if (!isReadFile) {
                UploadFileToServerHelper helper = new UploadFileToServerHelper();
                serverTmpFileName = helper.uploadFile(fileName);
                isReadFile = true;
            }
            dp.setOpenFileName(serverTmpFileName);
            dp.setLogUuID(this.uuid);
            dp.datataskMode = tmpmode;
            result.add(dp);
        }
        return result;
    }

    @Override
    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        String[] numbers = this.getParamNumbers();
        TemplateExport te = new TemplateExport(numbers);
        te.setParentComp((Component)((Object)this));
        try {
            String filePath = te.export();
            if (filePath != null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templatefilepath", new Object[]{filePath}));
            }
        }
        catch (Exception ex) {
            MsgBox.showInfo((String)EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "exporttemplatefilefail", new Object[]{ex.getMessage()}));
        }
    }

    private String[] getParamNumbers() {
        int size = this.params.size();
        String[] numbers = new String[size];
        for (int i = 0; i < size; ++i) {
            DatataskParameter dtp = (DatataskParameter)this.params.get(i);
            String number = dtp.solutionName;
            String[] tmp = number.split("\\.");
            numbers[i] = number = tmp[tmp.length - 1];
        }
        return numbers;
    }

    protected void enableButtons() {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnOpenFile.setEnabled(true);
        this.txtFile.setEnabled(true);
        this.btnExportTemplate.setEnabled(true);
    }

    protected void disableButtons() {
        this.btnConfirm.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.btnOpenFile.setEnabled(false);
        this.txtFile.setEnabled(false);
        this.btnExportTemplate.setEnabled(false);
    }

    private void onPreparedToRun() {
        this.panelProgress.setVisible(true);
        this.progressBar.setValue(0);
        this.increaseValue();
        this.disableButtons();
    }

    private void increaseValue() {
        Runnable increaseRun = new Runnable(){

            @Override
            public void run() {
                while (MultiTaskIEUI.this.noStopRequested) {
                    try {
                        Thread.sleep(100L);
                        MultiTaskIEUI.this.progressBar.setValue(MultiTaskIEUI.this.progressBar.getValue() + 5);
                        if (MultiTaskIEUI.this.progressBar.getValue() > MultiTaskIEUI.this.progressBar.getMaximum()) {
                            MultiTaskIEUI.this.progressBar.setValue(MultiTaskIEUI.this.progressBar.getMaximum());
                        }
                        MultiTaskIEUI.this.repaint();
                        if (MultiTaskIEUI.this.progressBar.getValue() < MultiTaskIEUI.this.progressBar.getMaximum()) continue;
                        MultiTaskIEUI.this.progressBar.setValue(MultiTaskIEUI.this.progressBar.getMinimum());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.progressThread = new Thread(increaseRun);
        this.progressThread.start();
    }

    public void stopProgressRequest() {
        this.noStopRequested = false;
        this.progressThread.interrupt();
    }

    private void onFinishedRunning() {
        this.enableButtons();
        this.progressBar.setValue(100);
        this.panelProgress.setVisible(false);
    }

    private void changeSheetNames(ArrayList sheetNames) {
        int i;
        KDTDefaultCellEditor itemEditor = null;
        KDComboBox comSheetNames = new KDComboBox();
        comSheetNames.addItem((Object)"");
        if (sheetNames != null) {
            int sheetCount = sheetNames.size();
            for (i = 0; i < sheetCount; ++i) {
                comSheetNames.addItem(sheetNames.get(i));
            }
        }
        itemEditor = new KDTDefaultCellEditor((JComboBox)comSheetNames);
        this.tblMain.getColumn(TB_SHEETTABNAME).setEditor((ICellEditor)itemEditor);
        int rowCount = this.tblMain.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            String taskName = (String)this.tblMain.getRow(i).getCell(TB_TASKNAME).getValue();
            String currentSheetName = (String)this.tblMain.getRow(i).getCell(TB_SHEETTABNAME).getValue();
            if (sheetNames.contains(taskName)) {
                this.tblMain.getRow(i).getCell(TB_SHEETTABNAME).setValue((Object)taskName);
                continue;
            }
            if (sheetNames.contains(currentSheetName)) {
                this.tblMain.getRow(i).getCell(TB_SHEETTABNAME).setValue((Object)currentSheetName);
                continue;
            }
            this.tblMain.getRow(i).getCell(TB_SHEETTABNAME).setValue(null);
        }
    }

    protected String getFileName() {
        return this.txtFile.getText();
    }

    private String getFirstFileName() {
        FilesPathInfo paths = this.getAlltFilePath();
        if (paths != null && paths.getFilePath() != null && paths.getFilePath().length > 0) {
            return paths.getFilePath()[0];
        }
        return null;
    }

    private FilesPathInfo getAlltFilePath() {
        return (FilesPathInfo)this.txtFile.getUserObject();
    }

    private void refreshSheet() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.disableButtons();
        Thread refreshThread = new Thread(){

            @Override
            public void run() {
                ExternalExcelDataReader reader = new ExternalExcelDataReader();
                ArrayList sheetNames = null;
                try {
                    sheetNames = reader.getSheetNameCollection(MultiTaskIEUI.this.getFirstFileName());
                }
                catch (Exception err) {
                    ExceptionRunnable exRun = new ExceptionRunnable();
                    exRun.setExMsg(err.getMessage());
                    SwingUtilities.invokeLater(exRun);
                    logger.error((Object)("open excel file error:" + err));
                    return;
                }
                EndRunnable endRun = new EndRunnable();
                endRun.setSheetNames(sheetNames);
                SwingUtilities.invokeLater(endRun);
            }
        };
        refreshThread.start();
    }

    private void toDefaultCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void initProgressBar() {
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
    }

    private void updateLogUI(TaskLog log) {
        if (log == null) {
            return;
        }
        if (log.getTaskState().equals((Object)TaskStateEnum.FAILEND) || log.getErrorDetailCount() > 0) {
            if (this.dlgLog == null) {
                this.dlgLog = new DlgEASDatataskLog((KDDialog)this.getUIWindow(), log);
                this.dlgLog.setModal(true);
                this.clearLog(log.getLogUuID());
                this.dlgLog.show();
                this.dlgLog.dispose();
                this.dlgLog = null;
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exportFailed") + log.getErrorDetail(0)));
            }
        } else if (log.getTaskState().equals((Object)TaskStateEnum.SUCCESSEND)) {
            this.clearLog(log.getLogUuID());
            if (this.mode == 1) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exportSucceeded"));
                this.getUIWindow().close();
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importSucceeded"));
                this.getUIWindow().close();
            }
        }
    }

    private void clearLog(String uuid) {
        try {
            if (this.getInterface() != null && uuid != null) {
                try {
                    this.getInterface().clearTaskLog(uuid);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public Icon getImage() {
        return EASResource.getIcon((String)"imgTransfers_pic260");
    }

    private class UpdateUIRunnable
    implements Runnable {
        private TaskLog _log = null;
        private Exception _e = null;

        private UpdateUIRunnable() {
        }

        public void setTaskLog(TaskLog log) {
            this._log = log;
        }

        public void setException(Exception e) {
            this._e = e;
        }

        @Override
        public void run() {
            if (this._log != null) {
                MultiTaskIEUI.this.onFinishedRunning();
                MultiTaskIEUI.this.updateLogUI(this._log);
                return;
            }
            if (this._e != null && this._e instanceof FileNotFoundException) {
                MultiTaskIEUI.this.onFinishedRunning();
                MsgBox.showInfo((Component)((Object)MultiTaskIEUI.this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile"));
                return;
            }
            if (this._e != null) {
                MultiTaskIEUI.this.onFinishedRunning();
                ExceptionHandler.handle((Component)((Object)MultiTaskIEUI.this), (Throwable)this._e);
                return;
            }
        }
    }

    private class EndRunnable
    implements Runnable {
        private ArrayList sheetNamesColl;

        private EndRunnable() {
        }

        public void setSheetNames(ArrayList sheetNames) {
            this.sheetNamesColl = sheetNames;
        }

        @Override
        public void run() {
            MultiTaskIEUI.this.changeSheetNames(this.sheetNamesColl);
            MultiTaskIEUI.this.toDefaultCursor();
            MultiTaskIEUI.this.enableButtons();
        }
    }

    private class ExceptionRunnable
    implements Runnable {
        private String exMsg;

        private ExceptionRunnable() {
        }

        public void setExMsg(String msg) {
            this.exMsg = msg;
        }

        @Override
        public void run() {
            MsgBox.showInfo((Component)((Component)MultiTaskIEUI.this.getUIWindow()), (String)this.exMsg);
            MultiTaskIEUI.this.toDefaultCursor();
            MultiTaskIEUI.this.enableButtons();
        }
    }
}

