/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import java.io.File;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileView;

public class SaveFileView
extends FileView {
    private static String EXCEL = "xls";
    private static String TXT = "txt";
    private static String CSV = "csv";
    private ImageIcon excelIcon = SaveFileView.createImageIcon("../images/excel.ico");
    private ImageIcon txtIcon = SaveFileView.createImageIcon("../images/txt.ico");
    private ImageIcon csvIcon = SaveFileView.createImageIcon("../images/csv.ico");

    @Override
    public String getName(File f) {
        return null;
    }

    @Override
    public String getDescription(File f) {
        return null;
    }

    @Override
    public Boolean isTraversable(File f) {
        return null;
    }

    @Override
    public String getTypeDescription(File f) {
        String extension = this.getExtension(f);
        String type = null;
        if (extension != null) {
            if (extension.equalsIgnoreCase(EXCEL)) {
                type = "excel file";
            } else if (extension.equalsIgnoreCase(TXT)) {
                type = "text file";
            } else if (extension.equalsIgnoreCase(CSV)) {
                type = "csv file";
            }
        }
        return type;
    }

    private String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    @Override
    public Icon getIcon(File f) {
        String extension = this.getExtension(f);
        ImageIcon icon = null;
        if (extension != null) {
            if (extension.equalsIgnoreCase(EXCEL)) {
                icon = this.excelIcon;
            } else if (extension.equalsIgnoreCase(TXT)) {
                icon = this.txtIcon;
            } else if (extension.equalsIgnoreCase(CSV)) {
                icon = this.csvIcon;
            }
        }
        return icon;
    }

    private static ImageIcon createImageIcon(String path) {
        URL imgURL = SaveFileView.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }
}

